/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cvsSupport2.connections;

import com.intellij.CvsBundle;
import com.intellij.cvsSupport2.connections.CvsMethod;
import com.intellij.cvsSupport2.connections.CvsRootException;
import com.intellij.cvsSupport2.connections.CvsRootParser;
import com.intellij.cvsSupport2.connections.CvsRootSettingsBuilder;
import com.intellij.cvsSupport2.connections.CvsSettings;
import com.intellij.openapi.util.text.StringUtil;
import org.netbeans.lib.cvsclient.connection.PServerPasswordScrambler;

public class RootFormatter<Settings extends CvsSettings> {
    private final CvsRootSettingsBuilder<Settings> myBuilder;

    public RootFormatter(CvsRootSettingsBuilder<Settings> builder) {
        this.myBuilder = builder;
    }

    public Settings createConfiguration(String rootAsString, boolean check) {
        CvsRootParser root = CvsRootParser.valueOf(rootAsString, check);
        Settings result = this.myBuilder.createSettings(root.METHOD, rootAsString);
        if (CvsMethod.LOCAL_METHOD.equals(root.METHOD)) {
            this.fillLocalSettings(root.REPOSITORY, result);
        } else if (CvsMethod.PSERVER_METHOD.equals(root.METHOD)) {
            this.fillPServerSettings(root, result, rootAsString);
        } else if (CvsMethod.EXT_METHOD.equals(root.METHOD) || CvsMethod.SSH_METHOD.equals(root.METHOD)) {
            this.fillSettings(root, result);
        } else {
            throw new CvsRootException(CvsBundle.message("exception.text.unsupported.method", root.METHOD, rootAsString));
        }
        return result;
    }

    private void fillLocalSettings(String repository, Settings settings) {
        settings.setRepository(repository);
    }

    private void fillPServerSettings(CvsRootParser root, Settings settings, String rootAsString) {
        this.fillSettings(root, settings);
        if (root.PASSWORD != null) {
            settings.setPassword(root.PASSWORD);
        } else {
            settings.setPassword(this.getPServerConnectionPassword(rootAsString, root));
        }
    }

    private void fillSettings(CvsRootParser root, Settings settings) {
        String[] hostAndPort = root.HOST.split(":");
        settings.setHost(hostAndPort[0]);
        if (hostAndPort.length > 1) {
            settings.setPort(Integer.parseInt(hostAndPort[1]));
        } else if (root.PORT != null) {
            try {
                settings.setPort(Integer.parseInt(root.PORT));
            }
            catch (NumberFormatException e) {
                settings.setHost(hostAndPort[0]);
            }
        } else {
            settings.setHost(hostAndPort[0]);
        }
        String repository = root.REPOSITORY;
        if (StringUtil.startsWithChar((CharSequence)repository, (char)':')) {
            repository = repository.substring(1);
        }
        settings.setRepository(repository);
        String[] userAndPassword = root.USER_NAME.split(":");
        settings.setUser(userAndPassword[0]);
        if (root.PROXY_HOST != null) {
            settings.setUseProxy(root.PROXY_HOST, root.PROXY_PORT);
        }
    }

    private String getPServerConnectionPassword(String cvsRoot, CvsRootParser root) {
        String[] userAndPassword = root.USER_NAME.split(":");
        if (userAndPassword.length > 1) {
            return PServerPasswordScrambler.getInstance().scramble(userAndPassword[1]);
        }
        return this.myBuilder.getPServerPassword(cvsRoot);
    }
}

