/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions.searcheverywhere;

import com.intellij.codeInsight.navigation.NavigationUtil;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.actions.GotoActionBase;
import com.intellij.ide.actions.GotoClassAction;
import com.intellij.ide.actions.GotoClassPresentationUpdater;
import com.intellij.ide.actions.searcheverywhere.AbstractGotoSEContributor;
import com.intellij.ide.actions.searcheverywhere.PersistentSearchEverywhereContributorFilter;
import com.intellij.ide.actions.searcheverywhere.SearchEverywhereContributor;
import com.intellij.ide.actions.searcheverywhere.SearchEverywhereContributorFactory;
import com.intellij.ide.actions.searcheverywhere.SearchEverywhereContributorFilter;
import com.intellij.ide.util.gotoByName.FilteringGotoByModel;
import com.intellij.ide.util.gotoByName.GotoClassModel2;
import com.intellij.ide.util.gotoByName.GotoClassSymbolConfiguration;
import com.intellij.lang.DependentLanguage;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageUtil;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.ui.IdeUICustomization;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.stream.Collectors;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClassSearchEverywhereContributor
extends AbstractGotoSEContributor<Language> {
    public ClassSearchEverywhereContributor(@Nullable Project project, @Nullable PsiElement context) {
        super(project, context);
    }

    @NotNull
    public String getGroupName() {
        String string = GotoClassPresentationUpdater.getTabTitle(true);
        if (string == null) {
            ClassSearchEverywhereContributor.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public String getFullGroupName() {
        String[] split = GotoClassPresentationUpdater.getActionTitle().split("/");
        String string = Arrays.stream(split).map(StringUtil::pluralize).collect(Collectors.joining("/"));
        if (string == null) {
            ClassSearchEverywhereContributor.$$$reportNull$$$0(1);
        }
        return string;
    }

    public String includeNonProjectItemsText() {
        return IdeBundle.message((String)"checkbox.include.non.project.classes", (Object[])new Object[]{IdeUICustomization.getInstance().getProjectConceptName()});
    }

    public int getSortWeight() {
        return 100;
    }

    @Override
    @NotNull
    protected FilteringGotoByModel<Language> createModel(@NotNull Project project) {
        if (project == null) {
            ClassSearchEverywhereContributor.$$$reportNull$$$0(2);
        }
        GotoClassModel2 gotoClassModel2 = new GotoClassModel2(project);
        if (gotoClassModel2 == null) {
            ClassSearchEverywhereContributor.$$$reportNull$$$0(3);
        }
        return gotoClassModel2;
    }

    @Override
    @NotNull
    public String filterControlSymbols(@NotNull String pattern) {
        if (pattern == null) {
            ClassSearchEverywhereContributor.$$$reportNull$$$0(4);
        }
        if (pattern.indexOf(35) != -1) {
            pattern = ClassSearchEverywhereContributor.applyPatternFilter(pattern, patternToDetectMembers);
        }
        if (pattern.indexOf(36) != -1) {
            pattern = ClassSearchEverywhereContributor.applyPatternFilter(pattern, patternToDetectAnonymousClasses);
        }
        String string = super.filterControlSymbols(pattern);
        if (string == null) {
            ClassSearchEverywhereContributor.$$$reportNull$$$0(5);
        }
        return string;
    }

    @Override
    public int getElementPriority(@NotNull Object element, @NotNull String searchPattern) {
        if (element == null) {
            ClassSearchEverywhereContributor.$$$reportNull$$$0(6);
        }
        if (searchPattern == null) {
            ClassSearchEverywhereContributor.$$$reportNull$$$0(7);
        }
        return super.getElementPriority(element, searchPattern) + 5;
    }

    public boolean isDumbModeSupported() {
        return false;
    }

    @Override
    protected PsiElement preparePsi(PsiElement psiElement, int modifiers, String searchText) {
        String path = ClassSearchEverywhereContributor.pathToAnonymousClass(searchText);
        if (path != null) {
            psiElement = GotoClassAction.getElement(psiElement, path);
        }
        return super.preparePsi(psiElement, modifiers, searchText);
    }

    @Override
    @Nullable
    protected Navigatable createExtendedNavigatable(final PsiElement psi, String searchText, final int modifiers) {
        Navigatable delegate;
        Navigatable res2 = super.createExtendedNavigatable(psi, searchText, modifiers);
        if (res2 != null) {
            return res2;
        }
        VirtualFile file2 = PsiUtilCore.getVirtualFile((PsiElement)psi);
        String memberName = ClassSearchEverywhereContributor.getMemberName(searchText);
        if (file2 != null && memberName != null && (delegate = GotoClassAction.findMember(memberName, searchText, psi, file2)) != null) {
            return new Navigatable(){

                public void navigate(boolean requestFocus) {
                    NavigationUtil.activateFileWithPsiElement(psi, AbstractGotoSEContributor.openInCurrentWindow(modifiers));
                    delegate.navigate(true);
                }

                public boolean canNavigate() {
                    return delegate.canNavigate();
                }

                public boolean canNavigateToSource() {
                    return delegate.canNavigateToSource();
                }
            };
        }
        return null;
    }

    private static String pathToAnonymousClass(String searchedText) {
        String path;
        Matcher matcher = patternToDetectAnonymousClasses.matcher(searchedText);
        if (matcher.matches() && (path = matcher.group(2)) != null) {
            if ((path = path.trim()).endsWith("$") && path.length() >= 2) {
                path = path.substring(0, path.length() - 2);
            }
            if (!path.isEmpty()) {
                return path;
            }
        }
        return null;
    }

    private static String getMemberName(String searchedText) {
        int index = searchedText.lastIndexOf(35);
        if (index == -1) {
            return null;
        }
        String name = searchedText.substring(index + 1).trim();
        return StringUtil.isEmpty((String)name) ? null : name;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 7: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 7: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/actions/searcheverywhere/ClassSearchEverywhereContributor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchPattern";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFullGroupName";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/actions/searcheverywhere/ClassSearchEverywhereContributor";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createModel";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "filterControlSymbols";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createModel";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "filterControlSymbols";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getElementPriority";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 7: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class Factory
    implements SearchEverywhereContributorFactory<Language> {
        public static final Function<Language, String> LANGUAGE_NAME_EXTRACTOR = Language::getDisplayName;
        public static final Function<Language, Icon> LANGUAGE_ICON_EXTRACTOR = language -> {
            LanguageFileType fileType = language.getAssociatedFileType();
            return fileType != null ? fileType.getIcon() : null;
        };

        @NotNull
        public SearchEverywhereContributor<Language> createContributor(AnActionEvent initEvent) {
            ClassSearchEverywhereContributor classSearchEverywhereContributor = new ClassSearchEverywhereContributor(initEvent.getProject(), GotoActionBase.getPsiContext(initEvent));
            if (classSearchEverywhereContributor == null) {
                Factory.$$$reportNull$$$0(0);
            }
            return classSearchEverywhereContributor;
        }

        @Nullable
        public SearchEverywhereContributorFilter<Language> createFilter(AnActionEvent initEvent) {
            Project project = initEvent.getProject();
            if (project == null) {
                return null;
            }
            List items = Language.getRegisteredLanguages().stream().filter(lang -> lang != Language.ANY && !(lang instanceof DependentLanguage)).sorted(LanguageUtil.LANGUAGE_COMPARATOR).collect(Collectors.toList());
            GotoClassSymbolConfiguration persistentConfig = GotoClassSymbolConfiguration.getInstance(project);
            return new PersistentSearchEverywhereContributorFilter<Language>(items, persistentConfig, LANGUAGE_NAME_EXTRACTOR, LANGUAGE_ICON_EXTRACTOR);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/actions/searcheverywhere/ClassSearchEverywhereContributor$Factory", "createContributor"));
        }
    }
}

