/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource.connection.audit;

import com.intellij.database.dataSource.DatabaseConnection;
import com.intellij.database.dataSource.connection.ConnectionRequestor;
import com.intellij.database.dataSource.connection.audit.AuditService;
import com.intellij.database.dataSource.connection.audit.DatabaseGlobalAuditService;
import com.intellij.database.dataSource.connection.audit.JdbcObjectsListener;
import com.intellij.database.dataSource.connection.audit.JdbcWarningsListener;
import com.intellij.database.dataSource.connection.audit.ListenerAuditService;
import com.intellij.database.dataSource.connection.statements.CallableStatementData;
import com.intellij.database.dataSource.connection.statements.ParameterizedStatementData;
import com.intellij.database.dataSource.connection.statements.SmartStatementMark;
import com.intellij.database.util.JdbcUtil;
import com.intellij.openapi.project.Project;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0018\u0010\u001b\u001a\u00020\u00182\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0018\u0010\u001e\u001a\u00020\u00182\u0006\u0010\u001c\u001a\u00020\u001f2\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0018\u0010 \u001a\u00020\u00182\u0006\u0010!\u001a\u00020\"2\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0018\u0010#\u001a\u00020\u00182\u0006\u0010$\u001a\u00020%2\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0018\u0010&\u001a\u00020\u00182\u0006\u0010'\u001a\u00020(2\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\b\u0010)\u001a\u00020\u0018H\u0016J\u0010\u0010*\u001a\u00020\u00182\u0006\u0010+\u001a\u00020%H\u0016J\u0018\u0010*\u001a\u00020\u00182\u0006\u0010+\u001a\u00020%2\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0010\u0010+\u001a\u00020\u00182\u0006\u0010+\u001a\u00020%H\u0016J\u0018\u0010+\u001a\u00020\u00182\u0006\u0010+\u001a\u00020%2\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0018\u0010,\u001a\u00020\u00182\u0006\u0010!\u001a\u00020\"2\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0010\u0010-\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0018\u0010.\u001a\u00020\u00182\u0006\u0010'\u001a\u00020(2\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0018\u0010/\u001a\u00020\u00182\u0006\u00100\u001a\u0002012\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0010\u00102\u001a\u00020\u00182\u0006\u0010+\u001a\u00020%H\u0016J\u0018\u00102\u001a\u00020\u00182\u0006\u0010+\u001a\u00020%2\u0006\u0010\u0019\u001a\u00020\u001aH\u0016R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0013\u001a\u00020\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016\u00a8\u00063"}, d2={"Lcom/intellij/database/dataSource/connection/audit/AdvancedAuditService;", "Lcom/intellij/database/dataSource/connection/audit/ListenerAuditService;", "Ljava/lang/AutoCloseable;", "connection", "Lcom/intellij/database/dataSource/DatabaseConnection;", "requestor", "Lcom/intellij/database/dataSource/connection/ConnectionRequestor;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/database/dataSource/DatabaseConnection;Lcom/intellij/database/dataSource/connection/ConnectionRequestor;Lcom/intellij/openapi/project/Project;)V", "auditServices", "", "Lcom/intellij/database/dataSource/connection/audit/AuditService;", "globalService", "Lcom/intellij/database/dataSource/connection/audit/DatabaseGlobalAuditService;", "objectsListeners", "Lcom/intellij/database/dataSource/connection/audit/JdbcObjectsListener;", "getProject", "()Lcom/intellij/openapi/project/Project;", "warningsListener", "Lcom/intellij/database/dataSource/connection/audit/JdbcWarningsListener;", "getWarningsListener", "()Lcom/intellij/database/dataSource/connection/audit/JdbcWarningsListener;", "afterStatement", "", "mark", "Lcom/intellij/database/dataSource/connection/statements/SmartStatementMark;", "beforeCallableStatement", "data", "Lcom/intellij/database/dataSource/connection/statements/CallableStatementData;", "beforeParameterizedStatement", "Lcom/intellij/database/dataSource/connection/statements/ParameterizedStatementData;", "beforeResultsClosing", "resultSet", "Ljava/sql/ResultSet;", "beforeSimpleStatement", "sql", "", "beforeStatementClosing", "statement", "Ljava/sql/Statement;", "close", "error", "message", "resultsOpened", "resultsProcessed", "statementOpened", "updateCount", "count", "", "warning", "intellij.database.impl"})
public final class AdvancedAuditService
implements ListenerAuditService,
AutoCloseable {
    @NotNull
    private final JdbcWarningsListener warningsListener;
    private final DatabaseGlobalAuditService globalService;
    private final List<JdbcObjectsListener> objectsListeners;
    private final List<AuditService> auditServices;
    @Nullable
    private final Project project;

    @NotNull
    public final JdbcWarningsListener getWarningsListener() {
        return this.warningsListener;
    }

    @Override
    public void updateCount(int count2, @NotNull SmartStatementMark mark2) {
        Intrinsics.checkParameterIsNotNull((Object)mark2, (String)"mark");
        Iterable $receiver$iv = this.auditServices;
        for (Object element$iv : $receiver$iv) {
            AuditService it = (AuditService)element$iv;
            it.updateCount(count2, mark2);
        }
    }

    @Override
    public void error(@NotNull String message2, @NotNull SmartStatementMark mark2) {
        Intrinsics.checkParameterIsNotNull((Object)message2, (String)"message");
        Intrinsics.checkParameterIsNotNull((Object)mark2, (String)"mark");
        Iterable $receiver$iv = this.auditServices;
        for (Object element$iv : $receiver$iv) {
            AuditService it = (AuditService)element$iv;
            it.error(message2, mark2);
        }
    }

    @Override
    public void warning(@NotNull String message2, @NotNull SmartStatementMark mark2) {
        Intrinsics.checkParameterIsNotNull((Object)message2, (String)"message");
        Intrinsics.checkParameterIsNotNull((Object)mark2, (String)"mark");
        Iterable $receiver$iv = this.auditServices;
        for (Object element$iv : $receiver$iv) {
            AuditService it = (AuditService)element$iv;
            it.warning(message2, mark2);
        }
    }

    @Override
    public void message(@NotNull String message2, @NotNull SmartStatementMark mark2) {
        Intrinsics.checkParameterIsNotNull((Object)message2, (String)"message");
        Intrinsics.checkParameterIsNotNull((Object)mark2, (String)"mark");
        Iterable $receiver$iv = this.auditServices;
        for (Object element$iv : $receiver$iv) {
            AuditService it = (AuditService)element$iv;
            it.message(message2, mark2);
        }
    }

    @Override
    public void error(@NotNull String message2) {
        Intrinsics.checkParameterIsNotNull((Object)message2, (String)"message");
        Iterable $receiver$iv = this.auditServices;
        for (Object element$iv : $receiver$iv) {
            AuditService it = (AuditService)element$iv;
            it.error(message2);
        }
    }

    @Override
    public void message(@NotNull String message2) {
        Intrinsics.checkParameterIsNotNull((Object)message2, (String)"message");
        Iterable $receiver$iv = this.auditServices;
        for (Object element$iv : $receiver$iv) {
            AuditService it = (AuditService)element$iv;
            it.message(message2);
        }
    }

    @Override
    public void warning(@NotNull String message2) {
        Intrinsics.checkParameterIsNotNull((Object)message2, (String)"message");
        Iterable $receiver$iv = this.auditServices;
        for (Object element$iv : $receiver$iv) {
            AuditService it = (AuditService)element$iv;
            it.warning(message2);
        }
    }

    @Override
    public void beforeSimpleStatement(@NotNull String sql, @NotNull SmartStatementMark mark2) {
        Intrinsics.checkParameterIsNotNull((Object)sql, (String)"sql");
        Intrinsics.checkParameterIsNotNull((Object)mark2, (String)"mark");
        Iterable $receiver$iv = this.auditServices;
        for (Object element$iv : $receiver$iv) {
            AuditService it = (AuditService)element$iv;
            it.beforeSimpleStatement(sql, mark2);
        }
    }

    @Override
    public void beforeParameterizedStatement(@NotNull ParameterizedStatementData data, @NotNull SmartStatementMark mark2) {
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        Intrinsics.checkParameterIsNotNull((Object)mark2, (String)"mark");
        Iterable $receiver$iv = this.auditServices;
        for (Object element$iv : $receiver$iv) {
            AuditService it = (AuditService)element$iv;
            it.beforeParameterizedStatement(data, mark2);
        }
    }

    @Override
    public void beforeCallableStatement(@NotNull CallableStatementData data, @NotNull SmartStatementMark mark2) {
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        Intrinsics.checkParameterIsNotNull((Object)mark2, (String)"mark");
        Iterable $receiver$iv = this.auditServices;
        for (Object element$iv : $receiver$iv) {
            AuditService it = (AuditService)element$iv;
            it.beforeCallableStatement(data, mark2);
        }
    }

    @Override
    public void resultsProcessed(@NotNull SmartStatementMark mark2) {
        Intrinsics.checkParameterIsNotNull((Object)mark2, (String)"mark");
        Iterable $receiver$iv = this.auditServices;
        for (Object element$iv : $receiver$iv) {
            AuditService it = (AuditService)element$iv;
            it.resultsProcessed(mark2);
        }
    }

    @Override
    public void beforeStatementClosing(@NotNull Statement statement, @NotNull SmartStatementMark mark2) {
        Intrinsics.checkParameterIsNotNull((Object)statement, (String)"statement");
        Intrinsics.checkParameterIsNotNull((Object)mark2, (String)"mark");
        Iterable $receiver$iv = this.objectsListeners;
        for (Object element$iv : $receiver$iv) {
            JdbcObjectsListener it = (JdbcObjectsListener)element$iv;
            it.beforeStatementClosing(statement, mark2);
        }
    }

    @Override
    public void afterStatement(@NotNull SmartStatementMark mark2) {
        Intrinsics.checkParameterIsNotNull((Object)mark2, (String)"mark");
        Iterable $receiver$iv = this.auditServices;
        for (Object element$iv : $receiver$iv) {
            AuditService it = (AuditService)element$iv;
            it.afterStatement(mark2);
        }
    }

    @Override
    public void statementOpened(@NotNull Statement statement, @NotNull SmartStatementMark mark2) {
        Intrinsics.checkParameterIsNotNull((Object)statement, (String)"statement");
        Intrinsics.checkParameterIsNotNull((Object)mark2, (String)"mark");
        Iterable $receiver$iv = this.objectsListeners;
        for (Object element$iv : $receiver$iv) {
            JdbcObjectsListener it = (JdbcObjectsListener)element$iv;
            it.statementOpened(statement, mark2);
        }
    }

    @Override
    public void resultsOpened(@NotNull ResultSet resultSet, @NotNull SmartStatementMark mark2) {
        Intrinsics.checkParameterIsNotNull((Object)resultSet, (String)"resultSet");
        Intrinsics.checkParameterIsNotNull((Object)mark2, (String)"mark");
        Iterable $receiver$iv = this.objectsListeners;
        for (Object element$iv : $receiver$iv) {
            JdbcObjectsListener it = (JdbcObjectsListener)element$iv;
            it.resultsOpened(resultSet, mark2);
        }
    }

    @Override
    public void beforeResultsClosing(@NotNull ResultSet resultSet, @NotNull SmartStatementMark mark2) {
        Intrinsics.checkParameterIsNotNull((Object)resultSet, (String)"resultSet");
        Intrinsics.checkParameterIsNotNull((Object)mark2, (String)"mark");
        Iterable $receiver$iv = this.objectsListeners;
        for (Object element$iv : $receiver$iv) {
            JdbcObjectsListener it = (JdbcObjectsListener)element$iv;
            it.beforeResultsClosing(resultSet, mark2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        try {
            JdbcUtil.closeSafe((AutoCloseable)this.warningsListener);
        }
        finally {
            JdbcUtil.closeSafe((AutoCloseable)this.globalService);
        }
    }

    @Nullable
    public final Project getProject() {
        return this.project;
    }

    public AdvancedAuditService(@NotNull DatabaseConnection connection2, @NotNull ConnectionRequestor requestor, @Nullable Project project) {
        Intrinsics.checkParameterIsNotNull((Object)connection2, (String)"connection");
        Intrinsics.checkParameterIsNotNull((Object)requestor, (String)"requestor");
        this.project = project;
        this.warningsListener = JdbcWarningsListener.Companion.listenFor(connection2, this);
        this.globalService = DatabaseGlobalAuditService.Companion.get(this.project, connection2);
        this.objectsListeners = CollectionsKt.listOf((Object[])new JdbcObjectsListener[]{this.globalService, this.warningsListener});
        this.auditServices = CollectionsKt.listOf((Object[])new AuditService[]{requestor.getAuditService(), this.globalService});
    }
}

