/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.editor;

import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.DataGridUtil;
import com.intellij.database.datagrid.GridDataHookUp;
import com.intellij.database.datagrid.GridRequestSource;
import com.intellij.database.editor.TableEditorBase;
import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.command.undo.DocumentReference;
import com.intellij.openapi.command.undo.DocumentReferenceManager;
import com.intellij.openapi.command.undo.DocumentReferenceProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ui.update.Activatable;
import com.intellij.util.ui.update.UiNotifyConnector;
import java.awt.Component;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;

public abstract class TableFileEditor
extends TableEditorBase
implements DocumentReferenceProvider {
    private final VirtualFile myFile;

    protected TableFileEditor(@NotNull Project project, @NotNull VirtualFile file) {
        if (project == null) {
            TableFileEditor.$$$reportNull$$$0(0);
        }
        if (file == null) {
            TableFileEditor.$$$reportNull$$$0(1);
        }
        super(project);
        this.myFile = file;
    }

    public Collection<DocumentReference> getDocumentReferences() {
        return Collections.singletonList(DocumentReferenceManager.getInstance().create(this.myFile));
    }

    @Override
    public boolean isValid() {
        return this.myFile.isValid();
    }

    @NotNull
    public VirtualFile getFile() {
        VirtualFile virtualFile = this.myFile;
        if (virtualFile == null) {
            TableFileEditor.$$$reportNull$$$0(2);
        }
        return virtualFile;
    }

    @NotNull
    protected final DataGrid createDataGrid(@NotNull GridDataHookUp<DataConsumer.Row, DataConsumer.Column> hookUp) {
        if (hookUp == null) {
            TableFileEditor.$$$reportNull$$$0(3);
        }
        ActionGroup popupActions = (ActionGroup)ActionManager.getInstance().getAction("Console.TableResult.Csv.PopupGroup");
        final DataGrid grid = DataGridUtil.createDataGrid(this.getProject(), hookUp, popupActions);
        Disposer.register((Disposable)this, (Disposable)grid);
        Disposer.register((Disposable)this, (Disposable)new UiNotifyConnector.Once((Component)grid.getComponent(), (Activatable)new Activatable.Adapter(){

            public void showNotify() {
                grid.getDataHookup().getLoader().loadFirstPage(GridRequestSource.create(grid, null));
            }
        }));
        FeatureUsageTracker.getInstance().triggerFeatureUsed("db.table.editor.wrapper");
        DataGrid dataGrid = grid;
        if (dataGrid == null) {
            TableFileEditor.$$$reportNull$$$0(4);
        }
        return dataGrid;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/editor/TableFileEditor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hookUp";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/editor/TableFileEditor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFile";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createDataGrid";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 4: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createDataGrid";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

