/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.postgres.inspections;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.LocalQuickFixBase;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.database.model.DasArgument;
import com.intellij.database.model.DasRoutine;
import com.intellij.database.model.DataType;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.util.DasUtil;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilBase;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.inspections.SqlInspectionBase;
import com.intellij.sql.psi.SqlAsExpression;
import com.intellij.sql.psi.SqlColumnAliasDefinition;
import com.intellij.sql.psi.SqlDefinition;
import com.intellij.sql.psi.SqlExplicitTableExpression;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlFromClause;
import com.intellij.sql.psi.SqlFunctionCallExpression;
import com.intellij.sql.psi.SqlNameElement;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlTypeElement;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class PgSelectFromProcedureInspection
extends SqlInspectionBase {
    @Override
    protected SqlInspectionBase.SqlAnnotationVisitor createAnnotationVisitor(@NotNull SqlLanguageDialectEx dialect, @NotNull InspectionManager manager, @NotNull List<ProblemDescriptor> result2, final boolean onTheFly) {
        if (dialect == null) {
            PgSelectFromProcedureInspection.$$$reportNull$$$0(0);
        }
        if (manager == null) {
            PgSelectFromProcedureInspection.$$$reportNull$$$0(1);
        }
        if (result2 == null) {
            PgSelectFromProcedureInspection.$$$reportNull$$$0(2);
        }
        if (!dialect.getDbms().isPostgres()) {
            return null;
        }
        return new SqlInspectionBase.SqlAnnotationVisitor(manager, dialect, result2){

            public void visitSqlAsExpression(SqlAsExpression o) {
                this.processExpression(o.getExpression(), o.getColumnAliasList());
            }

            public void visitSqlFromClause(SqlFromClause o) {
                super.visitSqlFromClause(o);
                SqlExpression expression = o.getFromExpression();
                this.processExpression(expression, Collections.emptyList());
            }

            private void processExpression(SqlExpression expression, List<SqlColumnAliasDefinition> aliases) {
                SqlFunctionCallExpression function2;
                if (expression instanceof SqlFunctionCallExpression) {
                    this.processFunctionCall((SqlFunctionCallExpression)expression, aliases);
                } else if (expression instanceof SqlExplicitTableExpression && (function2 = (SqlFunctionCallExpression)PsiTreeUtil.getChildOfType((PsiElement)expression, SqlFunctionCallExpression.class)) != null) {
                    this.processFunctionCall(function2, aliases);
                }
            }

            private void processFunctionCall(SqlFunctionCallExpression functionCall, List<SqlColumnAliasDefinition> aliases) {
                boolean needTypedAliasDefinition = PgSelectFromProcedureInspection.needTypedAliasDefinition(functionCall);
                if (needTypedAliasDefinition && aliases.isEmpty()) {
                    this.addDescriptor(this.myManager.createProblemDescriptor((PsiElement)functionCall, "The function call must have a typed alias definition", (LocalQuickFix)((LocalQuickFixBase)null), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, onTheFly));
                    return;
                }
                for (SqlDefinition sqlDefinition : aliases) {
                    if (sqlDefinition.getKind() != ObjectKind.COLUMN) continue;
                    SqlTypeElement type = (SqlTypeElement)PsiTreeUtil.getChildOfType((PsiElement)sqlDefinition, SqlTypeElement.class);
                    if (needTypedAliasDefinition && type == null) {
                        this.addDescriptor(this.myManager.createProblemDescriptor((PsiElement)sqlDefinition, "The alias must have a type", (LocalQuickFix)new MyAddTypeQuickFix("Add type element", "SQL"), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, onTheFly));
                    }
                    if (needTypedAliasDefinition || type == null) continue;
                    this.addDescriptor(this.myManager.createProblemDescriptor((PsiElement)sqlDefinition, "The alias can not have a type", (LocalQuickFix)new MyRemoveTypeQuickFix("Remove type element", "SQL"), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, onTheFly));
                }
            }
        };
    }

    private static boolean needTypedAliasDefinition(@NotNull SqlFunctionCallExpression functionCall) {
        String sqlType;
        SqlReferenceExpression nameElement;
        if (functionCall == null) {
            PgSelectFromProcedureInspection.$$$reportNull$$$0(3);
        }
        if ((nameElement = functionCall.getNameElement()) == null) {
            return false;
        }
        if (StringUtil.equalsIgnoreCase((CharSequence)nameElement.getName(), (CharSequence)"dblink")) {
            return true;
        }
        PsiElement resolve = nameElement.resolve();
        if (!(resolve instanceof DasRoutine)) {
            return false;
        }
        DasRoutine routine = (DasRoutine)resolve;
        for (DasArgument info : DasUtil.getParameters((DasRoutine)routine)) {
            DasArgument.Direction type = info.getArgumentDirection();
            if (type != DasArgument.Direction.OUT && type != DasArgument.Direction.INOUT) continue;
            return false;
        }
        DasArgument retArg = routine.getReturnArgument();
        DataType type = retArg == null ? null : retArg.getDataType();
        String string = sqlType = type != null ? type.getSpecification() : null;
        return StringUtil.equalsIgnoreCase((CharSequence)"record", (CharSequence)sqlType);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dialect";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "functionCall";
                break;
            }
        }
        objectArray2[1] = "com/intellij/sql/dialects/postgres/inspections/PgSelectFromProcedureInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "createAnnotationVisitor";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "needTypedAliasDefinition";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class MyAddTypeQuickFix
    extends LocalQuickFixBase {
        protected MyAddTypeQuickFix(@NotNull String name, @NotNull String familyName) {
            if (name == null) {
                MyAddTypeQuickFix.$$$reportNull$$$0(0);
            }
            if (familyName == null) {
                MyAddTypeQuickFix.$$$reportNull$$$0(1);
            }
            super(name, familyName);
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            PsiElement alias;
            if (project == null) {
                MyAddTypeQuickFix.$$$reportNull$$$0(2);
            }
            if (descriptor == null) {
                MyAddTypeQuickFix.$$$reportNull$$$0(3);
            }
            if ((alias = descriptor.getPsiElement()) instanceof SqlDefinition) {
                SqlNameElement name = ((SqlDefinition)alias).getNameElement();
                PsiDocumentManager instance = PsiDocumentManager.getInstance((Project)project);
                PsiFile file = alias.getContainingFile();
                Document document = instance.getDocument(file);
                if (name != null && document != null) {
                    int offset = name.getTextRange().getEndOffset();
                    String defaultType = "int";
                    document.insertString(offset, (CharSequence)(" " + defaultType));
                    instance.commitDocument(document);
                    Editor editor = PsiUtilBase.findEditor((PsiElement)file);
                    if (editor != null) {
                        int startOffset = offset + 1;
                        editor.getCaretModel().moveToOffset(startOffset);
                        editor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
                        editor.getSelectionModel().setSelection(startOffset, startOffset + defaultType.length());
                    }
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "familyName";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/sql/dialects/postgres/inspections/PgSelectFromProcedureInspection$MyAddTypeQuickFix";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "applyFix";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class MyRemoveTypeQuickFix
    extends LocalQuickFixBase {
        protected MyRemoveTypeQuickFix(@NotNull String name, @NotNull String familyName) {
            if (name == null) {
                MyRemoveTypeQuickFix.$$$reportNull$$$0(0);
            }
            if (familyName == null) {
                MyRemoveTypeQuickFix.$$$reportNull$$$0(1);
            }
            super(name, familyName);
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            SqlTypeElement type;
            PsiElement alias;
            if (project == null) {
                MyRemoveTypeQuickFix.$$$reportNull$$$0(2);
            }
            if (descriptor == null) {
                MyRemoveTypeQuickFix.$$$reportNull$$$0(3);
            }
            if ((alias = descriptor.getPsiElement()) instanceof SqlDefinition && (type = (SqlTypeElement)PsiTreeUtil.getChildOfType((PsiElement)alias, SqlTypeElement.class)) != null) {
                type.delete();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "familyName";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/sql/dialects/postgres/inspections/PgSelectFromProcedureInspection$MyRemoveTypeQuickFix";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "applyFix";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

