/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.inspections.bugs;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.css.CssBundle;
import com.intellij.psi.css.CssDeclaration;
import com.intellij.psi.css.CssElementVisitor;
import com.intellij.psi.css.CssPropertyDescriptor;
import com.intellij.psi.css.CssTermList;
import com.intellij.psi.css.impl.CssElementTypes;
import com.intellij.psi.css.impl.CssTokenImpl;
import com.intellij.psi.css.inspections.CssBaseInspection;
import com.intellij.psi.css.inspections.CssFixFactory;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.NotNull;

public class CssUnitlessNumberInspection
extends CssBaseInspection {
    @NotNull
    public String getDisplayName() {
        String string = CssBundle.message((String)"css.inspections.unitless.number", (Object[])new Object[0]);
        if (string == null) {
            CssUnitlessNumberInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            CssUnitlessNumberInspection.$$$reportNull$$$0(1);
        }
        CssElementVisitor cssElementVisitor = new CssElementVisitor(){

            public void visitCssDeclaration(CssDeclaration cssDeclaration) {
                CssPropertyDescriptor descriptor = cssDeclaration.getDescriptor();
                if (descriptor == null || descriptor.allowsIntegerWithoutSuffix()) {
                    return;
                }
                CssTermList termList = cssDeclaration.getValue();
                if (termList == null) {
                    return;
                }
                boolean lineHeight = false;
                boolean fontProperty = "font".equalsIgnoreCase(descriptor.getPropertyName());
                for (PsiElement t : termList.getChildren()) {
                    IElementType iElementType;
                    PsiElement firstTermElement = t.getFirstChild();
                    if (fontProperty && t instanceof LeafElement && CssElementTypes.CSS_SLASH == ((LeafElement)t).getElementType()) {
                        lineHeight = true;
                    }
                    if (firstTermElement == null) continue;
                    PsiElement child = firstTermElement.getFirstChild();
                    boolean foundNumberTerm = false;
                    if (child instanceof CssTokenImpl && (iElementType = ((CssTokenImpl)child).getElementType()) == CssElementTypes.CSS_NUMBER) {
                        foundNumberTerm = true;
                    }
                    if (!foundNumberTerm) continue;
                    boolean zeroValue = "0".equals(child.getText());
                    PsiElement nextSibling = child.getNextSibling();
                    if (!zeroValue && nextSibling == null && !lineHeight) {
                        holder.registerProblem(firstTermElement, CssBundle.message((String)"css.inspections.unitless.number.message", (Object[])new Object[]{child.getText()}), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[]{CssFixFactory.getInstance().insertUnitQualifier(cssDeclaration)});
                    }
                    lineHeight = false;
                }
            }
        };
        if (cssElementVisitor == null) {
            CssUnitlessNumberInspection.$$$reportNull$$$0(2);
        }
        return cssElementVisitor;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/css/inspections/bugs/CssUnitlessNumberInspection";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/css/inspections/bugs/CssUnitlessNumberInspection";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

