/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.structuralsearch.StructuralSearchUtil;
import com.intellij.structuralsearch.impl.matcher.MatchContext;
import com.intellij.structuralsearch.impl.matcher.predicates.MatchPredicate;
import com.intellij.util.ObjectUtils;
import com.jetbrains.php.PhpIndex;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.psi.elements.PhpTypedElement;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import org.jetbrains.annotations.Nullable;

public class PhpExprTypePredicate
extends MatchPredicate {
    private final boolean myHierarchy;
    private final PhpType myPatternType;

    public PhpExprTypePredicate(String type, boolean hierarchy) {
        this.myHierarchy = hierarchy;
        this.myPatternType = this.buildPatternType(type);
    }

    public PhpType buildPatternType(String type) {
        PhpType.PhpTypeBuilder builder = PhpType.builder();
        StringUtil.split((String)type, (String)"|").stream().map(PhpLangUtil::toFQN).forEach(arg_0 -> ((PhpType.PhpTypeBuilder)builder).add(arg_0));
        return builder.build();
    }

    public boolean match(PsiElement matchedNode, int start, int end, MatchContext context) {
        if ((matchedNode = (PsiElement)ObjectUtils.tryCast((Object)this.getParentIfNeeded(matchedNode), PhpTypedElement.class)) == null) {
            return false;
        }
        PhpType type = ((PhpTypedElement)matchedNode).getType();
        return PhpType.intersects((PhpType)this.myPatternType, (PhpType)type) || this.myHierarchy && this.myPatternType.isConvertibleFrom(type, PhpIndex.getInstance((Project)matchedNode.getProject()));
    }

    @Nullable
    public PsiElement getParentIfNeeded(PsiElement matchedNode) {
        return (matchedNode = StructuralSearchUtil.getParentIfIdentifier((PsiElement)matchedNode)) instanceof LeafPsiElement ? matchedNode.getParent() : matchedNode;
    }
}

