/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.composer.actions;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.AnsiEscapeDecoder;
import com.intellij.execution.process.KillableProcessHandler;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.OSProcessManager;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.execution.process.ScriptRunnerUtil;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.ThrowableNotNullFunction;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.execution.ParametersListUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.composer.ComposerRunningData;
import com.jetbrains.php.composer.actions.log.ComposerLogMessageBuilder;
import com.jetbrains.php.composer.actions.log.ComposerLogService;
import com.jetbrains.php.composer.statistics.ComposerActionStatistics;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ComposerCommandExecutor {
    private static final long CHECKING_TIMEOUT_IN_MILLISECONDS = 1000L;
    private static final int MAX_COMMAND_ELEMENT_LENGTH = 25;
    @NotNull
    protected final Project myProject;
    protected final String myWorkingDir;
    @Nullable
    protected final String myCommandLineOptions;
    @NotNull
    protected final ComposerRunningData myRunningData;
    @NotNull
    private final ComposerActionStatistics myActionStatistics;
    private final boolean myReportInEventLog;
    private final boolean myIsLogCommand;

    protected ComposerCommandExecutor(@NotNull Project project, String dir, @Nullable String commandLineOptions, @NotNull ComposerRunningData runningData, @NotNull ComposerActionStatistics actionStatistics, boolean reportInEventLog, boolean isLogCommand) {
        if (project == null) {
            ComposerCommandExecutor.$$$reportNull$$$0(0);
        }
        if (runningData == null) {
            ComposerCommandExecutor.$$$reportNull$$$0(1);
        }
        if (actionStatistics == null) {
            ComposerCommandExecutor.$$$reportNull$$$0(2);
        }
        this.myProject = project;
        this.myWorkingDir = dir;
        this.myCommandLineOptions = commandLineOptions;
        this.myRunningData = runningData;
        this.myActionStatistics = actionStatistics;
        this.myReportInEventLog = reportInEventLog && !isLogCommand;
        this.myIsLogCommand = isLogCommand;
    }

    public abstract void execute();

    protected void doRun(@NotNull ProgressIndicator indicator) {
        if (indicator == null) {
            ComposerCommandExecutor.$$$reportNull$$$0(3);
        }
        indicator.setIndeterminate(true);
        if (this.myIsLogCommand) {
            ApplicationManager.getApplication().invokeLater(() -> ComposerLogService.getInstance(this.myProject).getConsoleView().show(null));
        }
        ComposerLogMessageBuilder builder = ComposerLogService.getInstance(this.myProject).getConsoleView().attachMessageBuilder(indicator, null, indicator.getModalityState());
        List<String> basicCommand = this.getBasicCommand();
        List options = this.myCommandLineOptions == null ? Collections.emptyList() : ParametersListUtil.parse((String)this.myCommandLineOptions);
        ArrayList<String> command = new ArrayList<String>(basicCommand.size() + options.size());
        command.addAll(basicCommand);
        command.addAll(options);
        StringBuilder sb = new StringBuilder();
        sb.append(PhpBundle.message("framework.composer.add.dependency.running", new Object[0]));
        for (String aCommandToRun : command) {
            if (aCommandToRun.length() > 25) {
                aCommandToRun = "..." + aCommandToRun.substring(aCommandToRun.length() - 25);
            }
            sb.append(" ").append(aCommandToRun);
        }
        indicator.setText(sb.toString());
        this.myActionStatistics.report(this.myProject);
        String commandText = StringUtil.join(command, (String)" ");
        builder.printCommand(commandText, this.getExecutorGenerator(), this.myProject);
        boolean cancelledByUser = false;
        ExecutionException exception = null;
        Integer exitCode = null;
        List<Pair<String, Key>> output = Collections.synchronizedList(new ArrayList());
        ComposerTextListener listener = this.createTextListener(indicator, builder, output);
        try {
            boolean finished;
            String executable = (String)command.get(0);
            OSProcessHandler processHandler = ScriptRunnerUtil.execute((String)executable, (String)this.myWorkingDir, null, (String[])ArrayUtil.toStringArray(command.subList(1, command.size())), null, commandLine -> new MyColoredProcessHandler((GeneralCommandLine)commandLine, listener));
            processHandler.startNotify();
            while (!(finished = processHandler.waitFor(1000L))) {
                if (!indicator.isCanceled()) continue;
                cancelledByUser = true;
                OSProcessManager.getInstance().killProcessTree(processHandler.getProcess());
                break;
            }
            exitCode = processHandler.getExitCode();
        }
        catch (ExecutionException e) {
            exception = e;
        }
        boolean success = exception == null && !cancelledByUser && !output.isEmpty() && exitCode != null && exitCode == 0;
        this.reportFeedback(builder, command, success, output, exception, cancelledByUser);
        this.onFinish(success);
    }

    @NotNull
    protected ComposerTextListener createTextListener(@NotNull ProgressIndicator indicator, @NotNull ComposerLogMessageBuilder builder, @NotNull List<Pair<String, Key>> output) {
        if (indicator == null) {
            ComposerCommandExecutor.$$$reportNull$$$0(4);
        }
        if (builder == null) {
            ComposerCommandExecutor.$$$reportNull$$$0(5);
        }
        if (output == null) {
            ComposerCommandExecutor.$$$reportNull$$$0(6);
        }
        ComposerBaseTextListener composerBaseTextListener = new ComposerBaseTextListener(builder, output, indicator);
        if (composerBaseTextListener == null) {
            ComposerCommandExecutor.$$$reportNull$$$0(7);
        }
        return composerBaseTextListener;
    }

    protected void reportFeedback(@NotNull ComposerLogMessageBuilder builder, @NotNull List<String> command, boolean success, List<Pair<String, Key>> output, @Nullable ExecutionException exception, boolean cancelledByUser) {
        ComposerLogMessageBuilder.SummaryMessage summary;
        NotificationType notificationType;
        if (builder == null) {
            ComposerCommandExecutor.$$$reportNull$$$0(8);
        }
        if (command == null) {
            ComposerCommandExecutor.$$$reportNull$$$0(9);
        }
        if (success) {
            notificationType = NotificationType.INFORMATION;
            summary = this.createSuccessfulSummary();
        } else {
            notificationType = NotificationType.ERROR;
            summary = this.createFailureSummary();
            if (cancelledByUser) {
                notificationType = NotificationType.INFORMATION;
                summary.appendText(" Script was cancelled.");
            }
            if (exception != null) {
                summary.appendText(exception.getMessage());
            }
        }
        builder.printSummary(summary, success, this.reportInEventLog(), notificationType, this.myProject);
    }

    protected abstract ComposerLogMessageBuilder.SummaryMessage createSuccessfulSummary();

    protected abstract ComposerLogMessageBuilder.SummaryMessage createFailureSummary();

    protected boolean reportInEventLog() {
        return this.myReportInEventLog;
    }

    protected abstract String getProgressTitle();

    protected abstract String getActionName();

    @NotNull
    protected abstract List<String> getBasicCommand();

    protected void onFinish(boolean success) {
    }

    @Nullable
    protected abstract ThrowableNotNullFunction<Project, ComposerCommandExecutor, ExecutionException> getExecutorGenerator();

    @NotNull
    public static String createText(@NotNull List<? extends Pair<String, Key>> parts) {
        if (parts == null) {
            ComposerCommandExecutor.$$$reportNull$$$0(10);
        }
        if (parts.isEmpty()) {
            if ("" == null) {
                ComposerCommandExecutor.$$$reportNull$$$0(11);
            }
            return "";
        }
        StringBuilder builder = new StringBuilder();
        for (Pair<String, Key> pair : parts) {
            builder.append((String)pair.first);
        }
        String string = builder.toString();
        if (string == null) {
            ComposerCommandExecutor.$$$reportNull$$$0(12);
        }
        return string;
    }

    public static void checkFileExists(@NotNull String configFilePath, @Nullable VirtualFile configFile) throws ExecutionException {
        if (configFilePath == null) {
            ComposerCommandExecutor.$$$reportNull$$$0(13);
        }
        if (configFile == null) {
            throw new ExecutionException("File " + configFilePath + " does not exist.");
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 11: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 11: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runningData";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionStatistics";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "output";
                break;
            }
            case 7: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/composer/actions/ComposerCommandExecutor";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parts";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configFilePath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/composer/actions/ComposerCommandExecutor";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createTextListener";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "createText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "doRun";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createTextListener";
                break;
            }
            case 7: 
            case 11: 
            case 12: {
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "reportFeedback";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "createText";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "checkFileExists";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 11: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    protected static class ComposerBaseTextListener
    extends ComposerTextListener {
        private final ComposerLogMessageBuilder myBuilder;
        private final List<? super Pair<String, Key>> myOutput;
        private final ProgressIndicator myIndicator;

        public ComposerBaseTextListener(@NotNull ComposerLogMessageBuilder builder, @NotNull List<? super Pair<String, Key>> output, @NotNull ProgressIndicator indicator) {
            if (builder == null) {
                ComposerBaseTextListener.$$$reportNull$$$0(0);
            }
            if (output == null) {
                ComposerBaseTextListener.$$$reportNull$$$0(1);
            }
            if (indicator == null) {
                ComposerBaseTextListener.$$$reportNull$$$0(2);
            }
            this.myBuilder = builder;
            this.myOutput = output;
            this.myIndicator = indicator;
        }

        @Override
        void textAvailable(@NotNull String text, @NotNull Key attributes, @NotNull Key outputType) {
            if (text == null) {
                ComposerBaseTextListener.$$$reportNull$$$0(3);
            }
            if (attributes == null) {
                ComposerBaseTextListener.$$$reportNull$$$0(4);
            }
            if (outputType == null) {
                ComposerBaseTextListener.$$$reportNull$$$0(5);
            }
            this.myBuilder.printOutputPart(text, attributes);
            this.myOutput.add((Pair<String, Key>)Pair.create((Object)text, (Object)attributes));
            String indicatorText = StringUtil.notNullize((String)this.myIndicator.getText2()) + text;
            if (indicatorText.length() > 60) {
                indicatorText = "..." + indicatorText.substring(indicatorText.length() - 60);
            }
            this.myIndicator.setText2(indicatorText);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "builder";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "output";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "indicator";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "attributes";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "outputType";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/php/composer/actions/ComposerCommandExecutor$ComposerBaseTextListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "textAvailable";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static abstract class ComposerTextListener
    implements AnsiEscapeDecoder.ColoredTextAcceptor {
        private Key myOutputType;

        abstract void textAvailable(@NotNull String var1, @NotNull Key var2, @NotNull Key var3);

        public void coloredTextAvailable(@NotNull String text, @NotNull Key attributes) {
            if (text == null) {
                ComposerTextListener.$$$reportNull$$$0(0);
            }
            if (attributes == null) {
                ComposerTextListener.$$$reportNull$$$0(1);
            }
            this.textAvailable(text, attributes, this.myOutputType);
        }

        public void setOutputType(Key outputType) {
            this.myOutputType = outputType;
        }

        public void processTerminated(@NotNull ProcessEvent event) {
            if (event == null) {
                ComposerTextListener.$$$reportNull$$$0(2);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "attributes";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "event";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/php/composer/actions/ComposerCommandExecutor$ComposerTextListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "coloredTextAvailable";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "processTerminated";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class MyColoredProcessHandler
    extends KillableProcessHandler {
        private final AnsiEscapeDecoder myAnsiEscapeDecoder;
        @NotNull
        private final ComposerTextListener myListener;
        private boolean firstSystemShown;
        private final Object LOCK;

        private MyColoredProcessHandler(GeneralCommandLine commandLine, @NotNull ComposerTextListener listener) throws ExecutionException {
            if (listener == null) {
                MyColoredProcessHandler.$$$reportNull$$$0(0);
            }
            super(commandLine);
            this.myAnsiEscapeDecoder = new AnsiEscapeDecoder();
            this.firstSystemShown = false;
            this.LOCK = new Object();
            this.myListener = listener;
            this.setShouldKillProcessSoftly(false);
            this.addProcessListener((ProcessListener)new ProcessAdapter(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void processTerminated(@NotNull ProcessEvent event) {
                    if (event == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    Object object = LOCK;
                    synchronized (object) {
                        myListener.processTerminated(event);
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/jetbrains/php/composer/actions/ComposerCommandExecutor$MyColoredProcessHandler$1", "processTerminated"));
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void notifyTextAvailable(@NotNull String text, @NotNull Key outputType) {
            if (text == null) {
                MyColoredProcessHandler.$$$reportNull$$$0(1);
            }
            if (outputType == null) {
                MyColoredProcessHandler.$$$reportNull$$$0(2);
            }
            Object object = this.LOCK;
            synchronized (object) {
                if (!this.firstSystemShown && outputType == ProcessOutputTypes.SYSTEM) {
                    this.firstSystemShown = true;
                    return;
                }
                this.myListener.setOutputType(outputType);
                this.myAnsiEscapeDecoder.escapeText(text, outputType, (AnsiEscapeDecoder.ColoredTextAcceptor)this.myListener);
                this.myListener.setOutputType(null);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "listener";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "outputType";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/php/composer/actions/ComposerCommandExecutor$MyColoredProcessHandler";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "notifyTextAvailable";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

