/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.probablyBug;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.PhpIndex;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.BinaryExpression;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpEchoStatement;
import com.jetbrains.php.lang.psi.elements.PhpPrintExpression;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.PhpTypedElement;
import com.jetbrains.php.lang.psi.elements.SelfAssignmentExpression;
import com.jetbrains.php.lang.psi.elements.StringLiteralExpression;
import com.jetbrains.php.lang.psi.elements.Variable;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.Collection;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpToStringImplementationInspection
extends PhpInspection {
    public boolean STRICT_MODE = false;

    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            PhpToStringImplementationInspection.$$$reportNull$$$0(0);
        }
        PhpElementVisitor phpElementVisitor = new PhpElementVisitor(){

            public void visitPhpEchoStatement(PhpEchoStatement echoStatement) {
                PhpPsiElement[] arguments;
                for (PhpPsiElement argument : arguments = echoStatement.getArguments()) {
                    this.checkToStringImplementation((PsiElement)argument, holder);
                }
            }

            public void visitPhpPrint(PhpPrintExpression printExpression) {
                this.checkToStringImplementation((PsiElement)printExpression.getArgument(), holder);
            }

            public void visitPhpBinaryExpression(BinaryExpression expression) {
                if (expression.getOperationType() == PhpTokenTypes.opCONCAT) {
                    this.checkToStringImplementation(expression.getLeftOperand(), holder);
                    this.checkToStringImplementation(expression.getRightOperand(), holder);
                }
            }

            public void visitPhpSelfAssignmentExpression(SelfAssignmentExpression expression) {
                PsiElement operation = expression.getOperation();
                if (PhpPsiUtil.isOfType(operation, PhpTokenTypes.opCONCAT_ASGN)) {
                    this.checkToStringImplementation((PsiElement)expression.getVariable(), holder);
                    this.checkToStringImplementation((PsiElement)expression.getValue(), holder);
                }
            }

            private void checkToStringImplementation(@Nullable PsiElement element, @NotNull ProblemsHolder holder2) {
                if (holder2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (element instanceof StringLiteralExpression) {
                    List<Variable> variables = PhpPsiUtil.getChildren(element, (Condition<? super PsiElement>)Variable.INSTANCEOF);
                    for (Variable variable : variables) {
                        PhpToStringImplementationInspection.this.checkImplementation((PsiElement)variable, variable.getType(), holder2);
                    }
                } else if (element instanceof PhpTypedElement) {
                    PhpToStringImplementationInspection.this.checkImplementation(element, ((PhpTypedElement)element).getType(), holder2);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/jetbrains/php/lang/inspections/probablyBug/PhpToStringImplementationInspection$1", "checkToStringImplementation"));
            }
        };
        if (phpElementVisitor == null) {
            PhpToStringImplementationInspection.$$$reportNull$$$0(1);
        }
        return phpElementVisitor;
    }

    private void checkImplementation(@NotNull PsiElement element, @NotNull PhpType type, @NotNull ProblemsHolder holder) {
        PhpType completedType;
        if (element == null) {
            PhpToStringImplementationInspection.$$$reportNull$$$0(2);
        }
        if (type == null) {
            PhpToStringImplementationInspection.$$$reportNull$$$0(3);
        }
        if (holder == null) {
            PhpToStringImplementationInspection.$$$reportNull$$$0(4);
        }
        if (!this.checkType(completedType = type.globalLocationAware(element).filterNull(), PhpIndex.getInstance((Project)element.getProject()))) {
            holder.registerProblem(element, PhpBundle.message("inspection.method.to.string.is.not.implemented", completedType), new LocalQuickFix[0]);
        }
    }

    private boolean checkType(@NotNull PhpType phpType, @NotNull PhpIndex index) {
        if (phpType == null) {
            PhpToStringImplementationInspection.$$$reportNull$$$0(5);
        }
        if (index == null) {
            PhpToStringImplementationInspection.$$$reportNull$$$0(6);
        }
        if (phpType.isUndefined() || !phpType.isComplete() || phpType.getTypes().isEmpty()) {
            return true;
        }
        for (String type : phpType.getTypes()) {
            boolean canBeConverted;
            boolean bl = canBeConverted = PhpType.isUnresolved((String)type) || PhpType.isPrimitiveType((String)type) || PhpToStringImplementationInspection.hasToStringImplementation(index.getAnyByFQN(type));
            if (canBeConverted && !this.STRICT_MODE) {
                return true;
            }
            if (canBeConverted || !this.STRICT_MODE) continue;
            return false;
        }
        return this.STRICT_MODE;
    }

    private static boolean hasToStringImplementation(Collection<PhpClass> classes) {
        for (PhpClass clazz : classes) {
            if ((clazz.isInterface() || !clazz.isAbstract()) && clazz.findMethodByName((CharSequence)"__toString") == null) continue;
            return true;
        }
        return false;
    }

    public JComponent createOptionsPanel() {
        return new OptionsPanel().getComponent();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/inspections/probablyBug/PhpToStringImplementationInspection";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "phpType";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "index";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/inspections/probablyBug/PhpToStringImplementationInspection";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: {
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "checkImplementation";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "checkType";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public class OptionsPanel {
        private JPanel myOptionsPanel;
        private JCheckBox myStrictModeCheckBox;

        public OptionsPanel() {
            this.$$$setupUI$$$();
            this.myStrictModeCheckBox.setSelected(PhpToStringImplementationInspection.this.STRICT_MODE);
            this.myStrictModeCheckBox.getModel().addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    PhpToStringImplementationInspection.this.STRICT_MODE = OptionsPanel.this.myStrictModeCheckBox.isSelected();
                }
            });
        }

        public JPanel getComponent() {
            return this.myOptionsPanel;
        }

        private /* synthetic */ void $$$setupUI$$$() {
            JCheckBox jCheckBox;
            JPanel jPanel;
            this.myOptionsPanel = jPanel = new JPanel();
            jPanel.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
            this.myStrictModeCheckBox = jCheckBox = new JCheckBox();
            this.$$$loadButtonText$$$(jCheckBox, ResourceBundle.getBundle("messages/PhpBundle").getString("inspection.method.to.string.is.not.implemented.strict.mode"));
            jPanel.add((Component)jCheckBox, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
            Spacer spacer = new Spacer();
            jPanel.add((Component)spacer, new GridConstraints(1, 0, 1, 2, 0, 2, 1, 6, null, null, null));
            Spacer spacer2 = new Spacer();
            jPanel.add((Component)spacer2, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 1, null, null, null));
        }

        public /* synthetic */ JComponent $$$getRootComponent$$$() {
            return this.myOptionsPanel;
        }

        private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
            StringBuffer stringBuffer = new StringBuffer();
            boolean bl = false;
            char c = '\u0000';
            int n = -1;
            for (int i = 0; i < string.length(); ++i) {
                if (string.charAt(i) == '&') {
                    if (++i == string.length()) break;
                    if (!bl && string.charAt(i) != '&') {
                        bl = true;
                        c = string.charAt(i);
                        n = stringBuffer.length();
                    }
                }
                stringBuffer.append(string.charAt(i));
            }
            abstractButton.setText(stringBuffer.toString());
            if (bl) {
                abstractButton.setMnemonic(c);
                abstractButton.setDisplayedMnemonicIndex(n);
            }
        }
    }
}

