/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.quickfix;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.PhpIndex;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.inspections.quickfix.PhpBaseImportQuickFix;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.elements.ClassReference;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpReference;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpImportClassQuickFix
extends PhpBaseImportQuickFix<PhpClass> {
    public static final PhpImportClassQuickFix INSTANCE = new PhpImportClassQuickFix();
    public static final String NAME = PhpBundle.message("quickfix.import.class.name", new Object[0]);
    public static final String[] IGNORABLE_NAMESPACES = new String[]{"\\___PHPSTORM_HELPERS\\"};

    @NotNull
    public String getFamilyName() {
        String string = NAME;
        if (string == null) {
            PhpImportClassQuickFix.$$$reportNull$$$0(0);
        }
        return string;
    }

    protected PhpClass[] toArray(@NotNull Collection<PhpClass> candidates) {
        if (candidates == null) {
            PhpImportClassQuickFix.$$$reportNull$$$0(1);
        }
        return candidates.toArray(PhpClass.EMPTY_ARRAY);
    }

    @Override
    @NotNull
    protected String getImportPopupTitle() {
        String string = PhpBundle.message("quickfix.import.class.popup.title", new Object[0]);
        if (string == null) {
            PhpImportClassQuickFix.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    @Nullable
    protected String getImportKeyword() {
        return null;
    }

    @Override
    protected void replaceReference(@NotNull Project project, @NotNull PhpReference reference, @NotNull String fqn) {
        if (project == null) {
            PhpImportClassQuickFix.$$$reportNull$$$0(3);
        }
        if (reference == null) {
            PhpImportClassQuickFix.$$$reportNull$$$0(4);
        }
        if (fqn == null) {
            PhpImportClassQuickFix.$$$reportNull$$$0(5);
        }
        ClassReference qualifiedClassReference = PhpPsiElementFactory.createClassReference(project, PhpLangUtil.toPresentableFQN(fqn));
        reference.replace((PsiElement)qualifiedClassReference);
    }

    @Override
    @NotNull
    public Collection<PhpClass> getCandidates(@NotNull Project project, @NotNull PhpReference reference) {
        if (project == null) {
            PhpImportClassQuickFix.$$$reportNull$$$0(6);
        }
        if (reference == null) {
            PhpImportClassQuickFix.$$$reportNull$$$0(7);
        }
        String fqn = PhpType.isPluralType((String)reference.getText()) ? StringUtil.trimEnd((String)reference.getText(), (String)"[]") : reference.getText();
        LinkedHashMap candidates = ContainerUtil.newLinkedHashMap();
        Options options = PhpImportClassQuickFix.getImportOptions(reference);
        if (options == Options.IMPORT_INTERFACES || options == Options.IMPORT_BOTH) {
            PhpImportClassQuickFix.addFilteredClasses(candidates, PhpIndex.getInstance((Project)project).getInterfacesByName(fqn));
        }
        if (options == Options.IMPORT_CLASSES || options == Options.IMPORT_BOTH) {
            PhpImportClassQuickFix.addFilteredClasses(candidates, PhpIndex.getInstance((Project)project).getClassesByName(fqn));
        }
        if (options == Options.IMPORT_BOTH) {
            PhpImportClassQuickFix.addFilteredClasses(candidates, PhpIndex.getInstance((Project)project).getTraitsByName(fqn));
        }
        Collection<PhpClass> collection = candidates.values();
        if (collection == null) {
            PhpImportClassQuickFix.$$$reportNull$$$0(8);
        }
        return collection;
    }

    private static void addFilteredClasses(@NotNull Map<String, PhpClass> targetList, @NotNull Collection<PhpClass> sourceClasses) {
        if (targetList == null) {
            PhpImportClassQuickFix.$$$reportNull$$$0(9);
        }
        if (sourceClasses == null) {
            PhpImportClassQuickFix.$$$reportNull$$$0(10);
        }
        for (PhpClass phpClass : sourceClasses) {
            String namespace = phpClass.getNamespaceName();
            boolean ignore = false;
            for (String ignorableNamepsace : IGNORABLE_NAMESPACES) {
                if (!ignorableNamepsace.equals(namespace)) continue;
                ignore = true;
                break;
            }
            if (ignore) continue;
            targetList.put(phpClass.getFQN(), phpClass);
        }
    }

    @NotNull
    public static Options getImportOptions(@NotNull PhpReference classReference) {
        PsiElement target;
        IElementType targetType;
        if (classReference == null) {
            PhpImportClassQuickFix.$$$reportNull$$$0(11);
        }
        if ((targetType = PsiUtilCore.getElementType((PsiElement)(target = classReference.getParent()))) == PhpElementTypes.IMPLEMENTS_LIST) {
            Options options = Options.IMPORT_INTERFACES;
            if (options == null) {
                PhpImportClassQuickFix.$$$reportNull$$$0(12);
            }
            return options;
        }
        if (targetType == PhpElementTypes.EXTENDS_LIST || targetType == PhpElementTypes.NEW_EXPRESSION) {
            Options options = Options.IMPORT_CLASSES;
            if (options == null) {
                PhpImportClassQuickFix.$$$reportNull$$$0(13);
            }
            return options;
        }
        Options options = Options.IMPORT_BOTH;
        if (options == null) {
            PhpImportClassQuickFix.$$$reportNull$$$0(14);
        }
        return options;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/inspections/quickfix/PhpImportClassQuickFix";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "candidates";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fqn";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetList";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceClasses";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classReference";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/inspections/quickfix/PhpImportClassQuickFix";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getImportPopupTitle";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getCandidates";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getImportOptions";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "toArray";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "replaceReference";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getCandidates";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "addFilteredClasses";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getImportOptions";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static enum Options {
        IMPORT_INTERFACES,
        IMPORT_CLASSES,
        IMPORT_BOTH;

    }
}

