/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.phar;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.phar.PharFileSystem;
import com.jetbrains.php.phar.PharFileType;
import com.jetbrains.php.phar.PharLibraryManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IgnorePharAction
extends AnAction {
    public IgnorePharAction() {
        super(PhpBundle.message("phar.exclude.or.include.into.project.action.title", new Object[0]));
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            IgnorePharAction.$$$reportNull$$$0(0);
        }
        e.getPresentation().setVisible(false);
        Project project = e.getProject();
        if (project == null) {
            return;
        }
        VirtualFile[] selectedFiles = IgnorePharAction.getPhars(e);
        if (selectedFiles == null) {
            return;
        }
        PharLibraryManager manager = PharLibraryManager.getInstance(project);
        boolean isExcluded = manager.isExcluded(selectedFiles[0]);
        for (VirtualFile file : selectedFiles) {
            if (isExcluded == manager.isExcluded(file)) continue;
            return;
        }
        String text = isExcluded ? PhpBundle.message("phar.include.into.project.action.title", new Object[0]) : PhpBundle.message("phar.exclude.from.project.action.title", new Object[0]);
        e.getPresentation().setText(text);
        e.getPresentation().setVisible(true);
    }

    @Nullable
    private static VirtualFile[] getPhars(AnActionEvent e) {
        DataContext dataContext = e.getDataContext();
        VirtualFile[] selectedFiles = (VirtualFile[])CommonDataKeys.VIRTUAL_FILE_ARRAY.getData(dataContext);
        if (selectedFiles == null || selectedFiles.length == 0) {
            return null;
        }
        for (VirtualFile file : selectedFiles) {
            if (!file.isDirectory() && PharFileType.isPhar(file)) continue;
            return null;
        }
        PharFileSystem pharFileSystem = PharFileSystem.getInstance();
        VirtualFile[] result = new VirtualFile[selectedFiles.length];
        for (int i = 0; i < selectedFiles.length; ++i) {
            VirtualFile pharFile = pharFileSystem.getRootByLocal(selectedFiles[i]);
            if (pharFile == null) {
                return null;
            }
            result[i] = pharFile;
        }
        return result;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Project project;
        if (e == null) {
            IgnorePharAction.$$$reportNull$$$0(1);
        }
        if ((project = e.getProject()) == null) {
            return;
        }
        VirtualFile[] selectedFiles = IgnorePharAction.getPhars(e);
        if (selectedFiles == null) {
            return;
        }
        PharLibraryManager manager = PharLibraryManager.getInstance(project);
        boolean exclude = !manager.isExcluded(selectedFiles[0]);
        manager.setExcluded(selectedFiles, exclude);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "e";
        objectArray2[1] = "com/jetbrains/php/phar/IgnorePharAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

