/*
 * Decompiled with CFR 0.152.
 */
package com.sixrr.xrp.attributetotag;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.IncorrectOperationException;
import com.sixrr.xrp.base.XRPUsageInfo;

class ReplaceAttributeWithTag
extends XRPUsageInfo {
    private final XmlTag tag;
    private final String attributeName;
    private final String attributeNamespace;
    private final String tagName;

    ReplaceAttributeWithTag(XmlTag tag, String tagName, String attributeName, String attributeNamespace) {
        super((PsiElement)tag);
        this.tag = tag;
        this.attributeName = attributeName;
        this.attributeNamespace = attributeNamespace;
        this.tagName = tagName;
    }

    @Override
    public void fixUsage() throws IncorrectOperationException {
        XmlAttribute attribute = this.tag.getAttribute(this.attributeName, this.attributeNamespace);
        if (attribute == null) {
            return;
        }
        String value = attribute.getValue();
        value = StringUtil.unescapeXml((String)value);
        value = StringUtil.escapeXml((String)value);
        PsiManager manager = this.tag.getManager();
        XmlTag childTag = this.tag.createChildTag(this.tagName, this.attributeNamespace, value, true);
        this.tag.add((PsiElement)childTag);
        attribute.delete();
        CodeStyleManager codeStyleManager = CodeStyleManager.getInstance((Project)manager.getProject());
        codeStyleManager.reformat((PsiElement)this.tag);
    }
}

