# This file was auto-generated by lib/generators/tasks/generate.rb

module Slack
  module Endpoint
    module Files
      #
      # Add a comment to an existing file.
      #
      # @option options [Object] :comment
      #   Text of the comment to add.
      # @option options [Object] :file
      #   File to add a comment to.
      # @see https://api.slack.com/methods/files.comments.add
      # @see https://github.com/aki017/slack-api-docs/blob/master/methods/files.comments.add.md
      # @see https://github.com/aki017/slack-api-docs/blob/master/methods/files.comments.add.json
      def files_comments_add(options={})
        throw ArgumentError.new("Required arguments :comment missing") if options[:comment].nil?
        throw ArgumentError.new("Required arguments :file missing") if options[:file].nil?
        post("files.comments.add", options)
      end

      #
      # Deletes an existing comment on a file.
      #
      # @option options [Object] :file
      #   File to delete a comment from.
      # @option options [Object] :id
      #   The comment to delete.
      # @see https://api.slack.com/methods/files.comments.delete
      # @see https://github.com/aki017/slack-api-docs/blob/master/methods/files.comments.delete.md
      # @see https://github.com/aki017/slack-api-docs/blob/master/methods/files.comments.delete.json
      def files_comments_delete(options={})
        throw ArgumentError.new("Required arguments :file missing") if options[:file].nil?
        throw ArgumentError.new("Required arguments :id missing") if options[:id].nil?
        post("files.comments.delete", options)
      end

      #
      # Edit an existing file comment.
      #
      # @option options [Object] :comment
      #   Text of the comment to edit.
      # @option options [Object] :file
      #   File containing the comment to edit.
      # @option options [Object] :id
      #   The comment to edit.
      # @see https://api.slack.com/methods/files.comments.edit
      # @see https://github.com/aki017/slack-api-docs/blob/master/methods/files.comments.edit.md
      # @see https://github.com/aki017/slack-api-docs/blob/master/methods/files.comments.edit.json
      def files_comments_edit(options={})
        throw ArgumentError.new("Required arguments :comment missing") if options[:comment].nil?
        throw ArgumentError.new("Required arguments :file missing") if options[:file].nil?
        throw ArgumentError.new("Required arguments :id missing") if options[:id].nil?
        post("files.comments.edit", options)
      end

      #
      # Deletes a file.
      #
      # @option options [Object] :file
      #   ID of file to delete.
      # @see https://api.slack.com/methods/files.delete
      # @see https://github.com/aki017/slack-api-docs/blob/master/methods/files.delete.md
      # @see https://github.com/aki017/slack-api-docs/blob/master/methods/files.delete.json
      def files_delete(options={})
        throw ArgumentError.new("Required arguments :file missing") if options[:file].nil?
        post("files.delete", options)
      end

      #
      # Gets information about a team file.
      #
      # @option options [Object] :file
      #   Specify a file by providing its ID.
      # @option options [Object] :count
      #   Number of items to return per page.
      # @option options [Object] :page
      #   Page number of results to return.
      # @see https://api.slack.com/methods/files.info
      # @see https://github.com/aki017/slack-api-docs/blob/master/methods/files.info.md
      # @see https://github.com/aki017/slack-api-docs/blob/master/methods/files.info.json
      def files_info(options={})
        throw ArgumentError.new("Required arguments :file missing") if options[:file].nil?
        post("files.info", options)
      end

      #
      # Lists & filters team files.
      #
      # @option options [Object] :channel
      #   Filter files appearing in a specific channel, indicated by its ID.
      # @option options [Object] :count
      #   Number of items to return per page.
      # @option options [Object] :page
      #   Page number of results to return.
      # @option options [Object] :ts_from
      #   Filter files created after this timestamp (inclusive).
      # @option options [Object] :ts_to
      #   Filter files created before this timestamp (inclusive).
      # @option options [Object] :types
      #   Filter files by type:
      #   
      #   
      #   all - All files
      #   spaces - Posts
      #   snippets - Snippets
      #   images - Image files
      #   gdocs - Google docs
      #   zips - Zip files
      #   pdfs - PDF files
      #   
      #   
      #   You can pass multiple values in the types argument, like types=spaces,snippets.The default value is all, which does not filter the list.
      # @option options [Object] :user
      #   Filter files created by a single user.
      # @see https://api.slack.com/methods/files.list
      # @see https://github.com/aki017/slack-api-docs/blob/master/methods/files.list.md
      # @see https://github.com/aki017/slack-api-docs/blob/master/methods/files.list.json
      def files_list(options={})
        post("files.list", options)
      end

      #
      # Revokes public/external sharing access for a file
      #
      # @option options [Object] :file
      #   File to revoke
      # @see https://api.slack.com/methods/files.revokePublicURL
      # @see https://github.com/aki017/slack-api-docs/blob/master/methods/files.revokePublicURL.md
      # @see https://github.com/aki017/slack-api-docs/blob/master/methods/files.revokePublicURL.json
      def files_revokePublicURL(options={})
        throw ArgumentError.new("Required arguments :file missing") if options[:file].nil?
        post("files.revokePublicURL", options)
      end

      #
      # Enables a file for public/external sharing.
      #
      # @option options [Object] :file
      #   File to share
      # @see https://api.slack.com/methods/files.sharedPublicURL
      # @see https://github.com/aki017/slack-api-docs/blob/master/methods/files.sharedPublicURL.md
      # @see https://github.com/aki017/slack-api-docs/blob/master/methods/files.sharedPublicURL.json
      def files_sharedPublicURL(options={})
        throw ArgumentError.new("Required arguments :file missing") if options[:file].nil?
        post("files.sharedPublicURL", options)
      end

      #
      # This is for starting the upload process of a file. It only requires a filename, and gives back a ticket ID so that later, the upload can be found
      # and updated with all the remaining file info.
      #
      # @option options [Object] :file
      #   File contents via multipart/form-data.
      # @see https://api.slack.com/methods/files.startPartialUpload
      # @see https://github.com/aki017/slack-api-docs/blob/master/methods/files.startPartialUpload.md
      # @see https://github.com/aki017/slack-api-docs/blob/master/methods/files.startPartialUpload.json
      def files_startPartialUpload(options={})
        post("files.startPartialUpload", options)
      end

      #
      # Uploads or creates a file.
      #
      # @option options [Object] :channels
      #   Comma-separated list of channel names or IDs where the file will be shared.
      # @option options [Object] :content
      #   File contents via a POST variable. If omitting this parameter, you must provide a file.
      # @option options [Object] :file
      #   File contents via multipart/form-data. If omitting this parameter, you must submit content.
      # @option options [Object] :filename
      #   Filename of file.
      # @option options [Object] :filetype
      #   A file type identifier.
      # @option options [Object] :initial_comment
      #   Initial comment to add to file.
      # @option options [Object] :title
      #   Title of file.
      # @see https://api.slack.com/methods/files.upload
      # @see https://github.com/aki017/slack-api-docs/blob/master/methods/files.upload.md
      # @see https://github.com/aki017/slack-api-docs/blob/master/methods/files.upload.json
      def files_upload(options={})
        post("files.upload", options)
      end

    end
  end
end
