/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.nlp.lm.util;

public final class MurmurHash {
    public static int hash32(int[] data, int startPos, int endPos, int seed) {
        int m = 1540483477;
        int r = 24;
        int length = endPos - startPos;
        int h = seed ^ length;
        for (int i = startPos; i < endPos; ++i) {
            int k = data[i];
            k *= 1540483477;
            k ^= k >>> 24;
            h *= 1540483477;
            h ^= (k *= 1540483477);
        }
        h ^= h >>> 13;
        h *= 1540483477;
        h ^= h >>> 15;
        return h;
    }

    public static int hash32(int[] data, int startPos, int endPos) {
        return MurmurHash.hash32(data, startPos, endPos, -1756908916);
    }

    public static long hashOneLong(long k_, int seed) {
        long k = k_;
        long m = -4132994306676758123L;
        int r = 47;
        long h = (long)seed & 0xFFFFFFFFL ^ 0xC6A4A7935BD1E995L;
        k *= -4132994306676758123L;
        k ^= k >>> 47;
        h ^= (k *= -4132994306676758123L);
        h *= -4132994306676758123L;
        h ^= h >>> 47;
        h *= -4132994306676758123L;
        h ^= h >>> 47;
        return h;
    }

    public static long hashThreeLongs(long k1, long k2, long k3) {
        int seed = -1756908916;
        long m = -4132994306676758123L;
        int r = 47;
        long h = -4132994304784835815L;
        for (int i = 0; i <= 2; ++i) {
            long k = -1L;
            switch (i) {
                case 0: {
                    k = k1;
                    break;
                }
                case 1: {
                    k = k2;
                    break;
                }
                case 2: {
                    k = k3;
                    break;
                }
                default: {
                    assert (false);
                    break;
                }
            }
            k *= -4132994306676758123L;
            k ^= k >>> 47;
            h ^= (k *= -4132994306676758123L);
            h *= -4132994306676758123L;
        }
        h ^= h >>> 47;
        h *= -4132994306676758123L;
        h ^= h >>> 47;
        return h;
    }
}

