function Snowball() {
BaseStemmer = function() {
this.setCurrent = function(value) {
this.current = value;
this.cursor = 0;
this.limit = this.current.length;
this.limit_backward = 0;
this.bra = this.cursor;
this.ket = this.limit;
};
this.getCurrent = function() {
return this.current;
};
this.copy_from = function(other) {
this.current = other.current;
this.cursor = other.cursor;
this.limit = other.limit;
this.limit_backward = other.limit_backward;
this.bra = other.bra;
this.ket = other.ket;
};
this.in_grouping = function(s, min, max) {
if (this.cursor >= this.limit) return false;
var ch = this.current.charCodeAt(this.cursor);
if (ch > max || ch < min) return false;
ch -= min;
if ((s[ch >>> 3] & (0x1 << (ch & 0x7))) == 0) return false;
this.cursor++;
return true;
};
this.in_grouping_b = function(s, min, max) {
if (this.cursor <= this.limit_backward) return false;
var ch = this.current.charCodeAt(this.cursor - 1);
if (ch > max || ch < min) return false;
ch -= min;
if ((s[ch >>> 3] & (0x1 << (ch & 0x7))) == 0) return false;
this.cursor--;
return true;
};
this.out_grouping = function(s, min, max) {
if (this.cursor >= this.limit) return false;
var ch = this.current.charCodeAt(this.cursor);
if (ch > max || ch < min) {
this.cursor++;
return true;
}
ch -= min;
if ((s[ch >>> 3] & (0X1 << (ch & 0x7))) == 0) {
this.cursor++;
return true;
}
return false;
};
this.out_grouping_b = function(s, min, max) {
if (this.cursor <= this.limit_backward) return false;
var ch = this.current.charCodeAt(this.cursor - 1);
if (ch > max || ch < min) {
this.cursor--;
return true;
}
ch -= min;
if ((s[ch >>> 3] & (0x1 << (ch & 0x7))) == 0) {
this.cursor--;
return true;
}
return false;
};
this.eq_s = function(s)
{
if (this.limit - this.cursor < s.length) return false;
if (this.current.slice(this.cursor, this.cursor + s.length) != s)
{
return false;
}
this.cursor += s.length;
return true;
};
this.eq_s_b = function(s)
{
if (this.cursor - this.limit_backward < s.length) return false;
if (this.current.slice(this.cursor - s.length, this.cursor) != s)
{
return false;
}
this.cursor -= s.length;
return true;
};
 this.find_among = function(v)
{
var i = 0;
var j = v.length;
var c = this.cursor;
var l = this.limit;
var common_i = 0;
var common_j = 0;
var first_key_inspected = false;
while (true)
{
var k = i + ((j - i) >>> 1);
var diff = 0;
var common = common_i < common_j ? common_i : common_j; 
var w = v[k];
var i2;
for (i2 = common; i2 < w[0].length; i2++)
{
if (c + common == l)
{
diff = -1;
break;
}
diff = this.current.charCodeAt(c + common) - w[0].charCodeAt(i2);
if (diff != 0) break;
common++;
}
if (diff < 0)
{
j = k;
common_j = common;
}
else
{
i = k;
common_i = common;
}
if (j - i <= 1)
{
if (i > 0) break; 
if (j == i) break; 
if (first_key_inspected) break;
first_key_inspected = true;
}
}
do {
var w = v[i];
if (common_i >= w[0].length)
{
this.cursor = c + w[0].length;
if (w.length < 4) return w[2];
var res = w[3](this);
this.cursor = c + w[0].length;
if (res) return w[2];
}
i = w[1];
} while (i >= 0);
return 0;
};
this.find_among_b = function(v)
{
var i = 0;
var j = v.length
var c = this.cursor;
var lb = this.limit_backward;
var common_i = 0;
var common_j = 0;
var first_key_inspected = false;
while (true)
{
var k = i + ((j - i) >> 1);
var diff = 0;
var common = common_i < common_j ? common_i : common_j;
var w = v[k];
var i2;
for (i2 = w[0].length - 1 - common; i2 >= 0; i2--)
{
if (c - common == lb)
{
diff = -1;
break;
}
diff = this.current.charCodeAt(c - 1 - common) - w[0].charCodeAt(i2);
if (diff != 0) break;
common++;
}
if (diff < 0)
{
j = k;
common_j = common;
}
else
{
i = k;
common_i = common;
}
if (j - i <= 1)
{
if (i > 0) break;
if (j == i) break;
if (first_key_inspected) break;
first_key_inspected = true;
}
}
do {
var w = v[i];
if (common_i >= w[0].length)
{
this.cursor = c - w[0].length;
if (w.length < 4) return w[2];
var res = w[3](this);
this.cursor = c - w[0].length;
if (res) return w[2];
}
i = w[1];
} while (i >= 0);
return 0;
};
this.replace_s = function(c_bra, c_ket, s)
{
var adjustment = s.length - (c_ket - c_bra);
this.current = this.current.slice(0, c_bra) + s + this.current.slice(c_ket);
this.limit += adjustment;
if (this.cursor >= c_ket) this.cursor += adjustment;
else if (this.cursor > c_bra) this.cursor = c_bra;
return adjustment;
};
this.slice_check = function()
{
if (this.bra < 0 ||
this.bra > this.ket ||
this.ket > this.limit ||
this.limit > this.current.length)
{
return false;
}
return true;
};
this.slice_from = function(s)
{
var result = false;
if (this.slice_check())
{
this.replace_s(this.bra, this.ket, s);
result = true;
}
return result;
};
this.slice_del = function()
{
return this.slice_from("");
};
this.insert = function(c_bra, c_ket, s)
{
var adjustment = this.replace_s(c_bra, c_ket, s);
if (c_bra <= this.bra) this.bra += adjustment;
if (c_bra <= this.ket) this.ket += adjustment;
};
this.slice_to = function()
{
var result = '';
if (this.slice_check())
{
result = this.current.slice(this.bra, this.ket);
}
return result;
};
this.assign_to = function()
{
return this.current.slice(0, this.limit);
};
};
EnglishStemmer = function() {
var base = new BaseStemmer();
 var a_0 = [
["arsen", -1, -1],
["commun", -1, -1],
["gener", -1, -1]
];
 var a_1 = [
["'", -1, 1],
["'s'", 0, 1],
["'s", -1, 1]
];
 var a_2 = [
["ied", -1, 2],
["s", -1, 3],
["ies", 1, 2],
["sses", 1, 1],
["ss", 1, -1],
["us", 1, -1]
];
 var a_3 = [
["", -1, 3],
["bb", 0, 2],
["dd", 0, 2],
["ff", 0, 2],
["gg", 0, 2],
["bl", 0, 1],
["mm", 0, 2],
["nn", 0, 2],
["pp", 0, 2],
["rr", 0, 2],
["at", 0, 1],
["tt", 0, 2],
["iz", 0, 1]
];
 var a_4 = [
["ed", -1, 2],
["eed", 0, 1],
["ing", -1, 2],
["edly", -1, 2],
["eedly", 3, 1],
["ingly", -1, 2]
];
 var a_5 = [
["anci", -1, 3],
["enci", -1, 2],
["ogi", -1, 13],
["li", -1, 15],
["bli", 3, 12],
["abli", 4, 4],
["alli", 3, 8],
["fulli", 3, 9],
["lessli", 3, 14],
["ousli", 3, 10],
["entli", 3, 5],
["aliti", -1, 8],
["biliti", -1, 12],
["iviti", -1, 11],
["tional", -1, 1],
["ational", 14, 7],
["alism", -1, 8],
["ation", -1, 7],
["ization", 17, 6],
["izer", -1, 6],
["ator", -1, 7],
["iveness", -1, 11],
["fulness", -1, 9],
["ousness", -1, 10]
];
 var a_6 = [
["icate", -1, 4],
["ative", -1, 6],
["alize", -1, 3],
["iciti", -1, 4],
["ical", -1, 4],
["tional", -1, 1],
["ational", 5, 2],
["ful", -1, 5],
["ness", -1, 5]
];
 var a_7 = [
["ic", -1, 1],
["ance", -1, 1],
["ence", -1, 1],
["able", -1, 1],
["ible", -1, 1],
["ate", -1, 1],
["ive", -1, 1],
["ize", -1, 1],
["iti", -1, 1],
["al", -1, 1],
["ism", -1, 1],
["ion", -1, 2],
["er", -1, 1],
["ous", -1, 1],
["ant", -1, 1],
["ent", -1, 1],
["ment", 15, 1],
["ement", 16, 1]
];
 var a_8 = [
["e", -1, 1],
["l", -1, 2]
];
 var a_9 = [
["succeed", -1, -1],
["proceed", -1, -1],
["exceed", -1, -1],
["canning", -1, -1],
["inning", -1, -1],
["earring", -1, -1],
["herring", -1, -1],
["outing", -1, -1]
];
 var a_10 = [
["andes", -1, -1],
["atlas", -1, -1],
["bias", -1, -1],
["cosmos", -1, -1],
["dying", -1, 3],
["early", -1, 9],
["gently", -1, 7],
["howe", -1, -1],
["idly", -1, 6],
["lying", -1, 4],
["news", -1, -1],
["only", -1, 10],
["singly", -1, 11],
["skies", -1, 2],
["skis", -1, 1],
["sky", -1, -1],
["tying", -1, 5],
["ugly", -1, 8]
];
 var  g_v = [17, 65, 16, 1];
 var  g_v_WXY = [1, 17, 65, 208, 1];
 var  g_valid_LI = [55, 141, 2];
var  B_Y_found = false;
var  I_p2 = 0;
var  I_p1 = 0;
function r_prelude() {
B_Y_found = false;
var  v_1 = base.cursor;
lab0: {
base.bra = base.cursor;
if (!(base.eq_s("'")))
{
break lab0;
}
base.ket = base.cursor;
if (!base.slice_del())
{
return false;
}
}
base.cursor = v_1;
var  v_2 = base.cursor;
lab1: {
base.bra = base.cursor;
if (!(base.eq_s("y")))
{
break lab1;
}
base.ket = base.cursor;
if (!base.slice_from("Y"))
{
return false;
}
B_Y_found = true;
}
base.cursor = v_2;
var  v_3 = base.cursor;
lab2: {
while(true)
{
var  v_4 = base.cursor;
lab3: {
golab4: while(true)
{
var  v_5 = base.cursor;
lab5: {
if (!(base.in_grouping(g_v, 97, 121)))
{
break lab5;
}
base.bra = base.cursor;
if (!(base.eq_s("y")))
{
break lab5;
}
base.ket = base.cursor;
base.cursor = v_5;
break golab4;
}
base.cursor = v_5;
if (base.cursor >= base.limit)
{
break lab3;
}
base.cursor++;
}
if (!base.slice_from("Y"))
{
return false;
}
B_Y_found = true;
continue;
}
base.cursor = v_4;
break;
}
}
base.cursor = v_3;
return true;
};
function r_mark_regions() {
I_p1 = base.limit;
I_p2 = base.limit;
var  v_1 = base.cursor;
lab0: {
lab1: {
var  v_2 = base.cursor;
lab2: {
if (base.find_among(a_0) == 0)
{
break lab2;
}
break lab1;
}
base.cursor = v_2;
golab3: while(true)
{
lab4: {
if (!(base.in_grouping(g_v, 97, 121)))
{
break lab4;
}
break golab3;
}
if (base.cursor >= base.limit)
{
break lab0;
}
base.cursor++;
}
golab5: while(true)
{
lab6: {
if (!(base.out_grouping(g_v, 97, 121)))
{
break lab6;
}
break golab5;
}
if (base.cursor >= base.limit)
{
break lab0;
}
base.cursor++;
}
}
I_p1 = base.cursor;
golab7: while(true)
{
lab8: {
if (!(base.in_grouping(g_v, 97, 121)))
{
break lab8;
}
break golab7;
}
if (base.cursor >= base.limit)
{
break lab0;
}
base.cursor++;
}
golab9: while(true)
{
lab10: {
if (!(base.out_grouping(g_v, 97, 121)))
{
break lab10;
}
break golab9;
}
if (base.cursor >= base.limit)
{
break lab0;
}
base.cursor++;
}
I_p2 = base.cursor;
}
base.cursor = v_1;
return true;
};
function r_shortv() {
lab0: {
var  v_1 = base.limit - base.cursor;
lab1: {
if (!(base.out_grouping_b(g_v_WXY, 89, 121)))
{
break lab1;
}
if (!(base.in_grouping_b(g_v, 97, 121)))
{
break lab1;
}
if (!(base.out_grouping_b(g_v, 97, 121)))
{
break lab1;
}
break lab0;
}
base.cursor = base.limit - v_1;
if (!(base.out_grouping_b(g_v, 97, 121)))
{
return false;
}
if (!(base.in_grouping_b(g_v, 97, 121)))
{
return false;
}
if (base.cursor > base.limit_backward)
{
return false;
}
}
return true;
};
function r_R1() {
if (!(I_p1 <= base.cursor))
{
return false;
}
return true;
};
function r_R2() {
if (!(I_p2 <= base.cursor))
{
return false;
}
return true;
};
function r_Step_1a() {
var  among_var;
var  v_1 = base.limit - base.cursor;
lab0: {
base.ket = base.cursor;
if (base.find_among_b(a_1) == 0)
{
base.cursor = base.limit - v_1;
break lab0;
}
base.bra = base.cursor;
if (!base.slice_del())
{
return false;
}
}
base.ket = base.cursor;
among_var = base.find_among_b(a_2);
if (among_var == 0)
{
return false;
}
base.bra = base.cursor;
switch (among_var) {
case 1:
if (!base.slice_from("ss"))
{
return false;
}
break;
case 2:
lab1: {
var  v_2 = base.limit - base.cursor;
lab2: {
{
var  c1 = base.cursor - 2;
if (base.limit_backward > c1 || c1 > base.limit)
{
break lab2;
}
base.cursor = c1;
}
if (!base.slice_from("i"))
{
return false;
}
break lab1;
}
base.cursor = base.limit - v_2;
if (!base.slice_from("ie"))
{
return false;
}
}
break;
case 3:
if (base.cursor <= base.limit_backward)
{
return false;
}
base.cursor--;
golab3: while(true)
{
lab4: {
if (!(base.in_grouping_b(g_v, 97, 121)))
{
break lab4;
}
break golab3;
}
if (base.cursor <= base.limit_backward)
{
return false;
}
base.cursor--;
}
if (!base.slice_del())
{
return false;
}
break;
}
return true;
};
function r_Step_1b() {
var  among_var;
base.ket = base.cursor;
among_var = base.find_among_b(a_4);
if (among_var == 0)
{
return false;
}
base.bra = base.cursor;
switch (among_var) {
case 1:
if (!r_R1())
{
return false;
}
if (!base.slice_from("ee"))
{
return false;
}
break;
case 2:
var  v_1 = base.limit - base.cursor;
golab0: while(true)
{
lab1: {
if (!(base.in_grouping_b(g_v, 97, 121)))
{
break lab1;
}
break golab0;
}
if (base.cursor <= base.limit_backward)
{
return false;
}
base.cursor--;
}
base.cursor = base.limit - v_1;
if (!base.slice_del())
{
return false;
}
var  v_3 = base.limit - base.cursor;
among_var = base.find_among_b(a_3);
if (among_var == 0)
{
return false;
}
base.cursor = base.limit - v_3;
switch (among_var) {
case 1:
{
var  c1 = base.cursor;
base.insert(base.cursor, base.cursor, "e");
base.cursor = c1;
}
break;
case 2:
base.ket = base.cursor;
if (base.cursor <= base.limit_backward)
{
return false;
}
base.cursor--;
base.bra = base.cursor;
if (!base.slice_del())
{
return false;
}
break;
case 3:
if (base.cursor != I_p1)
{
return false;
}
var  v_4 = base.limit - base.cursor;
if (!r_shortv())
{
return false;
}
base.cursor = base.limit - v_4;
{
var  c2 = base.cursor;
base.insert(base.cursor, base.cursor, "e");
base.cursor = c2;
}
break;
}
break;
}
return true;
};
function r_Step_1c() {
base.ket = base.cursor;
lab0: {
var  v_1 = base.limit - base.cursor;
lab1: {
if (!(base.eq_s_b("y")))
{
break lab1;
}
break lab0;
}
base.cursor = base.limit - v_1;
if (!(base.eq_s_b("Y")))
{
return false;
}
}
base.bra = base.cursor;
if (!(base.out_grouping_b(g_v, 97, 121)))
{
return false;
}
lab2: {
if (base.cursor > base.limit_backward)
{
break lab2;
}
return false;
}
if (!base.slice_from("i"))
{
return false;
}
return true;
};
function r_Step_2() {
var  among_var;
base.ket = base.cursor;
among_var = base.find_among_b(a_5);
if (among_var == 0)
{
return false;
}
base.bra = base.cursor;
if (!r_R1())
{
return false;
}
switch (among_var) {
case 1:
if (!base.slice_from("tion"))
{
return false;
}
break;
case 2:
if (!base.slice_from("ence"))
{
return false;
}
break;
case 3:
if (!base.slice_from("ance"))
{
return false;
}
break;
case 4:
if (!base.slice_from("able"))
{
return false;
}
break;
case 5:
if (!base.slice_from("ent"))
{
return false;
}
break;
case 6:
if (!base.slice_from("ize"))
{
return false;
}
break;
case 7:
if (!base.slice_from("ate"))
{
return false;
}
break;
case 8:
if (!base.slice_from("al"))
{
return false;
}
break;
case 9:
if (!base.slice_from("ful"))
{
return false;
}
break;
case 10:
if (!base.slice_from("ous"))
{
return false;
}
break;
case 11:
if (!base.slice_from("ive"))
{
return false;
}
break;
case 12:
if (!base.slice_from("ble"))
{
return false;
}
break;
case 13:
if (!(base.eq_s_b("l")))
{
return false;
}
if (!base.slice_from("og"))
{
return false;
}
break;
case 14:
if (!base.slice_from("less"))
{
return false;
}
break;
case 15:
if (!(base.in_grouping_b(g_valid_LI, 99, 116)))
{
return false;
}
if (!base.slice_del())
{
return false;
}
break;
}
return true;
};
function r_Step_3() {
var  among_var;
base.ket = base.cursor;
among_var = base.find_among_b(a_6);
if (among_var == 0)
{
return false;
}
base.bra = base.cursor;
if (!r_R1())
{
return false;
}
switch (among_var) {
case 1:
if (!base.slice_from("tion"))
{
return false;
}
break;
case 2:
if (!base.slice_from("ate"))
{
return false;
}
break;
case 3:
if (!base.slice_from("al"))
{
return false;
}
break;
case 4:
if (!base.slice_from("ic"))
{
return false;
}
break;
case 5:
if (!base.slice_del())
{
return false;
}
break;
case 6:
if (!r_R2())
{
return false;
}
if (!base.slice_del())
{
return false;
}
break;
}
return true;
};
function r_Step_4() {
var  among_var;
base.ket = base.cursor;
among_var = base.find_among_b(a_7);
if (among_var == 0)
{
return false;
}
base.bra = base.cursor;
if (!r_R2())
{
return false;
}
switch (among_var) {
case 1:
if (!base.slice_del())
{
return false;
}
break;
case 2:
lab0: {
var  v_1 = base.limit - base.cursor;
lab1: {
if (!(base.eq_s_b("s")))
{
break lab1;
}
break lab0;
}
base.cursor = base.limit - v_1;
if (!(base.eq_s_b("t")))
{
return false;
}
}
if (!base.slice_del())
{
return false;
}
break;
}
return true;
};
function r_Step_5() {
var  among_var;
base.ket = base.cursor;
among_var = base.find_among_b(a_8);
if (among_var == 0)
{
return false;
}
base.bra = base.cursor;
switch (among_var) {
case 1:
lab0: {
var  v_1 = base.limit - base.cursor;
lab1: {
if (!r_R2())
{
break lab1;
}
break lab0;
}
base.cursor = base.limit - v_1;
if (!r_R1())
{
return false;
}
{
var  v_2 = base.limit - base.cursor;
lab2: {
if (!r_shortv())
{
break lab2;
}
return false;
}
base.cursor = base.limit - v_2;
}
}
if (!base.slice_del())
{
return false;
}
break;
case 2:
if (!r_R2())
{
return false;
}
if (!(base.eq_s_b("l")))
{
return false;
}
if (!base.slice_del())
{
return false;
}
break;
}
return true;
};
function r_exception2() {
base.ket = base.cursor;
if (base.find_among_b(a_9) == 0)
{
return false;
}
base.bra = base.cursor;
if (base.cursor > base.limit_backward)
{
return false;
}
return true;
};
function r_exception1() {
var  among_var;
base.bra = base.cursor;
among_var = base.find_among(a_10);
if (among_var == 0)
{
return false;
}
base.ket = base.cursor;
if (base.cursor < base.limit)
{
return false;
}
switch (among_var) {
case 1:
if (!base.slice_from("ski"))
{
return false;
}
break;
case 2:
if (!base.slice_from("sky"))
{
return false;
}
break;
case 3:
if (!base.slice_from("die"))
{
return false;
}
break;
case 4:
if (!base.slice_from("lie"))
{
return false;
}
break;
case 5:
if (!base.slice_from("tie"))
{
return false;
}
break;
case 6:
if (!base.slice_from("idl"))
{
return false;
}
break;
case 7:
if (!base.slice_from("gentl"))
{
return false;
}
break;
case 8:
if (!base.slice_from("ugli"))
{
return false;
}
break;
case 9:
if (!base.slice_from("earli"))
{
return false;
}
break;
case 10:
if (!base.slice_from("onli"))
{
return false;
}
break;
case 11:
if (!base.slice_from("singl"))
{
return false;
}
break;
}
return true;
};
function r_postlude() {
if (!B_Y_found)
{
return false;
}
while(true)
{
var  v_1 = base.cursor;
lab0: {
golab1: while(true)
{
var  v_2 = base.cursor;
lab2: {
base.bra = base.cursor;
if (!(base.eq_s("Y")))
{
break lab2;
}
base.ket = base.cursor;
base.cursor = v_2;
break golab1;
}
base.cursor = v_2;
if (base.cursor >= base.limit)
{
break lab0;
}
base.cursor++;
}
if (!base.slice_from("y"))
{
return false;
}
continue;
}
base.cursor = v_1;
break;
}
return true;
};
this.stem =  function() {
lab0: {
var  v_1 = base.cursor;
lab1: {
if (!r_exception1())
{
break lab1;
}
break lab0;
}
base.cursor = v_1;
lab2: {
{
var  v_2 = base.cursor;
lab3: {
{
var  c1 = base.cursor + 3;
if (0 > c1 || c1 > base.limit)
{
break lab3;
}
base.cursor = c1;
}
break lab2;
}
base.cursor = v_2;
}
break lab0;
}
base.cursor = v_1;
r_prelude();
r_mark_regions();
base.limit_backward = base.cursor; base.cursor = base.limit;
var  v_5 = base.limit - base.cursor;
r_Step_1a();
base.cursor = base.limit - v_5;
lab4: {
var  v_6 = base.limit - base.cursor;
lab5: {
if (!r_exception2())
{
break lab5;
}
break lab4;
}
base.cursor = base.limit - v_6;
var  v_7 = base.limit - base.cursor;
r_Step_1b();
base.cursor = base.limit - v_7;
var  v_8 = base.limit - base.cursor;
r_Step_1c();
base.cursor = base.limit - v_8;
var  v_9 = base.limit - base.cursor;
r_Step_2();
base.cursor = base.limit - v_9;
var  v_10 = base.limit - base.cursor;
r_Step_3();
base.cursor = base.limit - v_10;
var  v_11 = base.limit - base.cursor;
r_Step_4();
base.cursor = base.limit - v_11;
var  v_12 = base.limit - base.cursor;
r_Step_5();
base.cursor = base.limit - v_12;
}
base.cursor = base.limit_backward;
var  v_13 = base.cursor;
r_postlude();
base.cursor = v_13;
}
return true;
};
this['stemWord'] = function(word) {
base.setCurrent(word);
this.stem();
return base.getCurrent();
};
};
return new EnglishStemmer();
}
wh.search_stemmer = Snowball();
wh.search_baseNameList = [
 "appendix.LanguageToolPlugin.inOmegaT.html",
 "appendix.Scripts.inOmegaT.html",
 "appendix.TeamProjects.html",
 "appendix.Tokenizers.inOmegaT.html",
 "appendix.acknowledgements.html",
 "appendix.keyboard.html",
 "appendix.languages.html",
 "appendix.legal.notices.html",
 "appendix.shortcut.custom.html",
 "appendix.website.html",
 "chapter.TaaS.html",
 "chapter.about.OmegaT.html",
 "chapter.dictionaries.html",
 "chapter.file.filters.html",
 "chapter.files.and.folders.html",
 "chapter.files.to.translate.html",
 "chapter.formatted.text.html",
 "chapter.glossaries.html",
 "chapter.installing.and.running.html",
 "chapter.instant.start.guide.html",
 "chapter.machine.translate.html",
 "chapter.menu.html",
 "chapter.misc.html",
 "chapter.plain.text.html",
 "chapter.project.properties.html",
 "chapter.regexp.html",
 "chapter.searchandreplace.html",
 "chapter.searches.html",
 "chapter.segmentation.html",
 "chapter.spellchecker.html",
 "chapter.translation.editing.html",
 "chapter.translation.memories.html",
 "chapter.user.interface.html",
 "index.html",
 "ix01.html"
];
wh.search_titleList = [
 "Appendix E. Dodatni modul LanguageTool",
 "Appendix F. Skripte",
 "Appendix C. OmegaT – timski projekti",
 "Appendix D. Tokenizatori",
 "Appendix J. Zahvale",
 "Appendix B. Tipkovni prečaci u oknu za obradu",
 "Appendix A. Jezici – popis oznaka ISO 639",
 "Appendix I. Pravne napomene",
 "Appendix H. Prilagođavanje prečaca",
 "Appendix G. OmegaT na webu",
 "Korištenje servisa TaaS u programu OmegaT",
 "Uvod u program OmegaT",
 "Rječnici",
 "Datotečni filtri",
 "Datoteke i mape programa OmegaT",
 "Datoteke za prijevod",
 "Rad s oblikovanim tekstom",
 "Glosari",
 "Instaliranje i pokretanje programa OmegaT",
 "Naučite koristiti program OmegaT za pet minuta!",
 "Strojno prevođenje",
 "Izbornik i tipkovni prečaci",
 "Razne teme",
 "Rad na običnome tekstu",
 "Svojstva projekta",
 "Regularni izrazi",
 "Pretraživanje i zamjena",
 "Pretraživanja",
 "Segmentacija izvorišnoga teksta",
 "Alat za provjeru pravopisa",
 "Funkcioniranje obrade",
 "Prijevodne memorije",
 "Korisničko sučelje",
 "OmegaT 3.5 – Korisnički priručnik",
 "Index"
];
wh.search_wordMap= {
"pretvor": [30],
"mjesecu": [[22,31]],
"spremaju": [[21,24,30,31]],
"otvoren": [[13,18,28]],
"ostvaruju": [20],
"valovitom": [0],
"hall": [7],
"natuknicama": [17,[2,11,21]],
"minutama": [21],
"kategorija": [[25,32]],
"ponavljanj": [21],
"nadograđuju": [[18,31]],
"ručno": [15,[17,19]],
"rječnici": [[12,34],[29,32],[3,8,11,14,17,25,33]],
"kurzivu": [13],
"revidiranju": [32],
"orijski": [6],
"bloku": [25],
"tel": [6],
"tek": [[4,17,31,32]],
"rukom": [20],
"uključuj": [27],
"info.plist": [18],
"izbornika": [32,8,21,18,[13,20,24],[1,11,14,19,22,23,27,28,30,31]],
"europskih": [28],
"antonio": [7],
"varij": [16,13,[21,32]],
"odredišnom": [21,31,[0,15,16,18,20,22,32]],
"europskim": [10],
"tex": [15],
"otprilik": [18],
"djelomičan": [31],
"odredišnoj": [13,[16,24]],
"tekstna": [14],
"pronalaz": [25],
"preimenujt": [31,22],
"promaknuo": [17],
"fuzzi": [31,[30,32]],
"kvadratić": [24,28,27,[13,29],[0,2,18,21,30]],
"odredišnog": [21,31],
"tekstni": [21,[13,15,31]],
"kua": [6],
"standardn": [[27,32]],
"kombiniran": [13],
"izbornih": [32],
"međuplatformsk": [18],
"izbornik": [33,8,21,34,32,22,[11,15,24,25,27,28,29]],
"popratnim": [20],
"manipuliranja": [23],
"počinju": [25],
"izborniku": [21,13,[0,1,8,14,18,19,20,23,30,31]],
"će": [18,2,31,[13,19,24],[21,28],[7,14,15,23,27,29],[1,8,11,16,17,20,22,26,30,32]],
"postupk": [31],
"izrazu": [18],
"dijaloškom": [[17,19,29,31],[2,10,22,23,24,30]],
"samu": [16],
"jednostavan": [[15,31]],
"samo": [18,[21,31],[13,27],[24,32],2,[14,17,20],[4,15,16,29,30],[5,10,12,22,23,26,28]],
"uneredili": [16],
"ispuštanj": [[18,32,34],33],
"poveznic": [[9,12,13,32]],
"kur": [6],
"brišemo": [30],
"dgoogle.api.key": [18],
"prelazak": [5],
"ces": [6],
"većem": [20],
"tamilski": [6],
"edittagnextmissedmenuitem": [8],
"same": [[13,25]],
"raspoloživi": [32,14],
"gikuyu": [6],
"aktivni": [[28,32]],
"izrazi": [[25,27,34],11,[12,26,28,33]],
"izlaznih": [13],
"sama": [5],
"tgl": [6],
"tgk": [6],
"redom": [[28,32]],
"quiet": [[18,22]],
"raspoloživo": [18],
"izraza": [25,[18,19,22,33]],
"sami": [[17,23,27]],
"primamo": [30],
"prihvaća": [14],
"japanska": [28],
"fiksno": [16],
"imat": [18,[2,12,29],[15,17,21,22,23,28,30,32]],
"es_es.d": [29],
"japanski": [[6,22,28]],
"bambara": [6],
"pozadin": [31],
"tematik": [31],
"tha": [6],
"nadziru": [18],
"the": [18,[12,21,25,34]],
"download.htm": [18],
"projectimportmenuitem": [8],
"usklađen": [[2,31]],
"dvoslovn": [31],
"struktura": [[14,28,31]],
"jednokratnih": [32],
"imag": [18,14],
"revidiranih": [20],
"jednokratnim": [32],
"imal": [[13,28]],
"navodnika": [18],
"upravljanju": [[14,15]],
"okolnosti": [16],
"strukturu": [[14,31]],
"dekliniran": [17],
"otvorit": [31,[2,23],[11,13,14,17,18,19,22,24,32]],
"pauzu": [29],
"strukturn": [28],
"spremanj": [21,11,[2,8,31,32]],
"kopiju": [[22,31]],
"dolaz": [30],
"objektnom": [1],
"tih": [[20,29]],
"pogodna": [18],
"povrh": [[21,31,32]],
"dostupan": [2,[14,18,32]],
"umetni": [21,8,[27,30]],
"smatra": [[15,24]],
"currsegment.getsrctext": [1],
"tim": [[8,21],[2,17,24,31]],
"pohlepni": [25,33],
"natuknica": [32,[17,21],[5,33]],
"resurs": [[9,31]],
"tir": [6],
"cha": [6],
"export": [17],
"decimalnim": [30],
"appleovim": [21],
"prefiksa": [[3,30]],
"che": [6],
"neiskorist": [24],
"količinu": [[10,32]],
"razliku": [[20,21,27,32]],
"revizij": [32],
"isključeno": [32],
"dvosmjern": [[8,21]],
"pokazuju": [20],
"određenom": [13],
"identificirati": [31],
"raspoloživa": [18,22],
"isključena": [21],
"najjednostavnijem": [18],
"poslužitelju": [2,18],
"spremamo": [30],
"upravljanja": [[20,31]],
"poduzimati": [22],
"natuknicu": [32],
"upravljati": [2,[15,30]],
"chv": [6],
"chu": [6],
"xxxx9xxxx9xxxxxxxx9xxx99xxxxx9xx9xxxxxxxxxx": [18],
"kopija": [[2,31],34,[13,24]],
"smjernicama": [1],
"određenoj": [[29,30]],
"naputaka": [15],
"poslužitelja": [2,18],
"kopiji": [2],
"ometa": [21],
"fr-fr": [29],
"komentarima": [[8,27]],
"aspekta": [19],
"upisanih": [[21,27,30]],
"bivaju": [[16,30]],
"upisanim": [[17,21,24,27]],
"ndonga": [6],
"površini": [18],
"madlon-kay": [7],
"razlika": [32,[14,26,30]],
"prilagođen": [21,[8,15,16]],
"arhivu": [31],
"skriptiranj": [1,21],
"izbrišit": [[18,31,32]],
"primari": [[18,20]],
"izvezi": [21,30,8],
"funkcionalnosti": [2],
"termina": [21,[8,17,32],[11,27]],
"xmxzzm": [18],
"ključn": [27],
"uvezenih": [32],
"webster": [34,[12,32]],
"ključa": [10,[20,33]],
"nalogu": [18],
"mongolski": [6],
"termini": [17,[2,8,21,32]],
"preuzmit": [18,12],
"mapa-moj-projekt": [22],
"arhiva": [[12,14]],
"laoski": [6],
"nazivprojekta-omegat.tmx": [31],
"razin": [31,24],
"korisno": [[13,31],[3,9,18,19,24,30,32]],
"cjk": [27],
"aktivirat": [18],
"bloka": [[25,28]],
"korisni": [[25,31]],
"površinu": [18],
"nadogradnj": [21],
"aktiviran": [[3,21]],
"korisna": [21,[11,18,28]],
"najgoremu": [16],
"manjim": [16],
"empti": [31,18],
"događaj": [8],
"pokretač": [18],
"upisanom": [27],
"n.n_source.zip": [18],
"izvorniku": [[4,20,27]],
"vašim": [18],
"spolski": [9],
"mogla": [24,[14,19]],
"tvorničkih": [34],
"zanemaruju": [5],
"uklonit": [31,[18,32]],
"docku": [18],
"računalno": [11,[31,32,33]],
"nemamo": [15],
"dostupna": [[18,21,31]],
"block": [22],
"pravilno": [20,17,[16,18,23],[14,15,21]],
"tmx": [31,34,18,[20,21],[14,22,32],[8,11,27]],
"pravilnu": [16],
"vrijednosti": [25,13,[16,18,20,22,31,32]],
"otvorena": [[17,22,27,32]],
"rječnika": [29,34,12,33,32,14,11],
"integ": [13],
"gore": [31,18,[5,12,15,20,21,23,30,32]],
"lijepa": [3],
"intel": [18,[33,34]],
"otvoreni": [[21,32]],
"fr-ca": [28],
"mainmenushortcuts.properti": [8],
"upit": [18],
"pretražuju": [27],
"neujednačenostima": [21],
"upis": [1],
"lijepo": [3],
"lijepi": [21],
"anal": [21],
"poznata": [27],
"poništi": [21,8],
"kompatibilnim": [18],
"cmd": [21,5,15],
"zamijeni": [21,26,8,27],
"izvornika": [16],
"coach": [25],
"datoteketarget": [34],
"identična": [14],
"parametru": [20],
"zadanim": [[13,21],18,30,[2,3,8,14,15,17,23,24,25,28,31,32]],
"zadanih": [31,13],
"gotohistorybackmenuitem": [8],
"tehnička": [13],
"uvjeti": [20],
"poznato": [31],
"estévez": [7],
"spremiti": [31,[8,20,29]],
"vrstama": [15],
"podaci": [32,[2,10,17,30,34]],
"tog": [[16,32]],
"parametri": [18,[20,22,34]],
"toj": [[17,31]],
"segmentacij": [[24,28],[11,13,14,15,34],[25,31,32],[16,21,33]],
"project-save.tmx": [31],
"changedd": [32],
"ton": [6],
"identično": [13],
"izrađuj": [14,[18,31],[16,17,22]],
"razni": [[21,33]],
"tom": [[18,31],30,[11,13,16,21,32]],
"strojno": [20,21,34,33,[11,32],[10,29]],
"parametra": [[18,20,22,32]],
"kvantifikatori": [25,33],
"razno": [34,[11,14,21]],
"powerpc": [18],
"stavkaa": [21],
"stavkab": [21],
"poništavanj": [21],
"strojni": [21,20,34],
"naredbenim": [18,34,[14,20],[11,22,33]],
"nemaju": [[18,19]],
"obrađuj": [[18,20,28]],
"pokrenuti": [18,[1,8],[3,14,21]],
"distribuira": [7],
"dostupni": [8,[14,32]],
"drugu": [[14,29,31,32]],
"zahtjevno": [32],
"iskoristiva": [21],
"dostupno": [[25,27]],
"dovesti": [[22,31]],
"prelaskom": [32],
"djelomic": [20],
"blokov": [[25,28,33]],
"asamski": [6],
"dodjeljivanj": [2],
"druge": [[18,32],[15,16,21],[2,3,20,22,28,29]],
"regionalna": [13],
"gosp": [28],
"posivljen": [19],
"druga": [[2,13,16,21]],
"intervencij": [[16,32]],
"drugo": [30],
"regionalni": [13],
"order2": [31],
"moglo": [[2,9,15,23]],
"order1": [31],
"primijenjeni": [1],
"naredbenih": [18],
"markeru": [32],
"drugi": [32,31,[2,8,12,21,27]],
"označavaju": [21,31,22],
"projekt": [31,14,24,[32,34],[2,21,22],[13,18],33,[8,19],[17,28],9,[1,11,12,27,29]],
"ponovnim": [[14,27,31]],
"cos": [6],
"cor": [6],
"segemenata": [32],
"vašeg": [13],
"uslij": [21,[2,16,24]],
"izgledati": [19],
"vašem": [14],
"miša": [21,32,[2,5,18],17,[1,14],[0,27,29,30]],
"obrnutu": [18],
"primjenjuj": [16,31],
"proce": [[22,28,31]],
"sravnjivanja": [[18,22]],
"dokument.xx.docx": [13],
"omegat.sourceforge.io": [18],
"prevoditeljica": [31],
"pozicij": [32],
"lao": [6],
"datotečn": [[13,14,24],[15,34]],
"lat": [6],
"prevoditeljici": [31],
"lav": [6],
"ponavljaju": [[11,32]],
"primjeric": [31,[18,27],[11,13,15,29,32],28,[2,12,17,21,23,24,25],[0,1,5,14,16,20,30]],
"platforma": [20],
"slovensk": [32],
"latinski": [6],
"upisivanjem": [18,[13,21,22,32]],
"područjima": [2],
"cpu": [32],
"tri": [31,16,[2,12,14,15,23,32],[9,17,19,20,21]],
"ručnoga": [21],
"kopira": [13,[21,24,32]],
"translat": [20,13,34,18,[1,29,33]],
"komentara": [32,34,[17,27,31,33]],
"koristi": [18,21,[11,13],[14,28,29,32],[1,7,8,15,23,31],[0,2,3,17,20,22,24,27]],
"zapisnik": [[8,21]],
"komentari": [13,[32,34]],
"tahićanski": [6],
"platformi": [18,14],
"umetnutim": [24],
"definiran": [[21,23]],
"unosit": [18],
"tekstnu": [21,23],
"utvrđivanju": [[13,29]],
"nadogradnji": [18],
"hindski": [6],
"sindhski": [6],
"pritisak": [[14,27]],
"veliko": [25,[8,21]],
"respons": [20],
"preostal": [21],
"tsn": [6],
"interesar": [20],
"tso": [6],
"polovicu": [17],
"leži": [16],
"cre": [6],
"veliki": [30],
"chmod": [14],
"chihiro": [7],
"utvrđivanja": [[13,16,32]],
"tekstom": [21,31,27,[11,16,34],[8,23,28,33]],
"velika": [21,8,[17,25]],
"gnome": [18],
"otpušten": [8],
"gniježdenja": [16],
"statistički": [32,34],
"tekstov": [[11,22,23,28,30,31]],
"sporo": [21],
"produktivnost": [28],
"određenih": [21,[4,11,13,16,29,31,32]],
"zatvaranj": [21,[26,27,32]],
"postavkom": [18],
"umećemo": [[17,32]],
"razdvajanja": [17],
"detalja": [4],
"poziva": [18],
"polovici": [28,30],
"određenim": [[15,16,31,32]],
"označavanj": [32,[5,21,27,34]],
"izvezeni": [[17,21]],
"programska": [14],
"utjecaja": [[15,21,24]],
"ttx": [31,34],
"prečac": [8,21,18,[5,11,15,27]],
"programski": [18],
"appdata": [14],
"nadogradnja": [34,[18,31],33],
"kompletnu": [31],
"yandexa": [20],
"netom": [[17,28]],
"tm-ovi": [27],
"namjen": [32],
"slovnih": [32],
"prev": [[0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,34]],
"csv": [15,17],
"n.n_linux.tar.bz2": [18],
"manju": [31],
"spremit": [31,15,29,[17,18,23]],
"tehničk": [21],
"glavn": [31,20],
"tuk": [6],
"primjeru": [32,16,13,[2,12,14,17,18,23,25,29,31]],
"redak": [18,[22,31],[8,14,20,28,32]],
"tur": [6],
"napomenuti": [15],
"značajno": [11],
"otvori": [[8,21],[2,5,24]],
"priviknet": [32],
"sotho": [6],
"lev": [7],
"dock": [18],
"element": [[15,32],[13,21,22]],
"ctr": [16],
"praktična": [18],
"značajna": [14],
"doba": [19],
"posljednji": [21,18],
"standardom": [23],
"dmicrosoft.api.client_secret": [18],
"poteškoća": [31],
"primjeri": [[25,34],33],
"manji": [15],
"dobr": [[20,32]],
"primjera": [28,[13,18,32],[23,31],[3,8,22,25,27,33,34]],
"dijaloški": [34,13,19,[32,33],[21,23],[2,17,22,24,30,31]],
"oduzimanj": [31,[16,25]],
"manja": [32],
"kakvih": [[9,14,31]],
"filenameon": [32],
"spremili": [[21,31]],
"ctrl": [21,8,5,32,34,19,27,[15,30],[16,31],[14,17,20],[1,12,24,26]],
"mykhalchuk": [7],
"twi": [6],
"početn": [13,[14,16,18,19,31]],
"document": [[13,14,15,16,18,22,31]],
"standardni": [[6,11,18,21,29,32]],
"prebacivati": [21],
"paketima": [29],
"francuskog": [28],
"gigabajt": [18],
"smanjujemo": [15],
"uput": [[11,13,17,25,33]],
"gornjega": [32],
"standardno": [30],
"provjeravajt": [[15,22]],
"namjest": [32],
"uklanja": [[13,16,30]],
"nuditi": [24],
"pomaž": [31],
"uklon": [24,[0,3,16,29]],
"upisanoga": [[27,31]],
"ishoda": [9],
"logici": [27],
"složeno": [11],
"zatraž": [18],
"stavk": [8,21,18,[13,14,23,32]],
"resourc": [18],
"nekompatibilnosti": [[0,3]],
"briac": [7],
"značenja": [16],
"namjera": [28],
"robustan": [22],
"pločama": [18],
"izvozit": [17],
"xx_yy": [[13,31]],
"docx": [[13,15],24],
"držite": [9],
"txt": [23,17,[13,15],32],
"francuskom": [18],
"brisati": [[16,19]],
"naredbeni": [34,18,22,20],
"revizijama": [21],
"odvlač": [32],
"obuhvaćeno": [20],
"nemogućnosti": [19],
"ključ-vrijednost": [13],
"jezičn": [[2,20]],
"pretpostavku": [[15,23]],
"pokazivač": [5,28],
"završetak": [2],
"lib": [14],
"definir": [17],
"zadanom": [[21,28]],
"anket": [14],
"zadanoj": [21,32],
"estonski": [6],
"označavanja": [15],
"brisanj": [[21,30],[16,34]],
"rutinsko": [18],
"ojibwa": [6],
"lin": [6],
"lim": [6],
"trnsl": [18],
"zanemarivanj": [[21,32]],
"dodao": [32],
"dodan": [[1,2]],
"kontrolom": [2],
"lit": [6],
"viewdisplaymodificationinfoselectedradiobuttonmenuitem": [8],
"dodaj": [13,[1,18,23,28,31,32]],
"omegat.tmx": [[14,31]],
"index.html": [[18,32]],
"početnoga": [18],
"istodobno": [27,[2,11,17,21,28,31]],
"dodat": [18,14],
"tekuću": [[10,22,31]],
"želimo": [[26,31]],
"podizbornik": [18],
"provjeravanj": [21],
"pristup": [8,18,[14,21],32,[1,10]],
"naručiteljima": [2],
"poglavlja": [11,[7,17,32,33]],
"poljima": [15],
"glasi": [[18,32]],
"diffrevers": [32],
"tekući": [21,32,8,[2,11,13,15]],
"poglavlju": [32,20,[11,14],[24,31],[19,21,27]],
"glase": [27],
"izgubit": [14],
"tzv": [[20,31]],
"svrsishodna": [14],
"fula": [6],
"cym": [6],
"page": [5],
"terminološka": [[17,32,34]],
"izvozom": [[30,31]],
"šonski": [6],
"kakvom": [22],
"stara": [[0,18]],
"zarez": [[17,25]],
"chewa": [6],
"ponovnom": [[22,31]],
"djelomično": [32,[10,30]],
"pomič": [28,5],
"očekivanoga": [9],
"svakoga": [[13,19,27,30,32]],
"nijednom": [25],
"e-pošt": [9,20],
"optičko": [15],
"project.gettranslationinfo": [1],
"osoba": [2],
"djelomična": [32,[15,19,21,24,30]],
"stare": [24],
"prihvatit": [18],
"slučaju": [31,18,21,13,[16,32],[2,5],[11,24,30],[17,20,23,28]],
"snažno": [30],
"dvojben": [27],
"suradnj": [2],
"start": [18,34,33],
"mymemori": [20,34,33],
"engleski-katalonski": [20],
"smolej": [[7,33]],
"namjena": [34,31,18],
"prvotno": [20],
"equal": [31,18],
"procjen": [32],
"omogućeno": [[2,11,21,30,32]],
"usvaja": [31],
"njenim": [17],
"povećavanja": [32],
"interaktivnih": [25],
"namjenu": [7],
"podlijež": [7],
"kulik": [7],
"zatreb": [[13,19]],
"preimenovanj": [[24,31]],
"njenih": [31],
"izvorišnima": [18],
"redaka": [28,[13,18]],
"ugrozit": [14],
"optionsalwaysconfirmquitcheckboxmenuitem": [8],
"podešavanj": [13],
"pozadinom": [21],
"preimenovati": [29],
"bengalski": [6],
"nedostaju": [21,32,[5,8,34]],
"primjer": [[13,16],22,[20,21,33],[0,1,2,3,17,18,23,25,30,31]],
"sigurnošću": [20],
"spremljen": [31,[2,12]],
"spremat": [19],
"naziv_projekta-level1": [[14,31]],
"smisla": [29],
"pomoć": [[21,34],[8,33],[9,11,19,32]],
"enter": [21,5,8,[16,18,30,32]],
"poznavati": [2],
"applic": [14],
"francuski": [28,[6,18]],
"projectteamnewmenuitem": [8],
"zaštitn": [32],
"računa": [18,31,[9,16,24],[2,3,14,20,29]],
"avestijski": [6],
"razmaknica": [5],
"memori": [18],
"pošaljit": [14],
"smjelo": [24],
"indikatori": [[25,33]],
"nastaj": [[16,18]],
"cjelov": [[28,32]],
"godfrey": [7],
"log": [[9,14]],
"španjolskoga": [29],
"zvona": [25],
"vrstu": [13],
"gornja": [25],
"vrsta": [34,13,[15,16,20]],
"podmapama": [[2,11]],
"neusklađenih": [2],
"podatk": [20,[14,22,31,32],[2,15,17,18,21,23,24]],
"vrste": [15,[28,32],[13,14,16,23,30,31]],
"n.n_windows_without_jre.ex": [18],
"vraćanjem": [15],
"jezik-država": [28],
"klase": [[25,33]],
"dolj": [[5,15,18,28,29,30,31,32]],
"briše": [[21,30,32]],
"rezervira": [18],
"kontekstnih": [21],
"prof": [28],
"datotek": [34,31,13,15,18,14,32,19,[21,29],[11,17],[8,16,23,33],30,[2,22,27],[12,28],24,20,10],
"camproj": [15],
"predloženi": [20],
"gornjemu": [32,13,[18,25]],
"sklopu": [32,[18,31],[21,29],[13,16,17]],
"lokativ": [17],
"gornji": [[1,14,29,32]],
"dmicrosoft.api.client_id": [18],
"naznačen": [18],
"klasa": [25],
"prijavit": [[2,9,20]],
"zahtijevaju": [23],
"gornju": [32],
"netaknutima": [13],
"priče": [17],
"config-fil": [18],
"grčki": [6],
"naplatu": [20],
"nijedan": [[13,20,21]],
"poljskoga": [0],
"yandexov": [18],
"otkrivanja": [9],
"dvojezičn": [[11,31,34]],
"smanjiti": [16],
"dan": [[6,22,31]],
"potpunosti": [[16,27]],
"klasu": [32],
"podnesit": [9],
"formatima": [[12,13,18,27,32]],
"system-user-nam": [13],
"format": [15,[17,34],23,[11,13,20],[12,16,33]],
"zahvalni": [9],
"console.println": [1],
"joruba": [6],
"podacima": [[3,10,20,32]],
"deklinaciju": [17],
"vidjet": [20],
"launcher": [20],
"microsoft.api.client_id": [20],
"prepoznati": [[2,11,17]],
"paru": [16,[22,31]],
"razini": [28,[24,34],[5,31]],
"ponuđeno": [11],
"staze": [23],
"ispisuj": [[1,18]],
"nikakav": [21,23],
"mogao": [4],
"razina": [31],
"disku": [18],
"postavljati": [27],
"prijavom": [9],
"jednostavnosti": [2],
"podebljanoga": [32,[10,13,16,17,27]],
"leender": [7],
"kopiranjem": [[16,26]],
"regularn": [18,28],
"para": [16,[31,32]],
"loše": [24],
"diska": [31],
"agencij": [[11,32]],
"hiroshi": [7],
"ponovi": [21,8],
"dobili": [[2,11,18,20]],
"smislu": [2],
"project_files_show_on_load": [32],
"zastarijeva": [32],
"nehotic": [16],
"ltr": [15,34],
"odvijaju": [21],
"naziv_projekta-level2": [[14,31]],
"pružatelji": [20],
"optionsexttmxmenuitem": [8],
"temu": [18,21,[14,31]],
"ltz": [6],
"lub": [6],
"tonga": [6],
"temi": [14,[24,32]],
"marketplac": [20,18],
"kreativnij": [28],
"lug": [6],
"teme": [[21,22],[6,11,29,33,34]],
"slojem": [15],
"dosta": [30],
"prvi": [21,[2,5,8,24,27,32]],
"dobro": [[2,18,20,27,31]],
"prve": [[4,13,17,28]],
"neovisan": [14,20],
"entries.s": [1],
"izvor": [32],
"del": [30],
"odabiru": [11],
"gotonextuntranslatedmenuitem": [8],
"targetlocal": [13],
"prvo": [21,25,[2,8,18,32]],
"dobru": [25],
"swatski": [6],
"izvoz": [31,[21,34],[17,30],[15,20]],
"ovoga": [[18,20,21],[15,16,17,22,23]],
"postavljaju": [15],
"path": [18],
"kôda": [1,[0,11,13,14,20,31]],
"dobra": [28],
"prioritetnoga": [17],
"deu": [6],
"zapisivoga": [17,[21,34]],
"naknadnoga": [13],
"gubitak": [[14,22]],
"prva": [[16,17,18]],
"kružić": [27],
"dobri": [31],
"padajućega": [27],
"trenutan": [32],
"pdf-a": [15],
"odabira": [21,[18,19,24]],
"napominjemo": [[2,17]],
"kurdski": [6],
"datotečnoga": [13,[12,15]],
"bilo": [31,[2,7,18,25,27,32],[14,16,19,21],[13,22,29],[4,8,9,20,24,30]],
"izvedenicama": [21],
"početak": [5,[17,18,25]],
"određenu": [7,32],
"allsegments.tmx": [18],
"bili": [[14,28]],
"zbirkama": [[10,32]],
"poravnanja": [15],
"bile": [2],
"prečaci": [21,33,8,34,5,32,[2,6,11,24]],
"spojeni": [20],
"instalacijsk": [32],
"procitajm": [13,18],
"helpcontentsmenuitem": [8],
"polazišna": [28],
"prečaca": [8,[11,21,34],[16,18,33],[5,7,9,17,32]],
"decimalni": [30],
"softverskoj": [2],
"terminala": [18],
"initialcreationid": [32],
"iznad": [[27,30]],
"projectaccessdictionarymenuitem": [8],
"različita": [32],
"predobradom": [15],
"makedonski": [6],
"prečacima": [8],
"cjelovit": [21],
"različito": [15],
"sravnjivati": [22],
"hebrejski": [6],
"nekom": [17,29],
"potencijalni": [21],
"numeriranj": [16,34],
"potencijalno": [27],
"uig": [6],
"nekoj": [[17,31],18],
"željen": [29,[1,14,32]],
"odabran": [[21,31],[1,3,19,24,32]],
"urdski": [6],
"drugog": [[3,31]],
"drugoj": [[16,18]],
"term": [17],
"drugom": [[16,17,18,29,32]],
"instalacijskoga": [18],
"raspakiravanj": [18],
"tekstn": [[13,31],[23,28,30,34]],
"dotx": [15],
"staviti": [[2,17]],
"ploču": [18],
"raditi": [[0,2,21]],
"tekstu": [21,31,[16,18,30,32],[8,23],[2,5,11,15,17,19,25,27,28,33,34]],
"navigacijski": [18],
"duden": [32],
"priprem": [2,[14,19,31]],
"changedid": [32],
"zaseban": [[31,32]],
"teksta": [16,34,15,32,21,30,[19,33],[18,22],13,[23,31],[11,24],[5,17,28],[8,20,29],[2,27],[1,10]],
"prvu": [[16,21]],
"argumenata": [18],
"jednakovrijednih": [31],
"miura": [7],
"zasebn": [2],
"spotlight": [18],
"inač": [[2,21,30]],
"unošenju": [21],
"prikazan": [32,18,[1,2,13,20,21]],
"izvorišnu": [31,[8,15,19,20,21,22,23]],
"postavljanj": [21,28,[18,34],[13,15,24,33]],
"postavljen": [18,[13,15,22]],
"catlik": [3],
"objavit": [22],
"murray": [[4,7]],
"sâmo": [23],
"akanski": [6],
"datamarket.azure.com": [20],
"postupit": [31],
"uzork": [13,[24,28]],
"dio": [21,[14,16,32],[0,1,2,18,31]],
"prvih": [17],
"dir": [18],
"down": [5],
"latex": [15],
"prikazivanj": [[15,21]],
"div": [13,6],
"tržišnoga": [7],
"izmjenama": [8,21],
"instalacij": [18,22],
"konfiguracijske-datotek": [18],
"izvorni": [15,32,[13,16,24]],
"unošenja": [[8,15]],
"pregl": [18,10],
"situaciji": [31],
"prikazat": [[2,28,31],[18,26,27]],
"bira": [21,3],
"aragonski": [6],
"izvorno": [31],
"viewfilelistmenuitem": [8],
"pridruživanja": [21],
"ukr": [6],
"položaju": [28],
"info": [10],
"test": [18,22],
"pomak": [5],
"mittmann": [7],
"prihvaćanju": [20],
"tmx-ova": [31,[21,34]],
"omegat": [18,34,[14,31],22,11,33,[15,32],19,[2,9],21,20,13,[8,23],[16,24,30],[3,17],[1,7,10,29],[0,27,28],4,12,[5,25,26]],
"poštedjela": [4],
"xxxxx": [10],
"instalacijom": [32],
"naravno": [31,[17,18,23,29,32]],
"položaja": [[21,27]],
"ispušten": [32],
"kanuri": [6],
"izvorišna": [19,13],
"kojem": [2],
"namještanj": [21],
"nude": [[23,27,31,32]],
"promijeni": [8],
"izvorišni": [31,21,17,15,[30,32],[8,10,20,27,28,34],[1,3,11,13,24,33]],
"završava": [[18,22,28]],
"dobiveni": [20],
"nudi": [20,23,[13,18,30,34],[11,14,17],[0,1,2,3,10,21,24,25,28,32,33]],
"sinkronizacija": [27],
"virtual": [1],
"ažurira": [[2,17,22,31]],
"praćenju": [4],
"unutar": [16,[17,32]],
"bist": [18,[20,31],[2,12,14,15,22,28,29]],
"prijedlog": [[11,20,21,30,31]],
"nastavkom": [13,23,[14,18,22,31]],
"resursima": [11],
"console-align": [18,22],
"korisničkoga": [21,[9,11,18,34]],
"ms-dos": [18],
"postupku": [22],
"projectopenrecentmenuitem": [8],
"izvlačenj": [13],
"ljubičastom": [21],
"biti": [28,31,8,[2,17,18,21],[11,15],[16,30,32],[7,13,20],[1,12,14,22,23,24,25]],
"dobiva": [[2,13,16,20]],
"pazi": [32],
"jean-christoph": [[4,7]],
"zahval": [4,[7,11,33,34]],
"umu": [[29,31,32],[2,14,18,20,24],[9,12,16,27]],
"toliko": [17],
"henri": [7],
"relax": [15],
"custom": [20],
"zaglavlja": [13,32],
"odredišnoga": [21,29,[30,32],34],
"višejezičn": [34],
"dobiti": [20,18],
"und": [29],
"zdesna": [34,15,[5,33]],
"afarski": [6],
"vrati": [32,[8,21]],
"sjeverni": [6],
"promijenjenih": [24],
"kikuyu": [6],
"cijelim": [30],
"glagoli": [20],
"promijenjenim": [32],
"uno": [15,[10,30,32]],
"sravnjivanj": [[22,34],33],
"srednjega": [3],
"editoverwritemachinetranslationmenuitem": [8],
"zaglavlju": [[13,26,27]],
"postupka": [[11,16]],
"ingreek": [25],
"prepiši": [13],
"jednoga": [21,[16,18,22,25,31,32]],
"dvojezičnom": [31],
"es_es.aff": [29],
"pretraživanjem": [27],
"bitnoga": [23],
"poslov": [19],
"slikovni": [14],
"zatraži": [14],
"pojavnem": [17],
"projectexitmenuitem": [8],
"desnom": [32,2,18,17,[1,21,29,30]],
"kombiniranj": [34,15],
"elementima": [15],
"preko": [18],
"rjeđe": [11],
"text": [23],
"editregisteruntranslatedmenuitem": [8],
"sastoji": [32,[14,18]],
"prema": [13,[21,31],18,14,[2,17,28,32],[3,5,7,15,25,30],[1,4,16,22,23,26,27]],
"programerskoj": [9],
"izvlačenjem": [10],
"dnu": [32,[8,20,26,27,28]],
"odabrati": [21,32,[13,18,27],[10,14,16,24,29,31]],
"finski": [6],
"dovoljno": [[18,27,31]],
"pouzdana": [28],
"uloga": [11],
"kojih": [21,[11,23,31]],
"maco": [18],
"posredno": [31],
"dijelit": [2],
"inim": [31],
"pridružuj": [13],
"doc": [[15,32],14],
"slijed": [25,28],
"kojim": [[15,18,32]],
"status": [24],
"dok": [32,31,13,[2,8,16,17,22,24,28],[11,12,14,15,21]],
"izvora": [[10,15,17]],
"dupliciranja": [16],
"prijavljeni": [18],
"ikakvih": [[12,18]],
"prethodilo": [21],
"vidimo": [12],
"paramet": [18],
"zanemarena": [24],
"ostatku": [2],
"mac": [18,5,8,[14,21],[2,11,15,19,33,34]],
"izvršnu": [14],
"nula": [[16,25],[13,27]],
"naprednoj": [16],
"objektno": [1],
"vrijednostima": [21,18,[13,15,17,25,31,32]],
"očekuj": [18],
"dajet": [18],
"izvršna": [18],
"vremenskoga": [21],
"mah": [6],
"stanj": [[21,32],[2,22,30]],
"analizira": [25],
"mal": [6],
"man": [18],
"posivljena": [21],
"nepotrebno": [[2,31]],
"mar": [6],
"značajnim": [11],
"postići": [30],
"urd": [6],
"forward": [21],
"istraživanja": [20],
"provjeravati": [[16,29]],
"kazuj": [18,22,32],
"istovjetnosti": [27],
"kombinacijom": [32,[19,21],31,[1,5,15,16,20,24,26,27]],
"prednji": [21],
"dupliciranih": [32],
"url": [2,[18,21,29,32]],
"tabulatorom": [17,32],
"švedski": [6],
"odobril": [17],
"značajnih": [22],
"uključ": [13],
"obojani": [32],
"lokalizaciju": [9],
"uppercasemenuitem": [8],
"viewmarkuntranslatedsegmentscheckboxmenuitem": [8],
"cjelovitost": [14],
"poseban": [15],
"izvori": [32,15],
"raspolaganj": [2],
"izvorn": [[13,28,32]],
"www.omegat.org": [9],
"navedena": [18,[2,25]],
"poprilično": [15],
"naprednih": [27],
"učitavanjem": [[27,31]],
"naprednim": [25],
"use": [18],
"ponuđenim": [[21,27]],
"usd": [20],
"navedeni": [[11,23,30,31]],
"postupak": [[2,11,29,31]],
"manfr": [7],
"ponuđenih": [21],
"poredavanj": [21],
"osiguravamo": [13],
"tipkovnic": [21,32],
"omegat.jar": [14,[1,22,31]],
"ruski": [18,[6,22,23]],
"premjest": [32],
"omegat.app": [18],
"usr": [[14,18,22,24]],
"korištenih": [16],
"ispravan": [18],
"tipkovnih": [21,[8,11,32]],
"dvostrukim": [[14,18],[27,32]],
"dostav": [[20,31]],
"podešavanja": [21],
"pripremljenim": [2],
"tipkovnim": [[21,30]],
"posljedic": [[2,24]],
"drugih": [18,[15,16],[0,4,9,14,17,31,32]],
"najznačajnij": [14],
"otkrijet": [29],
"talentirani": [28],
"utf": [[17,23],13],
"oštećenj": [16],
"pojednostavljen": [11],
"prevoditeljskoga": [[18,22]],
"korištenja": [18,34,[20,21,22,25],[2,5,8,11,12,14,17,19,31,32,33]],
"skriptnim": [1],
"podvojenoga": [13],
"servic": [[2,20,21]],
"cijelom": [32],
"posavjetujt": [14],
"navedeno": [21],
"osnovama": [29],
"skriptnih": [14],
"njenoj": [17,12],
"podešena": [20],
"suradnja": [2,[33,34]],
"dsl": [12],
"navedenu": [31,[2,29]],
"prepoznaj": [3],
"numeriraju": [16],
"korištenju": [34,12,[17,24,31,33]],
"onemogućava": [18],
"područja": [10,[11,32]],
"dtaas.user.key": [10],
"određena": [[0,18],11],
"skripata": [1,18],
"postavka": [13,30],
"project_save.tmx.godnmmddhhnn.bak": [[22,31]],
"rezultata": [27,[21,32],[3,24,25,33]],
"postupci": [34,16,33],
"stranicama": [[9,20],[19,22]],
"obični": [15],
"određeni": [24,[20,31],[0,13,18,22,28,29]],
"tipičan": [31],
"prvog": [32],
"dtd": [15],
"vodiča": [18],
"postavki": [21,[14,34],24,[13,29,32,33],[3,8,11,18,22]],
"operacijski": [[13,18]],
"pojedinosti": [20,[7,19,31,32],[4,16,21,24,27,30,33]],
"obično": [[14,16,18],[15,22],[11,24,31,32]],
"postavku": [13],
"rumunjski": [6],
"određeno": [[10,13,16,24]],
"kvalitetno": [31],
"uži": [23],
"dopusti": [[13,30]],
"zapadnoeuropskih": [23],
"rječnik": [29,[11,12,14]],
"srednjoeuropsko": [34],
"drugim": [18,31,[11,16,19],[12,15,21,22,32]],
"postavit": [[13,17,19,28,31]],
"projectcompilemenuitem": [8],
"njegovim": [[24,32]],
"console-transl": [[18,22]],
"njegovih": [[11,17]],
"tehnologijom": [18],
"dijelom": [21],
"znamenka": [25],
"prevoditeljsk": [[11,32]],
"usluga": [20,18],
"abecedno": [31],
"materij": [11],
"općoj": [7],
"dijelov": [[9,11,21,32]],
"kojom": [[2,5,13,21,23]],
"gotonextuniquemenuitem": [8],
"kojoj": [18,22,[2,5,21,27,32]],
"rezultati": [[8,13,17,21,27]],
"ljepš": [3],
"uslugu": [20],
"netko": [4],
"okonč": [31],
"wordart": [13],
"uvijek": [[2,13,16],[14,17,28]],
"rečeno": [13],
"malajski": [6],
"optionsviewoptionsmenuitem": [8],
"gledišta": [32],
"hotimičnih": [16],
"broj": [32,16,[13,30],[15,18,27,31],[1,20,21,34]],
"polju": [18,[13,30,32]],
"commit": [2],
"upisivanju": [[19,21,27,30]],
"targetlocalelcid": [13],
"internetsku": [11],
"uključen": [21],
"project_stats_match.txt": [[2,14,32]],
"dva": [[2,18,32],[11,28,31],16,[14,17,21,22,29]],
"nesegmentiran": [28],
"pogledu": [7],
"dvd": [22],
"quarkxpress": [15],
"japanskom": [23,18],
"xmx2048m": [18],
"gornj": [28],
"polja": [32,[13,17,29],[10,11,18]],
"tiče": [32],
"meniju": [17],
"glasila": [18],
"internetska": [29],
"xxxxxxxxxxxxxxxx.xxxxxxxxxxxxxxxx.xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx": [18],
"modula": [20],
"hrvatska": [32],
"tabulatora": [[21,25]],
"održava": [2],
"traženj": [27,[10,25]],
"redoslij": [[16,27]],
"api-ja": [[18,20]],
"strelica": [5,32],
"svoje": [31,21,[2,15,16,27]],
"njegovom": [[21,28]],
"nazivom": [18,31,[1,10,14,19,21,22,32]],
"korijenu": [3],
"uklonili": [16],
"eventualnoga": [27],
"upisivanja": [[15,30]],
"korijena": [3,21,[8,34]],
"mala": [[8,21,25]],
"hrvatski": [31,6],
"moduli": [34],
"krunner": [18],
"svoju": [20],
"kategorij": [[25,32,33]],
"libreoffic": [29,[15,19]],
"dopunjava": [32],
"izričito": [4],
"škotski": [6],
"funkciju": [[21,29],[18,32],[1,5,13,31]],
"običan": [[15,27]],
"gumbom": [[24,28]],
"funkciji": [[16,17]],
"kombinirati": [18],
"valjanosti": [[16,34],32,[21,22],18,33,19,8,15],
"funkcioniranja": [[15,18,30,32,33]],
"najsličniji": [32,30],
"manipuliranj": [[27,32]],
"svejedno": [31,[19,21]],
"odabrani": [21,13,[22,29],[8,18,31]],
"funkcija": [21,30,[11,16],[10,13,14,17,20,26,28]],
"poistovjećuj": [11],
"željeni": [[1,21],[20,27,32]],
"izvan": [5,[16,32]],
"najbolj": [31],
"odabrano": [21,32,[8,27,30]],
"uzb": [6],
"odabranu": [[1,32]],
"dijel": [[2,7],31],
"pretvar": [14],
"poboljšanja": [[9,21]],
"tvorac": [2],
"manj": [[14,15,18,22,25,28,31]],
"stvarnoga": [9],
"opet": [18],
"strelic": [27],
"funkcioniranju": [32],
"kombinacij": [[5,30]],
"željeno": [16],
"ponavljanja": [32,21],
"sastavljanj": [18,34,[21,25,33]],
"odabrana": [18],
"staroslavenski": [6],
"e-poruku": [14],
"posebic": [[24,28]],
"izvještit": [22],
"željenu": [14,[12,16,27,32]],
"kornski": [6],
"viewdisplaysegmentsourcecheckboxmenuitem": [8],
"stavkama": [18],
"čitaju": [31],
"editregisteremptymenuitem": [8],
"naslova": [[27,32]],
"prethodn": [[13,14,21,22,31]],
"skraćenim": [1],
"obavljaju": [[15,26]],
"open": [13,[15,16],31],
"pomoću": [32,24,[2,18,21,31],[5,27,29,33,34]],
"www.oracle.com": [18],
"prikladan": [32],
"nužn": [[16,32]],
"skript": [1,34,[0,2,9,11,18,24,33]],
"zasebni": [[13,28]],
"pomoćn": [31],
"mkd": [6],
"zasebno": [15],
"project": [2,24,[14,21]],
"xmx1024m": [18],
"pomoći": [[32,34],4,21,[9,22,31]],
"pojavnic": [[16,26,27],[29,32]],
"razvoju": [[9,34]],
"metodama": [[15,24]],
"ispravit": [16],
"dzo": [6],
"pregledavanj": [10],
"pismu": [23],
"razdvojen": [[17,28]],
"razlikama": [17],
"tijekom": [14,[17,18,22,24,28,31]],
"praznih": [28],
"penalty-xxx": [31,34],
"gotonextsegmentmenuitem": [8],
"svijetu": [23],
"praznim": [13],
"poštivanj": [27],
"dinamički": [1],
"mlg": [6],
"mapu": [31,18,2,32,[21,29],14,[8,22],[10,12,17,19,20,24]],
"volonterski": [9],
"praznin": [28],
"povezan": [[11,20]],
"nnn.nnn.nnn.nnn": [18],
"dovršetku": [11],
"negacija": [25],
"internetskim": [14,11],
"mlt": [6],
"abort": [[18,22]],
"mapa": [14,31,18,24,[1,2,22,34],[8,12,21,32]],
"internetskih": [32],
"mape": [31,2,34,14,32,[18,19,27],[11,21,24],[0,3,13,15,29,30,33]],
"uređivanj": [18],
"mapi": [18,[14,31],21,[17,22],32,[0,1,2,3,8,12,13,19]],
"treba": [[15,20],[2,10,18,28],[14,16,17,19,24,25,32]],
"njima": [32,[2,11,19,20]],
"mojglosar.tbx": [17],
"internet": [20],
"glavnu": [14],
"skup": [24,28,[11,30]],
"onemogućavamo": [21],
"iznova": [2],
"podudarnom": [21],
"pridružen": [18],
"svoga": [24],
"printf": [16],
"obrađivanja": [21,31],
"priručnika": [32,[9,14,21]],
"pregledati": [[11,31]],
"zadrži": [13],
"interest": [20],
"distribucijski": [18],
"brže": [17],
"potpuno": [[21,32],[14,16,17,27,31]],
"čitanj": [17],
"pritiska": [27],
"ugrubo": [32],
"es-mx": [29],
"glavna": [14,31,34],
"procitaj": [13],
"crveno": [16],
"crveni": [2],
"itekako": [27],
"marc": [4],
"svojstva": [14,34,21,[13,24],22,[11,31,32,33],[8,12,17,18,28,29]],
"pruža": [32,9],
"glavni": [34,32,33,21,[1,8,11,13,22]],
"istovjetnoga": [30],
"vendski": [6],
"bash": [14],
"crvena": [31],
"stem": [3],
"base": [17],
"mog": [[2,20,31],[18,28,29]],
"pretražuj": [1],
"razmjenu": [17],
"mon": [6],
"preuzetih": [2],
"cjelokupnom": [18],
"ispravna": [31],
"zadano": [13,[23,34],[1,2,15,21,32,33]],
"početka": [5,31,[13,24],[19,22,25,28]],
"umetati": [21],
"postupno": [14],
"skoro": [[17,23]],
"prebac": [[15,21]],
"stila": [0],
"volapük": [6],
"narančastom": [21],
"zadanu": [21],
"zadana": [[14,28,31],[13,21,30]],
"vam": [18,[16,17],[14,19,20,27,28,30,32]],
"pregledavati": [32],
"neprioritetnih": [17],
"sastavljati": [28],
"ikakvoga": [7,21],
"vas": [14,[16,31]],
"zadani": [8,[15,32],[21,23],[14,31]],
"gubitka": [22,[14,34],[11,24,33]],
"gedit": [17],
"podcrtavaju": [21],
"odlomaka": [13,[11,15]],
"microsoftova": [[13,17,32,34]],
"posluž": [31,[15,17,18,28,32]],
"brojevi": [30,32],
"snalaženja": [27],
"objekt": [1],
"bilješkama": [21,[8,27]],
"srpski": [6],
"ispravno": [[0,2]],
"stilu": [16],
"potrebnoga": [32],
"brojeva": [32,[30,34]],
"word": [15,[13,19,21,27]],
"najnoviju": [[9,31]],
"putanja": [18,22,32],
"uporabi": [2],
"osetski": [6],
"zapravo": [[16,32],[2,17,18,22,24]],
"bezopasn": [[16,32]],
"haićanski": [6],
"brzi": [[11,18,20,21]],
"parametar": [18,22],
"japanskih": [[21,23]],
"namijenjena": [[14,17,20]],
"nedosljednosti": [4],
"najnoviji": [20],
"podatka": [22],
"uporabu": [28],
"namijenjenu": [29],
"mri": [6],
"početku": [14,[8,11,13,18,22,31]],
"namijenjeno": [[11,25]],
"oslobađanj": [32],
"vcs": [2],
"chamorro": [6],
"zaslona": [9],
"uzrocima": [18],
"lingvo": [12],
"poslova": [32],
"zhuang": [6],
"sobom": [19],
"mrs": [28],
"naslov": [21],
"zaslonu": [[18,22]],
"tortoisegit": [2],
"mudrij": [[29,31]],
"msa": [6],
"sinkronizira": [18],
"obrađen": [[16,21,31]],
"kratic": [[11,28]],
"mjesečno": [18],
"razlikovanja": [[25,27]],
"elemenata": [[13,15]],
"obavljenih": [[20,32]],
"znači": [[5,12,15,17,18,31,32]],
"baze": [17],
"prevedenedatotek": [22],
"nekim": [[14,16,18,20,22,23,24,28,31]],
"država": [31,[13,18,34]],
"početnu": [16],
"spremljeni": [[2,31]],
"n.n_sourc": [18],
"sučelju": [15],
"nekih": [[16,24,31]],
"sadržajem": [30,[8,14,18,21,22,32]],
"svome": [18],
"znače": [20],
"tokenizatorom": [32],
"segmentima": [[15,21,32,34],[13,16],[10,11,18,24,26,27,28,31]],
"heksadecimaln": [25],
"pt_pt.aff": [29],
"kolega": [32],
"konkretno": [22],
"sučelja": [14,[9,11,12,18,21,22,34]],
"html": [18,13,15,28,[14,16,19,22,31,32]],
"kopiraju": [32],
"kopirajt": [31,[18,22]],
"objedinjavanjem": [15],
"riječju": [21],
"ven": [6],
"prevedena": [[14,31]],
"veličinama": [15],
"prevedeni": [[21,32],31,22,[8,13,14,15,19,20,24,26,27,30]],
"omegat.bat": [14],
"sporijega": [22],
"razvojnih": [2],
"državu": [18],
"brzo": [18,[27,32]],
"artund": [29],
"kodnom": [23],
"izvršava": [2],
"oracleov": [18],
"početna": [[14,16],[8,21]],
"kratki": [11],
"prevedeno": [27],
"kratko": [11],
"hoće": [13],
"države": [31,13],
"različitijih": [20],
"početno": [[14,30]],
"svjetlosivom": [21],
"retku": [[8,21,32]],
"retka": [[18,25],[5,20],[14,22],[4,16,24,31]],
"neraspakiranoj": [18],
"kopirali": [31],
"iskoristit": [31],
"identičan": [13],
"sawuła": [7],
"www.ibm.com": [18],
"umetanj": [21,34,5,[13,27]],
"uključeno": [32],
"instaliranja": [18,[14,21,29]],
"obavljanj": [2],
"nagor": [28],
"ažuriranih": [34],
"platform": [[14,18]],
"prikazivati": [31,11],
"velik": [27],
"instaliranih": [18],
"korišten": [[8,32]],
"posebno": [[3,4,15,16,18,27]],
"sufiksa": [3],
"sastavljen": [31],
"dokumentacij": [4,[11,21]],
"nedostajalo": [4],
"dovoljan": [[14,27]],
"nastavlja": [[18,22]],
"podršk": [4],
"instaliranim": [[14,18]],
"posebnu": [13,[5,16,22]],
"uključena": [[13,21]],
"podržan": [17,15],
"ispravljanj": [[4,11,16,20]],
"ažuriranja": [[11,32]],
"vanjska": [24],
"podes": [15],
"command": [[8,21,32],[18,19]],
"ometati": [18],
"popravljanj": [16],
"n.n_without_jr": [18],
"vanjsku": [24],
"segmentiran": [[15,28]],
"povjerljivosti": [[2,21]],
"orijentiran": [1],
"bugarski": [6],
"izvod": [21],
"brazilski": [[18,29]],
"događajima": [[18,22]],
"materijal": [2,11],
"dopušta": [[15,20]],
"viewmarkbidicheckboxmenuitem": [8],
"pronalaženj": [21,[3,9,16,18,25,32]],
"kopiranj": [21,5,[22,29,31,32,33,34]],
"funkcioniraju": [28],
"znati": [[18,20,31]],
"sažmi": [13],
"vie": [6],
"dodavanj": [18,[2,8,21,32],[9,13,14,15,17,27,28,34]],
"naravi": [[17,23]],
"fileshortpath": [32],
"sastavljanjem": [31],
"vaš": [18,28],
"poruku": [[2,14,20,22]],
"sljedećemu": [[14,18,22]],
"matric": [13],
"primljen": [2],
"službeni": [33],
"odnosu": [32,34,[14,21,28,31]],
"poruka": [18,[20,32]],
"mijenj": [24,18],
"naredbi": [[2,18,21]],
"vidljivi": [9],
"zadržavanj": [[15,18]],
"version": [[2,18]],
"preglednikom": [14],
"tijeka": [[15,32]],
"lišiti": [23],
"priručnicima": [15],
"tijeku": [32],
"odnosi": [[18,31],[14,15,16,21,28,32]],
"folder": [18],
"mya": [6],
"stop": [21],
"okana": [32,[5,33,34]],
"zadržavamo": [13],
"duplicirati": [16],
"naredbu": [18,[14,24]],
"strukturiranih": [17],
"već": [[18,32],21,31,11,[1,14,15],[2,3,8,17,22,24,26,27,28,29,30]],
"vista": [14],
"udaljenom": [18],
"dmymemory.api.email": [20],
"nejasnoć": [9],
"milijuna": [18],
"spominjati": [4],
"autorska": [7],
"projecteditmenuitem": [8],
"arhiv": [14],
"zarezom": [17],
"rezultatima": [27],
"britannica": [[12,34]],
"naredba": [18,21,24],
"statistika": [34,32,8,21,[14,33]],
"grčkome": [25],
"podrobno": [15],
"enriqu": [7],
"sadržajima": [8,2,21,[9,14,32]],
"machin": [[1,20]],
"izostav": [16],
"zadržavaju": [[18,24]],
"gabarit": [32],
"programiranj": [1],
"prilagodlj": [13],
"polazišt": [9],
"nevidljivi": [13],
"pritisnuti": [18,[13,21,30,32]],
"ovako": [18,[19,28]],
"određivanj": [[8,21],[2,3,15,20,22,23,28]],
"potrebama": [18,[2,5,21,26]],
"iceni": [15],
"poduzima": [21],
"armenski": [6],
"općenitom": [18],
"programirana": [27],
"rastavljen": [[16,32]],
"vratiti": [[21,32],[14,15,22,27]],
"segmentira": [28,13],
"njegov": [[4,32],[13,17,20,21,24,29]],
"odluči": [24],
"ignorira": [13,[14,16,29]],
"krajnj": [13],
"izravno": [18,14,[13,21]],
"daljnjih": [31],
"prikaži": [[8,18,21]],
"preporučujemo": [2],
"ažuriranoga": [32],
"donekl": [32],
"dsun.java2d.noddraw": [18],
"beskorisn": [2],
"naziv_projekta": [[14,31]],
"izravnom": [2],
"istaknuto": [32],
"uredno": [2],
"skupina": [16,34,33,25],
"toga": [[21,32],[2,31],[17,18,20,22,26,28]],
"ell": [6],
"okvirni": [32],
"četiri": [32,21],
"x0b": [25],
"uvjetom": [[16,17,30,31]],
"izravnoga": [22],
"gruzijski": [6],
"temelj": [12],
"prikazanom": [[20,29]],
"albanski": [6],
"skupinu": [[9,14,16]],
"pritisnit": [18,2,19,[13,21],[17,23],[24,28,29],[1,9,16,20,26,30,32]],
"nastavak": [[17,23],13,[12,19]],
"http": [18,20,1],
"skupini": [[9,14,19,31]],
"odlučit": [[24,31]],
"naziv_projekta-omegat.tmx": [31],
"marāthī": [6],
"jre-e": [18],
"alternativnim": [[31,34],[13,24]],
"navest": [21],
"razdvojeni": [[8,17,21,28,32]],
"hrvatskom": [23],
"utvrđivanj": [13,2],
"dijaloškoga": [21,[5,13,19,24,28,30]],
"luganda": [6],
"razdvojena": [17],
"kopirati": [29,19,[13,14,18,32]],
"privatn": [10],
"padežu": [17],
"alternativnih": [32,[13,21]],
"jc-u": [4],
"vol": [6],
"strane": [16,[20,28,32]],
"softwar": [7],
"sigurnosn": [31,[14,22]],
"pisanja": [20,[5,15,22]],
"projectsinglecompilemenuitem": [8],
"end": [5],
"docbook": [[4,15,16]],
"helton": [4],
"eng": [6],
"reproduciran": [16],
"računanja": [32],
"zadacima": [31],
"nego": [32,[21,31]],
"zbirnih": [21],
"specifičn": [31],
"dokument.xx": [13],
"razdvajanjem": [17],
"okapi": [34],
"vpj": [31],
"albanskoga": [20],
"slikarstvo": [27],
"popravci": [31],
"kineski": [6],
"skočnoga": [32],
"skupin": [16,[14,32],[9,11,22]],
"veličinu": [8,18],
"pritisnut": [8],
"parametrom": [18],
"istoga": [31,[2,12,27,30,32]],
"moran": [7],
"system-os-nam": [13],
"veličini": [32],
"izrazima": [13,[25,27,28]],
"optionstabadvancecheckboxmenuitem": [8],
"traženja": [[27,32]],
"nad": [28],
"sigurni": [[14,19,23,31]],
"izravan": [28],
"donacij": [34],
"obavljen": [[2,16]],
"grafičkoga": [14],
"sigurno": [31],
"izgubili": [[22,31]],
"član": [2,[14,25]],
"mapa-konfiguracijskih-datoteka": [[18,22]],
"oznak": [16,34,13,31,15,[21,24,32],19,[29,30],[8,11,18,33]],
"optionsviewoptionsmenuloginitem": [8],
"daljnjem": [[25,31]],
"nam": [[13,24,32]],
"sumnja": [16],
"definicij": [8],
"pretraživačima": [27],
"prilagođeni": [32],
"nas": [32],
"nav": [6],
"nau": [6],
"tar.bz2": [12],
"epo": [6],
"prazni": [[8,18,30]],
"umetanju": [21],
"osvrnut": [21],
"obrnut": [25],
"tretira": [31,27,[16,24]],
"dodavanja": [[2,20,21,28]],
"vrh": [28],
"repozitorija": [2,31,34],
"među": [[8,31]],
"prazno": [30,[21,28]],
"konkretn": [18,11],
"umetanja": [30,21,[15,28]],
"etap": [31],
"veličina": [21,[15,16,22]],
"prijelaza": [32],
"x64": [18],
"nbl": [6],
"prijevodima": [31,[33,34],[13,24,25,27]],
"repozitoriju": [31],
"prazna": [14,[2,17,31]],
"povratak": [[5,16]],
"toni": [7],
"konfiguracija": [10],
"doprino": [34,9,[4,33]],
"kartici": [20],
"biljež": [[2,14]],
"isn\'t": [25],
"jednostavn": [[13,15,16,31]],
"praznu": [2],
"neku": [31,7,[13,14,18,24,27,29,32]],
"kartica": [32],
"potvrdni": [24,28,27,[13,29],[0,2,18,21,30]],
"izdavanj": [18],
"nastavka": [13,[12,15]],
"baskijski": [6],
"kutu": [32],
"tipkama": [32],
"nadziranja": [2],
"izračunima": [32],
"odlučili": [2],
"najprikladniji": [32],
"vezanim": [14],
"neke": [21,32,[13,16],[0,11,12,14,18,22,24,27,29,31]],
"duplicirano": [16],
"slovenskom": [20],
"optionsteammenuitem": [8],
"tome": [[13,31,32]],
"trebat": [18,31,14,[9,13,17,20,22,23,29,32]],
"neki": [31,32,[17,28],22,[13,15,18,25]],
"dijela": [21,32,[5,29]],
"funkcionirati": [29,8],
"neko": [[10,28,29,31,32]],
"tekst": [15,21,32,[13,28],[16,31],30,34,23,[5,8,18,27],[11,14,20,22,24,25,29]],
"objedinjavanj": [16],
"lokaliziranoga": [22],
"gzip": [31],
"nde": [6],
"trebal": [18],
"trebam": [4],
"pojednostavn": [16],
"istovjetnost": [16],
"esc": [32,[5,21,27]],
"duplicirana": [16],
"morat": [18,20,22,[13,14,31],[28,29]],
"x86": [18],
"nastavku": [[2,17,22,31]],
"ndo": [6],
"operacijsk": [2],
"neprevedenoga": [21],
"dupliciranj": [[16,34]],
"vodič": [11,[9,15]],
"neka": [[4,19,21,31]],
"nostemscor": [32],
"bilješka": [21,[8,32]],
"zaključavanj": [32,18],
"parametara": [15,4],
"vodit": [18,31,[16,24],[2,9,14,29]],
"podmapu": [19,[14,18,24,31],[2,22,30]],
"est": [6],
"izbjeg": [[2,22,31]],
"podmapi": [31,[17,19,32],[2,12,14,22]],
"bilješki": [32,27],
"ukazuju": [16,32],
"zanima": [[14,31]],
"console-createpseudotranslatetmx": [18],
"podmapa": [14,34,[11,29,31]],
"internoj": [32],
"praznina": [25],
"etc": [18],
"strojnim": [21,8],
"vrijem": [[13,14,20,29],[11,18,19,21,22,24,30,32]],
"njenoga": [[13,14,17,23,27]],
"funkcioniranj": [34,30,21,[31,32],[3,8,11,14,15,23,33]],
"longman": [[12,34]],
"nep": [6],
"fuzzyflag": [32],
"ukazuj": [[15,31]],
"izmjen": [18,[15,28],[2,7,31],[8,13,14,20,21]],
"račun": [[18,20],2],
"rečenica": [[11,16,19,20,24,28]],
"merriam": [[32,34]],
"didn\'t": [0],
"ništa": [25,[5,21],4],
"određuju": [18,31],
"pojedinačno": [[11,27]],
"modifikatora": [8],
"premda": [[20,27]],
"sprječavanj": [[22,34],[14,24,33]],
"korisnicima": [[14,15,18,20,25,27]],
"nema": [31,17,[18,27],[3,5,15,19,20,21,22,24,29,32]],
"referentn": [31],
"podudarivači": [[25,33]],
"označ": [32,[16,21,30]],
"dohvaćaju": [21],
"rečenicu": [[19,31]],
"skupna": [18],
"nastavit": [4],
"običnoj": [14],
"ljepši": [3],
"eus": [6],
"medij": [22],
"project_sav": [32],
"poništ": [14],
"pridruženo": [21],
"dostatna": [28],
"običnom": [23,[16,30,33,34]],
"funkcionaln": [1],
"cijen": [20],
"veličinom": [21],
"predoč": [28],
"pandžapski": [6],
"sprječavamo": [30],
"cijel": [30,31],
"n.n_without_jre.zip": [18],
"lokaliziranim": [22],
"izravnim": [13],
"odrđena": [18],
"ljepša": [3],
"najnovijoj": [2],
"igbo": [6],
"prijelazu": [30],
"višerječna": [[32,33]],
"tiskanih": [32],
"najnovijom": [2],
"običnog": [17],
"izbrisano": [16],
"interlingua": [6],
"ndebel": [6],
"magento": [15],
"evo": [18,15],
"upisivanj": [32,[17,18,30]],
"zamijen": [26],
"mrežnih": [20],
"prošir": [28],
"okcitanski": [6],
"vxd": [15],
"potvrdit": [18],
"zadan": [13,[2,14,18,21,22]],
"vrijed": [24,18,[15,16,32]],
"ewe": [6],
"odvlačenj": [[18,32,34],33],
"putanjom": [18],
"martin": [7],
"dostatno": [31],
"u00a": [27],
"prevodivih": [32],
"funkcijska": [1],
"nastavi": [2],
"ishodišna": [8],
"načinima": [[14,15,24]],
"neodvojivi": [27],
"lingvističkih": [20],
"nizom": [27],
"nekoga": [[14,31],[3,5]],
"upozorenj": [[18,32]],
"shift": [21,8,5,15,[16,19,27],[17,30,34],32],
"samci": [16,34],
"ključev": [18],
"naveden": [[18,21],13,[14,15,19,20,22,29,31]],
"utvrđuj": [13],
"oblicima": [[3,13,14,16,32]],
"odjeljku": [23,[16,18,24,30,32]],
"wunderlich": [7],
"označi": [21,8,30],
"isključivanjem": [21,13],
"naš": [2],
"odjeljka": [16],
"java": [18,14,22,[8,34],1,[15,16,33],[13,25,31]],
"exe": [18],
"modela": [20,31],
"zamjenu": [21,[26,32]],
"razgranatu": [14],
"dokumenata": [15,[13,21,31,34],[10,16,19,24,27]],
"javi": [25],
"ključem": [20],
"project_save.tmx": [31,22,[14,15],[2,21,27,30]],
"javn": [7,14],
"niz": [[21,27],32],
"previš": [32],
"tehnologija": [18],
"dictionari": [12,2],
"nadograd": [31,18],
"zamjena": [[21,26],34,27,[8,13,25,31,33]],
"svakodnevno": [14],
"umetanjem": [31],
"njemačkoga": [0],
"modelu": [[1,31]],
"prevodivi": [28],
"nje": [18],
"preveden": [21,8,[11,13,14,20,23,24,30,31]],
"obrazložen": [11],
"radnoga": [18,34],
"nju": [18,14,[1,5,31]],
"industrijska": [32],
"okončanj": [25],
"raspoloživoga": [[18,22]],
"flash": [15],
"pravilo": [28,34,16],
"appl": [[19,21]],
"napredn": [[11,22,31]],
"tekstovima": [11],
"prevedet": [21],
"funkcijama": [[1,32]],
"pravila": [28,34,24,11,[0,14,16,33],[15,25,32],[13,20,31]],
"odzivn": [20],
"amharski": [6],
"tehnologiju": [17],
"timestamp": [13],
"skrivanj": [21],
"služi": [32,[13,16,18,27],[5,11,22,28,30,31]],
"projectaccessrootmenuitem": [8],
"razmaka": [[11,21,25,27,32]],
"služe": [32,[16,21,30,31]],
"dyandex.api.key": [18],
"inačicom": [2],
"nld": [6],
"siročići": [31,34,32],
"jedinic": [31,28],
"barem": [20,[2,30,31,32]],
"oracleovim": [18],
"identifikacija": [20],
"plugin": [[0,3]],
"unatrag": [21],
"prilagođenih": [21],
"citiranj": [25],
"omegat-l10n-request": [9],
"nizov": [17],
"fusnot": [13],
"okončali": [31],
"vidjeti": [[13,17,25]],
"siročića": [27],
"instalacija": [18],
"plaća": [20],
"rabi": [20],
"lokalnoj": [2,18],
"intervencija": [17],
"editinsertsourcemenuitem": [8],
"rabe": [13],
"doprinosi": [[15,16,32]],
"lokalnom": [2],
"pokazati": [[2,11,15,24]],
"objašnjenj": [[11,18,22]],
"microsoft": [[13,15,20,34],[11,18,19,33]],
"projectnewmenuitem": [8],
"prilagodbu": [[9,13]],
"prvome": [32,[16,17,18,31]],
"sustavima": [18,21,11],
"dijelu": [[1,32]],
"optionstranstipsenablemenuitem": [8],
"segment": [21,32,31,[16,30],8,27,13,[15,19],5,[1,11,20,22,24,28],[17,18]],
"changes.txt": [14],
"prednost": [[21,28,31]],
"funkcionira": [20,[14,18,25,29,31]],
"milijun": [20],
"metod": [27,[18,34],33],
"glossari": [17,2,[19,21,27,32]],
"ignored_words.txt": [[2,14]],
"prijeđit": [18],
"počevši": [32],
"članovima": [[2,31]],
"otvaranj": [21,[18,32],[5,8],[14,27,34]],
"configuration.properti": [18,10],
"regularnim": [13,25,[27,28]],
"prevedit": [15],
"nno": [6],
"regularnih": [25,33],
"svake": [2],
"svaki": [[2,13,31],[14,15,17,27,28]],
"dovršavanja": [21,5],
"količin": [32],
"otvaramo": [32,[2,21,26,27]],
"razloga": [21,[14,18,29]],
"svaka": [31,[11,22]],
"next": [[0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33]],
"nob": [6],
"radi": [21,32,[2,31],[15,16,18],[13,23,28],27,[8,14,17,19,20,25],[1,3,10,11,22,29]],
"svaku": [21,[9,32]],
"samac": [16],
"string": [18],
"rade": [11],
"čuvati": [15],
"izbjegavanja": [[2,15]],
"radn": [4,[3,28]],
"premještenih": [21],
"oznakama": [16,34,32,[15,31,33],[6,11,18,19,21,22,30]],
"nor": [6],
"zaglavlj": [13],
"not": [18],
"uvjetima": [7,31],
"najvjerojatnij": [[22,23,31]],
"now": [0],
"otvaraju": [21],
"rada": [18,22,34,31,32,[11,14,24],[2,13,15,16,30,33]],
"očitava": [23,31],
"prevod": [13,[18,31],[11,22]],
"pronađeni": [27,[17,32]],
"ascii": [15],
"olakšava": [16],
"postavci": [13],
"najnovij": [[14,18]],
"mogućnosti": [[13,21],[32,34],33,30,[24,26,27],[8,16,20,29,31],[23,28],[0,2,5,10,11,14,15,18,22,25]],
"pristupanj": [10,[2,33]],
"očitavanja": [15],
"xml-a": [[13,15,20]],
"izvođenja": [20],
"kodiranjem": [[13,23]],
"iskustvo": [[16,24]],
"selection.txt": [30,21],
"softverski": [22],
"instalaciju": [18],
"xhtml": [13,[15,16,28]],
"npr": [[16,31],[17,22],[18,30,32],[2,12,15,19,20,24,27,29]],
"drugoga": [[16,18,22,31]],
"xml-u": [17],
"upozorenja": [18,30],
"zatim": [18,21,23,[24,27,32],[2,10,22,26,28,29,31]],
"prilagod": [[1,5,11,16]],
"ženskoga": [3],
"spomenut": [21],
"postupkom": [22],
"window": [18,14,[2,34],21,[11,12,15,17,20,22,25,32,33]],
"sprječava": [16],
"lingvističkim": [20],
"samca": [16],
"kodirani": [15],
"odjeljci": [15],
"spriječilo": [16],
"glosaru": [17,[11,32,33]],
"gramatičkih": [11],
"izvornom": [[4,32]],
"napravit": [31,[14,16]],
"kodiranj": [13,34,23,[17,20,32,33]],
"bojaju": [16],
"unijeti": [18,[22,32]],
"rečenicama": [28,[11,13,24,34]],
"naziva": [13,34,[14,30,32],[12,17,18,23,28,31]],
"disable-project-lock": [18],
"ključni": [17],
"cjelovitim": [31],
"okončava": [25],
"vrijedi": [22,[18,24,32],[2,21,27,31]],
"omegat.pref": [[14,32]],
"kodiranu": [23],
"toplo": [15],
"branko": [31],
"glosari": [17,34,10,[8,11,12,14,19,27,33]],
"nazivi": [13,[29,34]],
"inupiaq": [6],
"globalno": [13],
"fao": [6],
"txml": [15],
"glosara": [17,21,34,32,[2,10,14,27,33],[5,8,11]],
"prikaza": [15,21,32,[8,10,22,23,26,29]],
"kodirana": [17],
"fas": [6],
"sažet": [[31,34]],
"plan": [21],
"globalna": [34],
"bartko": [7],
"nazivu": [13],
"globalni": [34],
"znaka": [28,[5,17],[16,18,21,25]],
"kodni": [23,11],
"nedostatna": [20],
"nudit": [31],
"završn": [[13,16]],
"pt_pt.dic": [29],
"sljedećoj": [8,[25,32]],
"izlazni": [[8,15,21]],
"pritisnet": [[17,18]],
"radu": [[11,16,18,31]],
"primarni": [[18,20]],
"završi": [26],
"konzolnom": [22,18],
"nastala": [18],
"level1": [[19,31],21],
"znaku": [25],
"level2": [[19,31],21],
"blokovi": [[32,33,34]],
"zarezima": [13],
"izmjena": [31,[2,20,21],[8,13,17,18,26]],
"prikazuju": [21,17,32,[13,27],[18,22],24,[8,11,15,20,25,29,30,31]],
"visok": [31],
"poveznicu": [32,[16,20]],
"bojama": [15,21],
"izmjenu": [31,8],
"gomilali": [27],
"nepromjenjivi": [30],
"maratski": [6],
"provjerit": [20,29,[11,12,31]],
"znaju": [[11,16,32]],
"prevoditelj": [20,34,33,18,11,[28,31]],
"poveznica": [32],
"web": [18,[20,34],9,33,[2,14,19]],
"pojednostavljivanj": [[15,16,32]],
"uspoređivanja": [32],
"priviknuti": [18],
"volof": [6],
"kwanyamaški": [6],
"nastanka": [16],
"znakovima": [21,32],
"berlin": [7],
"trenutku": [[15,31]],
"povezivanj": [2],
"samoanski": [6],
"unosa": [[5,21]],
"editselectfuzzy4menuitem": [8],
"editregisteridenticalmenuitem": [8],
"ovisi": [[14,15],[0,20,21,31,32]],
"softverom": [32],
"savjetniku": [17],
"detaljnij": [32],
"sljedeć": [13,[2,20],18,[14,32],[8,11,15,21,27,30],[5,16,17,22,23,31,34]],
"gotovih": [11],
"cjelovitih": [20],
"pojedinu": [21,32],
"procesom": [30],
"napomen": [[7,34],[4,8,11,27,33]],
"višestrukih": [[32,34]],
"savjetnika": [[8,21,32]],
"nedvojbeno": [16],
"timskom": [[2,31]],
"pt_br.dic": [29],
"dosljedno": [31],
"samom": [[13,16,18,31]],
"izvornog": [16],
"pokušaja": [[5,18]],
"uputa": [[13,18]],
"unabridg": [12],
"zatvori": [[8,21],[26,27]],
"provjerom": [[21,22]],
"preporučuj": [[15,17,24,28]],
"kontekst": [[13,32]],
"parovi": [[16,34]],
"section": [21],
"pojedini": [[13,27]],
"afrikaan": [6],
"čuvaju": [2,15],
"somalski": [6],
"želji": [[14,17,31]],
"pokušajt": [18],
"trenutna": [20],
"optionsglossaryexactmatchcheckboxmenuitem": [8],
"spomenuli": [18],
"riješ": [[18,21]],
"prigodu": [18],
"ekstenzivno": [11],
"vremena": [[14,29]],
"ipak": [[24,27,30],[14,20,29,31]],
"arapski": [6],
"komponenti": [21],
"kazački": [6],
"želit": [31,18,[27,32],[9,13,28],[7,14,19,20],[8,21,23,24,25,30]],
"povećati": [[28,30]],
"dobijet": [11],
"kodiraju": [17],
"iskoristivost": [31],
"parova": [[13,20],16],
"nnnn": [32,18],
"stječu": [24],
"marker": [[32,34]],
"timskih": [2,33],
"savjetima": [15],
"licenca": [14],
"zajedničkih": [2,32],
"većina": [[14,18,21]],
"samim": [2],
"gubitkom": [14],
"rtl-a": [15],
"izvornih": [20],
"većini": [[2,8,15,23]],
"prvoga": [[1,21]],
"nečega": [31],
"naznačenoj": [18],
"izvornim": [27],
"višekratn": [[8,21,24]],
"slučajeva": [[2,23]],
"naučit": [[11,19],[4,7,18,33]],
"nadalj": [[16,18]],
"memorijom": [31],
"neobično": [16],
"većinu": [[23,28],[13,16]],
"apsolutnom": [31],
"žuto": [32],
"wordfast": [15],
"volji": [22],
"huriaux": [7],
"olakšano": [11],
"wix": [15],
"uskličnika": [2],
"trenutno": [32,[2,15,21]],
"grčkoga": [25],
"riječ": [21,27,[5,26,32],[3,11,14,16,18,25,28,29]],
"trenutni": [[17,21,32]],
"zajednic": [31],
"memorija": [31,34,11,32,33,[2,27],[14,18,20,21,24]],
"ljudskom": [20],
"txt2": [23],
"otočj": [6],
"prikazanih": [21,27],
"visio": [15],
"nya": [6],
"memoriji": [32,[14,15,17,21,26,28,31]],
"txt1": [23],
"archiv": [18],
"memoriju": [31,[21,24],[19,22,27]],
"user": [18,14],
"proxi": [18,[21,34],8],
"donijeti": [31],
"extens": [13],
"fij": [6],
"fin": [6],
"retoromanski": [6],
"uzorka": [28,13],
"mješavina": [17],
"slučajevima": [31,21,[11,13,15,28],[3,18,20,22,23,24,25,30,32]],
"hausa": [6],
"b0": [16],
"lijevom": [1,[18,32]],
"b1": [16],
"nevidlj": [24],
"b2": [16],
"preuzetu": [18],
"jednu": [[13,31],[8,12,14,26,27]],
"padajući": [[22,29]],
"obaveznoga": [13],
"neodređeni": [25],
"preuzeti": [14,[2,29]],
"iznimno": [11],
"aa": [6],
"ostavljanj": [16],
"ab": [6],
"ae": [6],
"parametr": [18],
"af": [6],
"podrazumijevano": [13],
"rješavanja": [[2,23]],
"naizmjenično": [21],
"pojedinačnoga": [30],
"dvije": [18,29,[1,14,15,21,24,28,30,31]],
"ak": [[6,22]],
"diff": [32],
"am": [6],
"an": [25,6],
"editmultiplealtern": [8],
"timova": [2],
"ar": [6],
"imaju": [[5,21,28],[1,15,17,27,30]],
"as": [[6,21]],
"podrazumijevana": [2],
"av": [6],
"sinhaleški": [6],
"pretvara": [19],
"hvala": [4,33],
"ay": [6],
"wln": [6],
"az": [6],
"izbjegavajt": [9],
"ostavljamo": [13],
"starih": [24],
"razdjelnik": [32],
"imajt": [[29,31,32],[14,18,20,24],[2,9,12,16,27]],
"surađuj": [2],
"ba": [6],
"dodaci": [11],
"be": [6],
"najjednostavnij": [18],
"bg": [6],
"određujemo": [24],
"bh": [6],
"bi": [2,18,[27,28,31],[13,15,24],[4,23],[6,8,9,12,14,16,17,19,22,29]],
"prevesti": [[11,18,28]],
"jednim": [18],
"filters.xml": [14,[2,24]],
"razmislit": [23],
"rješavanju": [31],
"bm": [6],
"bn": [6],
"europsk": [31],
"bo": [6],
"terminologij": [10,[27,31,32]],
"promijen": [[18,23,32],[13,14,15,17,28]],
"br": [8,21,13,[6,18]],
"bs": [6],
"uzima": [24],
"search": [21],
"ostavljaju": [21,8],
"uključivanja": [21],
"upisuj": [[21,27,31,32]],
"činjenici": [26],
"segmentation.conf": [[14,22],[18,24]],
"gumba": [27,[10,26,32]],
"ca": [[6,18,20]],
"okruženju": [[18,22]],
"cd": [18,22],
"ce": [[6,15]],
"öäüqwß": [27],
"prijedlozima": [[5,31,32]],
"dostupn": [21,[13,14,18,32]],
"ch": [6],
"bjelinu": [13],
"upućuj": [[14,16]],
"sljedećim": [[13,31],[2,14,15,18,22,25]],
"cn": [18],
"co": [6],
"sljedećih": [13,32,[10,18,26]],
"trećemu": [32],
"figur": [32,[14,17,29],[0,12,16,20,25,30,33]],
"cr": [6],
"cs": [6],
"okruženja": [18,[2,22,32,34]],
"cu": [6],
"standardnom": [32],
"cv": [6],
"cx": [25],
"cy": [6],
"sanskrit": [6],
"inkrementalno": [16],
"apach": [[2,29]],
"da": [18,31,32,20,[16,17],[2,29],24,[13,15,22],[27,28],14,[4,9,11,12,19,21,23,30],[1,7,25],[3,5,6,8,26]],
"adjustedscor": [32],
"font": [22,[32,34],[8,21]],
"uvelik": [[11,15,16,32]],
"dd": [[22,31]],
"de": [[6,32]],
"iznimki": [28],
"plitkoga": [20],
"korijensk": [31,32],
"iznimka": [28],
"do": [18,5,22,16,[11,25,32],[1,21,31],[0,2,14,17,20,27]],
"f1": [[21,32],[8,34]],
"praćenj": [16],
"oštećen": [16],
"f2": [32,[18,24]],
"f3": [21,[8,34]],
"očitavati": [[23,31]],
"dr": [28],
"f5": [[8,21]],
"valjanost": [[15,30,31]],
"dv": [6],
"wol": [6],
"dz": [[6,12]],
"lokacij": [24,[8,14,21,29,31,32,33]],
"editundomenuitem": [8],
"otkriva": [17],
"četveroznamenkasta": [[22,31]],
"kopiraj": [21,[8,19,32]],
"označimo": [24],
"generiranj": [[20,31]],
"ee": [6],
"pravopisnih": [11],
"which": [17],
"u000a": [25],
"dodavanjem": [[3,13,17,30,31]],
"predmetn": [29],
"poglavito": [[16,22,24]],
"el": [6],
"visualsvn": [2],
"belazar": [20,34,33],
"en": [[6,18,22,31,32]],
"eo": [6],
"definirati": [13,[23,32]],
"skočnog": [30],
"preklopljena": [32],
"es": [[6,20]],
"u000d": [25],
"et": [6],
"izbjegavanj": [28,16],
"u000c": [25],
"eu": [6],
"leksički": [20],
"predmeta": [9],
"tematikom": [31],
"kreolski": [6],
"fa": [6],
"omiljen": [1],
"pokušati": [[18,21]],
"odznačit": [28,20],
"ff": [6],
"opetovanim": [31],
"stats.txt": [14],
"u001b": [25],
"fi": [6],
"fj": [6],
"okruženj": [2],
"različit": [[21,31],[2,11,24]],
"pisama": [22],
"for": [1,23],
"fo": [6],
"fr": [18,22,[6,20,28,29]],
"instalir": [18],
"odjeljak": [21,[14,20,31]],
"otkriti": [31],
"content": [18,33],
"fy": [6],
"applescript": [18],
"svojega": [2],
"ga": [[18,32],20,[17,27],[0,2,6,11,19,21,23,28]],
"zadataka": [[2,15]],
"gb": [18],
"gd": [6],
"class": [13],
"točkom": [[28,30]],
"helplogmenuitem": [8],
"nećet": [[16,28,32]],
"didierov": [4],
"sažeta": [14],
"upisani": [[21,27]],
"kurziv": [16],
"preinačena": [18],
"odluč": [30],
"gl": [6],
"tipizacij": [1],
"editoverwritetranslationmenuitem": [8],
"gn": [6],
"i0": [16],
"sažeti": [[2,4,32]],
"i2": [16],
"aeiou": [25],
"gu": [6],
"klijenata": [2],
"gv": [6],
"oba": [[16,22]],
"pronaći": [27,[19,25],[0,7,9,14,15,18,22,30],[1,6,8,13,16,20,29,31,32]],
"kružića": [[27,32]],
"svima": [4,[9,33]],
"pokušava": [[13,30]],
"obj": [20],
"testiranj": [25],
"ha": [6],
"zgotovljen": [22],
"upisana": [28],
"zajedničkom": [2],
"he": [6],
"nekoliko": [[31,32],18,27,[19,21,28,33],[2,13,14,15,30,34]],
"hh": [[22,31]],
"jednoj": [[26,31]],
"hi": [6],
"jednom": [25,31,[21,27]],
"duser.languag": [18],
"perzijski": [6],
"potencijala": [7],
"dodamo": [[18,22]],
"naći": [32,[18,20,21,24],[16,19,27,31]],
"ho": [6],
"projektima": [21,[2,34],[13,14,33],[19,31]],
"našem": [2],
"hr": [[6,31]],
"tab-delimit": [17],
"pretvaranjem": [20],
"poboljšavaju": [3,20],
"ht": [6],
"pregledavanja": [32,27],
"hu": [6],
"načinom": [15],
"vrijednost": [31,[18,22,32],[13,15,21]],
"hy": [6],
"hz": [6],
"inuktitutski": [6],
"file-target-encod": [13],
"strpljive": [4],
"fra": [6],
"oci": [6],
"očuvati": [14],
"eventualnu": [[15,32]],
"odmah": [[17,31]],
"dodana": [21,31],
"vcs-a": [2],
"ia": [6],
"eventualni": [[17,32]],
"context": [32],
"briel": [[4,7]],
"id": [[6,20,32]],
"https": [10,18],
"ie": [6],
"fri": [6],
"if": [1],
"project_stats.txt": [32,2],
"ig": [6],
"eventualno": [[14,18],[13,31]],
"ih": [31,14,32,[18,29],[2,13,19,21,24,27],[11,15,16,17,20,22]],
"ocr": [15],
"ii": [6],
"starijim": [21],
"ometanja": [2],
"ik": [6],
"projectaccesscurrenttargetdocumentmenuitem": [8],
"upisati": [[9,17],[16,18,21,22,24,25,27]],
"im": [21,[14,19]],
"in": [1,21],
"io": [6],
"učlanjenja": [14],
"načela": [11],
"svrhe": [13],
"termin": [17,18,[19,21,27]],
"ip": [18,34],
"načelo": [2],
"index": [34,4],
"is": [[6,17,25]],
"dodali": [8],
"it": [6],
"iu": [6],
"tonganski": [6],
"odf": [15,[13,16,28]],
"uzevši": [[16,18,32]],
"prevodimo": [30,31],
"iz": [32,31,18,21,[2,16,17],[15,27],30,[3,13,19,24,29,34],[0,5,8,10,11,14,20,22,25,28,33]],
"nepalski": [6],
"načelu": [25,[5,11,15,23,24,28,31,32]],
"odg": [15],
"ja": [[6,18]],
"svrhu": [[30,32]],
"multiterm": [17,34,33],
"izvoznih": [31],
"odp": [15],
"je": [18,31,32,21,14,13,20,17,15,[2,22],[11,16],27,30,[28,29],[8,25],23,5,19,[1,4],[7,24],[0,9,12],[3,26,33]],
"odt": [15,24],
"gotonexttranslatedmenuitem": [8],
"uključujući": [14,32,[20,25]],
"librari": [14],
"analiza": [[20,32]],
"jp": [23],
"nplural": [13],
"lokalnih": [2,31],
"js": [1],
"megabajtima": [18],
"jv": [6],
"primjerima": [18],
"learned_words.txt": [[2,14]],
"slučaj": [[15,32]],
"zamjensk": [[24,27,31]],
"maxym": [7],
"ka": [6],
"moći": [[14,16]],
"kakvi": [2],
"značajn": [[11,13,19]],
"kg": [6],
"barata": [15],
"značajk": [11,33],
"ki": [6],
"pripremati": [19],
"kj": [6],
"kk": [6],
"kl": [6],
"km": [6],
"kn": [6],
"ko": [6],
"kr": [6],
"značaja": [16],
"ks": [6],
"nahođenju": [[2,24]],
"viewdisplaymodificationinfoallradiobuttonmenuitem": [8],
"ku": [6],
"kastiljski": [6],
"kv": [6],
"draw": [15],
"uobičajen": [27,21],
"kw": [6],
"zaštit": [24],
"ky": [6],
"činiti": [18],
"isprobati": [15],
"la": [6],
"lb": [6],
"kontrolni": [[21,25]],
"dobivenih": [32],
"le": [17],
"lg": [6],
"ful": [6],
"dodaju": [[14,17,18]],
"li": [18,22,20,[28,31],13,[12,16,29],[2,6,11,19,27,30,32]],
"dodajt": [[18,20,23,28]],
"dswing.aatext": [18],
"primjenu": [[16,23]],
"ln": [6],
"lo": [6],
"izrada": [34,21,[2,10,15,19,31,33],[18,27]],
"dostupnih": [29,11],
"ls": [14],
"lt": [6],
"lu": [25,6],
"dist": [18],
"lv": [6],
"dostupnim": [14],
"redoslijeda": [16],
"vjerojatnost": [17],
"skripti": [18],
"pretraživanja": [27,26,33,[32,34],[10,11,13,17,25,28]],
"prebacivanj": [21,5,[33,34]],
"operacijskoga": [18,[13,21]],
"cycleswitchcasemenuitem": [8],
"softver": [0,[1,2,7]],
"prebacuju": [24],
"mb": [18],
"skripta": [21],
"unesit": [18,[2,8,17,20]],
"razn": [22,[6,19,21,29,33,34]],
"bidaux": [7],
"me": [4],
"mg": [6],
"najmanj": [[4,14]],
"mh": [6],
"mi": [6],
"mk": [6],
"redoslijedu": [27,[28,31]],
"ml": [6],
"mm": [[22,31]],
"entri": [1],
"mn": [6],
"parametrima": [31,14],
"osnovno": [16],
"pristupni": [2],
"mr": [28,6],
"ms": [20,[6,16,27,28]],
"pouzdanih": [31],
"mt": [31,[6,20]],
"podudara": [13,16],
"daljnjega": [27],
"izradu": [[19,21],[2,15,17,18,20,22,24,31]],
"mu": [31,13],
"tokenizator": [3,11],
"wxl": [15],
"osnovnu": [18],
"članova": [2,[4,31]],
"my": [[6,14,20]],
"usto": [1],
"znakovnoga": [17],
"pridruživanj": [13],
"disk": [21],
"na": [18,32,21,20,2,31,[14,28],16,[5,13,23],22,[9,24,29,34],27,15,[1,8,19],30,[17,33],11,[12,25],[0,3,10],[4,26],[6,7]],
"efikasnij": [25],
"članovi": [2],
"nb": [6],
"primjenj": [14],
"nd": [6],
"ne": [24,18,31,21,[13,17,32],15,16,[20,27],22,[4,30],[0,14,25,28,29],[2,23],[3,5,6,7,19,26]],
"terminom": [17],
"pogrešci": [18],
"prijenosa": [20],
"višenacionalni": [31],
"updat": [2],
"ng": [[6,15]],
"ni": [[17,18,31],[4,16,21,22]],
"primjena": [1,[0,13,33]],
"izradi": [21,8,24,[13,14,32]],
"nl": [6],
"zamjenjuju": [31],
"nn": [[6,22,31]],
"datum": [32,[13,27]],
"no": [13,[24,27],[0,4,6,15,30,31]],
"kontekstna": [13],
"kodiran": [23,17],
"code": [8,20],
"nr": [[6,17]],
"otkrili": [15],
"glavnoga": [32,[18,34],[1,11,13,21]],
"neograničeni": [18],
"nv": [6],
"tigrinjski": [6],
"gotohistoryforwardmenuitem": [8],
"očitavanj": [23],
"ny": [6],
"čuva": [[2,17]],
"tagaloški": [6],
"podudarn": [17],
"dosljedniji": [28],
"oc": [[6,20]],
"razlikuju": [18],
"od": [31,32,21,20,[11,16],[18,28],27,[1,7,13,14,25],[2,8,12,15,22,23,26]],
"uključivanj": [21,[11,13]],
"repozitorij": [2,4],
"of": [33,[2,12]],
"oj": [6],
"ok": [2],
"om": [6],
"on": [[17,34]],
"pretraživanju": [27,[16,25]],
"definiranj": [21],
"or": [6],
"smanjenju": [[15,16,32]],
"os": [18,34,14,[2,6,11,15,21,33]],
"izbjegavati": [[2,28,32]],
"ot": [15],
"sljedećem": [25,[2,12,16,17,18,20,30]],
"uočavanj": [11],
"definirano": [[13,15,32]],
"definirana": [8],
"otvarati": [14],
"muški": [3],
"dostupnosti": [18],
"oji": [6],
"pa": [32,31,[18,23,28],[2,15,16,17],[19,21,27,29],[1,3,6,9,11,13,20,22,24,25,30]],
"editinserttranslationmenuitem": [8],
"skrivenih": [21],
"kandidata": [31],
"udaljenoga": [21],
"zamijenit": [31],
"pi": [6],
"datotečnim": [13,[23,31,32],[12,14,15,17]],
"pl": [6],
"datotečnih": [13,15,[23,24,32],[19,33,34]],
"po": [21,27,[13,31],28,[2,24,32],[8,11,15,17],[14,34],22,[5,10,16,18,19,20,26,30]],
"funkcijom": [21],
"ps": [6],
"optionsglossarystemmingcheckboxmenuitem": [8],
"strategij": [[30,31]],
"pružaju": [32],
"pt": [[6,18,20]],
"započinju": [18],
"uslug": [20,[10,18]],
"preklapanj": [16,34,33],
"dohvaćanj": [21],
"upisivati": [[2,13,19,21]],
"oko": [4],
"nikakvoga": [[15,32]],
"pogrešno": [29],
"natrag": [21,[8,32]],
"istom": [21,[8,23,25,31]],
"donosi": [18],
"istoj": [14,18],
"pojavljivanja": [27],
"pronađenim": [18],
"vezu": [11],
"pronađenih": [[27,32],[21,31]],
"sebe": [[13,25]],
"veza": [29],
"dvaju": [2],
"isprazn": [32],
"qu": [6],
"imenovanj": [[16,34]],
"editselectfuzzy5menuitem": [8],
"vezi": [[11,18],[19,21,24,32],[16,22]],
"ručnog": [30],
"izuzetkom": [18],
"sebi": [5],
"opisom": [11],
"dodatn": [[1,14,31],[6,13,17,18,25,27]],
"veze": [19],
"dvostruki": [[14,18]],
"paketom": [18],
"ključ": [20,18,[10,32],[8,15]],
"rm": [6],
"rn": [6],
"ro": [6],
"datotečnom": [13,17],
"minut": [2],
"ispravnom": [4],
"ru": [6],
"združen": [[13,32]],
"rw": [6],
"najprij": [21,2,[9,18,28],[14,29,32]],
"ustrajn": [4],
"pune": [27],
"pamti": [21],
"narednom": [18],
"puna": [[8,32]],
"reproducirati": [[15,16]],
"ispravnog": [15],
"tadžički": [6],
"sa": [[18,21],14,[2,13],27,[6,11,15,19,22,24,28,30,31]],
"nikakva": [[17,21]],
"oduzimanjem": [32],
"sc": [[6,25]],
"prikladnosti": [7],
"uvrstiti": [22],
"sd": [6],
"se": [32,21,31,18,15,13,17,24,16,2,22,14,[27,28],20,11,30,[5,9],[19,34],[25,29],[10,23],[0,1,3,4,26],[7,8],[6,12,33]],
"dodati": [18,[2,8],[9,13,19,31]],
"nikakvu": [5],
"nepreveden": [21,[8,31,32]],
"nynorsk": [6],
"sg": [6],
"cijan": [21],
"si": [[6,28,29]],
"daje": [18],
"dodjel": [2],
"sk": [6],
"sl": [[2,6,28]],
"samuel": [[4,7]],
"sm": [6],
"propagacij": [24],
"učit": [31],
"sn": [6],
"so": [6],
"teluški": [6],
"kojega": [32,21,[19,25,29]],
"meksičk": [29],
"sq": [6],
"email": [20],
"sr": [6],
"ss": [6],
"st": [6],
"su": [32,31,16,[15,17,18],14,[11,13,19],[20,21],[2,23],[0,1,4,8,9,22],[27,28],[6,24,25,26,30]],
"prioritet": [[28,34],33],
"ona": [[2,13,18,22]],
"sv": [6],
"intern": [[21,32]],
"sw": [6],
"ukaž": [[13,19]],
"one": [[15,27],[11,14,18,20,24]],
"norma": [[17,32]],
"oni": [13,[8,17,25,27,30,31]],
"ta": [18,31,[2,6,16,20,21,30,32]],
"smanjivanj": [[18,32]],
"najmudrija": [23],
"editoverwritesourcemenuitem": [8],
"bosanski": [6],
"te": [31,[18,32],13,[6,11,14,15,28,29]],
"dostavljanj": [20],
"ono": [32,21],
"engleski": [25,[0,3,6,18,31]],
"jedan": [21,16,2,32,[5,19,27],[3,8,13,17,24,25,30,31]],
"tg": [6],
"th": [6],
"nemat": [[18,20,29]],
"enforc": [31],
"ti": [32,6],
"tj": [31,2,[18,21,32],[17,22,24,26,27],[5,11,12,13,14,16,20,23,29]],
"tk": [6],
"remov": [18],
"onu": [24],
"tl": [6],
"izvoznom": [31],
"skriptu": [18,1,24],
"tm": [31,32,34,[2,20],[19,21,27]],
"tn": [6],
"to": [18,31,32,14,13,15,[7,21,22],[2,17,23,26,27,29,30],[3,11,16,20],[6,12,24,25,28]],
"doznali": [14],
"v2": [20,[18,34]],
"sȃm": [[21,25]],
"donjemu": [32,1],
"tr": [6],
"ts": [6],
"tt": [6],
"tu": [21,[13,19,20,29,30,31]],
"izbrisati": [16,17],
"najljepših": [3],
"tw": [[6,18]],
"ty": [6],
"plitki": [20],
"običnim": [11],
"viewmarkautopopulatedcheckboxmenuitem": [8],
"terminološk": [10],
"hmxp": [15],
"obavit": [[12,14,18]],
"projectwikiimportmenuitem": [8],
"countri": [18],
"ug": [6],
"ispočetka": [[18,28]],
"argumentima": [18],
"dali": [4],
"dalj": [31,[2,7],[4,13,21,28]],
"uk": [6],
"yahoo": [[9,14]],
"uzoraka": [13,28,16],
"istaknut": [[16,32]],
"up": [5],
"burmanski": [6],
"automatska": [29,[13,24,27]],
"ur": [6],
"instalacijskoj": [1],
"postotkom": [32],
"automatsko": [[8,21],[22,34],[5,20,33]],
"automatski": [21,[18,23],[8,17,30],[19,32],[0,2,3,11,14,15,16,22,24,27,29,31]],
"turkmenski": [6],
"pogrešku": [16,[24,31,32]],
"zahtjevnij": [28],
"uz": [[21,31],[10,15,16,30,32],[2,6,8,11,23,27]],
"namješten": [18],
"crteži": [13],
"naziv": [[13,32],18,31,[29,34],[1,2,8,15,17,19,22,24,27,28]],
"početnoj": [[18,22],[2,15,32]],
"this": [[17,25]],
"automatsku": [18,21],
"nalazi": [18,[5,32],[17,21,22],[0,16]],
"opi": [9,[2,4,8,11,18,21,31,32]],
"atributima": [13],
"riječi": [32,27,21,25,11,[3,5,14,20,29],[8,15,34]],
"ve": [6],
"oštet": [16],
"dakl": [[2,20,27]],
"zapadnofrizijski": [6],
"puno": [22],
"vi": [[6,18,31]],
"puni": [13],
"prethodnoga": [21,[5,30,31]],
"pripremljenoga": [[2,21]],
"pomicanj": [[30,32],[5,8,21,27,28]],
"vo": [6],
"prazan": [[13,31],[2,28]],
"vašoj": [[14,18]],
"frazu": [27,[0,26]],
"moguć": [15,32,[14,18],[2,5,17,19,25,31],[11,13,16,21,22,27,28],[8,9,20,23,30]],
"procitajme.txt": [13],
"prikazivanja": [21],
"dopust": [29],
"komentar": [17,13,18],
"svakako": [[13,14]],
"wa": [6],
"preduvjeti": [22,18],
"microsoft.api.client_secret": [20],
"podebljani": [[15,16]],
"ugnijezd": [16],
"žele": [[8,18]],
"fraze": [27],
"istim": [2],
"učinka": [[5,13,28,32]],
"istih": [32],
"licenc": [7,[12,31]],
"groovy.codehaus.org": [1],
"wo": [6],
"odnedavno": [20],
"kmerski": [6],
"mehanizam": [21],
"dana": [31],
"backspac": [5,30],
"podrazumijevanoga": [7],
"pogrešk": [9,[0,16],[4,18,19,22,31,32]],
"nauruanski": [6],
"ripley": [28],
"licens": [14],
"emac": [18],
"lokalnu": [2],
"ori": [6],
"lokalno": [2],
"wordovim": [15],
"dopuštaju": [[16,18]],
"oblikovan": [28],
"timov": [2],
"orm": [6],
"dodani": [17],
"pogrešn": [[24,30]],
"nesmetan": [2],
"xf": [18],
"regularni": [[16,25,27],[11,34],26,[12,28,33]],
"xh": [6],
"svim": [18,[13,14,22],[1,10,15,21,27,32]],
"svih": [32,[5,13],[2,4,11,14,16,21,24,26,27,34]],
"xp": [14],
"filtera": [2],
"lokalna": [2],
"obrađivati": [[5,15],13],
"popunjava": [31],
"xx": [18,13],
"xy": [25],
"sourc": [31,32,[1,18],[14,17,19,21,22]],
"izuzeti": [31],
"olakšavamo": [15],
"puta": [25,[11,27,32]],
"informaciju": [13],
"promjenu": [[24,32]],
"proučit": [28],
"imati": [18,2,[27,31,32],[8,12,13,14,22,24,29]],
"promijenjen": [31],
"logički": [[25,33]],
"odgovora": [29],
"oss": [6],
"volker": [7],
"yi": [6],
"zabun": [15],
"toolssinglevalidatetagsmenuitem": [8],
"problem": [17,[14,15,16,21,22,23,31,32]],
"bezopasan": [31],
"yo": [6],
"konzolni": [22,34,18,33],
"yu": [7],
"projectaccesssourcemenuitem": [8],
"simbola": [18,14],
"oblikovanom": [11],
"yy": [32,13],
"poravnanj": [15],
"simboli": [[18,32]],
"za": [32,18,21,[13,27],34,[20,29,31],14,28,[11,33],15,22,2,[16,24],19,30,[8,17],9,5,25,[0,7],[3,26],[10,23],[1,4],12,6],
"otp": [15],
"promjena": [[21,23],[2,16,17,22]],
"chichewa": [6],
"fraza": [[0,11,27]],
"zh": [6],
"ott": [15],
"pokušavaju": [25],
"aspektima": [11],
"prikazivanju": [15],
"onima": [[13,14,26,29]],
"dinamičk": [20],
"izrađenoga": [32],
"hunspel": [3],
"pronađu": [22],
"penalti": [31],
"tatarski": [6],
"zu": [6],
"uzorci": [[13,24]],
"skraćeno": [25],
"zz": [18],
"zapisivi": [8],
"nedostaj": [[8,16,21,25,32,34]],
"obradom": [30],
"inačicama": [4],
"opć": [7,14],
"utf8": [[17,23],15],
"svoj": [18,[2,4]],
"ažuriran": [[2,6,11]],
"izrađen": [31,[11,14,15,21,32]],
"jednak": [31],
"oslanjanj": [23],
"dodavati": [32,17,[1,8,13,14,19,21,24,29]],
"prijevoda": [32,21,[13,20],16,[30,31],[19,34],11,15,[22,24,27,28],[8,14,18,33]],
"mijenjanja": [15,[13,26]],
"pogreškama": [22,[14,18,21]],
"ova": [21,14,[13,18],[11,28,30]],
"zaustavlja": [22,[18,30]],
"morfološka": [20],
"primijet": [20],
"ove": [21,13,30,27,24,[10,15,16,22]],
"operatori": [[25,33]],
"ograničeno": [27],
"prijevodu": [16,32,[15,20],[13,14,19,30]],
"kojemu": [21,31,23,[2,13,18,22,27,29]],
"odredišnim": [[16,31],[12,15,27,30,32]],
"odredišnih": [[13,34],15,[14,24,30],[16,18,19,20,21,27,31,32]],
"tag-valid": [22,18],
"učitanim": [18],
"prijevodn": [31,11,32,[19,22,34],[24,33],[14,15,16,18,21,25,27,28]],
"ovo": [16,[24,25,32],[11,15,17,23,28,30]],
"fizički": [29],
"pretvaranj": [34,15],
"potreb": [31,18,[20,24,27,29]],
"prijevodi": [[21,31,32],[2,11,13,24]],
"preuzimanja": [2,9],
"ograničeni": [13],
"porukama": [31],
"ovu": [[14,21],18,13],
"morfološko": [20],
"širin": [27],
"help": [15],
"isključujemo": [13],
"spremati": [29],
"skupinama": [16],
"doznati": [20,[18,24]],
"cijeni": [20],
"sljedećega": [21,[8,25,28,30]],
"u0009": [25],
"xhh": [25],
"informacija": [18,21,[5,32],[9,11,15,22,24,31,34]],
"revis": [12],
"savjeti": [34,[16,29,33]],
"u0007": [25],
"repositori": [2],
"učitanih": [30],
"vašega": [[18,29]],
"cijena": [32],
"xho": [6],
"date": [17],
"uplat": [9],
"korištenoga": [13],
"data": [14],
"xht": [15],
"ispravnih": [31],
"lowercasemenuitem": [8],
"firefox": [29,1],
"wiki": [12],
"obrađivanj": [21,34,33],
"blok": [25],
"prozor": [32,34,33,[2,21,27],[16,22,26],[1,18],[3,8,15,29]],
"lists.sourceforge.net": [9],
"povećavanj": [32],
"nečitak": [15],
"norm": [20],
"započnet": [31],
"filepath": [32],
"ispravnim": [3],
"predan": [2],
"kôd": [8,13],
"predlažu": [32],
"oasi": [15],
"započeto": [25],
"dati": [32],
"predaj": [2],
"siguran": [28],
"vašemu": [18],
"ispravn": [18],
"čega": [30,[20,32],[2,8,16,18,19,24,25,28,29,31]],
"relevantnosti": [32],
"mijenjanju": [22],
"stečevina": [31],
"čuvaški": [6],
"zabilježit": [2],
"galicijski": [6],
"poravnavanj": [15],
"slovima": [21],
"svom": [[18,24]],
"openoffic": [29],
"napisao": [9],
"dask": [16],
"napisan": [23],
"preklapati": [32],
"oblikovanim": [[16,21,34],[11,23,31,33]],
"note": [25,[22,31,32]],
"lokaln": [2,21],
"zovemo": [11],
"izvesti": [29],
"optionsautocompletechartablemenuitem": [8],
"optičkoga": [24],
"noth": [0],
"opisana": [[5,11]],
"potrajati": [[29,32]],
"rezerviranih": [18],
"svahili": [6],
"proračunskim": [32,17],
"url-ovi": [13],
"helari": [[4,7]],
"git": [2,31],
"programerima": [9],
"opisano": [[11,27,31]],
"između": [[5,13,32],21,[15,16,25,30,31]],
"zato": [21],
"oblikovanih": [15],
"ručnim": [[20,29,31],[17,24]],
"opisani": [2],
"izrađujet": [17],
"xx-yy": [13],
"sasvim": [31,[14,18,28]],
"uzorak": [13,34,28,[16,23,25]],
"nose": [31],
"poboljšavati": [20],
"odaberit": [18,2,[23,29],[13,19,31],[1,10,14,21,22,26,30]],
"osnova": [[28,32]],
"riječima": [27,21,[3,16,25]],
"prijavljivanj": [34],
"mogućnost": [[18,21,30],[14,16,20],[2,10,12,13,15,17,25]],
"will": [4],
"imamo": [30,[13,18],[22,32],[8,15,16,21,23,24,25,31]],
"kašmirski": [6],
"oblikovanju": [[15,16],31],
"razdvojenim": [17,32],
"nizozemski": [6],
"osnovi": [28,[13,29]],
"optionsspellcheckmenuitem": [8],
"dvaput": [18,32],
"tipkovnicama": [21],
"početnim": [28],
"xlf": [15],
"početnih": [[13,30]],
"oblikovanja": [16,34,[15,31],[20,24],[13,19,30,32,33]],
"početnik": [[11,19]],
"razgran": [14],
"jedna": [16,5,[2,18,25,31]],
"oblikovanj": [16,15,[11,19,32]],
"pretvaraju": [[13,28]],
"optionssetupfilefiltersmenuitem": [8],
"oblikovani": [34,[15,16]],
"oblikovanjem": [[19,24,34]],
"opisan": [[18,21]],
"rizik": [19],
"altgraph": [8],
"nove": [19,[17,18,21],25,[1,8,13,14,24,27]],
"razdvajaju": [31],
"memorijama": [[11,20],[3,21,28,31]],
"novi": [8,[18,19,28,31],[2,6,13,15,17,21,23,24,32,34]],
"terminoloških": [17],
"uključili": [18],
"slobodno": [[19,22]],
"budu": [[13,18],[3,16,27,29]],
"šalju": [20],
"autori": [20],
"terminološkim": [32],
"without": [18],
"novijom": [18],
"stilski": [28],
"xml": [15,13,[14,16]],
"zamijenili": [20],
"umetnut": [[24,30]],
"sudjelovati": [9],
"adres": [[2,20,21,32]],
"gla": [6],
"koristan": [13],
"zahtijeva": [20],
"nova": [18,[2,14,31]],
"sažetak": [11,33],
"gle": [6],
"prikupljaju": [31],
"glg": [6],
"prevođenja": [14,32,[19,22,24],[21,31],[11,18,20],[15,17,28,29]],
"pitanju": [12],
"pravilnoga": [15],
"glv": [6],
"leceburški": [6],
"befor": [18],
"autora": [[27,32]],
"ispravljanja": [[16,27,32]],
"klasifikacij": [32],
"tekućim": [[27,30]],
"bude": [2,[12,15,29,31,32]],
"tar.bz": [12],
"kratica": [28,[2,8,21]],
"šalj": [20],
"xltx": [15],
"postotak": [32,31],
"održavaju": [2],
"linuxu": [17],
"pitanja": [[9,11]],
"prikaz": [21,32,8,27,33,[16,34],15,13,[2,11,12,18,22,28,30]],
"prazn": [[26,32]],
"apsolutno": [23],
"zalijep": [32],
"izračun": [32],
"uspor": [31],
"lozinku": [[2,21]],
"iskorist": [15,[28,31,32]],
"sardinijski": [6],
"isprav": [[11,24,32]],
"mrtvi": [15],
"upišit": [18,2,[19,20,21,26]],
"izrađenih": [[15,24]],
"nepohlepni": [25,33],
"xlsx": [[13,15]],
"obračun": [32],
"međutim": [[15,16,18,19,29,31],[4,20,22,23,24,28,32]],
"zatvar": [27],
"stranic": [9,[2,8,13,14,15,20,25,32,33,34]],
"elektronički": [32],
"povezano": [16],
"kvalitetu": [31,3],
"gnu": [[7,14]],
"središnji": [6],
"taas-ov": [10],
"sigurnosnih": [[18,31]],
"povezana": [1],
"novu": [18,[21,26,28,29,32]],
"dostavljanjem": [20],
"target.txt": [30],
"hrvatskoga": [3],
"god": [31,[19,32],[4,15,21]],
"učenja": [20],
"sinhalski": [6],
"odaberet": [22,[21,28,29]],
"slobodna": [20],
"pravopisa": [29,34,33,21,[0,11,14],[8,20,22]],
"funkcionalnost": [5,[27,33]],
"korejskih": [21],
"podijeljenom": [32],
"srednjoeuropskih": [23],
"interakcij": [20],
"autorskih": [21],
"korištenjem": [[5,15,18,31]],
"ojibw": [6],
"praksi": [18],
"njihovih": [15,31,[16,20,27]],
"kvaliteti": [[15,20]],
"ženski": [3],
"neprevod": [13],
"nameon": [13],
"njihovim": [16,[14,21,31,32]],
"kontroln": [[8,21]],
"rezervirali": [18],
"mišem": [[18,32],1],
"optionsglossarytbxdisplaycontextcheckboxmenuitem": [8],
"dodatnih": [[14,17]],
"pak": [32,[18,21],17,[7,15,20,24,31],[5,13,22,27,28,29,30]],
"kvaliteta": [20,15],
"poslužiteljima": [2],
"pan": [6],
"startnoga": [18],
"dodatnim": [14],
"pogrešaka": [9,16,[11,31,32,34],[0,14,15,18,19,22,33]],
"gotonextnotemenuitem": [8],
"par": [16,20,31,[2,24,28,32]],
"izuzimanj": [31],
"isključivo": [[18,22],[4,13,24,26,27,32]],
"fulanski": [6],
"tar.gz": [18],
"gpl": [12],
"tekućeg": [30],
"ustvari": [[15,20]],
"automatsk": [24],
"list": [33],
"segmentacijom": [[11,28]],
"prikupljanj": [32],
"postavljanjem": [21,[0,8,15,16,32]],
"povezati": [15],
"proizvoda": [15],
"ostavlja": [30],
"preglednika": [[14,32]],
"oklijevanja": [14],
"nerijetko": [[15,18]],
"zapisnika": [[9,16,21]],
"lisa": [17],
"unix-a": [21],
"azur": [20,18],
"tekućem": [30],
"problematičnim": [[15,24]],
"tipkovni": [21,33,[5,32,34],[2,6,8,11,24]],
"formatu": [[21,32],[8,13,15,17,19],[10,30]],
"knjižn": [13],
"oštećenja": [16,[14,17,30]],
"pregledniku": [[21,31,32]],
"takvim": [[21,31],[15,23,32]],
"obavlja": [21,22,[17,18,20,27]],
"rashid": [7],
"uneseni": [20],
"takvih": [[2,11,15,23,31,32]],
"uneseno": [17],
"formati": [34,15,33,[13,16,32]],
"uspostavili": [2],
"koristeći": [12,[1,10,30,31]],
"dozvolama": [18],
"kvalitetniji": [[20,31]],
"kraticu": [28],
"neprevedeni": [21,[27,30],[8,14,19,24,26,32]],
"koda": [18,34,33],
"rezervirano": [18],
"formata": [13,[15,17],[11,19,32]],
"rezerviranj": [[18,34]],
"navegar": [20],
"istoimenoj": [2],
"vanjsk": [32,[8,15,21]],
"neprevedeno": [27,26],
"kvalitetnija": [28],
"čemu": [31,20,[8,9,18,32],[1,3,13,14,15,17,21,28]],
"kodn": [13],
"nepravilno": [32],
"inačic": [18,7,31,[4,15],[2,3,14,28,29]],
"grn": [6],
"desno": [5,[18,21,28,30]],
"nyanja": [6],
"slova": [21,8,25,27,[18,31,32,34]],
"omogućava": [21,[13,18,31,32],11,10,[1,2,16,17,20,22,30],[15,26,28,29]],
"slovo": [25,21,8],
"xtg": [15],
"bindownload.cgi": [18],
"otvorili": [18],
"with": [18],
"slovu": [15],
"višekratnih": [32],
"pdf": [15,34],
"novij": [7],
"izbor": [30,28],
"novih": [21,[8,32]],
"there": [0],
"potpora": [[9,34]],
"novim": [24],
"ispravaka": [29],
"pokrećemo": [22],
"stoga": [31,[15,18,32],28,[2,17,19],[9,14,16,20,21,23,24,27,29]],
"jednako": [27],
"bislama": [6],
"toolsshowstatisticsmatchesmenuitem": [8],
"naručitelja": [31,[11,32]],
"filtriranj": [27,33],
"poboljšati": [31],
"viewdisplaymodificationinfononeradiobuttonmenuitem": [8],
"čete": [24],
"ltr-a": [15],
"operacijskim": [21,18],
"ostav": [13,15],
"otkrivenih": [28],
"širokoj": [2],
"pet": [21,[11,19,32],[4,7,16,17,18,31,33]],
"obavljanja": [26,[18,31]],
"potrebu": [30],
"raspakirali": [12],
"paštunski": [6],
"cvana": [6],
"fundusu": [20],
"potrebn": [18,22,[12,14,19,31]],
"obuhvaćanja": [21],
"angažiranih": [31],
"projectaccesswriteableglossarymenuitem": [8],
"dialoški": [22],
"potrebi": [[15,16,17,21]],
"cilju": [[9,15]],
"esperanto": [6],
"otipkamo": [17],
"potreba": [15,[13,19,24,28]],
"guj": [6],
"regexp": [22],
"pravopi": [29],
"svakih": [21],
"običnoga": [15,34,23,30,[2,11,13,17,21]],
"sentencecasemenuitem": [8],
"troškova": [32],
"skupa": [28,24,17],
"obama": [[17,32]],
"izuzeća": [24],
"stemmer": [3],
"prijedlogom": [20],
"novijih": [18],
"luksemburški": [6],
"razmak": [13,[27,28],[8,16,21,25]],
"uhhhh": [25],
"prijevod": [32,31,21,30,[15,20],11,[8,24],[13,14,18,19],[22,34],[1,16,33]],
"uslugama": [14],
"makroal": [1],
"bilješk": [[13,32]],
"izuzeću": [31],
"optionssentsegmenuitem": [8],
"skupn": [14],
"registrirati": [20],
"ostal": [32,15,[11,13]],
"ostaj": [13],
"optionsaccessconfigdirmenuitem": [8],
"dokuwiki": [15],
"tekućoj": [[4,18,22]],
"sačuvani": [24],
"stilskih": [11],
"izbjegava": [14],
"test.html": [18],
"držanja": [2],
"xxx": [31],
"obav": [2,[9,20,29,31]],
"smalltalk": [1],
"ant.apache.org": [18],
"hr-fr": [31],
"preimenovan": [31],
"kineskih": [21],
"koji": [32,18,21,[13,31],[2,15,27],[11,24,25,30],34,[17,22],[16,20],[19,28],[5,8,23,26],[1,4,7,9,14,33]],
"poznat": [[1,18]],
"sažetom": [32],
"pseudotranslatetmx": [[18,31]],
"putem": [32,18,[14,21],27,20,[2,9,13,30],[24,29,31],[8,10,23],[1,11,12,15,17,19,22,26,28]],
"filtriranja": [11],
"postupanja": [16],
"srednji": [3],
"koju": [18,8,29,[2,13,14,17,19,27,28,31,32]],
"označava": [[2,21,31]],
"arno": [7],
"jednakim": [[16,22]],
"suziti": [27],
"slanja": [31],
"hr-en": [31],
"velasco": [7],
"dogod": [31,16],
"targetlanguagecod": [13],
"argumenat": [18],
"koja": [31,[14,18,21],[8,15,20,22,24,28],[1,2,12,13,23,32,34]],
"kronologiji": [21,8],
"lako": [[11,19,27,32]],
"koje": [18,21,[31,32],13,14,[16,25],[11,19,27],[24,34],[2,15,17,20,23],[0,4,7,8,28],[1,5,22,29,30,33]],
"pilpré": [7],
"nuosu": [6],
"mojprojekt": [31],
"sustavom": [[19,23]],
"izdanja": [12],
"nezgodn": [23],
"potvrdnoga": [24,[13,16,30]],
"postobradnih": [21],
"dragocjen": [4],
"unered": [16],
"aktivirali": [[20,32]],
"prethodno": [21,[5,8,28,31]],
"komentarom": [17],
"prethodni": [21,8],
"pazit": [[16,17,18]],
"microsoftov": [18],
"raspakirajt": [18,12],
"namještanja": [21],
"pomoćnu": [31],
"operacijskog": [13],
"pomoćni": [31],
"bjeloruski": [6],
"operacijskom": [18],
"automatskoga": [21,[5,30],18],
"datotečni": [34,13,23,[15,17,24],33,32,[11,14,21],[8,19]],
"radnjama": [[2,29,30,32]],
"ostaloga": [21],
"izgl": [[13,31]],
"isključivanja": [21],
"kôdova": [[2,8]],
"njezin": [1],
"pli": [6],
"upisan": [21,[20,27],[8,16,18,30,32]],
"aktiviraju": [21],
"ograničenja": [30],
"razdvajanj": [24],
"encyclopedia": [12],
"prethodna": [[8,21,32]],
"engleskom": [4,[0,20,31,32]],
"sastavit": [31],
"informacijama": [18,12],
"tihi": [22,18],
"aktiviranj": [29],
"projekti": [34,[2,18,33],[3,5,11,14,22,31]],
"optionstagvalidationmenuitem": [8],
"projektn": [[18,32,34]],
"pratiti": [[9,32]],
"lokalizacijskih": [15],
"projekta": [31,21,32,[2,14,34],19,8,24,18,22,17,[11,13,29,33],27,[1,3,15,20],[0,10,12,28,30]],
"aktivirana": [[20,21]],
"pt_br": [29,18],
"padajućih": [24],
"a-z": [25],
"uslužni": [18],
"ubrzati": [31],
"potpunim": [32],
"završnu": [16],
"izboru": [[18,22]],
"zoltan": [7],
"učitajt": [[1,15]],
"limburški": [6],
"kvalitet": [31],
"konzoli": [[18,22]],
"potpunih": [21,32],
"onlin": [20],
"zatvaranju": [30,31],
"uklanjanju": [16],
"primjenjuju": [28],
"sustavu": [18,21,[13,22],[2,8,14,17,23,29]],
"prioritetni": [17,[33,34]],
"registrirani": [2],
"besplatnim": [2],
"javnoj": [7],
"zadržava": [31],
"popisom": [29],
"završna": [[4,16]],
"citira": [25],
"png": [18],
"registriranj": [21],
"prijedlozi": [[20,31,32]],
"postotno": [31,[16,32]],
"javascript": [1],
"sustavi": [34,18,[14,33]],
"mediawiki": [[21,32],8],
"ostavi": [30,[8,21]],
"zatvor": [19],
"zajednici": [2],
"komi": [6],
"gniježđenj": [16,34,33],
"superlativ": [3],
"uklanjanja": [[9,21,30]],
"pokazivača": [21,32,28,5,[0,17]],
"sustava": [18,2,[13,33,34],[8,20,21,29,31],[5,14,15]],
"projekt2": [2],
"bismo": [11,[20,29]],
"besplatnih": [29],
"projekt1": [2],
"obzir": [32,31,[13,16,21,22,24,30]],
"join.html": [14],
"osim": [25,[5,15,17,18,24]],
"sadržavalo": [13],
"spadaju": [32],
"engleskoga": [[0,31]],
"obilježavanja": [21],
"pod": [18,[21,32],31,[1,2,19],[8,10,14,15,16,17,22,29,30]],
"izdanju": [7],
"omegat.kaptn": [10],
"facto": [32],
"pol": [6],
"vidit": [32],
"onemoguć": [32],
"distribucija": [7],
"tražen": [25],
"por": [6],
"kolizij": [31],
"found": [18],
"korisnikovoj": [20],
"poslati": [20],
"pretvaraj": [30],
"prijeno": [20],
"definiranim": [14],
"stilovima": [15],
"definiranih": [18],
"raspravama": [14],
"sadržavaju": [31,[15,27],11,13,[9,10,14,17,18,19,22,23,30,32]],
"razdvoj": [[2,11]],
"nominativ": [3],
"sastavni": [14],
"ovisnosti": [[18,32]],
"ostati": [[18,24,30]],
"googl": [20,[18,34],33,[11,27]],
"opendocu": [13],
"radit": [31],
"ponekad": [13,[1,14,15,16,22,31]],
"korisnijom": [24],
"zahtjeva": [20,9],
"kodnoga": [13],
"nazivima": [29,[19,31]],
"dvostruk": [25],
"kose": [25],
"otvor": [27,32,16,[14,18,19,22]],
"nalog": [13],
"obiju": [18],
"spremanja": [[1,17,21,22,31]],
"najčešć": [[11,32]],
"sourceforg": [9,[8,14,34],[2,33]],
"održavati": [14],
"izvršavanjem": [[14,18]],
"regularnoga": [22],
"utječ": [16],
"registrirajt": [[2,9]],
"titlova": [15],
"strojnoga": [32,20,[21,34]],
"ulog": [11],
"hat": [6],
"spremanju": [[13,22]],
"dolazi": [[16,31]],
"hau": [6],
"hijerarhiji": [14],
"izvorišnih": [13,34,[14,31],32,[15,18,23,24],[19,21,27,30],[16,20,22,26]],
"otkriven": [16],
"umetnuti": [21,[17,20,32]],
"pri": [31,[13,16,20],[21,22,32],[8,9,15,27,30],[1,3,17,18,19,24,25,28,29]],
"učitavanja": [[2,13,19,30,31]],
"editmultipledefault": [8],
"segmentom": [[16,27,30]],
"korzički": [6],
"editfindinprojectmenuitem": [8],
"njemačk": [27],
"vraća": [31],
"dodjeljuju": [31],
"dvoslovna": [31],
"grenlandski": [6],
"pozorno": [14],
"zaboravit": [[5,15,16,18]],
"treći": [17],
"warn": [22,18],
"technetwork": [18],
"zahtjevu": [21,20],
"zahtjevi": [9],
"lakš": [15],
"odstupanja": [[16,32]],
"aktiviranja": [[20,21]],
"treće": [[7,31]],
"izvorišnim": [21,[13,31],27,[3,8,12,15,17,19,32]],
"istovjetn": [[18,27,29,32]],
"plural": [13],
"radom": [[18,22]],
"stanja": [32,21,[18,22,31]],
"aktivirati": [20],
"posebnim": [[28,29]],
"stanju": [[4,14,16,17,22,32]],
"izreži": [[21,32]],
"jre-om": [18],
"jacob": [7],
"omašk": [[0,4]],
"radni": [[11,22]],
"radnj": [[21,31],[2,14]],
"slobodan": [[7,11,33]],
"radnu": [18],
"dijelova": [[28,31,32]],
"softvera": [21],
"lingvističk": [20],
"norveški": [6],
"dijelovi": [14,[11,21,32]],
"interlingu": [6],
"n.n_windows.ex": [18],
"kosu": [18],
"jedinstveno": [16],
"pop-up": [17],
"uglavnom": [25],
"time": [31,18,24,[14,16],[2,11,21,27,29,30,32]],
"radna": [[2,14]],
"projektu": [[2,9,31,34],32,14,[19,22,24,27,33]],
"platformama": [14],
"popriličnom": [20],
"tima": [2,31],
"trenutnom": [28],
"ugrađena": [20],
"pojavnici": [18],
"projektom": [24,32],
"heb": [6],
"tipk": [21,[5,14],[8,32]],
"brune": [7],
"kanji": [23],
"sigurnosnu": [[22,31]],
"registriranja": [[20,21]],
"sigurnosno": [22],
"prepoznavanja": [24],
"različitim": [[1,13,14,15,31]],
"program": [18,22,[15,23,33,34],11,[19,32],[2,7,13,31],[8,16,17,20,21,24,29],[4,10,14,25,27,28,30]],
"pojavnicu": [[26,27,32]],
"put": [2],
"sadržavati": [31,[15,18,22],[2,8,12,13,19,24,29,30,32]],
"pus": [6],
"odaberu": [13],
"keith": [7],
"različitih": [21,[11,16,22,31,32]],
"her": [6],
"rješenj": [34,23,[16,29,30,31,33]],
"nastalih": [2],
"usporeno": [18],
"ugrađeni": [[29,32]],
"točkic": [21],
"odaberi": [8,21],
"ujednačenost": [11],
"pozor": [13,[27,28]],
"usklađena": [28],
"tihom": [[18,22]],
"španjolski": [20,29,6],
"obrad": [34,21,30,31,[11,13],15,[8,14,20,23,32,33]],
"nastalim": [14],
"zamjenjuj": [[21,27]],
"projektna": [[31,34]],
"poluširoki": [27],
"grupiranj": [16],
"camtasia": [15],
"segmentiranja": [28,[16,24],32],
"obratno": [15,24],
"obrađuju": [18,31],
"n.n_mac.zip": [18],
"projektnu": [19],
"zbog": [31,32,[2,11,15,16,20,21,22,24,30]],
"resursi": [18],
"obrat": [31],
"pojavnica": [27,[18,26],[21,32,33]],
"pojašnjeno": [15],
"sigurnosna": [[31,34]],
"pojašnjenj": [[0,2]],
"pseudoprijevod": [[31,34]],
"tabl": [21,25,8,32,33,[5,6]],
"smanjena": [32],
"odabir": [21,[3,13,18],[29,32,34],[5,10,22,27,28,30,33]],
"jedinstvenim": [20],
"doc-license.txt": [14],
"podrška": [9],
"yid": [6],
"copyflowgold": [15],
"izrijekom": [13],
"ostalo": [21,34,[9,14]],
"engl": [[2,9,20]],
"pseudotranslatetyp": [[18,31]],
"hhc": [15],
"katkada": [[21,30,32]],
"povrata": [21],
"hhk": [15],
"učitati": [31,[10,13,20,28,32]],
"otkrivanj": [[0,16]],
"ostala": [[11,24]],
"koristimo": [21,[27,32]],
"prikaž": [18],
"ostali": [34,[32,33],18,15,[13,14,21]],
"smjer": [15,[18,22]],
"moldavski": [6],
"deklaracij": [13],
"važno": [[4,20,31]],
"nepodudaranja": [21],
"taas-ovih": [10],
"projectclosemenuitem": [8],
"hin": [6],
"razlikuj": [25],
"viewmarknonuniquesegmentscheckboxmenuitem": [8],
"hio": [7],
"konzolnoga": [18],
"agresivni": [21],
"uvesti": [31],
"odvučen": [32],
"važna": [14],
"svojemu": [2],
"okončanja": [[11,14]],
"revidenta": [27],
"spremljenog": [31],
"spremljenoj": [14],
"obratit": [16,[12,22]],
"group": [14],
"naziv-izlazne-datotek": [18],
"okončanju": [2,[14,28,31]],
"findinprojectreuselastwindow": [8],
"sredstvo": [31],
"rednim": [32],
"ostaju": [[14,16,18,24,26]],
"readme.txt": [[7,14]],
"dokumentu": [13,[15,21],16],
"languagetool": [0,[11,33,34],[1,3,21]],
"postotka": [31,16],
"source.txt": [30],
"files.s": [1],
"prilagodb": [16],
"poretku": [[31,32]],
"vezan": [32],
"učitava": [32,[17,18,19,22]],
"siband": [7],
"logotipa": [14],
"histori": [21],
"rješavaju": [31],
"exchang": [17],
"output-tag-valid": [18],
"dokumenta": [5,[15,16],32,[2,11,17,21]],
"projectlock": [2],
"request": [20],
"ispravcima": [21],
"svojstava": [[3,14,15,17,18,19,22,29,31]],
"currseg": [1],
"pravn": [[7,34],[4,8,11,33]],
"their": [0],
"odgovarajući": [[28,29],[3,13,14,16,17,18,21,22,24]],
"preimenovanjem": [13],
"otkrivati": [16],
"danski": [6],
"procesa": [[28,32]],
"general": [14],
"l4j.ini": [18],
"demo.taas-project.eu": [10],
"vpj-ova": [31],
"prava": [7,2,21],
"održavanj": [2],
"ruskom": [18],
"varijant": [[13,29,31]],
"dokumenti": [[15,21],[18,19,28,30,31]],
"odgovarajuću": [[18,22],[2,12,14,21,32]],
"vinogradov": [7],
"prednjemu": [21],
"promijenit": [28,23,[13,16,31]],
"ugniježđeno": [16],
"zamijenjena": [18],
"upišet": [[14,18,21,24]],
"hodu": [31],
"andrzej": [7],
"alternativa": [[23,24]],
"godina": [[22,31]],
"downloaded_file.tar.gz": [18],
"odgovarajuća": [[0,13,18,32]],
"zatvaranja": [21,8],
"obuhvaćaju": [[18,30,31,32]],
"svn-a": [2,34,[18,33]],
"studenoga": [17],
"prefiksom": [30],
"malajalamski": [6],
"podrobnij": [15],
"account": [20,[10,18]],
"odabranim": [21,8],
"podržano": [26],
"dhttp.proxyhost": [18],
"odabranih": [[21,27]],
"japanes": [23],
"hmo": [6],
"konfiguracijskih": [[18,22]],
"konfiguracijskim": [0],
"obrasca": [18],
"distribuiranj": [14],
"postepeno": [31],
"izostavljati": [13],
"podržana": [13],
"prikazani": [32,[8,13,30]],
"odluci": [20],
"pretraživanj": [27,[21,34],[26,32],33,[8,19,25],[10,11,15,22]],
"podržani": [16],
"napredniji": [18],
"ignored_word": [34],
"prikazana": [[17,31]],
"yor": [6],
"upozorava": [16],
"očit": [4],
"zatvara": [32,21],
"naznačenu": [18],
"obrascu": [25],
"pokretanja": [18,[20,22],[0,3,4,14,34]],
"modifik": [8],
"odgovarala": [27],
"istočnoeuropsko": [34],
"citat": [[25,33]],
"konstrukt": [25],
"odredit": [24],
"negdj": [20],
"prikazano": [25],
"kuanyamajski": [6],
"premjesti": [[28,32]],
"configur": [18],
"naznačeni": [18],
"materijalima": [[2,15,31]],
"uzastopna": [11],
"sivom": [21],
"muškoga": [3],
"uzastopno": [5],
"obrada": [21,34,8,[13,23,27,33],32,[19,30,31]],
"učitavaju": [31,[13,18]],
"buloichik": [7],
"odgovaraju": [31,[14,22]],
"važećih": [20],
"konfiguracijsk": [[18,22]],
"rješavanj": [[2,20,34],33],
"prijevodnoj": [32,[14,15,21,28,31]],
"smije": [[28,30],[21,31]],
"prijevodnom": [[2,31]],
"optionsworkflowmenuitem": [8],
"pozornost": [16,[12,22]],
"poveznicama": [32,[14,16]],
"releas": [18],
"peter": [7],
"napomena": [21,[31,32],[15,17],[2,19,20,22,28]],
"odznačavanjem": [[13,24],[21,30]],
"obradu": [32,27,13,30,[5,18,21],[15,33,34],11,[17,19,22,24],[0,1,2,6,16,20,23,26,31]],
"njihova": [[11,27]],
"predmetnoga": [[24,28]],
"podebljanim": [32],
"poništavanju": [21],
"cordonni": [7],
"sparc": [18],
"smiju": [28],
"njihovi": [31],
"razmotrit": [31],
"njihovo": [11,[10,12,15,16,21,30]],
"ključnoga": [16],
"pronađit": [[12,20,29]],
"sastav": [31],
"davati": [21],
"obuhvat": [27],
"sandra": [7],
"izradio": [13],
"položajima": [[1,15]],
"prije": [31,[14,18,19,22,32],[0,3,13,15,16,20,26]],
"dvosmjeran": [15],
"izradit": [2,[15,29,31]],
"sličnosti": [[16,30,31]],
"spojiti": [31],
"tekstova": [20,[11,16,24,32,34]],
"najprikladnijih": [11],
"kodiranja": [13,23,15],
"prijevodnim": [[11,20],[3,21,28,31]],
"pročitati": [14],
"rtl-ltr": [5],
"prijevodnih": [31,34,11,32,[15,20,33],[2,14,18,21,24,27]],
"neodređenih": [4],
"crvenoj": [13],
"temelju": [13,[11,20],[3,21,28],[1,2,10,18,23,29]],
"prior": [4],
"oknu": [27,[17,21],[5,31,32],[30,33],[11,13,20,24],[0,2,6,16,22]],
"temelji": [20,17],
"novoga": [21,34,[19,31],[13,28,29,30,33],[11,20,25]],
"južni": [6],
"dodatku": [[21,24,32]],
"podudarno": [28],
"potvrdu": [21,26],
"korijenskim": [3],
"odlomak": [13],
"kanadski": [28],
"gornjoj": [[28,32],[0,29]],
"poslužiteljem": [2],
"tako": [31,32,[2,27],[11,13,16,17],[4,10,12,14,15,19,20,24,29]],
"knjiški": [6],
"okno": [32,34,33,[5,19],[1,15,17,21]],
"trake": [[21,30,32]],
"grafikoni": [13],
"kodiranju": [13,17],
"drugačiji": [[15,28]],
"domeni": [1],
"hrv": [6],
"kečuanski": [6],
"sprječavanja": [[11,22]],
"takv": [[30,31],[13,15,16,20,32]],
"traka": [32],
"schematron": [15],
"dhivehi": [6],
"najznačajnija": [14],
"potvrda": [[8,21]],
"sličn": [[13,19,26]],
"uočit": [[14,24,28]],
"najznačajniji": [[18,22,32]],
"okna": [32,34,[21,33],[5,15,17,22,26,27,30]],
"file-source-encod": [13],
"često": [19,[2,13,15,31]],
"postupaka": [[14,16]],
"vilei": [7],
"piotr": [7],
"tang": [7],
"nikakv": [18,[15,19,23]],
"određivanja": [25],
"česta": [9],
"pokretanju": [20],
"konfiguracijskoj": [[8,14,32]],
"dodatna": [[11,28]],
"traku": [32,[18,28]],
"razvoj": [34],
"jamstvo": [7],
"posudit": [3],
"odlomci": [15],
"zasebnom": [21],
"dodatno": [28],
"editexportselectionmenuitem": [8],
"pronađen": [[21,27,31,32]],
"monitor": [9],
"djelomičnoga": [21,31],
"dodatni": [18,[0,22],34,[1,3,16,25,32,33]],
"home": [5,[0,1,2,3,4,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,34]],
"pokazuj": [1],
"michael": [7],
"informatičku": [17],
"jamstva": [7],
"print": [16],
"podijeljen": [32],
"projectaccesstargetmenuitem": [8],
"ispustit": [18],
"kodiranim": [17],
"tama": [21],
"okolnoga": [16],
"build.xml": [18],
"tablicama": [32,[6,15,17]],
"portugalski": [[6,18,29]],
"hun": [6],
"kriterij": [27],
"pritiskom": [32,18,[1,13,14,15],[2,5,16,17,20,21,24,26,27,29]],
"množina": [3],
"herero": [6],
"traže": [10],
"jezicima": [[1,10,15,17,20,24,34]],
"traži": [27,21,26,[18,34]],
"aligndir": [[18,22]],
"system-host-nam": [13],
"usporednog": [16],
"isključivanj": [21,[13,27]],
"nikada": [13],
"creat": [[2,10,17]],
"python": [1],
"odgovarati": [[17,29]],
"es_mx.dic": [29],
"prozorima": [22],
"zajednički": [2],
"nalaz": [16,[18,32],[17,22],[2,3,11,13,14,20,25]],
"infix": [15],
"tehnik": [20],
"detaljno": [32],
"izmjenično": [8],
"zajedničko": [31,34,16],
"istovjetnih": [32,21],
"potencijalnih": [[15,31]],
"tarbal": [12],
"ostvarilo": [28],
"istovjetnim": [31],
"prototipa": [1],
"ogranič": [[10,27]],
"omegat-development-request": [9],
"pretraživati": [19],
"adresu": [9,20,18],
"poredak": [16,28],
"popularni": [[1,2]],
"simbolom": [21,14],
"učitavanju": [31,[13,22]],
"premještati": [19],
"međuspremnik": [21,5],
"adresi": [[9,10,18]],
"tražimo": [27],
"prikazati": [18,[2,23]],
"razdvaja": [28],
"usklađivanj": [30],
"file": [[1,18],27,34],
"razmaci": [25,[21,32]],
"prijelomima": [13],
"sekundi": [21],
"postati": [[14,24]],
"adresa": [18,34],
"postojećim": [31,[33,34]],
"natuknicom": [17],
"uvrštava": [31],
"dodatak": [[5,10,14,31]],
"automatiziranja": [18],
"francuskoga": [0],
"popularna": [2],
"meni": [17],
"postojećih": [31,[10,34],[11,20,24,33]],
"slovenski": [20,[6,17]],
"katalonski": [6],
"catti": [3],
"pomicanja": [27],
"menu": [[8,32],17],
"jednokratnost": [32],
"pročitajt": [[9,14]],
"otvar": [[18,24]],
"komercijalnoga": [2],
"hye": [6],
"a-za-z": [25,27],
"otvara": [32,19,16,[21,29],[1,30]],
"return": [[20,21]],
"potpomognuto": [11,[31,32,33]],
"redovito": [22,[15,31]],
"specifičniji": [21],
"voditelji": [2],
"ažurir": [17],
"principa": [16],
"postavljena": [28,[17,21,29]],
"kombinacija": [8,[5,18,32]],
"source-pattern": [[18,22]],
"servi": [20,[10,18,21]],
"reviziju": [32],
"njihovoga": [[5,11,13,14,15]],
"kombinaciju": [21,32,[8,12,27]],
"podmap": [14,2,[11,24,31,33,34]],
"područj": [[1,21]],
"chua": [7],
"problemi": [34,17,[12,33],[2,21,31]],
"natuknic": [[17,21],[8,11,27,33,34]],
"započinjanja": [32],
"tipka": [21,1,[5,8]],
"tablic": [32,[5,15,21,28]],
"problema": [[16,20,23,34],[2,18,24,31,32,33]],
"najviš": [5,[8,20,23]],
"zanimljiva": [11],
"kritika": [17],
"tipki": [32,21,5,19,8,[27,31],[1,15,16,20,24,26,33]],
"xliff": [15],
"true": [18],
"poredati": [32],
"revizija": [31,2],
"laponski": [6],
"konačn": [32],
"paradigmi": [1],
"zamršenih": [4],
"bojom": [21,0],
"groovi": [1],
"prozora": [21,32,27,26,[1,18],[28,30]],
"poredava": [31],
"odabranoj": [[13,27]],
"povećaval": [2],
"odabranom": [[11,21,22,31]],
"pomicanjem": [[30,32]],
"odabranog": [30],
"prozori": [34,32,33,21],
"tipku": [32,21,[17,19,24]],
"radnim": [[24,31]],
"učitavanj": [21,[1,13]],
"nemojt": [[13,19]],
"predati": [2],
"kmenueditor": [18],
"postojeć": [[17,24,31],[1,14,18,19,21]],
"radnih": [21],
"rijetkim": [[24,31]],
"odvucit": [18],
"postojećemu": [20],
"određenoga": [[0,10,14]],
"postojećem": [17],
"tortoisesvn": [2],
"funkcioniranjem": [21],
"datuma": [13],
"praga": [30],
"predstavlja": [28,[16,17,18]],
"messageformat": [16],
"zadržati": [[13,16]],
"pomoćnih": [31,[15,32]],
"dvosmjerni": [[15,21]],
"umeć": [[21,32],[5,30]],
"podnožja": [13],
"skriptama": [21],
"premještanj": [5],
"plavom": [[0,21]],
"kmenuedit": [18],
"prozoru": [32,[18,21],29,[1,14,16,20,24,26,27,31]],
"chuang": [6],
"odlomka": [13,28],
"radnji": [18,[9,21,28]],
"plavog": [27],
"xxxxxxxx-xxxx-xxxx-xxxx-xxxxxxxxxxxx": [18],
"writer": [15,19],
"nadziranj": [2,31,33],
"radnja": [21,5],
"rubi": [1],
"dzongkha": [6],
"pokreć": [18,[21,22]],
"žutom": [21],
"moguća": [[13,16,31,32]],
"posumnj": [[22,31]],
"programa": [18,34,14,32,21,[22,33],[9,15,31],8,[2,11,20],[17,29],19,[0,1,16,30],[3,4,7,10,12,13,24,27]],
"radnju": [21,8,29],
"konteksta": [[8,21]],
"metoda": [18,27],
"ćemo": [16,27,21,[2,3]],
"raznih": [11,[10,20,21,31]],
"globaln": [24],
"pristupa": [[2,12]],
"mogući": [17],
"azerbajdžanski": [6],
"metodu": [27],
"doći": [16],
"programu": [31,[15,18],[14,17,33,34],[11,20,29],[2,10,13,22],[0,4,8,16,19,21,23,32]],
"fontov": [21],
"usklađivati": [2],
"pulaar": [6],
"pristupn": [[2,20]],
"raspakirati": [14],
"napisali": [15],
"locmanag": [15],
"programi": [18],
"regex": [25,33,34],
"meta": [8],
"kontekstu": [[5,11,16,21,32]],
"sljedovi": [16],
"rasporeda": [13],
"smatrati": [[24,31]],
"stupaca": [17],
"izvezet": [11],
"adiel": [7],
"sango": [6],
"automatskih": [21],
"sintaksa": [8,28],
"automatskim": [[13,24]],
"izvezen": [17],
"naknadnu": [32],
"preglednik": [32,34,18],
"steknet": [24],
"čitljivosti": [21],
"free": [7],
"podešavanjem": [28],
"tekuć": [21,[8,14,32]],
"predlaganj": [11],
"način": [22,[18,34],15,[24,32],[13,17,21,25,27,33],[1,5,11,12,19,20,23,28,31]],
"tražiti": [11,[2,19]],
"rečenic": [[24,28],[8,11,19,21,25,32,34]],
"procitaj.m": [13],
"bjelinama": [15],
"odredi": [8],
"usklađenost": [29],
"sintaksu": [13],
"organizacij": [17],
"raspoloživih": [[20,32],[1,13,18,21,22,29]],
"oveći": [11],
"omoguć": [14],
"ibm": [18],
"fish": [3],
"ibo": [6],
"izgleda": [[16,17,21]],
"sadržaju": [17],
"nisam": [28],
"zadnj": [21,8],
"raspoloživim": [[18,32]],
"sastoj": [[14,16]],
"suvisliji": [28],
"odgovarajućim": [15,[1,12,31]],
"svakoj": [32],
"svakom": [[15,31],[2,13,19,20,22,24,28,30]],
"sadržaji": [[14,18],13],
"gramatičk": [0],
"gelski": [6],
"postojećega": [30],
"prevođenjem": [[24,28]],
"smijemo": [30],
"sadržaja": [21,[30,31],[14,18,32],[2,11,13,16,20,22,23,24,26,27]],
"odgovarajućih": [[15,18],[2,8,16,21,27,31,32]],
"izvorišn": [13,34,31,[21,32],[8,16,19],[2,20,23,24,28]],
"tradicionaln": [18],
"višestruk": [13],
"glosar": [8,21,17,32,[19,27],[10,11,14,15,22,33,34]],
"relativnom": [31],
"naiđemo": [31],
"izvorišt": [[8,21]],
"odnos": [32,24],
"postavk": [18,34,[13,22],[14,33],32,[20,24,29,30],[17,19,28]],
"jean": [7],
"radnom": [18],
"radnoj": [18,[22,31]],
"promjen": [[18,21,24,31],[2,8,22,32]],
"osnovnog": [16],
"ograničen": [31],
"znamenkama": [21],
"pravilima": [[11,18,28],[15,16,24]],
"triju": [31],
"idi": [21,[8,32,33,34],30,19],
"prozorom": [18],
"išta": [28],
"nadograđuj": [31],
"html-a": [13,15],
"xhtml-u": [32],
"valja": [[2,15,21],16,[13,28,31],[3,8,9],[0,11,14,17,18,19,20,22,24,29,30]],
"daleko": [29],
"izračuna": [32],
"irski": [6],
"ido": [6],
"naknadno": [[14,15,18,24,30,31]],
"pokretati": [18,[14,21]],
"idx": [12],
"privatni": [[2,18]],
"korisnima": [11],
"posvećenoj": [21],
"izradili": [[2,29]],
"que": [6],
"korisnička": [14,9],
"isključuj": [21],
"sravnjuj": [18],
"djelomičnog": [21],
"glavnom": [[8,13,21,32]],
"korisnički": [33,14,[11,13,18]],
"izvezit": [15],
"ruski-bjeloruski": [20],
"obavljena": [26],
"djelomičnom": [32],
"nakon": [18,[21,32],[16,19,25,28],[2,20,26],[8,14,22,24,29,30],[17,27,31]],
"xhtml-a": [13],
"korisničko": [18,[21,32],[2,11,13,22,33,34]],
"nužno": [[14,16,17]],
"zadržavanja": [31],
"projectaccesscurrentsourcedocumentmenuitem": [8],
"podržavaju": [[11,31]],
"glavnoj": [31],
"nuđeni": [13],
"linux": [18,34,[2,14],[11,20,22,25,32,33]],
"višejezičnih": [20],
"istovjetni": [[18,27,30]],
"checkout": [2],
"jasno": [23],
"kanadskoga": [28],
"korisniku": [21],
"lokaliziranj": [34],
"osigurava": [[2,18]],
"gdje": [18,31,22,[15,16,20,27]],
"osjećaj": [21],
"sličnih": [11],
"poput": [[2,12,16,28]],
"nesegmentiranim": [13],
"korisnika": [18,14,2,[13,20,34]],
"taas-u": [10],
"sučelj": [18,32,[11,21,22,33,34]],
"zha": [6],
"lokalizirana": [18],
"ifo": [12],
"korisničku": [[9,14]],
"brisanja": [16],
"revidira": [32],
"ms-dos-a": [18],
"njega": [28,[5,14,21,27]],
"abecedi": [32],
"jednakom": [25],
"zho": [6],
"izazvati": [[16,32],[14,24]],
"automatskog": [30],
"automatskom": [30],
"jezični": [20,[28,31],[2,3,11,18,22,24,34]],
"xx.docx": [13],
"višerječn": [[17,33,34]],
"oktaln": [25],
"jezikom": [[15,28]],
"željenom": [[18,32]],
"takvom": [31],
"jezična": [[0,21]],
"dokument": [21,8,31,[13,14,15],[24,32,33]],
"koristit": [18,32,15,[14,21,22,31],[19,26,27,28,29,30]],
"dođe": [14],
"ulaznu": [27],
"prefik": [31],
"sadržava": [14,31,18,21,13,[11,17,22],[1,2,3,16,28,32,33]],
"optionsautocompleteautotextmenuitem": [8],
"proizvod": [11],
"povrat": [21],
"fernández": [7],
"obrnutom": [32],
"filtrima": [[15,31]],
"zip": [[14,18]],
"usklađenosti": [21],
"pokraj": [29],
"lokaciju": [[14,17,32],[18,19,21,31]],
"otvorenoga": [[5,31],[0,1,11,20]],
"koristil": [15],
"prevodi": [13,[22,31],[11,18,32]],
"prijašnjih": [[11,32]],
"valut": [25],
"tajski": [6],
"unosimo": [26],
"ibai": [7],
"jezičnu": [12],
"gumb": [32,[18,23,24,26],[1,27,28,29]],
"yahoogroups.com": [9],
"jedn": [[11,16,21],[18,20,27]],
"concis": [12],
"sdlxliff": [15],
"customer-id": [18],
"tokeniz": [3,34],
"uvoza": [[2,32]],
"prevoditelju": [32],
"term.tilde.com": [10],
"izrad": [[18,31],24,[10,14,17,34],[2,13,19,20,22,32,33]],
"zadnji": [[5,21,31]],
"izaziva": [[16,21]],
"iii": [6],
"nedavni": [[8,21]],
"odgovarajućoj": [[12,29,31]],
"zadnju": [21,8,31],
"uvid": [32,[11,18,28]],
"segmentaciju": [[24,28,34]],
"njihovom": [15,[13,32]],
"lokaciji": [[14,18,29,31]],
"zeleno": [32],
"kyle": [7],
"viewmarknotedsegmentscheckboxmenuitem": [8],
"ćete": [32,18,[14,20,21,24,29],[23,27,28,31]],
"lokacija": [34,18,31,22,[2,14]],
"segmentacija": [34,28,24,11,[21,32],[8,13,25,27,31,33]],
"odvojenim": [13],
"pokrenit": [[18,22]],
"izraz": [16,27,[18,25,26],[5,11,17,28]],
"zapadno": [34],
"event": [8],
"označavanjem": [[27,30],[10,16,17,24,26,32]],
"neispravn": [[16,18,31]],
"vrstom": [15],
"naredb": [18,[2,21],5],
"subscrib": [9],
"porukom": [9],
"tokenizatora": [3,32],
"položaj": [21,32,17],
"naziv_datotek": [31],
"njihovog": [[5,31]],
"kirgiski": [6],
"koncu": [[15,18],[4,14,19,23,28,31,32]],
"gotomatchsourceseg": [8],
"abstract": [33],
"lingala": [6],
"skeniran": [15],
"zeleni": [2],
"tokenizatori": [3,[24,34],[0,2,33]],
"yandex.api.key": [20],
"optionssaveoptionsmenuitem": [8],
"excel": [13],
"naredn": [2],
"comma": [17],
"prevoditelja": [[2,9,20,31]],
"složenij": [25],
"budet": [19],
"prevoditelji": [[20,31,32]],
"stardict": [12,34],
"omegat.l4j.ini": [18,[10,20]],
"izrezivanj": [21,[5,33]],
"span": [13],
"konca": [27],
"kraće": [2],
"prefer": [14],
"ujgurski": [6],
"regularni-izraz": [18],
"hans-pet": [7],
"omogućaval": [31],
"polj": [21,[13,30,32],[2,9,27],[16,17,18,20,22,24,25,28]],
"djelomičnih": [34,[21,32],31,30,[5,16,27]],
"prijav": [9,[14,30,31,33,34]],
"space": [21],
"struktur": [[14,28]],
"njenu": [18,31],
"potonja": [[16,32]],
"iku": [6],
"pijffer": [7],
"njeno": [[1,23,31]],
"zakharov": [7],
"ogledni": [22],
"jednokratni": [32,[8,21,27]],
"referenca": [32],
"premješta": [32],
"dobivamo": [11],
"njene": [[2,13,18]],
"detaljan": [[14,21]],
"thunderbird": [29],
"stupanj": [32],
"ile": [6],
"editselectfuzzy3menuitem": [8],
"duplikati": [27],
"ili": [31,21,18,32,14,25,[17,30],27,13,16,[8,29],[2,15,24],[7,20,28],[9,22],[11,12,19],[3,5,26],[1,10]],
"neprevedenima": [13],
"ukloni": [13,[8,21,24,27,29,30]],
"proizveden": [31],
"podudaraju": [31,[17,32],[24,27]],
"djeluj": [21,28],
"zna": [[4,15,31,32]],
"project.projectfil": [1],
"fals": [[18,32]],
"njemu": [[2,32]],
"crkvenoslavenski": [6],
"zaslužuju": [2],
"kraću": [29],
"uputno": [21],
"phillip": [7],
"djelomičnim": [[21,32]],
"ima": [[21,29,31],[2,15,17,18,27,28]],
"simbol": [18,2,25],
"ime": [[14,21],[2,13]],
"gudžaratski": [6],
"približn": [32],
"naredbenoga": [18,20,22,[4,14,31]],
"vincent": [7],
"traženjem": [27],
"prevođenj": [20,11,[21,33,34],15,[19,32],31,[2,9,10,13,16,29]],
"izvedenic": [3],
"ekvivalentom": [[17,21]],
"ističu": [[10,27]],
"shortcut": [8],
"public": [14],
"podudaranj": [32,21,8,31,[16,30]],
"track": [9],
"ina": [6],
"ind": [6],
"traci": [[18,32],[20,22]],
"pt_br.aff": [29],
"tmx2sourc": [31],
"koliko": [4,32],
"specijalizirani": [32],
"korisnici": [18,[20,34],33,[11,21],[2,8]],
"nehotičan": [14],
"jabuk": [21],
"potrebno": [32,[16,22,29]],
"kongo": [6],
"ini": [15,[18,34]],
"sadržaj": [[2,13],[21,31],[30,32],[14,18],[11,17,19,22],[8,12,15,16,27]],
"nalijevo": [34,15,[5,33]],
"istovremeno": [32],
"birat": [32],
"susjedna": [16],
"potrebni": [[18,22]],
"praznoga": [[21,28]],
"sakupili": [14],
"potrebna": [[9,14,18,29]],
"pokretanj": [18,34,[20,22],[11,14,33],[1,10,19,32]],
"dhttp.proxyport": [18],
"trado": [17,34,33],
"kanadu": [18],
"ispuštanjem": [[18,32]],
"imenic": [20],
"ulazn": [31],
"najbitnij": [11,33],
"očito": [32],
"uvod": [33,11,[0,1,2,3,19,20,34]],
"sljedovima": [16],
"slika": [34,27],
"znatno": [11],
"nije": [18,21,[16,22],[31,32],[13,25],[17,19,20,26,27],[1,2,4,14,15,23,24,30]],
"subrip": [15],
"predviđen": [31],
"podudaranju": [[21,32]],
"popi": [11,34,[6,13,32],[19,28,31,33],[0,5,8,14,15,18,20,21,22,23,27]],
"moraju": [2,[29,30],[8,13,18,20,31]],
"slike": [2,[9,15]],
"cije": [18,[13,14,21,30,32]],
"score": [32],
"uputili": [29],
"rad": [18,[11,16,34],[23,32],[17,22,33],[2,14,20,21,28,30,31]],
"zasniva": [2],
"podudaranja": [32,34,21,31,30,33,[8,13,16,25],[3,5,24],[14,15,19,22,27,28]],
"sliku": [32],
"dozvoljava": [14],
"navajo": [6],
"fonta": [22,[21,34],[32,33]],
"appendix": [[0,1,2,3,5,7,8,9],[4,6],[22,28,31,34]],
"ipk": [6],
"pojedinoga": [15],
"naletit": [22],
"materinji": [31],
"izvorišnoga": [21,34,30,32,[28,31],[5,15,19,20,24,27,33]],
"upozor": [16],
"neodgovarajućemu": [17],
"takođ": [31,[18,32],21,[15,17,22,29],[0,2,3,8,9,11,13,19,20,28,30,33]],
"jednorječna": [17],
"mreže": [[2,18]],
"štedi": [30],
"povezuj": [31],
"segmentiraju": [28],
"priključka": [18,34],
"mreži": [2,18],
"aaa": [25],
"budućih": [2],
"takvi": [[15,20,21]],
"contemporari": [12],
"budućim": [[14,19,31]],
"solari": [18,14],
"istočnoeuropskih": [23],
"upravo": [31,2],
"korejski": [6],
"projekata": [2,31,[13,14,21,28,32,33]],
"pore": [[12,13,15,17,18,27,31,32]],
"raspolož": [21,18],
"alatima": [31,[11,20,21,32]],
"manual": [15],
"odredišnu": [15,22],
"odredišna": [13],
"aar": [6],
"voditi": [3],
"samoglasnicima": [25],
"željenim": [[28,31]],
"kirundi": [6],
"pronalaženja": [[11,16]],
"najmanja": [21],
"odredišni": [31,21,[13,15,29],32,[10,17,20,24],[1,3,8,11,18]],
"podudaranjima": [32,[14,30,31]],
"promjenom": [24,21],
"izišli": [21],
"korisničkog": [14],
"materijali": [2],
"odgovarao": [27],
"abc": [25],
"informacij": [15,32,[16,18,31],[8,11],[14,21],[2,6,17,20,23,30]],
"dokumentaciju": [7,34,[14,32,33]],
"korisničkoj": [[18,22],[14,19,31]],
"upotrebljavaju": [20],
"navaho": [6],
"dokumentaciji": [[8,24],[13,25,31]],
"uvezen": [31],
"abk": [6],
"numeriral": [31],
"dokumentacija": [7,[11,13]],
"spremi": [21,[8,18,30]],
"identifikacij": [13],
"postupcima": [[14,16]],
"poljski": [6],
"tehnologij": [[18,34],33],
"izvorima": [[14,21]],
"sprema": [[24,31],[18,22],[11,15,21],[13,32]],
"uvoz": [31,[2,32,34],20],
"materijala": [32,[2,9,11,21]],
"okvira": [21,[5,13,19,24,27,28]],
"hunspellovi": [3],
"kineskoga": [18],
"obavezni": [17],
"isl": [6],
"iso": [6,34,23,33,[5,11,17,22,28,31]],
"zatvorit": [[21,22,31]],
"obavezno": [[13,18]],
"kraja": [5,25],
"pokretanjem": [18,[16,22]],
"ist": [[14,16,18,22,31]],
"log.txt": [16],
"obavljati": [19],
"samoga": [[15,18,21,31]],
"zul": [6],
"potrebnim": [18,20],
"uvezit": [15],
"nepromijenjen": [11],
"glossary.txt": [17],
"ita": [6],
"obuhvaća": [23,13,[7,14,16,18,27]],
"itd": [15,[16,28,31],[13,17,24,27],[0,2,3,12,14,25,32]],
"potrebnih": [[2,11,15,20,26]],
"obojan": [32],
"finish": [2],
"ispr": [18,28,[5,16],[14,17,19,25]],
"paket": [[14,18],[22,29]],
"add": [2],
"prethodnim": [4],
"ciljani": [14],
"uobičajeni": [[17,18,22],[5,21,31,33,34]],
"prethodnih": [31,28],
"segmentiranu": [31],
"sličan": [[2,24,31]],
"udesno": [5],
"segmentiranj": [24,[11,28,31]],
"brojna": [15],
"okolnostima": [24],
"potom": [2,[8,13,14],[1,9,11,15,17,18,19,20,22,29,31]],
"najsličnijih": [[11,32]],
"uobičajena": [31],
"prednosti": [[1,2,18,28]],
"pridržavajt": [[15,18]],
"tablicu": [[16,32]],
"korisničkih": [14,[8,34],[21,30,33]],
"lakšega": [32,[11,23,27]],
"uobičajenu": [18],
"optionsautocompleteshowautomaticallyitem": [8],
"predviđena": [14],
"kraju": [25],
"korisničkim": [18,[22,32]],
"indonezijski": [6],
"tablica": [8,21],
"shema": [[13,15]],
"skriptiranja": [[18,21,22,30]],
"predviđeni": [32],
"larouss": [32],
"nešto": [14,31],
"mapa-projekta": [[18,22]],
"pridržavanj": [16],
"slikam": [27],
"predviđeno": [[11,29,32]],
"untar": [12],
"tablici": [28],
"vjerojatno": [17,[16,18,20,28]],
"slikar": [27],
"sheme": [4],
"kopiranja": [2],
"benjamin": [7],
"ponovno": [[8,21,31],[13,32],[17,24,28]],
"upisujet": [21],
"filters.conf": [22,18],
"popunjeno": [2],
"kopiranih": [2],
"programskoga": [18,1],
"odred": [[13,24],[2,8,11,14,17,18,21,22,29,32]],
"bitnih": [19,33],
"pokrenet": [[18,22]],
"bitnim": [23],
"pouzdan": [17],
"jesi": [28],
"modifi": [8],
"kriterijima": [27],
"preciznij": [13],
"zadnjemu": [[22,32]],
"okomit": [24],
"uklanjati": [24],
"oblika": [[8,13,31,32]],
"zanemari": [13],
"malteški": [6],
"jesu": [[2,12,16,31,32]],
"afr": [6],
"jest": [20,[23,32]],
"ukupni": [32],
"uključi": [24,[8,13]],
"ignoriran": [16],
"filtra": [13,[23,28,32]],
"predmetni": [24,14,[2,13],[32,34]],
"prilično": [[15,32]],
"saboga": [7],
"obliku": [32,[13,31],[2,4,10,14,15,16,17,18,19,21,27]],
"brojnih": [[4,13]],
"targetlanguag": [13],
"directori": [2],
"brojnim": [21],
"prilikom": [18,[13,22,30],21,32,[19,27,31],[12,14,16,24,28,33]],
"duge": [[23,32]],
"maldivski": [6],
"fazi": [2],
"onoga": [20],
"filtru": [13],
"properti": [15],
"naizmjeničnom": [30],
"filtri": [13,24,[23,34],[14,21,32],[8,19,33]],
"memorij": [31,18,11,32,[19,34],22,[24,33],[14,15,16,21,25,27,28]],
"fisher": [3],
"grafičko": [[18,22]],
"tekstnom": [25],
"en-it": [31],
"editselectfuzzyprevmenuitem": [8],
"segmentirati": [28],
"tekstnoj": [17],
"isto": [32,[1,2,18,21,30]],
"bjelin": [13,21,[8,17,25]],
"pdf-ovi": [15],
"klijent": [2],
"pregledava": [15],
"odgovarajućemu": [11],
"istu": [31,[18,22]],
"upotrebljavati": [[19,20,22]],
"računaju": [32],
"privremeno": [32],
"najzastupljeniji": [24],
"pojedinom": [13],
"više": [[25,31,32],18,[24,27],[17,20],[11,14,21],[7,13],[1,8,9,15,16,22,29,30]],
"pažljiv": [[4,16]],
"uzimaju": [[21,31,32]],
"dijagrami": [13],
"ispod": [[2,27,31]],
"stvara": [[2,17,18,19]],
"postotnih": [32],
"script": [1,[14,30]],
"isti": [30,31,[15,21],[1,13,16,17,25,34]],
"istovjetan": [[8,21,27,31,32]],
"system": [[2,10]],
"spellcheck": [29],
"jezici": [34,[1,33],[6,15,24,31],[5,11,20,22,28]],
"sudjelovanja": [14],
"datotekama": [13,[18,21],[14,15,23,29,31,32],[0,1,2,8,16,17,19,27,28]],
"oknom": [27],
"kratkom": [5],
"poslužitelj": [2],
"željenoga": [18,32],
"računalo": [23,30],
"pojavljuju": [[27,32]],
"pretprevođenj": [[31,34]],
"nadi": [7],
"unij": [18],
"skladu": [18,[2,11,13,17,28,30,31]],
"segmentu": [32,[5,30],[17,21,31],[11,18,20]],
"local": [15,[2,18]],
"velikoga": [29],
"iza": [28,5,[8,13,17,18,19]],
"mapama": [[18,31],[2,14,21]],
"objašnjenja": [11],
"revidiranj": [[21,32]],
"vanjskih": [2],
"upisa": [[8,21],5],
"sustav": [[2,18],23,[8,20],[12,13,17,21,25]],
"računalu": [18,2,[19,21]],
"dnevno": [20],
"segmenta": [21,5,32,30,28,16,[27,31,34],[2,11,13,15,17,19,20]],
"cree": [6],
"gigabajta": [18],
"operacija": [2],
"vanjskim": [[14,32]],
"svode": [32],
"pandani": [32],
"savjetnik": [21,[8,32]],
"jezičnoga": [28,[11,21]],
"pretvaranju": [23],
"razlikovanj": [[16,27]],
"nisu": [[17,21,30],[8,13,16,20,26,31,32]],
"obveza": [12],
"nist": [[12,14,18,21]],
"en-hr": [31],
"računala": [18,22,[13,34],23],
"odznač": [31],
"pokrećet": [31],
"drugačij": [[5,13,18,31]],
"vijetnamski": [6],
"filtrom": [13,15],
"aka": [6],
"potreban": [[2,16,18,22,25]],
"terminologijom": [11,17],
"segmenti": [31,21,32,27,34,[13,28],30,[14,15,18,20,24,26,33]],
"književnom": [20],
"svodi": [[3,31]],
"izbornicima": [18],
"automatiziranj": [13],
"navodnik": [17],
"tsonga": [6],
"neželjeni": [16],
"ako": [18,31,14,13,29,32,[17,21,22],[15,20],[19,27,30],[0,9,16,24,28],[2,7,8,23],[1,12]],
"uklonjeni": [[16,17]],
"imenovanja": [19],
"etapama": [20],
"češki": [6],
"es_mx.aff": [29],
"filtr": [[13,24],[14,34]],
"mode": [18,22],
"stvoren": [20],
"oblik": [3,[13,14,17]],
"niže": [18,[8,16,21,27]],
"profesionalni": [20],
"raspolaganju": [13,[14,17,18,27,28,29]],
"ponavljanjima": [32],
"očekivati": [15],
"neželjenu": [21],
"potonjemu": [[11,31]],
"toolsshowstatisticsstandardmenuitem": [8],
"pretvaranja": [15],
"izrađujt": [[15,22]],
"ali": [31,18,[11,25],[2,7,14,19,21],[15,17,20,22,27,29]],
"prevedi": [13],
"izrađuju": [[14,31],20],
"nadesno": [[5,15]],
"umarov": [7],
"postav": [28,[2,18,21,24]],
"navedenoj": [18],
"brojem": [32,21,1,[8,16,26]],
"alt": [5,[1,8,18]],
"abhaski": [6],
"brojev": [30,[15,32]],
"izrazom": [25],
"rng": [15],
"navedenom": [18,17],
"prioriteta": [28],
"sintaks": [[24,28]],
"najgornj": [32],
"napisanih": [[1,29]],
"alat": [29,[20,34],[22,33],[11,14],[1,3,15,25]],
"guaraní": [6],
"zadnjega": [32],
"postaj": [31],
"wildrich": [7],
"pinfo.list": [20],
"uklanjanj": [5,[15,16,20,24,30,31]],
"amh": [6],
"premještanju": [16],
"unix": [21],
"pojedinim": [32],
"islandski": [6],
"reda": [1],
"rod": [3],
"roh": [6],
"dijeljenj": [31],
"pronašli": [18,[4,11]],
"postavili": [18],
"uklanjaju": [[24,27,29]],
"ron": [6],
"genitiv": [3],
"ana": [31],
"and": [[14,18,22,27]],
"uzimanj": [32],
"opći": [24],
"instalirati": [18,29],
"lijep": [3],
"tragovi": [16],
"definicija": [8,2],
"lijev": [14],
"minutu": [[22,31]],
"postoji": [[14,21],[18,32],[1,13,15,17,25,27,30,31]],
"dulj": [22],
"cijelosti": [31,[15,17]],
"ant": [18,24],
"unatoč": [26],
"referentni": [[11,21]],
"minuta": [[11,19],[4,7,18,21,22,33]],
"slabe": [1],
"reci": [8],
"zadržit": [31],
"opća": [14],
"definiciju": [8],
"povlač": [19],
"sastavljenoga": [23],
"filtara": [13,[24,33,34],[23,32]],
"isključ": [[13,27]],
"stvaka": [21],
"meksički": [29],
"oblici": [27],
"turski": [6],
"jnlp": [18],
"helplastchangesmenuitem": [8],
"pomalo": [31],
"omegat.ex": [18],
"zajedno": [[13,32]],
"revidirati": [[24,27,29]],
"oblikovanoga": [15,34,19],
"ključeva": [18],
"jezik": [18,31,29,[15,34],[1,13,23,24,28],[0,3,8,10,19,20],[6,11,14,17,21,22,32]],
"nizu": [[13,27]],
"suglasnicima": [25],
"pitati": [4],
"sourcetext": [32],
"sljedeću": [8,[18,21,32]],
"unos": [20],
"broja": [[16,21,32],[4,15,29]],
"izlazn": [15],
"ažuriramo": [2],
"niza": [27,[0,28]],
"javna": [14],
"obavezan": [31],
"ažurirani": [15],
"ažuriranj": [[2,32]],
"valjanu": [9],
"english": [12],
"javni": [9],
"jar": [18,22,14,31],
"zastarjelu": [15],
"api": [20],
"valjani": [28],
"ažurirana": [2],
"ekvivalenti": [[17,32]],
"jav": [6],
"editselectfuzzy2menuitem": [8],
"app": [18],
"mogu": [31,[28,32],15,[11,21],[2,14,17,18,24],[0,8,25]],
"ignoriramo": [13],
"javnu": [14],
"sljedeća": [[8,32],21],
"odgovarajućega": [18,[13,21,24,31]],
"zahvala": [21],
"broju": [32,21,[17,20]],
"namjerav": [14],
"prijeloma": [28,[15,34]],
"redu": [[18,19,21]],
"alex": [7],
"prikazom": [[10,11,27]],
"razlikovati": [31],
"mogl": [31],
"brojn": [31,[9,15,28]],
"zulu": [6],
"sljedeći": [21,8,19,[1,30],[2,20,23,31,32],[12,13,14,25,26,27,29]],
"ključnih": [[11,32]],
"omegat.sh": [18],
"izvozi": [21],
"prezentacija": [13],
"korisničk": [[9,11,14,16,22,24,32,34]],
"editselectfuzzynextmenuitem": [8],
"izvoza": [30],
"pseudoprevedenu": [31],
"prečacem": [21],
"nominativu": [17],
"pašto": [6],
"ara": [6],
"poželjno": [[18,29]],
"ignoriraju": [18,31],
"našemu": [31,23],
"površinom": [18],
"raspoloživosti": [20],
"zelenoj": [32],
"arg": [6],
"mijenjanjem": [15,[13,14,18]],
"javanski": [6],
"malih": [27],
"zelenom": [21],
"ključnim": [27],
"paypal": [9],
"pseudoprevedena": [31,[33,34]],
"predloženim": [32],
"očuvao": [4],
"boji": [13,[21,30]],
"art": [29],
"očuvan": [16],
"timskoga": [2,[8,21,31,34]],
"instalirani": [[3,14]],
"pojedinačnih": [27],
"instaliranj": [18,34,29,33,20,[0,11,12],[2,19,32]],
"načina": [15,18,32,[21,22,31],[2,11,17,20,23,28,29,30]],
"boje": [21,[8,15,16,32]],
"ažuriranu": [2],
"instaliranu": [18],
"boja": [21,[15,16]],
"moja": [20],
"rtl": [15,34],
"gornjem": [16],
"osiguranja": [2],
"moje": [4],
"jdk": [18],
"call": [21],
"načinu": [18,22,20,[14,15,21,34]],
"podliježu": [12],
"zanemaruj": [8],
"naznač": [18],
"asm": [6],
"uzbečki": [6],
"uzeti": [[13,16]],
"tabul": [28],
"sudionicima": [14],
"provjeru": [29,[32,33],34,[0,18,22],[14,16],[12,20,21,28,31]],
"toolsshowstatisticsmatchesperfilemenuitem": [8],
"mijenjali": [18],
"run": [6],
"računalima": [2,21],
"okvir": [13,19,34,[21,22,23,26,27,33],[2,17,18,24,30,31]],
"odgovorna": [2],
"rus": [6],
"razumio": [28],
"dovršavanj": [8,21,5],
"neujednačenosti": [32],
"jer": [18,[13,16,32],[17,19,22,26,28,30]],
"predaja": [2],
"otvaranjem": [32,[17,19,24,30,31]],
"označen": [[2,20,21,24,28,29]],
"titlecasemenuitem": [8],
"našega": [32],
"snaći": [15],
"editcreateglossaryentrymenuitem": [8],
"zbirka": [[17,32,34]],
"brisanjem": [16,30],
"bolj": [21,[17,22,27]],
"nastavcima": [12,[17,32]],
"zbirki": [10],
"statistik": [[21,32]],
"predaju": [2],
"molb": [18],
"najkvalitetnij": [30],
"znakov": [21,[8,27,32],[13,14,23,24,25]],
"njegova": [31,[4,13]],
"znakovi": [27,[13,16,17,21]],
"ukupnim": [32],
"provjera": [34,[16,21],[18,29],22,8,[19,32,33],[0,4,11,15,17,25]],
"name": [[13,27]],
"budući": [32,17,[18,22,24],[1,2,13,16,27,28,31]],
"zbirku": [25],
"gramatik": [0],
"provjeri": [30],
"zaključana": [18],
"izdao": [8],
"postojao": [4],
"takav": [30,27],
"njegovo": [32,[11,14,18,21]],
"android": [15],
"dvojezičnih": [20],
"ljubavi": [4],
"znakova": [27,5,[21,33],[8,13,15,18,20,23,25,32,34],24],
"reluktantni": [[25,33]],
"ava": [6],
"povezuju": [2],
"usklad": [13],
"ave": [6],
"ponuđenoj": [17],
"korist": [21,18,31,[13,15],20,17,[11,19],[2,27,29],[8,14,24,28],[4,7,12,22,25,32,33]],
"mijenjaju": [[13,18,31]],
"distribucijskom": [18],
"znakom": [[16,18,30]],
"oromski": [6],
"korisn": [[1,11,19]],
"tekućemu": [[17,21,32],14],
"ažuriraju": [[13,14]],
"mađarski": [6],
"pridruž": [[9,13,19]],
"subfold": [22],
"komparativ": [3],
"uzroka": [18],
"target": [[1,19,21,31],[2,24]],
"prilagođavati": [[13,21]],
"poduzimanja": [15],
"članku": [9],
"uvjer": [23],
"podsjetnik": [32],
"dvjema": [[2,30,31]],
"instaliraju": [29],
"obzira": [[13,24,27,28,30,31,32]],
"instalirajt": [[12,18]],
"navedenoga": [15],
"fabián": [7],
"config-dir": [[18,22]],
"jidiša": [20],
"uvjet": [13],
"izvornoga": [[15,32],[18,34],[2,11,14,16,33]],
"postoj": [[15,18],[2,24,31]],
"dostatn": [13],
"crte": [[24,25]],
"slici": [32,[0,25,29]],
"pripremljen": [14],
"odluku": [[13,21,31]],
"litvanski": [6],
"označit": [27,[2,13,24,28],[0,18,21,29,30,31,32]],
"crtu": [18],
"item": [8],
"listova": [13],
"vaši": [18],
"metaoznaka": [13],
"sundski": [6],
"modul": [0,20,[1,3,33,34]],
"podržava": [31,15,32,[1,2,11,13,19,25]],
"alternativni": [32,21,[2,8,13,14,15,24,30,31,34]],
"kannadski": [6],
"ishod": [[28,31]],
"atribut": [13],
"targettext": [32],
"neispravnom": [[18,20]],
"aym": [6],
"tretirat": [32],
"neispravnoj": [31],
"vaše": [[11,18,20,31]],
"merriam-webst": [12,33],
"neizmijenjenom": [13],
"sretni": [32],
"ostalih": [[5,13,14,32]],
"višeplatformski": [11],
"ostalim": [[22,31,32]],
"kinjarvandski": [6],
"mijenjanj": [32,21,14,[11,16,24,30,33]],
"programima": [15,[11,19,21,22,29]],
"dodijel": [21],
"aaabbb": [25],
"ubuduć": [31],
"aze": [6],
"compil": [15],
"pozadina": [[21,31]],
"podnošenj": [9],
"najsigurnij": [24],
"njen": [12,[2,14,31]],
"edittagpaintermenuitem": [8],
"klokan": [11],
"donjoj": [[28,30,32]],
"odznačavanj": [13],
"ljudi": [4],
"bokmål": [6],
"optionscolorsselectionmenuitem": [8],
"suprotnom": [[16,21]],
"posljedicama": [14],
"prevoditeljski": [32],
"mora": [17,[8,16,18],22,[12,13,15,29,31]],
"sastavnica": [14],
"neizbježnoga": [16],
"dužemu": [32],
"nazvati": [31],
"grafičkim": [22,18],
"pišet": [15],
"trebaju": [31,[2,8,18,25,30]],
"omogućen": [[5,18,31]],
"omogućavaju": [[5,13,16,17,21,28,32]],
"pozadini": [32],
"učitaj": [[8,21]],
"manipulacij": [[21,30]],
"preuzetoga": [18],
"viewmarknbspcheckboxmenuitem": [8],
"unicod": [23,[17,25,33,34]],
"sastavljanju": [[16,31,32]],
"usreć": [32],
"određujet": [18],
"sastavljanja": [[14,16,17]],
"segmenata": [32,27,[30,31],[11,16,21,24],[15,20],[13,22,26]],
"nadograđenom": [31],
"učitan": [17],
"ignorirati": [24],
"prikazuj": [32,[18,27],[16,21,31],13,[0,2,11,15,17,19,20,22,23,24,30]],
"izdvojeni": [28],
"provjerava": [16],
"korijenskoj": [18,21],
"završnih": [13],
"letonski": [6],
"en-us": [31],
"korištenj": [34,[31,33],18,[11,17,29],22,[2,13,20],[0,10,12,27],[1,14,15,16,23,24,28,30,32]],
"atributa": [13,32],
"servisima": [[18,20]],
"zadnjih": [[21,27]],
"ekvivalentima": [21],
"mijenjati": [13,[18,21,24],[7,32],[8,14,15,19,28,30]],
"motu": [6],
"odlikuju": [11],
"atributi": [13,28],
"msgstr": [13],
"što": [32,31,[15,18],11,[2,23,25],[1,17],[9,14,19,21,22,24,27],[0,13,16,20,28,29]],
"katarn": [7],
"korištena": [24],
"prilagođavanj": [34,8,33,[5,7,9,11,21,32]],
"možda": [18,[17,20,27,31,32]],
"propagacija": [24],
"većega": [4],
"strukturalni": [20],
"priprema": [[19,34],[21,33]],
"deklaraciju": [13],
"korijensku": [[3,31]],
"zbirci": [32],
"grafičkog": [[18,22]],
"omegat.project": [18,[2,14,32,34]],
"okolni": [16],
"targetcountrycod": [13],
"izbjeći": [31,30],
"inačicu": [[2,18],[9,15,16,21,31]],
"prepustimo": [11],
"odgovara": [25,[20,21],[13,23,24,27,30,31,32]],
"inačica": [2,18,[20,31],[0,33]],
"stalno": [[20,31]],
"fontova": [[15,21],[16,22]],
"e-adresa.com": [20],
"jednostavnim": [[16,18],14],
"ignoriranj": [13],
"joj": [[18,31]],
"inačici": [18,[2,4]],
"webstart": [18],
"lijepljenj": [21,[5,32,33,34]],
"talijanski": [31,6],
"stalni": [31],
"pogledati": [32],
"pripremu": [21],
"njim": [2],
"označuju": [21],
"koraku": [2],
"oznakom": [[13,28,31,32]],
"sag": [6],
"fontovi": [22],
"funkcij": [21,27,[18,24],13,[16,30,32],[1,5,10,12,15,19,26,31]],
"troslovna": [31],
"jednostavnih": [16,28,[17,33,34]],
"subvers": [2,34],
"retk": [13],
"jednostavnij": [29],
"možemo": [27,[30,32],[10,16],[0,2,11,13,17,21,24,25,28,31]],
"san": [6],
"kraj": [5,25],
"zgorega": [31],
"odnosno": [2,[14,18,19,21]],
"omogućavanj": [21,25],
"omogućav": [23],
"pridjev": [3],
"sat": [[22,31]],
"njih": [17,32,21,[13,14,18,29,31]],
"međusobnoga": [2],
"jpn": [6],
"sav": [[22,32]],
"also": [34,0],
"oknima": [5],
"brojači": [32,[33,34]],
"resx": [15],
"možet": [18,32,[13,19,21],31,[20,24],15,22,[14,27],29,[16,17],1,[7,9],30,[2,8,23,28],[5,6,11,12,25]],
"yandex": [[20,34],18,33],
"vlastita": [28],
"pāli": [6],
"može": [31,16,11,[2,8,15,32],[24,28],[0,14,17,18,22],[3,4,20,23,29]],
"zahvaljujem": [4],
"međuspremnika": [21],
"a123456789b123456789c123456789d12345678": [18],
"viewmarkwhitespacecheckboxmenuitem": [8],
"preuzimanjem": [14],
"bad": [20],
"neće": [18,[31,32],[17,22,29]],
"izmijenit": [16],
"lucen": [34],
"bak": [[2,6,14]],
"bam": [6],
"parov": [[13,16],[2,20]],
"njemački": [6],
"aplikacija": [18],
"administratorska": [2],
"konvertiranih": [24],
"bat": [18],
"postavljanja": [[2,21],32],
"priručnik": [32,33,11,[4,7,8,21,34]],
"cijeloga": [[5,21],[11,31,32]],
"sch": [15],
"tretiraju": [32,15],
"jre": [18],
"optionsfontselectionmenuitem": [8],
"lokacijama": [14],
"datoteku": [18,[21,27],[15,31],[14,32],[8,22,23],[12,20],24,[1,7,17,19,30]],
"prihvatljivo": [16],
"potvrđuju": [21],
"postobradnu": [24],
"izrađenu": [31],
"aktiviranjem": [[0,21]],
"instaliranjem": [[2,14]],
"prihvatljivi": [[8,20]],
"montažnoj": [20],
"planu": [21],
"uočiti": [[4,27]],
"njegovoga": [27],
"aaron": [7],
"svega": [[8,16,25]],
"izrađena": [22],
"odvlačenjem": [[18,32]],
"izrađeni": [[2,15,21]],
"freebsd": [[14,25]],
"točku": [28],
"prijedloga": [21,[8,20,29,31]],
"datoteka": [[13,14],31,18,34,32,15,[17,21],[19,23,24],27,2,22,[11,16,29],[9,30],[8,33]],
"delet": [5,30,32],
"ovakav": [21],
"projectaccessglossarymenuitem": [8],
"točka": [25,[14,28]],
"see": [34],
"vito": [[7,33]],
"alatom": [[11,12,31]],
"seq": [17],
"ćirilićnom": [23],
"pretaču": [20],
"developerwork": [18],
"kada": [21,31,32,18,[15,28],[13,22,24,27],[2,3,5,14,16,17],[11,19,25]],
"uobičajenim": [[14,18,21,24]],
"set": [[14,18,22]],
"contain": [17],
"ovaj": [18,[13,22],[4,14,16,24,32,33]],
"zamjenskih": [27,34,33],
"namjestili": [18],
"prijavu": [9,18],
"n.n_windows_without_jr": [18],
"parom": [31],
"rezerviran": [18],
"nedostataka": [21],
"vraćanj": [[21,32],13,[20,27,34]],
"djelovanja": [[13,24,28]],
"optionsrestoreguimenuitem": [8],
"programer": [14],
"vremenom": [20],
"prijava": [[8,9,21]],
"nazivaju": [15],
"ograničenjima": [7],
"preskoči": [13,26],
"savjet": [24,[15,18,31,32]],
"nenamjernih": [16],
"alatni": [[32,33,34]],
"fleurk": [7],
"slučajev": [31],
"trebala": [2,[12,28]],
"nazivamo": [[18,28]],
"offic": [16,[13,15]],
"terminolog": [21],
"konkretnih": [25],
"bel": [6],
"ben": [6],
"stavku": [21,[14,18,20,23,32]],
"točk": [18,[25,28],32],
"koristili": [[11,18]],
"bez": [30,[13,32],[7,18,21],[14,17,27],[4,8,28,34],[2,12,16,20,24,25,26,31]],
"raspakiravanjem": [[14,18]],
"projectsavemenuitem": [8],
"posla": [[11,14]],
"koristila": [31],
"ovdj": [[16,21],18,[1,2,13,24,27,30]],
"utječu": [16],
"pregleda": [[15,16]],
"normom": [31],
"joel": [9],
"powerpoint": [13],
"fontovima": [15],
"podcrtava": [0],
"njoj": [[14,18]],
"prepoznavanj": [3,[15,34]],
"naširoko": [11],
"dekliniranih": [3],
"povezanih": [9],
"sučeljem": [18,22,32],
"pridjeva": [3],
"naprav": [[18,23,31]],
"mjere": [22],
"izgrađenih": [20],
"internetu": [2],
"pptx": [15],
"izvršavaju": [21],
"odgovarajuć": [29,[2,13,16,31,32],[14,17,18,20,22,23,26]],
"trebali": [[8,12]],
"obrađenoga": [21],
"još": [[16,19,21],[2,18,22,24,25,26,31,33]],
"spajanj": [[2,24]],
"xhosa": [6],
"maršalski": [6],
"zadnjoj": [21],
"tipkovnici": [8],
"izgradnju": [20],
"stupca": [17,[16,32]],
"imena": [30,32],
"trebamo": [[15,21,32]],
"statističkih": [32,[21,34]],
"sin": [6],
"standardan": [13],
"pritom": [[14,16,30]],
"kvadratići": [30],
"stavka": [8,18,21],
"tibetski": [6],
"punjabi": [6],
"tiago": [7],
"jedinica": [31,[11,16]],
"mjesec": [[22,31]],
"samostalnih": [18],
"prevodivoga": [13],
"optimalan": [28],
"čestih": [18],
"pogledajt": [[21,31],14,15,0,[2,5,8,17,22,25,27,28,29]],
"kvadratića": [24,[13,16,30]],
"stupcu": [32,[17,23]],
"kalaallisut": [6],
"stavki": [[8,21,32]],
"objekata": [28],
"foundat": [7],
"vrhu": [[9,17,20,21,32]],
"bih": [[4,6]],
"ionako": [18],
"vlastitih": [25],
"zasigurno": [11],
"rečeničn": [24],
"plavo": [32],
"baš": [32,[2,15,16,22]],
"mogućih": [[8,18,30]],
"unošenjem": [20,[18,32]],
"prepoznavanjem": [3],
"zamislimo": [11],
"bin": [14],
"kako": [[15,31,32],[2,18,28],[13,14],[10,11,16,17,20,21,27,29]],
"vrlo": [[11,31],[2,9,13,14,15,17,20,28]],
"plave": [[16,32]],
"bio": [[4,22],[15,23,28]],
"apertium": [20,34,33],
"bit": [18,[2,13,14]],
"vlastitim": [5],
"bis": [[6,25]],
"kaptain": [20],
"projectopenmenuitem": [8],
"autom": [18],
"odlomcima": [24,28,[11,13,31]],
"kazala": [13],
"dopunjavanj": [17],
"samostalni": [25],
"uzroci": [17],
"jednostavnoga": [[16,17,20]],
"djeluju": [25],
"toolsvalidatetagsmenuitem": [8],
"programom": [15,[11,17,31],[19,21,22],[12,18,23,24]],
"zaborav": [19],
"zamisl": [0],
"stranica": [[13,14,15,20,21,32]],
"objavljivati": [22],
"preuzmi": [[8,21]],
"autor": [32,[7,21]],
"granični": [[25,33]],
"pretraži": [27],
"stranicu": [5,[8,21,28]],
"slk": [6],
"najvećim": [32],
"dvoslovnoga": [18],
"datoteci": [32,[18,21],[13,31],[16,17],[14,20,23]],
"john": [7],
"kreativn": [11],
"slv": [6],
"stranici": [18,[15,20,21]],
"viewmarktranslatedsegmentscheckboxmenuitem": [8],
"određen": [13,31,[8,15,25,30,33]],
"registriraj": [[8,21]],
"naredbom": [[18,21],29],
"prekidni": [18,25],
"skočni": [32,21],
"zatvaranjem": [31],
"praktičn": [32],
"malgaški": [6],
"sme": [6],
"ilia": [7],
"sanskrt": [6],
"predstavljaju": [32,[13,16,25]],
"tretirati": [21],
"konačnom": [[19,20]],
"licencni": [18],
"smo": [18,[2,6,9,15,16]],
"divehi": [6],
"nizovi": [[15,27,31]],
"naknadnim": [31],
"poprav": [31],
"pojavni": [17],
"editselectfuzzy1menuitem": [8],
"kazalo": [11],
"sna": [6],
"snd": [6],
"tijek": [32],
"recima": [13],
"didier": [[4,7]],
"prepušta": [13],
"nizova": [34,15,[17,26,27,32]],
"hide": [13],
"kakv": [[4,11]],
"ograničava": [[17,27]],
"dobroga": [29],
"recimo": [[29,31]],
"ovim": [18,[21,22,24,26]],
"slijedi": [18,28,[25,31,32],[2,8,11]],
"auto": [31,[21,34],[13,20]],
"trebati": [28,[19,31,32]],
"spajati": [24],
"pronalaska": [[13,18,22,31]],
"nizozemskoga": [0],
"podcrtanu": [[0,29]],
"otvaranja": [18,[11,16,19,21,30,32]],
"notepad": [17],
"project_save.tmx.privremeno": [[22,31]],
"vremenski": [32],
"rječničk": [12],
"som": [6],
"oznaci": [29,32],
"ostavit": [2],
"otvaranju": [[15,31],[14,17,20,22]],
"popunjavanj": [[10,31]],
"oracl": [[8,18],13],
"sot": [6],
"granica": [25],
"programsk": [14,34,[11,18,33]],
"uobičajenih": [[11,21]],
"administr": [2],
"osobnim": [2],
"kroz": [21],
"isključujući": [31],
"prevedenoga": [32,21,16],
"spa": [6],
"tmx-a": [31,32,[21,34]],
"poglavlj": [11,[14,31],[4,25,28]],
"ukrajinski": [6],
"osobnih": [18],
"povjerljivim": [9],
"detaljniji": [19],
"baškirski": [6],
"programskih": [18],
"temeljnoga": [16],
"valjan": [28],
"bod": [6],
"starobugarski": [6],
"podcrtana": [17],
"slovom": [28],
"situacij": [23],
"manje-viš": [25],
"vlastit": [[18,31]],
"bos": [6],
"sqi": [6],
"stanovita": [16],
"pronalazi": [[17,25],0],
"govoreći": [13],
"kad": [19,[5,18,31],[14,16,21,22,32]],
"nezatvoreni": [21],
"popisima": [17],
"fouri": [7],
"odabirom": [21,13,30,18,14,[1,10,24,27,32]],
"mijenja": [31,[2,15,24,32]],
"kal": [6],
"konačnima": [24],
"kao": [31,32,18,[11,15,21],[14,17],27,[13,16,20],[2,9],[23,30],[22,25,28,34],[0,1,10,29],[3,8,19,24,26,33]],
"kan": [6],
"eventualnog": [17],
"jidiš": [6],
"kas": [6],
"thoma": [7],
"kau": [6],
"dozvol": [18],
"kat": [6],
"nestandardn": [22],
"primjenjivosti": [28],
"izvorišnom": [[21,32],[30,31],[0,8,14,15,17]],
"br1": [16],
"odredišn": [13,[31,34],15,[8,14,16,19,21,26,32]],
"ostvar": [[18,22]],
"srd": [6],
"mišljenja": [32],
"kaz": [6],
"izvorišnoj": [[13,23,24,31]],
"licenciranju": [21],
"popisa": [13,21,[17,29]],
"control": [21,[2,8,19]],
"izvorišnog": [[21,27,31]],
"tekućega": [21,32,[1,14,27,30],[13,17,31,34]],
"no-team": [18],
"smanjuj": [31],
"srp": [6],
"financijska": [[9,34]],
"unaprij": [[17,18,21,25,28,33]],
"terminologiji": [31],
"konačni": [11],
"dovršen": [32],
"čak": [[7,21],[13,17,18,27,32]],
"srt": [15],
"popisu": [1,25],
"primjenjivati": [24],
"javnim": [10],
"obavljenoga": [2],
"konačnu": [16],
"prevedenih": [15,[32,34],27,[11,13,19,21,24]],
"ispitivanja": [31],
"postojati": [[17,28]],
"prevedenim": [[19,21,27,32]],
"pripremit": [14],
"uputama": [18],
"jezičnim": [31,[22,34]],
"jezičnih": [20],
"avarski": [6],
"environ": [18,14],
"optionsautocompleteglossarymenuitem": [8],
"mogućnostima": [16],
"zbrajanjem": [32],
"jedina": [32],
"bre": [6],
"kazati": [[15,20]],
"ssw": [6],
"bitna": [[18,22],21],
"obrazac": [[10,32]],
"ugovor": [18],
"predstavljati": [32],
"odabiremo": [[2,13]],
"paketa": [18,[14,16,29]],
"događa": [9],
"ste": [[2,18,31],29,[8,14,21,22,32]],
"privatnih": [10],
"glosarima": [17,[21,32,33,34],3],
"jezika": [[18,29,31],[3,22],[14,33,34],[0,1,6,8,13,15,20,23,28],[11,17,24,32]],
"neprikladnih": [11],
"učlanit": [9],
"instaliran": [18,[2,21]],
"kde": [18,34],
"uvodno": [4],
"ekvivalenata": [21,[10,17,32]],
"sekundama": [21],
"ovom": [18,21,2,[5,11,13,16,19,22,23,28]],
"upitnika": [28],
"metaznakova": [25],
"ovoj": [14,[18,24,32]],
"privatnost": [18],
"slični": [[2,11]],
"slično": [32,[2,18,24,27]],
"općenito": [[10,24,33],[16,18,32]],
"privatnim": [[10,20]],
"jeziku": [18,[23,32],[1,4,20,22],[0,14,15,16]],
"zagradama": [32],
"instalacijsku": [18],
"it_it.tmx": [31],
"sub": [17],
"painless": [9],
"velikih": [[25,27]],
"umjesto": [21,[2,8,17,18,19,23,31]],
"languag": [18],
"pogrešnoga": [16],
"suvremeni": [6],
"slovački": [6],
"sun": [6],
"rječnicima": [[29,32]],
"prioriteti": [34],
"najlakš": [16],
"znam": [18],
"sredit": [15],
"odabranoga": [21,8,[5,14,18,22,30,31]],
"miješ": [31],
"key": [8,[10,18,20]],
"prijevodnoga": [14,[11,34],33],
"sva": [31,[10,13,15,23,30,32]],
"ukupan": [32],
"sve": [18,31,[14,20,21,27],[11,15,16,24],[2,4,13,19,22,26,32],[1,3,5,8,9,17,23,25,29]],
"brojci": [15],
"svg": [18],
"prevodit": [32],
"svi": [27,[17,31],[1,8,13,16,18,20,28,32]],
"paketi": [14,[2,15]],
"znak": [25,28,[18,27],13,5,[2,24,32,33]],
"objašnjen": [11],
"pronađ": [[4,11,17]],
"navedenih": [31,[12,27]],
"svn": [2,31],
"paketu": [18],
"navedenim": [[18,31,32]],
"lijevo": [5,[28,30]],
"bug": [9],
"poruk": [22,18,[2,9,14,20,32]],
"bul": [6],
"ograničenjem": [2],
"varijanti": [25],
"swa": [6],
"instalacijska": [14],
"onaj": [[17,18,21,32]],
"editreplaceinprojectmenuitem": [8],
"prijelaz": [19,[17,27,32]],
"velikim": [28],
"swe": [6],
"uopć": [30],
"dogodi": [14],
"express": [25,[13,33]],
"prijevodna": [31,[2,11,14,32]],
"slijedom": [30],
"siročić": [[28,31]],
"timsko": [2],
"raspoloživ": [20],
"kojima": [16,11,[3,8,15,26,27,28,29,30,31]],
"timski": [34,2,[3,5,11,18,33]],
"eventualnim": [[14,21]],
"besplatan": [[7,11,33]],
"razlik": [32,2],
"oznaku": [[8,13,16,20,21,29]],
"gotoprevioussegmentmenuitem": [8],
"rumunjskoga": [0],
"značenj": [27],
"očuvanja": [31],
"korisnih": [25],
"otvorenog": [1],
"prijevodnu": [31,21,[22,24]],
"otvorenom": [5],
"gotopreviousnotemenuitem": [8],
"normama": [31],
"zajedničk": [2],
"omogućavanja": [20],
"korisnim": [[2,18]],
"editredomenuitem": [8],
"uilayout.xml": [14],
"korisnik": [22,31,[2,8,9,10,11,24,30]],
"fidžijski": [6],
"khm": [6],
"prijevodni": [14,[18,22,31]],
"ekvival": [17,[18,21,32]],
"kompatibilni": [18],
"neprevedenih": [27,[21,24,32]],
"bretonski": [6],
"mjesta": [18],
"njihov": [31,[27,32],[1,13,15,16,24]],
"razmjerno": [14],
"ferojski": [6],
"uzastopnih": [21],
"learned_word": [34],
"vlastitom": [[2,11]],
"uvida": [18],
"mjesto": [[1,2,16,31]],
"namjestit": [[18,22]],
"hiri": [6],
"ovisno": [[13,16,18,21,31,32]],
"kik": [6],
"prevoditeljima": [[13,15,31,32]],
"kim": [7],
"stilova": [15],
"kin": [6],
"jednostavni": [[0,25,30]],
"ovakvi": [13],
"ogledni_projekt": [14],
"stvari": [17],
"kir": [6],
"lakunza": [7],
"pišu": [34,15,33],
"jednostavna": [25],
"zakonodavni": [31],
"zbirk": [10],
"tipkom": [32,[2,18],21,[1,17,27],[29,30]],
"oznaka": [16,[13,34],21,32,33,22,18,[15,31],[6,19],[8,28,29,30],5,24],
"izrađivati": [14],
"odabiret": [[18,20,27]],
"servisa": [2,20,[8,10,14,34],[9,11,17,18,21,33]],
"velški": [6],
"guido": [7],
"maorski": [6],
"rješenja": [[9,11,30,31]],
"algoritam": [3],
"rezult": [[20,31,32]],
"jednostavno": [[17,32],[9,11,15,16,18,27,28,29,31]],
"nastavaka": [15,23],
"servisi": [20],
"pdf-ova": [24],
"parovima": [31,[12,16,22,34]],
"čečenski": [6],
"čin": [4],
"množinski": [3],
"stilom": [2],
"filtar": [13,[15,27]],
"potvrđuj": [32],
"servisu": [[9,10],[33,34],[2,12,14,20,21]],
"stilov": [1],
"license.txt": [14],
"uočljiv": [19],
"manski": [6],
"programskoj": [18,14],
"runtim": [18,14],
"zaštićen": [19],
"alati": [34,32,[8,21,33],[1,14,25],[0,3,11,20,28,31]],
"besplatna": [20,2],
"retkom": [18,34,[14,20],[11,22,33]],
"veći": [20],
"čovjek": [4],
"luba-katanga": [6],
"stupac": [17],
"tester": [25,33],
"alata": [29,21,[25,33],[11,15,18,22,28,31,34]],
"onih": [[13,21,25,31]],
"veću": [24],
"besplatni": [18],
"strogo": [[13,16,27]],
"zamjen": [26],
"internu": [[21,24]],
"filenam": [13],
"skriptom": [21],
"pular": [6],
"veće": [28],
"zbunjujuć": [31],
"provjer": [16,19,[21,31],[2,13,33],[11,28,29,30]],
"roam": [14],
"veća": [22],
"alatu": [31],
"nbsp": [27],
"kompatibilan": [18,19],
"skupovi": [28],
"postojeću": [31],
"skriptni": [1,[14,33]],
"gotosegmentmenuitem": [8],
"svojoj": [[22,32]],
"algoritama": [[8,21]],
"skupova": [11],
"konfiguracijska": [18],
"sljedećima": [4],
"starocrkvenoslavenski": [6],
"kasnij": [19],
"koliziji": [8],
"povezivanjem": [15],
"postojeći": [18,[28,31]],
"pripremljena": [2],
"združujemo": [13],
"kolizija": [2],
"uzmit": [[22,32]],
"interna": [32],
"postojeća": [[18,28]],
"xx_yy.tmx": [31],
"čiju": [16],
"različ": [32],
"initialcreationd": [32],
"mačka": [6],
"čiji": [[11,18,20,22,23]],
"kraćih": [11],
"nadomjesn": [13],
"godn": [[22,31]],
"konfiguracijsku": [18],
"fleksibilnost": [28],
"eventualn": [[9,15,31,32]],
"helpaboutmenuitem": [8],
"otipkan": [8],
"roda": [3],
"klijenti": [2],
"prijevodom": [21,[8,24,32]],
"odredili": [29],
"pokriva": [[11,14]],
"mandelbaum": [7],
"iznimk": [28,34],
"proširena": [20],
"regular": [25,33],
"međunarodna": [17],
"preuzimanj": [18,34,[12,21],[2,8,10,14,17,33]],
"elementa": [9],
"klasificiraju": [32],
"provod": [18],
"klijenta": [2,[18,20,31]],
"potvrđivanja": [21],
"stroge": [31],
"označena": [21,[27,30,32]],
"elementi": [[15,21,32]],
"određuj": [18,31],
"namještenih": [21],
"kastiljanskoga": [29],
"ajmarski": [6],
"token": [34],
"filter": [14],
"pojednostavnit": [16],
"označeni": [[21,31]],
"besplatno": [[12,18]],
"biharski": [6],
"ruskoga": [10],
"omegat.log": [14],
"abashkin": [7],
"sada": [[16,31]],
"označenu": [[14,21,32]],
"kod": [[21,32],[15,18],[2,3,11,14,24]],
"standardnoga": [[14,29]],
"argument": [18,31],
"okviri": [34,32,33],
"kom": [6],
"zalijepi": [[21,32]],
"naredben": [[1,18]],
"kon": [6],
"lozink": [2],
"kor": [6],
"obnovu": [16],
"aplikacij": [18],
"tab": [17,8,[5,21],32],
"preuzimaju": [10],
"taa": [10,33,[17,20,21,34]],
"okviru": [32,19,[2,17,29,30,31],[1,8,10,11,12,13,14,16,18,20,22,23,24,25]],
"webu": [[9,29,34],[1,8,11,20,33]],
"naprij": [21,8],
"plain": [23],
"gramatički": [3],
"veličin": [21,[15,18,22,25,27,32,34]],
"tah": [6],
"ulijevo": [5],
"tag": [15],
"taj": [32,21,[15,18,31],[10,17,20,22,24,30]],
"važnim": [15],
"predložak": [[21,32]],
"dopušteni": [30],
"tam": [6],
"kopir": [29],
"tar": [14,18],
"nevidljivom": [14],
"tat": [6],
"onli": [13],
"smanjuju": [31],
"projectreloadmenuitem": [8],
"neugodnosti": [4],
"relativno": [32],
"podataka": [32,[14,22,34],[2,10,17,20,21],[11,15,18,24,25,30,33]],
"ukazati": [[15,24,28]],
"činu": [32],
"tvore": [3],
"kopij": [31,[2,9,14,21,22]],
"weba": [9,[20,27,29,32]],
"raspor": [[21,32]],
"rodu": [17],
"podudaranjem": [21,8],
"tvori": [28],
"raspon": [25],
"savjetujemo": [28],
"postavkama": [13,[14,21],[18,30,31],[2,3,19,23]],
"potvrd": [2],
"prevedenom": [13,16],
"povezivanja": [2],
"sail": [20],
"čine": [[15,27]],
"prevedenog": [16],
"programiranja": [[1,16,21]],
"graham": [7],
"onom": [13],
"izabrali": [18],
"tbx": [17,21,[8,10,34]],
"winrar": [12],
"čini": [14],
"jezičnom": [[22,31]],
"onoj": [28],
"uključivanjem": [21,[13,24,27]],
"svojim": [18,2,21],
"otvorenim": [32],
"prijelom": [28,[5,16]],
"jednina": [3],
"složen": [15],
"cat": [3],
"odaberemo": [[18,22]],
"postobradna": [24],
"posao": [2],
"uklanjanjem": [16],
"duser.countri": [18],
"tcl": [30],
"vraćaju": [[11,14]],
"podržanim": [15,32],
"tck": [30],
"argumenti": [34,18,20],
"podržanih": [0],
"stvaraju": [14],
"slijeva": [15,5],
"stalnom": [9],
"tipkovn": [11],
"statističk": [14,[20,21,24,32]],
"svojih": [28],
"čime": [21,[31,32],[18,19,23,29,30]],
"otvorenih": [27,32],
"upravljanj": [[21,34],[11,16,29,33],[14,17,20]],
"stavci": [8],
"fragment": [16],
"valonski": [6],
"filtriraj": [27],
"typo3": [15],
"align.tmx": [18,22],
"programiranju": [9]
};
