/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.sitraka;

import java.util.Hashtable;
import java.util.Vector;
import org.apache.tools.ant.BuildException;

public class Triggers {
    protected Vector triggers = new Vector();
    private static final Hashtable actionMap = new Hashtable(3);
    private static final Hashtable eventMap = new Hashtable(3);

    public void addMethod(Method method) {
        this.triggers.addElement(method);
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        int size = this.triggers.size();
        for (int i = 0; i < size; ++i) {
            buf.append(this.triggers.elementAt(i).toString());
            if (i >= size - 1) continue;
            buf.append(',');
        }
        return buf.toString();
    }

    static {
        actionMap.put("enter", "E");
        actionMap.put("exit", "X");
        eventMap.put("clear", "C");
        eventMap.put("pause", "P");
        eventMap.put("resume", "R");
        eventMap.put("snapshot", "S");
        eventMap.put("suspend", "A");
        eventMap.put("exit", "X");
    }

    public static class Method {
        protected String name;
        protected String event;
        protected String action;
        protected String param;

        public void setName(String value) {
            this.name = value;
        }

        public void setEvent(String value) {
            if (eventMap.get(value) == null) {
                throw new BuildException("Invalid event, must be one of " + eventMap);
            }
            this.event = value;
        }

        public void setAction(String value) throws BuildException {
            if (actionMap.get(value) == null) {
                throw new BuildException("Invalid action, must be one of " + actionMap);
            }
            this.action = value;
        }

        public void setParam(String value) {
            this.param = value;
        }

        public String toString() {
            StringBuffer buf = new StringBuffer();
            buf.append(this.name).append(":");
            buf.append(eventMap.get(this.event)).append(":");
            buf.append(actionMap.get(this.action));
            if (this.param != null) {
                buf.append(":").append(this.param);
            }
            return buf.toString();
        }
    }
}

