/*
 * Decompiled with CFR 0.152.
 */
package org.caffinitas.ohc.linked;

import java.io.IOException;
import org.caffinitas.ohc.linked.AbstractOffHeapDataOutput;
import org.caffinitas.ohc.linked.Uns;
import org.caffinitas.ohc.linked.Util;

final class HashEntryValueOutput
extends AbstractOffHeapDataOutput {
    HashEntryValueOutput(long hashEntryAdr, long keyLen, long valueLen) {
        super(hashEntryAdr, 56L + Util.roundUpTo8(keyLen), valueLen);
    }

    HashEntryValueOutput(long hashEntryAdr, long valueLen) {
        super(hashEntryAdr, 0L, valueLen);
    }

    @Override
    public void writeBoolean(boolean v) throws IOException {
        this.assertAvail(1);
        Uns.putBoolean(this.blkAdr, this.blkOff++, v);
    }

    @Override
    public void writeByte(int v) throws IOException {
        this.assertAvail(1);
        Uns.putByte(this.blkAdr, this.blkOff++, (byte)v);
    }

    @Override
    public void writeShort(int v) throws IOException {
        this.assertAvail(2);
        Uns.putShort(this.blkAdr, this.blkOff, (short)v);
        this.blkOff += 2L;
    }

    @Override
    public void writeChar(int v) throws IOException {
        this.assertAvail(2);
        Uns.putChar(this.blkAdr, this.blkOff, (char)v);
        this.blkOff += 2L;
    }

    @Override
    public void writeInt(int v) throws IOException {
        this.assertAvail(4);
        Uns.putInt(this.blkAdr, this.blkOff, v);
        this.blkOff += 4L;
    }

    @Override
    public void writeLong(long v) throws IOException {
        this.assertAvail(8);
        Uns.putLong(this.blkAdr, this.blkOff, v);
        this.blkOff += 8L;
    }

    @Override
    public void writeFloat(float v) throws IOException {
        this.assertAvail(4);
        Uns.putFloat(this.blkAdr, this.blkOff, v);
        this.blkOff += 4L;
    }

    @Override
    public void writeDouble(double v) throws IOException {
        this.assertAvail(8);
        Uns.putDouble(this.blkAdr, this.blkOff, v);
        this.blkOff += 8L;
    }
}

