/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.stress.generate.values;

import java.nio.ByteBuffer;
import java.util.Arrays;
import org.apache.cassandra.db.marshal.BytesType;
import org.apache.cassandra.stress.generate.values.Generator;
import org.apache.cassandra.stress.generate.values.GeneratorConfig;

public class HexBytes
extends Generator<ByteBuffer> {
    private final byte[] bytes;

    public HexBytes(String name, GeneratorConfig config) {
        super(BytesType.instance, config, name, ByteBuffer.class);
        this.bytes = new byte[(int)this.sizeDistribution.maxValue()];
    }

    @Override
    public ByteBuffer generate() {
        long seed = this.identityDistribution.next();
        this.sizeDistribution.setSeed(seed);
        int size = (int)this.sizeDistribution.next();
        for (int i = 0; i < size; i += 16) {
            long value = this.identityDistribution.next();
            for (int j = 0; j < 16 && i + j < size; ++j) {
                int v = (int)(value & 0xFL);
                this.bytes[i + j] = (byte)((v < 10 ? 48 : 65) + v);
                value >>>= 4;
            }
        }
        return ByteBuffer.wrap(Arrays.copyOf(this.bytes, size));
    }
}

