/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.utils.memory;

import org.apache.cassandra.utils.memory.MemtableAllocator;
import org.apache.cassandra.utils.memory.MemtablePool;
import org.apache.cassandra.utils.memory.SlabAllocator;

public class SlabPool
extends MemtablePool {
    final boolean allocateOnHeap;

    public SlabPool(long maxOnHeapMemory, long maxOffHeapMemory, float cleanupThreshold, Runnable cleaner) {
        super(maxOnHeapMemory, maxOffHeapMemory, cleanupThreshold, cleaner);
        this.allocateOnHeap = maxOffHeapMemory == 0L;
    }

    @Override
    public MemtableAllocator newAllocator() {
        return new SlabAllocator(this.onHeap.newAllocator(), this.offHeap.newAllocator(), this.allocateOnHeap);
    }

    @Override
    public boolean needToCopyOnHeap() {
        return !this.allocateOnHeap;
    }
}

