/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.sandbox.security.trust;

import java.rmi.RemoteException;
import java.text.MessageFormat;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class WSTrustException
extends RemoteException {
    public static final String INVALID_REQUEST = "InvalidRequest";
    public static final String DESC_INCORRECT_CHILD_ELEM = "incorrectChildElement";
    public static final String DESC_EXPECTED_CHILD_ELEM = "expectedChildElement";
    public static final String DESC_CHILD_IN_VALUE_ELEM = "childInValueElement";
    public static final String DESC_TEXT_IN_COMPOSITE_ELEM = "textInCompositeElement";
    private static ResourceBundle resources;
    private String faultCode;
    private String faultString;

    public WSTrustException(String faultCode, String msgId, Object[] args, Throwable exception) {
        super(WSTrustException.getMessage(faultCode, null, null), exception);
        this.faultCode = faultCode;
        this.faultString = resources.getString(faultCode);
    }

    public WSTrustException(String faultCode, String msgId, Object[] args) {
        super(WSTrustException.getMessage(faultCode, null, null));
        this.faultCode = faultCode;
        this.faultString = resources.getString(faultCode);
    }

    public WSTrustException(String faultCode, String msg) {
        super(msg);
        this.faultCode = faultCode;
        this.faultString = resources.getString(faultCode);
    }

    private static String getMessage(String faultCode, String msgId, Object[] args) {
        String msg = null;
        try {
            msg = resources.getString(faultCode);
            if (msgId != null) {
                msg = msg + " (" + MessageFormat.format(resources.getString(msgId), args) + ")";
                return msg;
            }
        }
        catch (MissingResourceException e) {
            throw new RuntimeException("Undefined '" + msgId + "' resource property");
        }
        return msg;
    }

    public WSTrustException(String message) {
        super(message);
    }

    public WSTrustException(String message, Throwable ex) {
        super(message, ex);
    }

    public String getFaultCode() {
        return "wst" + this.faultCode;
    }

    public String getFaultString() {
        return this.faultString;
    }

    static {
        try {
            resources = ResourceBundle.getBundle("org.apache.ws.security.trust.errors");
        }
        catch (MissingResourceException e) {
            throw new RuntimeException(e.getMessage());
        }
    }
}

