/*
 * Decompiled with CFR 0.152.
 */
package jmapps.export;

import com.sun.media.ui.AudioFormatChooser;
import com.sun.media.ui.TabControl;
import com.sun.media.ui.VideoFormatChooser;
import com.sun.media.util.JMFI18N;
import java.awt.BorderLayout;
import java.awt.Choice;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Label;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Hashtable;
import java.util.Vector;
import javax.media.Format;
import javax.media.Processor;
import javax.media.control.TrackControl;
import javax.media.format.AudioFormat;
import javax.media.format.VideoFormat;
import javax.media.protocol.ContentDescriptor;
import jmapps.export.PanelMediaTargetType;
import jmapps.ui.ImageArea;
import jmapps.ui.JMPanel;
import jmapps.ui.MessageDialog;

public class PanelMediaTargetFormat
extends JMPanel
implements ActionListener,
ItemListener {
    private Processor processor = null;
    private String strTargetType = PanelMediaTargetType.TYPE_OTHER;
    private ContentDescriptor[] arrContentDescriptors = null;
    private Hashtable hashtableContentDescriptors = null;
    private TrackControl[] arrTrackControls = null;
    private String[] arrAllowContentType = null;
    private JMPanel panelContent;
    private Choice comboContentType;
    private TabControl tabControl;
    private Vector vectorPanelsAudio;
    private Vector vectorPanelsVideo;
    private Vector vectorTracksAudio;
    private Vector vectorTracksVideo;
    private Image imageAudioEn = null;
    private Image imageAudioDis = null;
    private Image imageVideoEn = null;
    private Image imageVideoDis = null;

    public PanelMediaTargetFormat() {
        try {
            this.init();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void setAllowContentType(String[] arrAllowContentType) {
        this.arrAllowContentType = arrAllowContentType;
    }

    private void init() throws Exception {
        this.setLayout(new BorderLayout(6, 6));
        Panel panelDescription = new Panel(new GridLayout(0, 1));
        this.add((Component)panelDescription, "North");
        panelDescription.add(new Label(JMFI18N.getResource("jmstudio.export.format.label1")));
        panelDescription.add(new Label(JMFI18N.getResource("jmstudio.export.format.label2")));
        this.panelContent = new JMPanel(new BorderLayout(6, 6));
        this.panelContent.setEmptyBorder(6, 6, 6, 6);
        this.add((Component)this.panelContent, "Center");
        this.imageAudioEn = ImageArea.loadImage("audio.gif", this, true);
        this.imageAudioDis = ImageArea.loadImage("audio-disabled.gif", this, true);
        this.imageVideoEn = ImageArea.loadImage("video.gif", this, true);
        this.imageVideoDis = ImageArea.loadImage("video-disabled.gif", this, true);
    }

    public void setProcessor(Processor processor, String strContType, String strTargetType) {
        this.processor = processor;
        this.strTargetType = strTargetType;
        this.arrContentDescriptors = processor.getSupportedContentDescriptors();
        this.arrTrackControls = processor.getTrackControls();
        this.panelContent.removeAll();
        this.buildPage();
        if (strTargetType.equals(PanelMediaTargetType.TYPE_NETWORK)) {
            strContType = new ContentDescriptor("raw.rtp").toString();
        }
        if (strTargetType.equals(PanelMediaTargetType.TYPE_SCREEN)) {
            strContType = new ContentDescriptor("raw").toString();
        }
        if (strContType != null) {
            this.comboContentType.select(strContType);
        }
        this.changeContentType();
    }

    public void updateProcessorFormat() {
        Format format;
        TrackControl trackControl;
        int nCount = this.vectorPanelsVideo.size();
        int i2 = 0;
        while (i2 < nCount) {
            VideoFormatChooser panelVideo = (VideoFormatChooser)this.vectorPanelsVideo.elementAt(i2);
            trackControl = (TrackControl)this.vectorTracksVideo.elementAt(i2);
            if (!panelVideo.isTrackEnabled()) {
                trackControl.setEnabled(false);
            } else {
                format = panelVideo.getFormat();
                if (format == null) {
                    MessageDialog.createErrorDialog(this.getFrame(), "Internal error. Unable to match choosen video format. Track will be disabled.");
                    trackControl.setEnabled(false);
                } else {
                    trackControl.setEnabled(true);
                    trackControl.setFormat(format);
                }
            }
            ++i2;
        }
        nCount = this.vectorPanelsAudio.size();
        i2 = 0;
        while (i2 < nCount) {
            AudioFormatChooser panelAudio = (AudioFormatChooser)this.vectorPanelsAudio.elementAt(i2);
            trackControl = (TrackControl)this.vectorTracksAudio.elementAt(i2);
            if (!panelAudio.isTrackEnabled()) {
                trackControl.setEnabled(false);
            } else {
                format = panelAudio.getFormat();
                if (format == null) {
                    MessageDialog.createErrorDialog(this.getFrame(), "Internal error. Unable to match choosen audio format. Track will be disabled.");
                    trackControl.setEnabled(false);
                } else {
                    trackControl.setEnabled(true);
                    trackControl.setFormat(format);
                }
            }
            ++i2;
        }
    }

    public boolean[] getEnabledVideoTracks() {
        int nCount = this.vectorPanelsVideo.size();
        boolean[] arrResult = new boolean[nCount];
        int i2 = 0;
        while (i2 < nCount) {
            VideoFormatChooser panelVideo = (VideoFormatChooser)this.vectorPanelsVideo.elementAt(i2);
            arrResult[i2] = panelVideo.isTrackEnabled();
            ++i2;
        }
        return arrResult;
    }

    public boolean[] getEnabledAudioTracks() {
        int nCount = this.vectorPanelsAudio.size();
        boolean[] arrResult = new boolean[nCount];
        int i2 = 0;
        while (i2 < nCount) {
            AudioFormatChooser panelAudio = (AudioFormatChooser)this.vectorPanelsAudio.elementAt(i2);
            arrResult[i2] = panelAudio.isTrackEnabled();
            ++i2;
        }
        return arrResult;
    }

    public void actionPerformed(ActionEvent event) {
        String strCmd = event.getActionCommand();
        Object objectSource = event.getSource();
        if (strCmd.equals("ACTION_AUDIO_TRACK_ENABLED")) {
            if (objectSource instanceof AudioFormatChooser) {
                this.tabControl.setPageImage((Panel)objectSource, this.imageAudioEn);
            }
        } else if (strCmd.equals("ACTION_AUDIO_TRACK_DISABLED")) {
            if (objectSource instanceof AudioFormatChooser) {
                this.tabControl.setPageImage((Panel)objectSource, this.imageAudioDis);
            }
        } else if (strCmd.equals("ACTION_VIDEO_TRACK_ENABLED")) {
            if (objectSource instanceof VideoFormatChooser) {
                this.tabControl.setPageImage((Panel)objectSource, this.imageVideoEn);
            }
        } else if (strCmd.equals("ACTION_VIDEO_TRACK_DISABLED") && objectSource instanceof VideoFormatChooser) {
            this.tabControl.setPageImage((Panel)objectSource, this.imageVideoDis);
        }
    }

    public void itemStateChanged(ItemEvent event) {
        Object objectSource = event.getSource();
        if (objectSource == this.comboContentType) {
            this.changeContentType();
        }
    }

    private void buildPage() {
        Panel panelFormat = new Panel(new BorderLayout(6, 6));
        this.panelContent.add((Component)panelFormat, "North");
        Label label = new Label(JMFI18N.getResource("jmstudio.export.format.format"));
        panelFormat.add((Component)label, "West");
        this.comboContentType = new Choice();
        this.comboContentType.addItemListener(this);
        int nCount = this.arrContentDescriptors.length;
        this.hashtableContentDescriptors = new Hashtable();
        int i2 = 0;
        while (i2 < nCount) {
            String strContType = this.arrContentDescriptors[i2].getContentType();
            if (this.isContentTypeAllowed(strContType)) {
                strContType = this.arrContentDescriptors[i2].toString();
                this.comboContentType.addItem(strContType);
                this.hashtableContentDescriptors.put(strContType, this.arrContentDescriptors[i2]);
            }
            ++i2;
        }
        panelFormat.add((Component)this.comboContentType, "Center");
        Panel panel = this.buildTrackFormatPanel();
        this.panelContent.add((Component)panel, "Center");
    }

    private Panel buildTrackFormatPanel() {
        Format format;
        int nAudioTrackCount = 0;
        int nVideoTrackCount = 0;
        String strAudio = JMFI18N.getResource("jmstudio.export.format.audio");
        String strVideo = JMFI18N.getResource("jmstudio.export.format.video");
        String strHinted = JMFI18N.getResource("jmstudio.export.format.hinted");
        this.tabControl = new TabControl(0);
        int nIndexAudio = 0;
        int nIndexVideo = 0;
        nAudioTrackCount = 0;
        nVideoTrackCount = 0;
        this.vectorPanelsAudio = new Vector();
        this.vectorPanelsVideo = new Vector();
        this.vectorTracksAudio = new Vector();
        this.vectorTracksVideo = new Vector();
        int nCount = this.arrTrackControls.length;
        int i2 = 0;
        while (i2 < nCount) {
            format = this.arrTrackControls[i2].getFormat();
            if (format instanceof VideoFormat) {
                ++nVideoTrackCount;
            }
            if (format instanceof AudioFormat) {
                ++nAudioTrackCount;
            }
            ++i2;
        }
        i2 = 0;
        while (i2 < nCount) {
            String strEncoding;
            String strTitle;
            format = this.arrTrackControls[i2].getFormat();
            if (format instanceof AudioFormat) {
                strTitle = nAudioTrackCount < 2 ? new String(strAudio) : new String(strAudio + " " + ++nIndexAudio);
                strEncoding = format.getEncoding();
                if (strEncoding.endsWith("/rtp")) {
                    strTitle = strTitle + " " + strHinted;
                }
                AudioFormatChooser chooserAudio = new AudioFormatChooser(this.arrTrackControls[i2].getSupportedFormats(), (AudioFormat)format, true, this);
                chooserAudio.setTrackEnabled(this.arrTrackControls[i2].isEnabled());
                this.tabControl.addPage(chooserAudio, strTitle, this.imageAudioEn);
                this.vectorPanelsAudio.addElement(chooserAudio);
                this.vectorTracksAudio.addElement(this.arrTrackControls[i2]);
            } else if (format instanceof VideoFormat) {
                strTitle = nVideoTrackCount < 2 ? new String(strVideo) : new String(strVideo + " " + ++nIndexVideo);
                strEncoding = format.getEncoding();
                if (strEncoding.endsWith("/rtp")) {
                    strTitle = strTitle + " " + strHinted;
                }
                VideoFormatChooser chooserVideo = new VideoFormatChooser(this.arrTrackControls[i2].getSupportedFormats(), (VideoFormat)format, true, this);
                chooserVideo.setTrackEnabled(this.arrTrackControls[i2].isEnabled());
                this.tabControl.addPage(chooserVideo, strTitle, this.imageVideoEn);
                this.vectorPanelsVideo.addElement(chooserVideo);
                this.vectorTracksVideo.addElement(this.arrTrackControls[i2]);
            }
            ++i2;
        }
        return this.tabControl;
    }

    private void changeContentType() {
        TrackControl trackControl;
        String strContentType = this.comboContentType.getSelectedItem();
        ContentDescriptor contentDescriptor = (ContentDescriptor)this.hashtableContentDescriptors.get(strContentType);
        if (this.processor.setContentDescriptor(contentDescriptor) == null) {
            System.err.println("Error setting content descriptor on processor");
        }
        int nCount = this.vectorPanelsVideo.size();
        int i2 = 0;
        while (i2 < nCount) {
            VideoFormatChooser panelVideo = (VideoFormatChooser)this.vectorPanelsVideo.elementAt(i2);
            trackControl = (TrackControl)this.vectorTracksVideo.elementAt(i2);
            panelVideo.setSupportedFormats(trackControl.getSupportedFormats(), (VideoFormat)trackControl.getFormat());
            ++i2;
        }
        nCount = this.vectorPanelsAudio.size();
        i2 = 0;
        while (i2 < nCount) {
            AudioFormatChooser panelAudio = (AudioFormatChooser)this.vectorPanelsAudio.elementAt(i2);
            trackControl = (TrackControl)this.vectorTracksAudio.elementAt(i2);
            panelAudio.setSupportedFormats(trackControl.getSupportedFormats(), (AudioFormat)trackControl.getFormat());
            ++i2;
        }
    }

    private boolean isContentTypeAllowed(String strContType) {
        boolean boolResult = false;
        if (this.arrAllowContentType != null) {
            int i2 = 0;
            while (i2 < this.arrAllowContentType.length && !boolResult) {
                if (this.arrAllowContentType[i2].equalsIgnoreCase(strContType)) {
                    boolResult = true;
                }
                ++i2;
            }
        } else if (this.strTargetType.equals(PanelMediaTargetType.TYPE_NETWORK)) {
            String strTypeRaw = ContentDescriptor.mimeTypeToPackageName("raw");
            String strTypeRawRtp = ContentDescriptor.mimeTypeToPackageName("raw.rtp");
            if (strContType.equals(strTypeRaw) || strContType.equals(strTypeRawRtp)) {
                boolResult = true;
            }
        } else {
            boolResult = true;
        }
        return boolResult;
    }
}

