/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.encoding.readfeatures;

import htsjdk.samtools.cram.encoding.readfeatures.ReadFeature;
import java.io.Serializable;
import java.util.Objects;

public class ReadBase
implements Serializable,
ReadFeature {
    private int position;
    private byte base;
    private byte qualityScore;
    public static final byte operator = 66;

    public ReadBase(int position, byte base, byte qualityScore) {
        this.position = position;
        this.base = base;
        this.qualityScore = qualityScore;
    }

    @Override
    public byte getOperator() {
        return 66;
    }

    @Override
    public int getPosition() {
        return this.position;
    }

    public byte getQualityScore() {
        return this.qualityScore;
    }

    public String toString() {
        return new StringBuilder(this.getClass().getSimpleName() + "[").append("position=").append(this.position).append("; base=").appendCodePoint(this.base).append("; score=").appendCodePoint(this.qualityScore == -1 ? (byte)0 : this.qualityScore).append("] ").toString();
    }

    public byte getBase() {
        return this.base;
    }

    public void setBase(byte base) {
        this.base = base;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ReadBase readBase = (ReadBase)o;
        return this.position == readBase.position && this.base == readBase.base && this.qualityScore == readBase.qualityScore;
    }

    public int hashCode() {
        return Objects.hash(this.position, this.base, this.qualityScore);
    }
}

