/*
 * Decompiled with CFR 0.152.
 */
package com.birosoft.liquid;

import java.awt.event.InputEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.JScrollBar;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicScrollPaneUI;

public class LiquidScrollPaneUI
extends BasicScrollPaneUI
implements PropertyChangeListener {
    public static ComponentUI createUI(JComponent c) {
        return new LiquidScrollPaneUI();
    }

    protected MouseWheelListener createMouseWheelListener() {
        return new MouseWheelHandler();
    }

    public void installUI(JComponent c) {
        super.installUI(c);
        this.scrollpane.getHorizontalScrollBar().putClientProperty("JScrollBar.isFreeStanding", Boolean.FALSE);
        this.scrollpane.getVerticalScrollBar().putClientProperty("JScrollBar.isFreeStanding", Boolean.FALSE);
    }

    protected PropertyChangeListener createScrollBarSwapListener() {
        return this;
    }

    public void propertyChange(PropertyChangeEvent event) {
    }

    protected class MouseWheelHandler
    implements MouseWheelListener {
        public void mouseWheelMoved(MouseWheelEvent e) {
            if (LiquidScrollPaneUI.this.scrollpane.isWheelScrollingEnabled() && e.getScrollAmount() != 0) {
                JScrollBar toScroll = LiquidScrollPaneUI.this.scrollpane.getVerticalScrollBar();
                int direction = 0;
                int length = toScroll.getHeight();
                if (toScroll == null || !toScroll.isVisible() || e.getModifiers() == InputEvent.ALT_MASK) {
                    toScroll = LiquidScrollPaneUI.this.scrollpane.getHorizontalScrollBar();
                    if (toScroll == null || !toScroll.isVisible()) {
                        return;
                    }
                    length = toScroll.getWidth();
                }
                int n = direction = e.getWheelRotation() < 0 ? -1 : 1;
                if (e.getScrollType() == 0) {
                    int newValue = toScroll.getValue() + e.getWheelRotation() * length / (toScroll.getUnitIncrement() * 2);
                    toScroll.setValue(newValue);
                } else if (e.getScrollType() == 1) {
                    int newValue = toScroll.getValue() + e.getWheelRotation() * length / (toScroll.getBlockIncrement() * 2);
                    toScroll.setValue(newValue);
                }
            }
        }

        MouseWheelHandler() {
        }
    }
}

