/*
 * Decompiled with CFR 0.152.
 */
package free.jin.board;

import free.chess.JBoard;
import free.chess.Position;
import free.chess.Square;
import free.jin.board.Arrow;
import free.jin.board.Circle;
import free.jin.board.event.ArrowCircleListener;
import free.util.PaintHook;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.util.Vector;

public class JinBoard
extends JBoard
implements PaintHook {
    private final Vector arrows = new Vector(3);
    private final Vector circles = new Vector(2);
    private Color defaultArrowColor = Color.lightGray;
    private Color defaultCircleColor = Color.lightGray;
    private boolean isArrowCircleEnabled = true;

    public JinBoard(Position position) {
        super(position);
        this.addPaintHook(this);
    }

    public boolean isArrowCircleEnabled() {
        return this.isArrowCircleEnabled;
    }

    public void setArrowCircleEnabled(boolean bl) {
        this.isArrowCircleEnabled = bl;
    }

    public void setDefaultArrowColor(Color color) {
        this.defaultArrowColor = color;
    }

    public void setDefaultCircleColor(Color color) {
        this.defaultCircleColor = color;
    }

    public Color getDefaultArrowColor() {
        return this.defaultArrowColor;
    }

    public Color getDefaultCircleColor() {
        return this.defaultCircleColor;
    }

    public void addArrowCircleListener(ArrowCircleListener arrowCircleListener) {
        this.listenerList.add(ArrowCircleListener.class, arrowCircleListener);
    }

    public void removeArrowCircleListener(ArrowCircleListener arrowCircleListener) {
        this.listenerList.remove(ArrowCircleListener.class, arrowCircleListener);
    }

    protected void fireArrowAdded(Arrow arrow) {
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = 0; i < objectArray.length; i += 2) {
            if (objectArray[i] != (class$free$jin$board$event$ArrowCircleListener == null ? JinBoard.class$("free.jin.board.event.ArrowCircleListener") : class$free$jin$board$event$ArrowCircleListener)) continue;
            ArrowCircleListener arrowCircleListener = (ArrowCircleListener)objectArray[i + 1];
            arrowCircleListener.arrowAdded(this, arrow);
        }
    }

    protected void fireCircleAdded(Circle circle) {
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = 0; i < objectArray.length; i += 2) {
            if (objectArray[i] != (class$free$jin$board$event$ArrowCircleListener == null ? JinBoard.class$("free.jin.board.event.ArrowCircleListener") : class$free$jin$board$event$ArrowCircleListener)) continue;
            ArrowCircleListener arrowCircleListener = (ArrowCircleListener)objectArray[i + 1];
            arrowCircleListener.circleAdded(this, circle);
        }
    }

    protected void fireArrowRemoved(Arrow arrow) {
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = 0; i < objectArray.length; i += 2) {
            if (objectArray[i] != (class$free$jin$board$event$ArrowCircleListener == null ? JinBoard.class$("free.jin.board.event.ArrowCircleListener") : class$free$jin$board$event$ArrowCircleListener)) continue;
            ArrowCircleListener arrowCircleListener = (ArrowCircleListener)objectArray[i + 1];
            arrowCircleListener.arrowRemoved(this, arrow);
        }
    }

    protected void fireCircleRemoved(Circle circle) {
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = 0; i < objectArray.length; i += 2) {
            if (objectArray[i] != (class$free$jin$board$event$ArrowCircleListener == null ? JinBoard.class$("free.jin.board.event.ArrowCircleListener") : class$free$jin$board$event$ArrowCircleListener)) continue;
            ArrowCircleListener arrowCircleListener = (ArrowCircleListener)objectArray[i + 1];
            arrowCircleListener.circleRemoved(this, circle);
        }
    }

    protected int calcArrowSize(int n, int n2) {
        return n / 7;
    }

    protected int calcCircleSize(int n, int n2) {
        return n / 10;
    }

    public void paint(Component component, Graphics graphics) {
        int n;
        if (component != this) {
            throw new IllegalArgumentException("Can only paint on this");
        }
        Rectangle rectangle = this.squareToRect(0, 0, null);
        int n2 = this.calcArrowSize(rectangle.width, rectangle.height);
        int n3 = this.calcCircleSize(rectangle.width, rectangle.height);
        int n4 = this.arrows.size();
        for (n = 0; n < n4; ++n) {
            Arrow arrow = (Arrow)this.arrows.elementAt(n);
            this.drawArrow(graphics, arrow.getFrom(), arrow.getTo(), n2, arrow.getColor());
        }
        n = this.circles.size();
        for (int i = 0; i < n; ++i) {
            Circle circle = (Circle)this.circles.elementAt(i);
            this.drawSquare(graphics, circle.getSquare(), n3, circle.getColor());
        }
    }

    public void addArrow(Arrow arrow) {
        this.arrows.addElement(arrow);
        this.fireArrowAdded(arrow);
        this.repaint();
    }

    public void removeArrowsAt(Square square, Square square2) {
        for (int i = this.arrows.size() - 1; i >= 0; --i) {
            Arrow arrow = (Arrow)this.arrows.elementAt(i);
            if (!arrow.getFrom().equals(square) || !arrow.getTo().equals(square2)) continue;
            this.arrows.removeElementAt(i);
            this.fireArrowRemoved(arrow);
        }
        this.repaint();
    }

    public boolean areArrowsAt(Square square, Square square2) {
        for (int i = 0; i < this.arrows.size(); ++i) {
            Arrow arrow = (Arrow)this.arrows.elementAt(i);
            if (!arrow.getFrom().equals(square) || !arrow.getTo().equals(square2)) continue;
            return true;
        }
        return false;
    }

    public void removeAllArrows() {
        for (int i = this.arrows.size() - 1; i >= 0; --i) {
            Arrow arrow = (Arrow)this.arrows.elementAt(i);
            this.arrows.removeElementAt(i);
            this.fireArrowRemoved(arrow);
        }
        this.repaint();
    }

    public void addCircle(Circle circle) {
        this.circles.addElement(circle);
        this.fireCircleAdded(circle);
        this.repaint();
    }

    public void removeCirclesAt(Square square) {
        for (int i = this.circles.size() - 1; i >= 0; --i) {
            Circle circle = (Circle)this.circles.elementAt(i);
            if (!circle.getSquare().equals(square)) continue;
            this.circles.removeElementAt(i);
            this.fireCircleRemoved(circle);
        }
        this.repaint();
    }

    public boolean areCirclesAt(Square square) {
        for (int i = 0; i < this.circles.size(); ++i) {
            Circle circle = (Circle)this.circles.elementAt(i);
            if (!circle.getSquare().equals(square)) continue;
            return true;
        }
        return false;
    }

    public void removeAllCircles() {
        for (int i = this.circles.size() - 1; i >= 0; --i) {
            Circle circle = (Circle)this.circles.elementAt(i);
            this.circles.removeElementAt(i);
            this.fireCircleRemoved(circle);
        }
        this.repaint();
    }
}

