/*
 * Decompiled with CFR 0.152.
 */
package free.jin.console.icc;

import free.jin.console.Console;
import free.jin.console.ConsoleManager;
import free.jin.console.icc.ChessclubConsole;
import free.jin.console.icc.ChessclubConsolePrefsPanel;
import free.jin.event.ChatEvent;
import free.jin.ui.PreferencesPanel;

public class ChessclubConsoleManager
extends ConsoleManager {
    public void chatMessageReceived(ChatEvent chatEvent) {
        super.chatMessageReceived(chatEvent);
        if (this.isPaused()) {
            return;
        }
        String string = chatEvent.getType();
        if (string.equals("tell") || string.equals("say") || string.equals("atell") || string.equals("ptell")) {
            this.console.tellReceived(chatEvent.getSender());
        }
    }

    protected String translateChat(ChatEvent chatEvent) {
        String string = chatEvent.getType();
        String string2 = chatEvent.getSender();
        String string3 = chatEvent.getSenderTitle();
        String string4 = this.decode(chatEvent.getMessage());
        Object object = chatEvent.getForum();
        if ("qtell".equals(string)) {
            return this.parseQTell(chatEvent);
        }
        if ("channel-qtell".equals(string)) {
            return this.parseChannelQTell(chatEvent);
        }
        Object[] objectArray = new Object[]{string2, string3, String.valueOf(object), string4};
        return this.getI18n().getFormattedString(string + ".displayPattern", objectArray);
    }

    protected Console createConsole() {
        return new ChessclubConsole(this);
    }

    private String parseQTell(ChatEvent chatEvent) {
        int n;
        String string = chatEvent.getMessage();
        while ((n = string.indexOf("\\n")) != -1) {
            string = string.substring(0, n) + "\n:" + string.substring(n + 2);
        }
        while ((n = string.indexOf("\\h")) != -1) {
            string = string.substring(0, n) + string.substring(n + 2);
        }
        while ((n = string.indexOf("\\H")) != -1) {
            string = string.substring(0, n) + string.substring(n + 2);
        }
        while ((n = string.indexOf("\\b")) != -1) {
            string = string.substring(0, n) + string.substring(n + 2);
        }
        return ":" + string;
    }

    private String parseChannelQTell(ChatEvent chatEvent) {
        int n;
        String string = chatEvent.getMessage();
        Object object = chatEvent.getForum();
        while ((n = string.indexOf("\\n")) != -1) {
            string = string.substring(0, n) + "\n" + object + ">" + string.substring(n + 2);
        }
        while ((n = string.indexOf("\\h")) != -1) {
            string = string.substring(0, n) + string.substring(n + 2);
        }
        while ((n = string.indexOf("\\H")) != -1) {
            string = string.substring(0, n) + string.substring(n + 2);
        }
        while ((n = string.indexOf("\\b")) != -1) {
            string = string.substring(0, n) + string.substring(n + 2);
        }
        return object + ">" + string;
    }

    public boolean supportsMultipleEncodings() {
        return true;
    }

    public PreferencesPanel getPreferencesUI() {
        return new ChessclubConsolePrefsPanel(this);
    }
}

