/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.mlf.metouia;

import java.awt.Color;
import java.awt.Insets;
import java.awt.Toolkit;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.swing.ImageIcon;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.plaf.metal.MetalLookAndFeel;
import javax.swing.plaf.metal.MetalTheme;
import net.sourceforge.mlf.metouia.MetouiaDefaultTheme;
import net.sourceforge.mlf.metouia.borders.MetouiaBorderUtilities;
import net.sourceforge.mlf.metouia.borders.MetouiaInternalFrameBorder;
import net.sourceforge.mlf.metouia.borders.MetouiaMenuBarBorder;
import net.sourceforge.mlf.metouia.borders.MetouiaMenuItemBorder;
import net.sourceforge.mlf.metouia.borders.MetouiaOptionDialogBorder;
import net.sourceforge.mlf.metouia.borders.MetouiaPaletteBorder;
import net.sourceforge.mlf.metouia.borders.MetouiaPopupMenuBorder;
import net.sourceforge.mlf.metouia.borders.MetouiaScrollPaneBorder;
import net.sourceforge.mlf.metouia.borders.MetouiaTableHeaderBorder;
import net.sourceforge.mlf.metouia.borders.MetouiaToolBarBorder;

public class MetouiaLookAndFeel
extends MetalLookAndFeel {
    protected static MetouiaDefaultTheme metouiaTheme;
    private static boolean isInstalled;
    private static boolean themeHasBeenSet;

    public String getID() {
        return "Metouia";
    }

    public String getName() {
        return "Metouia";
    }

    public String getDescription() {
        return "Metouia Look and Feel";
    }

    public boolean isNativeLookAndFeel() {
        return false;
    }

    public boolean isSupportedLookAndFeel() {
        return true;
    }

    protected void initClassDefaults(UIDefaults uIDefaults) {
        super.initClassDefaults(uIDefaults);
        uIDefaults.putDefaults(new Object[]{"ButtonUI", "net.sourceforge.mlf.metouia.MetouiaButtonUI", "CheckBoxUI", "net.sourceforge.mlf.metouia.MetouiaCheckBoxUI", "TextFieldUI", "net.sourceforge.mlf.metouia.MetouiaTextFieldUI", "ListUI", "net.sourceforge.mlf.metouia.MetouiaListUI", "TreeUI", "net.sourceforge.mlf.metouia.MetouiaTreeUI", "ToolBarUI", "net.sourceforge.mlf.metouia.MetouiaToolBarUI", "MenuBarUI", "net.sourceforge.mlf.metouia.MetouiaMenuBarUI", "MenuUI", "net.sourceforge.mlf.metouia.MetouiaMenuUI", "ScrollBarUI", "net.sourceforge.mlf.metouia.MetouiaScrollBarUI", "TabbedPaneUI", "net.sourceforge.mlf.metouia.MetouiaTabbedPaneUI", "ToggleButtonUI", "net.sourceforge.mlf.metouia.MetouiaToggleButtonUI", "PasswordFieldUI", "net.sourceforge.mlf.metouia.MetouiaPasswordFieldUI", "ScrollPaneUI", "net.sourceforge.mlf.metouia.MetouiaScrollPaneUI", "ProgressBarUI", "net.sourceforge.mlf.metouia.MetouiaProgressBarUI", "TableHeaderUI", "net.sourceforge.mlf.metouia.MetouiaTableHeaderUI", "InternalFrameUI", "net.sourceforge.mlf.metouia.MetouiaInternalFrameUI"});
    }

    protected void createDefaultTheme() {
        if (!themeHasBeenSet) {
            metouiaTheme = new MetouiaDefaultTheme();
            MetouiaLookAndFeel.setCurrentTheme(metouiaTheme);
        }
    }

    public static void setCurrentTheme(MetalTheme metalTheme) {
        MetalLookAndFeel.setCurrentTheme(metalTheme);
        themeHasBeenSet = true;
    }

    protected void initSystemColorDefaults(UIDefaults uIDefaults) {
        super.initSystemColorDefaults(uIDefaults);
        uIDefaults.put("textHighlight", MetalLookAndFeel.getTextHighlightColor());
    }

    protected void initComponentDefaults(UIDefaults uIDefaults) {
        super.initComponentDefaults(uIDefaults);
        uIDefaults.put("Button.border", MetouiaBorderUtilities.getButtonBorder());
        uIDefaults.put("ToggleButton.border", MetouiaBorderUtilities.getToggleButtonBorder());
        uIDefaults.put("TextField.border", MetouiaBorderUtilities.getTextFieldBorder());
        uIDefaults.put("ToolBar.border", new MetouiaToolBarBorder());
        uIDefaults.put("MenuBar.border", new MetouiaMenuBarBorder());
        uIDefaults.put("ScrollPane.border", new MetouiaScrollPaneBorder());
        uIDefaults.put("InternalFrame.border", new MetouiaInternalFrameBorder());
        uIDefaults.put("InternalFrame.paletteBorder", new MetouiaPaletteBorder());
        uIDefaults.put("InternalFrame.optionDialogBorder", new MetouiaOptionDialogBorder());
        MetouiaMenuItemBorder metouiaMenuItemBorder = new MetouiaMenuItemBorder();
        uIDefaults.put("Menu.border", metouiaMenuItemBorder);
        uIDefaults.put("MenuItem.border", metouiaMenuItemBorder);
        uIDefaults.put("CheckBoxMenuItem.border", metouiaMenuItemBorder);
        uIDefaults.put("RadioButtonMenuItem.border", metouiaMenuItemBorder);
        uIDefaults.put("PopupMenu.border", new MetouiaPopupMenuBorder());
        uIDefaults.put("TableHeader.cellBorder", new MetouiaTableHeaderBorder());
        uIDefaults.put("SplitPane.dividerSize", new Integer(6));
        uIDefaults.put("InternalFrame.paletteTitleHeight", new Integer(13));
        uIDefaults.put("InternalFrame.frameTitleHeight", new Integer(21));
        uIDefaults.put("TabbedPane.contentBorderInsets", new Insets(4, 4, 3, 3));
        uIDefaults.put("Button.select", metouiaTheme.getPressedBackground());
        uIDefaults.put("RadioButton.select", metouiaTheme.getPressedBackground());
        uIDefaults.put("ToggleButton.select", metouiaTheme.getPressedBackground());
        uIDefaults.put("Checkbox.select", metouiaTheme.getPressedBackground());
        uIDefaults.put("TabbedPane.unselected", metouiaTheme.getPressedBackground());
        uIDefaults.put("InternalFrame.icon", MetouiaLookAndFeel.loadIcon("default.gif", this));
        uIDefaults.put("InternalFrame.paletteCloseIcon", MetouiaLookAndFeel.loadIcon("pclose.gif", this));
        uIDefaults.put("InternalFrame.closeIcon", MetouiaLookAndFeel.loadIcon("close.gif", this));
        uIDefaults.put("InternalFrame.maximizeIcon", MetouiaLookAndFeel.loadIcon("maximize.gif", this));
        uIDefaults.put("InternalFrame.iconifyIcon", MetouiaLookAndFeel.loadIcon("minimize.gif", this));
        uIDefaults.put("InternalFrame.minimizeIcon", MetouiaLookAndFeel.loadIcon("restore.gif", this));
    }

    static ImageIcon loadIcon(String string, Object object) {
        string = "/net/sourceforge/mlf/metouia/icons/" + string;
        try {
            return new ImageIcon(Toolkit.getDefaultToolkit().createImage(MetouiaLookAndFeel.readStream(object.getClass().getResourceAsStream(string))));
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.out.println("Error getting resource " + string);
            return null;
        }
    }

    static final byte[] readStream(InputStream inputStream) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] byArray = new byte[256];
        try {
            int n;
            while ((n = inputStream.read(byArray, 0, 256)) != -1) {
                byteArrayOutputStream.write(byArray, 0, n);
            }
        }
        catch (IOException iOException) {
            throw (IOException)iOException.fillInStackTrace();
        }
        return byteArrayOutputStream.toByteArray();
    }

    public static Color getGradientReflection() {
        return metouiaTheme.getGradientReflection();
    }

    public static Color getGradientShadow() {
        return metouiaTheme.getGradientShadow();
    }

    public static Color getGradientTranslucentReflection() {
        return metouiaTheme.getGradientTranslucentReflection();
    }

    public static Color getGradientTranslucentShadow() {
        return metouiaTheme.getGradientTranslucentShadow();
    }

    public MetouiaLookAndFeel() {
        if (!isInstalled) {
            isInstalled = true;
            UIManager.installLookAndFeel(new UIManager.LookAndFeelInfo("Metouia", "net.sourceforge.mlf.metouia.MetouiaLookAndFeel"));
        }
    }

    static {
        isInstalled = false;
        themeHasBeenSet = false;
    }
}

