/*
 * Decompiled with CFR 0.152.
 */
package free.jin.board.fics;

import free.freechess.Ivar;
import free.jin.Connection;
import free.jin.Game;
import free.jin.Preferences;
import free.jin.board.BoardManager;
import free.jin.board.BoardPanel;
import free.jin.board.fics.FreechessBoardPanel;
import free.jin.event.GameEndEvent;
import free.jin.event.GameStartEvent;
import free.jin.freechess.FreechessListenerManager;
import free.jin.freechess.JinFreechessConnection;
import free.jin.freechess.event.IvarStateChangeEvent;
import free.jin.freechess.event.IvarStateChangeListener;
import free.jin.plugin.PluginUIEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;

public class FreechessBoardManager
extends BoardManager
implements IvarStateChangeListener {
    private Object primaryObservedGameID = null;
    private Object primaryPlayedGameID = null;

    public FreechessBoardManager() {
        this.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if ("moveSendingMode".equals(propertyChangeEvent.getPropertyName())) {
                    Integer n = (Integer)propertyChangeEvent.getOldValue();
                    Integer n2 = (Integer)propertyChangeEvent.getNewValue();
                    Integer n3 = new Integer(3);
                    if (!n2.equals(n) && (n3.equals(n2) || n3.equals(n))) {
                        JinFreechessConnection jinFreechessConnection = (JinFreechessConnection)FreechessBoardManager.this.getConn();
                        jinFreechessConnection.setIvarState(Ivar.PREMOVE, n3.equals(n2));
                    }
                }
            }
        });
    }

    protected void registerConnListeners() {
        super.registerConnListeners();
        FreechessListenerManager freechessListenerManager = ((JinFreechessConnection)this.getConn()).getFreechessListenerManager();
        freechessListenerManager.addIvarStateChangeListener((IvarStateChangeListener)this);
    }

    protected void unregisterConnListeners() {
        super.unregisterConnListeners();
        FreechessListenerManager freechessListenerManager = ((JinFreechessConnection)this.getConn()).getFreechessListenerManager();
        freechessListenerManager.removeIvarStateChangeListener((IvarStateChangeListener)this);
    }

    protected BoardPanel createBoardPanel(Game game) {
        FreechessBoardPanel freechessBoardPanel = new FreechessBoardPanel(this, game);
        return freechessBoardPanel;
    }

    public void pluginUIActivated(PluginUIEvent pluginUIEvent) {
        BoardPanel boardPanel = (BoardPanel)this.containersToBoardPanels.get(pluginUIEvent.getSource());
        if (boardPanel == null) {
            return;
        }
        Game game = boardPanel.getGame();
        Object object = game.getID();
        if (boardPanel.isActive()) {
            int n = game.getGameType();
            Connection connection = this.getConn();
            if (n == 2) {
                if (!object.equals(this.primaryObservedGameID)) {
                    connection.sendCommand("$$primary " + object);
                    this.primaryObservedGameID = object;
                }
            } else if (n == 1 && !object.equals(this.primaryPlayedGameID)) {
                connection.sendCommand("$$goboard " + object);
                this.primaryPlayedGameID = object;
            }
        }
        super.pluginUIActivated(pluginUIEvent);
    }

    public void gameStarted(GameStartEvent gameStartEvent) {
        Game game = gameStartEvent.getGame();
        int n = game.getGameType();
        Object object = game.getID();
        if (n == 2 && this.primaryObservedGameID == null) {
            this.primaryObservedGameID = object;
        } else if (n == 1 && this.primaryPlayedGameID == null) {
            this.primaryPlayedGameID = object;
        }
        super.gameStarted(gameStartEvent);
    }

    public void gameEnded(GameEndEvent gameEndEvent) {
        Game game = gameEndEvent.getGame();
        int n = game.getGameType();
        Object object = game.getID();
        if (n == 2 && object.equals(this.primaryObservedGameID)) {
            this.primaryObservedGameID = null;
        } else if (n == 1 && object.equals(this.primaryPlayedGameID)) {
            this.primaryPlayedGameID = null;
        }
        super.gameEnded(gameEndEvent);
    }

    public void ivarStateChanged(IvarStateChangeEvent ivarStateChangeEvent) {
        if (ivarStateChangeEvent.getIvar() == Ivar.PREMOVE && !ivarStateChangeEvent.getState() && this.getMoveSendingMode() == 3) {
            this.setMoveSendingMode(1);
        }
    }

    public void loginSucceeded(Connection connection) {
        super.loginSucceeded(connection);
        Preferences preferences = this.getPrefs();
        if (preferences.getBool("setDefaultAutoflagValue", true)) {
            connection.sendCommand("$set autoflag 1");
            preferences.setBool("setDefaultAutoflagValue", false);
        }
    }
}

