/*
 * Decompiled with CFR 0.152.
 */
package free.workarounds;

import free.workarounds.FixUtils;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import javax.swing.BoundedRangeModel;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.text.Document;

public class FixedJTextField
extends JTextField {
    public FixedJTextField() {
    }

    public FixedJTextField(Document document, String string, int n) {
        super(document, string, n);
    }

    public FixedJTextField(String string) {
        super(string);
    }

    public FixedJTextField(int n) {
        super(n);
    }

    public FixedJTextField(String string, int n) {
        super(string, n);
    }

    public void scrollRectToVisible(Rectangle rectangle) {
        Insets insets = this.getInsets();
        BoundedRangeModel boundedRangeModel = this.getHorizontalVisibility();
        int n = rectangle.x + boundedRangeModel.getValue() - insets.left;
        if (n < boundedRangeModel.getValue()) {
            boundedRangeModel.setValue(n);
        } else if (n > boundedRangeModel.getValue() + boundedRangeModel.getExtent()) {
            boundedRangeModel.setValue(n - boundedRangeModel.getExtent());
        }
    }

    public void setEditable(boolean bl) {
        super.setEditable(bl);
        Cursor cursor = this.getCursor();
        if (this.isEditable() && (cursor == null || cursor.getType() != 2)) {
            this.setCursor(Cursor.getPredefinedCursor(2));
        } else if (!(this.isEditable() || cursor != null && cursor.getType() == 0)) {
            this.setCursor(Cursor.getPredefinedCursor(0));
        }
        this.updateInactiveColor();
    }

    public void updateUI() {
        super.updateUI();
        this.updateInactiveColor();
    }

    protected void updateInactiveColor() {
        Color color;
        String string = UIManager.getLookAndFeel().getClass().getName();
        if (string.equals("com.sun.java.swing.plaf.windows.WindowsLookAndFeel") && (color = UIManager.getColor("TextField.inactiveBackground")) == null) {
            if (!this.isEditable()) {
                this.setBackground(UIManager.getColor("Panel.background"));
            } else {
                this.setBackground(UIManager.getColor("TextField.background"));
            }
        }
    }

    protected void processComponentKeyEvent(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 10 && this.listenerList.getListenerCount(ActionListener.class) == 0) {
            return;
        }
        super.processComponentKeyEvent(keyEvent);
    }

    public void paste() {
        int n;
        try {
            super.paste();
        }
        catch (RuntimeException runtimeException) {
            if (runtimeException.getClass().getName().equals("com.ms.security.SecurityExceptionEx")) {
                FixUtils.fakePaste(this);
            }
            throw runtimeException;
        }
        int n2 = this.getCaretPosition();
        String string = this.getText();
        while ((n = string.indexOf("\r\n")) != -1) {
            string = string.substring(0, n) + " " + string.substring(n + 2);
            if (n >= n2) continue;
            --n2;
        }
        string = string.replace('\n', ' ').replace('\r', ' ');
        this.setText(string);
        this.setCaretPosition(n2);
    }

    public void copy() {
        try {
            super.copy();
        }
        catch (RuntimeException runtimeException) {
            if (runtimeException.getClass().getName().equals("com.ms.security.SecurityExceptionEx")) {
                FixUtils.fakeCopy(this);
            }
            throw runtimeException;
        }
    }

    public void cut() {
        try {
            super.cut();
        }
        catch (RuntimeException runtimeException) {
            if (runtimeException.getClass().getName().equals("com.ms.security.SecurityExceptionEx")) {
                FixUtils.fakeCut(this);
            }
            throw runtimeException;
        }
    }
}

