/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.checkers;

import com.intellij.psi.PsiElement;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.StandardNames;
import org.jetbrains.kotlin.config.ApiVersion;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyGetterDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.Annotated;
import org.jetbrains.kotlin.diagnostics.DiagnosticSink;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtReferenceExpression;
import org.jetbrains.kotlin.psi.KtThisExpression;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.checkers.CallCheckerContext;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.scopes.HierarchicalScope;
import org.jetbrains.kotlin.resolve.scopes.LexicalScope;
import org.jetbrains.kotlin.resolve.scopes.LexicalScopeKind;
import org.jetbrains.kotlin.resolve.scopes.receivers.ExpressionReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.kotlin.resolve.scopes.utils.ScopeUtilsKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000^\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\n\u0010\u0004\u001a\u00020\u0005*\u00020\u0001\u001a\n\u0010\u0004\u001a\u00020\u0005*\u00020\u0006\u001a\n\u0010\u0004\u001a\u00020\u0005*\u00020\u0007\u001a\u0010\u0010\u000b\u001a\u0004\u0018\u00010\u00062\u0006\u0010\f\u001a\u00020\r\u001a\u0014\u0010\u000e\u001a\u00020\u0005*\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0006H\u0002\u001a\u001e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018\u001a\n\u0010\u0019\u001a\u00020\u0005*\u00020\u001a\u001a\n\u0010\u001b\u001a\u00020\u0005*\u00020\u0006\u001a,\u0010\u001c\u001a\u00020\u00122\u0006\u0010\u001d\u001a\u00020\u001e2\n\u0010\u001f\u001a\u0006\u0012\u0002\b\u00030 2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\f\u001a\u00020\rH\u0002\"\u0011\u0010\u0000\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0003\"\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"COROUTINE_CONTEXT_FQ_NAME", "Lorg/jetbrains/kotlin/name/FqName;", "getCOROUTINE_CONTEXT_FQ_NAME", "()Lorg/jetbrains/kotlin/name/FqName;", "isBuiltInCoroutineContext", "", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "Lorg/jetbrains/kotlin/descriptors/PropertyDescriptor;", "ALLOWED_SCOPE_KINDS", "", "Lorg/jetbrains/kotlin/resolve/scopes/LexicalScopeKind;", "findEnclosingSuspendFunction", "context", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallCheckerContext;", "isScopeForDefaultParameterValuesOf", "Lorg/jetbrains/kotlin/resolve/scopes/HierarchicalScope;", "enclosingSuspendFunction", "checkCoroutinesFeature", "", "languageVersionSettings", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "diagnosticHolder", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticSink;", "reportOn", "Lcom/intellij/psi/PsiElement;", "isRestrictsSuspensionReceiver", "Lorg/jetbrains/kotlin/types/KotlinType;", "isRestrictedSuspendFunction", "checkRestrictsSuspension", "enclosingSuspendCallableDescriptor", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "resolvedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "frontend"})
@SourceDebugExtension(value={"SMAP\ncoroutineCallChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 coroutineCallChecker.kt\norg/jetbrains/kotlin/resolve/calls/checkers/CoroutineCallCheckerKt\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,199:1\n183#2,2:200\n1761#3,3:202\n*S KotlinDebug\n*F\n+ 1 coroutineCallChecker.kt\norg/jetbrains/kotlin/resolve/calls/checkers/CoroutineCallCheckerKt\n*L\n50#1:200,2\n135#1:202,3\n*E\n"})
public final class CoroutineCallCheckerKt {
    @NotNull
    private static final FqName COROUTINE_CONTEXT_FQ_NAME;
    @NotNull
    private static final Set<LexicalScopeKind> ALLOWED_SCOPE_KINDS;

    @NotNull
    public static final FqName getCOROUTINE_CONTEXT_FQ_NAME() {
        return COROUTINE_CONTEXT_FQ_NAME;
    }

    public static final boolean isBuiltInCoroutineContext(@NotNull FqName $this$isBuiltInCoroutineContext) {
        Intrinsics.checkNotNullParameter($this$isBuiltInCoroutineContext, "<this>");
        Name name2 = Name.identifier("coroutineContext");
        Intrinsics.checkNotNullExpressionValue(name2, "identifier(...)");
        return Intrinsics.areEqual($this$isBuiltInCoroutineContext, StandardNames.COROUTINES_PACKAGE_FQ_NAME.child(name2));
    }

    public static final boolean isBuiltInCoroutineContext(@NotNull FunctionDescriptor $this$isBuiltInCoroutineContext) {
        Intrinsics.checkNotNullParameter($this$isBuiltInCoroutineContext, "<this>");
        Object object = $this$isBuiltInCoroutineContext instanceof PropertyGetterDescriptor ? (PropertyGetterDescriptor)$this$isBuiltInCoroutineContext : null;
        return object != null && (object = object.getCorrespondingProperty()) != null && (object = DescriptorUtilsKt.getFqNameSafe((DeclarationDescriptor)object)) != null ? CoroutineCallCheckerKt.isBuiltInCoroutineContext((FqName)object) : false;
    }

    public static final boolean isBuiltInCoroutineContext(@NotNull PropertyDescriptor $this$isBuiltInCoroutineContext) {
        Intrinsics.checkNotNullParameter($this$isBuiltInCoroutineContext, "<this>");
        return CoroutineCallCheckerKt.isBuiltInCoroutineContext(DescriptorUtilsKt.getFqNameSafe($this$isBuiltInCoroutineContext));
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public static final FunctionDescriptor findEnclosingSuspendFunction(@NotNull CallCheckerContext context) {
        block3: {
            Intrinsics.checkNotNullParameter(context, "context");
            $this$firstOrNull$iv = ScopeUtilsKt.getParentsWithSelf(context.getScope());
            $i$f$firstOrNull = false;
            var4_3 = $this$firstOrNull$iv.iterator();
            while (var4_3.hasNext()) {
                it = element$iv = var4_3.next();
                $i$a$-firstOrNull-CoroutineCallCheckerKt$findEnclosingSuspendFunction$scope$1 = false;
                if (!(it instanceof LexicalScope) || !CoroutineCallCheckerKt.ALLOWED_SCOPE_KINDS.contains((Object)((LexicalScope)it).getKind())) ** GOTO lbl-1000
                var8_7 = ((LexicalScope)it).getOwnerDescriptor();
                v0 = var8_7 instanceof FunctionDescriptor != false ? (FunctionDescriptor)var8_7 : null;
                v1 = v0 != null ? v0.isSuspend() : false;
                if (v1) {
                    v2 = true;
                } else lbl-1000:
                // 2 sources

                {
                    v2 = false;
                }
                if (!v2) continue;
                v3 = element$iv;
                break block3;
            }
            v3 = null;
        }
        v4 = scope = (LexicalScope)v3;
        return (FunctionDescriptor)(v4 != null ? v4.getOwnerDescriptor() : null);
    }

    private static final boolean isScopeForDefaultParameterValuesOf(HierarchicalScope $this$isScopeForDefaultParameterValuesOf, FunctionDescriptor enclosingSuspendFunction) {
        return $this$isScopeForDefaultParameterValuesOf instanceof LexicalScope && ((LexicalScope)$this$isScopeForDefaultParameterValuesOf).getKind() == LexicalScopeKind.DEFAULT_VALUE && Intrinsics.areEqual(((LexicalScope)$this$isScopeForDefaultParameterValuesOf).getOwnerDescriptor(), enclosingSuspendFunction);
    }

    public static final void checkCoroutinesFeature(@NotNull LanguageVersionSettings languageVersionSettings, @NotNull DiagnosticSink diagnosticHolder, @NotNull PsiElement reportOn) {
        Intrinsics.checkNotNullParameter(languageVersionSettings, "languageVersionSettings");
        Intrinsics.checkNotNullParameter(diagnosticHolder, "diagnosticHolder");
        Intrinsics.checkNotNullParameter(reportOn, "reportOn");
        if (languageVersionSettings.supportsFeature(LanguageFeature.ReleaseCoroutines)) {
            if (languageVersionSettings.getApiVersion().compareTo(ApiVersion.KOTLIN_1_3) < 0) {
                diagnosticHolder.report(Errors.UNSUPPORTED.on(reportOn, "cannot use release coroutines with api version less than 1.3"));
            }
            return;
        }
    }

    public static final boolean isRestrictsSuspensionReceiver(@NotNull KotlinType $this$isRestrictsSuspensionReceiver) {
        boolean bl;
        block5: {
            Intrinsics.checkNotNullParameter($this$isRestrictsSuspensionReceiver, "<this>");
            Iterable $this$any$iv = CollectionsKt.plus((Collection)CollectionsKt.listOf($this$isRestrictsSuspensionReceiver), (Iterable)TypeUtilsKt.supertypes($this$isRestrictsSuspensionReceiver));
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    boolean bl2;
                    KotlinType it = (KotlinType)element$iv;
                    boolean bl3 = false;
                    Object object = it.getConstructor().getDeclarationDescriptor();
                    if (object != null && (object = object.getAnnotations()) != null) {
                        Name name2 = Name.identifier("RestrictsSuspension");
                        Intrinsics.checkNotNullExpressionValue(name2, "identifier(...)");
                        bl2 = object.hasAnnotation(StandardNames.COROUTINES_PACKAGE_FQ_NAME.child(name2));
                    } else {
                        bl2 = false;
                    }
                    if (!bl2) continue;
                    bl = true;
                    break block5;
                }
                bl = false;
            }
        }
        return bl;
    }

    public static final boolean isRestrictedSuspendFunction(@NotNull FunctionDescriptor $this$isRestrictedSuspendFunction) {
        Intrinsics.checkNotNullParameter($this$isRestrictedSuspendFunction, "<this>");
        Annotated annotated = $this$isRestrictedSuspendFunction.getExtensionReceiverParameter();
        return annotated != null && (annotated = annotated.getType()) != null ? CoroutineCallCheckerKt.isRestrictsSuspensionReceiver((KotlinType)annotated) : false;
    }

    private static final void checkRestrictsSuspension(CallableDescriptor enclosingSuspendCallableDescriptor, ResolvedCall<?> resolvedCall2, PsiElement reportOn, CallCheckerContext context2) {
        ReceiverParameterDescriptor receiverParameterDescriptor = enclosingSuspendCallableDescriptor.getExtensionReceiverParameter();
        ReceiverValue enclosingSuspendExtensionReceiverValue = receiverParameterDescriptor != null ? receiverParameterDescriptor.getValue() : null;
        ReceiverParameterDescriptor receiverParameterDescriptor2 = enclosingSuspendCallableDescriptor.getDispatchReceiverParameter();
        ReceiverValue enclosingSuspendDispatchReceiverValue = receiverParameterDescriptor2 != null ? receiverParameterDescriptor2.getValue() : null;
        ReceiverValue[] receiverValueArray = new ReceiverValue[]{resolvedCall2.getDispatchReceiver(), resolvedCall2.getExtensionReceiver()};
        List<ReceiverValue> receivers = CollectionsKt.listOfNotNull(receiverValueArray);
        for (ReceiverValue receiverValue : receivers) {
            if (!CoroutineCallCheckerKt.checkRestrictsSuspension$isRestrictsSuspensionReceiver(receiverValue)) continue;
            ReceiverValue receiverValue2 = enclosingSuspendExtensionReceiverValue;
            if (receiverValue2 != null ? CoroutineCallCheckerKt.checkRestrictsSuspension$sameInstance(receiverValue2, context2, receiverValue) : false) continue;
            ReceiverValue receiverValue3 = enclosingSuspendDispatchReceiverValue;
            if (receiverValue3 != null ? CoroutineCallCheckerKt.checkRestrictsSuspension$sameInstance(receiverValue3, context2, receiverValue) : false) continue;
            CoroutineCallCheckerKt.checkRestrictsSuspension$reportError(context2, reportOn);
            return;
        }
        ReceiverValue receiverValue = enclosingSuspendExtensionReceiverValue;
        if (!(receiverValue != null ? CoroutineCallCheckerKt.checkRestrictsSuspension$isRestrictsSuspensionReceiver(receiverValue) : false)) {
            return;
        }
        if (CoroutineCallCheckerKt.checkRestrictsSuspension$sameInstance(enclosingSuspendExtensionReceiverValue, context2, resolvedCall2.getDispatchReceiver())) {
            return;
        }
        if (CoroutineCallCheckerKt.checkRestrictsSuspension$sameInstance(enclosingSuspendExtensionReceiverValue, context2, resolvedCall2.getExtensionReceiver())) {
            ReceiverParameterDescriptor receiverParameterDescriptor3 = resolvedCall2.getCandidateDescriptor().getExtensionReceiverParameter();
            Intrinsics.checkNotNull(receiverParameterDescriptor3);
            ReceiverValue receiverValue4 = receiverParameterDescriptor3.getValue();
            Intrinsics.checkNotNullExpressionValue(receiverValue4, "getValue(...)");
            if (CoroutineCallCheckerKt.checkRestrictsSuspension$isRestrictsSuspensionReceiver(receiverValue4)) {
                return;
            }
        }
        CoroutineCallCheckerKt.checkRestrictsSuspension$reportError(context2, reportOn);
    }

    private static final boolean checkRestrictsSuspension$isRestrictsSuspensionReceiver(ReceiverValue $this$checkRestrictsSuspension_u24isRestrictsSuspensionReceiver) {
        KotlinType kotlinType = $this$checkRestrictsSuspension_u24isRestrictsSuspensionReceiver.getType();
        Intrinsics.checkNotNullExpressionValue(kotlinType, "getType(...)");
        return CoroutineCallCheckerKt.isRestrictsSuspensionReceiver(kotlinType);
    }

    private static final boolean checkRestrictsSuspension$sameInstance(ReceiverValue $this$checkRestrictsSuspension_u24sameInstance, CallCheckerContext $context, ReceiverValue other) {
        ReceiverValue receiverValue;
        DeclarationDescriptor referenceTarget;
        DeclarationDescriptor declarationDescriptor;
        KtReferenceExpression referenceExpression;
        if (other == null) {
            return false;
        }
        if ($this$checkRestrictsSuspension_u24sameInstance.getOriginal() == other.getOriginal()) {
            return true;
        }
        ExpressionReceiver expressionReceiver = other instanceof ExpressionReceiver ? (ExpressionReceiver)other : null;
        KtExpression ktExpression = expressionReceiver != null ? expressionReceiver.getExpression() : null;
        KtThisExpression ktThisExpression = ktExpression instanceof KtThisExpression ? (KtThisExpression)ktExpression : null;
        KtReferenceExpression ktReferenceExpression = referenceExpression = ktThisExpression != null ? ktThisExpression.getInstanceReference() : null;
        if (ktReferenceExpression != null) {
            KtReferenceExpression it = ktReferenceExpression;
            boolean bl = false;
            declarationDescriptor = (DeclarationDescriptor)$context.getTrace().get(BindingContext.REFERENCE_TARGET, referenceExpression);
        } else {
            declarationDescriptor = null;
        }
        DeclarationDescriptor declarationDescriptor2 = referenceTarget = declarationDescriptor;
        if (declarationDescriptor2 instanceof CallableDescriptor) {
            ReceiverParameterDescriptor receiverParameterDescriptor = ((CallableDescriptor)referenceTarget).getExtensionReceiverParameter();
            receiverValue = receiverParameterDescriptor != null ? receiverParameterDescriptor.getValue() : null;
        } else {
            receiverValue = declarationDescriptor2 instanceof ClassDescriptor ? ((ClassDescriptor)referenceTarget).getThisAsReceiverParameter().getValue() : null;
        }
        ReceiverValue referenceReceiverValue = receiverValue;
        return $this$checkRestrictsSuspension_u24sameInstance == referenceReceiverValue;
    }

    private static final void checkRestrictsSuspension$reportError(CallCheckerContext $context, PsiElement $reportOn) {
        $context.getTrace().report(Errors.ILLEGAL_RESTRICTED_SUSPENDING_FUNCTION_CALL.on($reportOn));
    }

    public static final /* synthetic */ void access$checkRestrictsSuspension(CallableDescriptor enclosingSuspendCallableDescriptor, ResolvedCall resolvedCall2, PsiElement reportOn, CallCheckerContext context2) {
        CoroutineCallCheckerKt.checkRestrictsSuspension(enclosingSuspendCallableDescriptor, resolvedCall2, reportOn, context2);
    }

    public static final /* synthetic */ boolean access$isScopeForDefaultParameterValuesOf(HierarchicalScope $receiver, FunctionDescriptor enclosingSuspendFunction) {
        return CoroutineCallCheckerKt.isScopeForDefaultParameterValuesOf($receiver, enclosingSuspendFunction);
    }

    static {
        Name name2 = Name.identifier("coroutineContext");
        Intrinsics.checkNotNullExpressionValue(name2, "identifier(...)");
        COROUTINE_CONTEXT_FQ_NAME = StandardNames.COROUTINES_PACKAGE_FQ_NAME.child(name2);
        LexicalScopeKind[] lexicalScopeKindArray = new LexicalScopeKind[]{LexicalScopeKind.FUNCTION_INNER_SCOPE, LexicalScopeKind.FUNCTION_HEADER_FOR_DESTRUCTURING};
        ALLOWED_SCOPE_KINDS = SetsKt.setOf(lexicalScopeKindArray);
    }
}

