/*
 * Decompiled with CFR 0.152.
 */
package org.wiztools.restclient.ui.reqbody;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import org.wiztools.restclient.bean.MultipartMode;
import org.wiztools.restclient.bean.MultipartSubtype;
import org.wiztools.restclient.bean.ReqEntity;
import org.wiztools.restclient.bean.ReqEntityFilePart;
import org.wiztools.restclient.bean.ReqEntityMultipart;
import org.wiztools.restclient.bean.ReqEntityMultipartBean;
import org.wiztools.restclient.bean.ReqEntityPart;
import org.wiztools.restclient.bean.ReqEntityStringPart;
import org.wiztools.restclient.ui.RESTView;
import org.wiztools.restclient.ui.UIUtil;
import org.wiztools.restclient.ui.reqbody.AddMultipartFileDialog;
import org.wiztools.restclient.ui.reqbody.AddMultipartPartListener;
import org.wiztools.restclient.ui.reqbody.AddMultipartStringDialog;
import org.wiztools.restclient.ui.reqbody.MultipartOptionsDialog;
import org.wiztools.restclient.ui.reqbody.ReqBodyPanel;

public class ReqBodyPanelMultipart
extends JPanel
implements ReqBodyPanel {
    @Inject
    private RESTView view;
    @Inject
    private AddMultipartFileDialog jd_addFileDialog;
    @Inject
    private AddMultipartStringDialog jd_addStringDialog;
    @Inject
    private MultipartOptionsDialog jd_options;
    private final JButton jb_string = new JButton("String");
    private final JButton jb_file = new JButton("File");
    private final JButton jb_config = new JButton(UIUtil.getIconFromClasspath("org/wiztools/restclient/cog.png"));
    private final MultipartTableModel model = new MultipartTableModel();
    private final JTable jt = new JTable(this.model);

    @PostConstruct
    protected void init() {
        AddMultipartPartListener listener = new AddMultipartPartListener(){

            @Override
            public void addPart(ReqEntityPart part) {
                ReqBodyPanelMultipart.this.model.addPartFirst(part);
            }
        };
        this.jd_addStringDialog.addMultipartPartListener(listener);
        this.jd_addFileDialog.addMultipartPartListener(listener);
        JPopupMenu menu = new JPopupMenu();
        JMenuItem jmi_rm = new JMenuItem("Delete selected");
        jmi_rm.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int[] rows = ReqBodyPanelMultipart.this.jt.getSelectedRows();
                Arrays.sort(rows);
                if (rows != null && rows.length > 0) {
                    int i = 0;
                    for (int row : rows) {
                        ReqBodyPanelMultipart.this.model.removeRow(row -= i);
                        ++i;
                    }
                    ReqBodyPanelMultipart.this.view.setStatusMessage(MessageFormat.format("Deleted {0} row(s)", i));
                } else {
                    ReqBodyPanelMultipart.this.view.setStatusMessage("No row(s) selected!");
                }
            }
        });
        menu.add(jmi_rm);
        JMenuItem jmi_view = new JMenuItem("Quick view");
        jmi_view.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ReqBodyPanelMultipart.this.quickView();
            }
        });
        menu.add(jmi_view);
        this.jt.setComponentPopupMenu(menu);
        this.setLayout(new BorderLayout());
        JPanel jp_border = new JPanel(new BorderLayout(0, 0));
        JPanel jp_center = new JPanel(new FlowLayout(0));
        jp_center.add(new JLabel("Add Part: "));
        this.jb_string.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ReqBodyPanelMultipart.this.jd_addStringDialog.setVisible(true);
            }
        });
        jp_center.add(this.jb_string);
        this.jb_file.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ReqBodyPanelMultipart.this.jd_addFileDialog.setVisible(true);
            }
        });
        jp_center.add(this.jb_file);
        jp_border.add((Component)jp_center, "Center");
        JPanel jp_east = new JPanel(new FlowLayout(2));
        this.jb_config.setToolTipText("Set multipart mode");
        this.jb_config.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ReqBodyPanelMultipart.this.jd_options.setVisible(true);
            }
        });
        jp_east.add(this.jb_config);
        jp_border.add((Component)jp_east, "East");
        this.add((Component)jp_border, "North");
        JScrollPane jsp = new JScrollPane(this.jt);
        this.add((Component)jsp, "Center");
    }

    private void quickView() {
        int row = this.jt.getSelectedRow();
        if (row != -1) {
            ReqEntityPart entity = this.model.getEntityInRow(row);
            this.view.showMessage("Quick View", entity.toString());
        }
    }

    @Override
    public void enableBody() {
        this.jb_string.setEnabled(true);
        this.jb_file.setEnabled(true);
        this.jb_config.setEnabled(true);
        this.jt.setEnabled(true);
        this.jd_options.setEnabled(true);
    }

    @Override
    public void disableBody() {
        this.jb_string.setEnabled(false);
        this.jb_file.setEnabled(false);
        this.jb_config.setEnabled(false);
        this.jt.setEnabled(false);
        this.jd_options.setEnabled(false);
    }

    @Override
    public void clear() {
        this.jd_options.clear();
        this.model.clear();
    }

    @Override
    public void setEntity(ReqEntity entity) {
        if (entity instanceof ReqEntityMultipart) {
            ReqEntityMultipart e = (ReqEntityMultipart)entity;
            MultipartSubtype type = e.getSubtype();
            this.jd_options.setSelectedSubtype(type);
            MultipartMode mode = e.getMode();
            this.jd_options.setSelectedMode(mode);
            List<ReqEntityPart> parts = e.getBody();
            for (ReqEntityPart part : parts) {
                this.model.addPartLast(part);
            }
        }
    }

    @Override
    public ReqEntity getEntity() {
        MultipartSubtype type = this.jd_options.getSelectedSubtype();
        MultipartMode mode = this.jd_options.getSelectedMode();
        ReqEntityMultipartBean entity = new ReqEntityMultipartBean((LinkedList)this.model.list.clone(), mode, type);
        return entity;
    }

    @Override
    public Component getComponent() {
        return this;
    }

    private class MultipartTableModel
    extends AbstractTableModel {
        private final String[] columnNames = new String[]{"Type", "Content-type", "Name", "Part"};
        private final LinkedList<ReqEntityPart> list = new LinkedList();

        private MultipartTableModel() {
        }

        @Override
        public int getRowCount() {
            return this.list.size();
        }

        @Override
        public int getColumnCount() {
            return 4;
        }

        @Override
        public String getColumnName(int columnIndex) {
            return this.columnNames[columnIndex];
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            ReqEntityPart part = this.list.get(rowIndex);
            if (columnIndex == 0) {
                if (part instanceof ReqEntityStringPart) {
                    return "String";
                }
                if (part instanceof ReqEntityFilePart) {
                    return "File";
                }
            } else {
                if (columnIndex == 1) {
                    return part.getContentType();
                }
                if (columnIndex == 2) {
                    return part.getName();
                }
                if (part instanceof ReqEntityStringPart) {
                    return ((ReqEntityStringPart)part).getPart();
                }
                if (part instanceof ReqEntityFilePart) {
                    return ((ReqEntityFilePart)part).getPart();
                }
            }
            throw new IllegalArgumentException("Should never come here!");
        }

        public void addPartFirst(ReqEntityPart part) {
            this.list.addFirst(part);
            this.fireTableDataChanged();
        }

        public void addPartLast(ReqEntityPart part) {
            this.list.addLast(part);
            this.fireTableDataChanged();
        }

        public ReqEntityPart getEntityInRow(int row) {
            return this.list.get(row);
        }

        public void removeRow(int row) {
            this.list.remove(row);
            this.fireTableDataChanged();
        }

        public void clear() {
            this.list.clear();
            this.fireTableDataChanged();
        }
    }
}

