/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide;

import com.intellij.openapi.diagnostic.Logger;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import sun.awt.DisplayChangedListener;

public class DisplayChangeDetector {
    private static final Logger LOG = Logger.getInstance(DisplayChangeDetector.class);
    private static final DisplayChangeDetector INSTANCE = new DisplayChangeDetector();
    private final DisplayChangeHandler myHandler = new DisplayChangeHandler();
    private final List<Listener> myListeners = new CopyOnWriteArrayList<Listener>();

    public static DisplayChangeDetector getInstance() {
        return INSTANCE;
    }

    private DisplayChangeDetector() {
        try {
            GraphicsEnvironment env = GraphicsEnvironment.getLocalGraphicsEnvironment();
            env.getScreenDevices();
            Class<?> aClass = Class.forName("sun.awt.DisplayChangedListener");
            if (aClass.isInstance(env)) {
                env.getClass().getMethod("addDisplayChangedListener", aClass).invoke((Object)env, this.myHandler);
            }
        }
        catch (HeadlessException env) {
        }
        catch (Throwable t) {
            LOG.error("Cannot setup display change listener", t);
        }
    }

    public void addListener(Listener listener2) {
        this.myListeners.add(listener2);
    }

    public void removeListener(Listener listener2) {
        this.myListeners.remove(listener2);
    }

    private class DisplayChangeHandler
    implements DisplayChangedListener {
        private DisplayChangeHandler() {
        }

        @Override
        public void displayChanged() {
            this.runActions();
        }

        @Override
        public void paletteChanged() {
            this.runActions();
        }

        private void runActions() {
            for (Listener listener2 : DisplayChangeDetector.this.myListeners) {
                listener2.displayChanged();
            }
        }
    }

    public static interface Listener {
        public void displayChanged();
    }
}

