/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.idea.ActionsBundle;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.openapi.wm.ex.IdeFrameEx;
import java.awt.Component;
import java.awt.Window;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ToggleFullScreenAction
extends DumbAwareAction {
    private static final String TEXT_ENTER_FULL_SCREEN = ActionsBundle.message((String)"action.ToggleFullScreen.text.enter", (Object[])new Object[0]);
    private static final String TEXT_EXIT_FULL_SCREEN = ActionsBundle.message((String)"action.ToggleFullScreen.text.exit", (Object[])new Object[0]);

    public void actionPerformed(@NotNull AnActionEvent e) {
        IdeFrameEx frame;
        if (e == null) {
            ToggleFullScreenAction.$$$reportNull$$$0(0);
        }
        if ((frame = ToggleFullScreenAction.getFrame()) != null) {
            frame.toggleFullScreen(!frame.isInFullScreen());
        }
    }

    public void update(@NotNull AnActionEvent e) {
        boolean isApplicable;
        if (e == null) {
            ToggleFullScreenAction.$$$reportNull$$$0(1);
        }
        Presentation p = e.getPresentation();
        IdeFrameEx frame = null;
        boolean bl = isApplicable = WindowManager.getInstance().isFullScreenSupportedInCurrentOS() && (frame = ToggleFullScreenAction.getFrame()) != null;
        if (e.getPlace() != "MainToolbar") {
            p.setVisible(isApplicable);
        }
        p.setEnabled(isApplicable);
        if (isApplicable) {
            p.setText(frame.isInFullScreen() ? TEXT_EXIT_FULL_SCREEN : TEXT_ENTER_FULL_SCREEN);
        }
    }

    @Nullable
    private static IdeFrameEx getFrame() {
        Component focusOwner = IdeFocusManager.getGlobalInstance().getFocusOwner();
        if (focusOwner != null) {
            Window window;
            Window window2 = window = focusOwner instanceof JFrame ? (Window)focusOwner : SwingUtilities.getWindowAncestor(focusOwner);
            if (window != null && !(window instanceof IdeFrameEx)) {
                window = SwingUtilities.getWindowAncestor(window);
            }
            if (window instanceof IdeFrameEx) {
                return (IdeFrameEx)((Object)window);
            }
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "e";
        objectArray2[1] = "com/intellij/ide/actions/ToggleFullScreenAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

