/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.options.newEditor;

import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurableGroup;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.UnnamedConfigurable;
import com.intellij.openapi.options.ex.ConfigurableVisitor;
import com.intellij.openapi.options.ex.ConfigurableWrapper;
import com.intellij.openapi.options.ex.Settings;
import com.intellij.openapi.options.newEditor.AbstractEditor;
import com.intellij.openapi.options.newEditor.Banner;
import com.intellij.openapi.options.newEditor.ConfigurableController;
import com.intellij.openapi.options.newEditor.ConfigurableEditor;
import com.intellij.openapi.options.newEditor.ISettingsTreeViewFactory;
import com.intellij.openapi.options.newEditor.OptionsEditorColleague;
import com.intellij.openapi.options.newEditor.SettingsFilter;
import com.intellij.openapi.options.newEditor.SettingsSearch;
import com.intellij.openapi.options.newEditor.SettingsTreeView;
import com.intellij.openapi.options.newEditor.SpotlightPainter;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.LoadingDecorator;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.OnePixelSplitter;
import com.intellij.ui.SearchTextField;
import com.intellij.ui.components.panels.VerticalLayout;
import com.intellij.ui.treeStructure.SimpleNode;
import com.intellij.util.Alarm;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class SettingsEditor
extends AbstractEditor
implements DataProvider {
    private static final String SELECTED_CONFIGURABLE = "settings.editor.selected.configurable";
    private static final String SPLITTER_PROPORTION = "settings.editor.splitter.proportion";
    private static final float SPLITTER_PROPORTION_DEFAULT_VALUE = 0.2f;
    private final PropertiesComponent myProperties;
    private final Settings mySettings;
    private final SettingsSearch mySearch;
    private final JPanel mySearchPanel;
    private final SettingsFilter myFilter;
    private final SettingsTreeView myTreeView;
    private final ConfigurableEditor myEditor;
    private final OnePixelSplitter mySplitter;
    private final SpotlightPainter mySpotlightPainter;
    private final LoadingDecorator myLoadingDecorator;
    private final Banner myBanner;
    private final Map<Configurable, ConfigurableController> myControllers = new HashMap<Configurable, ConfigurableController>();
    private ConfigurableController myLastController;

    SettingsEditor(Disposable parent, Project project, ConfigurableGroup[] groups, Configurable configurable, String filter, ISettingsTreeViewFactory factory) {
        super(parent);
        String id;
        this.myProperties = PropertiesComponent.getInstance((Project)project);
        this.mySettings = new Settings(groups){

            @Override
            protected ActionCallback selectImpl(Configurable configurable) {
                SettingsEditor.this.myFilter.update((String)null, false, true);
                return SettingsEditor.this.myTreeView.select(configurable);
            }

            @Override
            public void revalidate() {
                SettingsEditor.this.myEditor.requestUpdate();
            }
        };
        this.mySearch = new SettingsSearch(){

            @Override
            void onTextKeyEvent(KeyEvent event) {
                ((SettingsEditor)SettingsEditor.this).myTreeView.myTree.processKeyEvent(event);
            }
        };
        this.mySearchPanel = new JPanel((LayoutManager)new VerticalLayout(0));
        this.mySearchPanel.add("CENTER", (Component)((Object)this.mySearch));
        this.myFilter = new SettingsFilter(project, groups, this.mySearch){

            @Override
            Configurable getConfigurable(SimpleNode node) {
                return SettingsTreeView.getConfigurable(node);
            }

            @Override
            SimpleNode findNode(Configurable configurable) {
                return SettingsEditor.this.myTreeView.findNode(configurable);
            }

            @Override
            void updateSpotlight(boolean now) {
                if (!SettingsEditor.this.myDisposed && SettingsEditor.this.mySpotlightPainter != null) {
                    if (!now) {
                        SettingsEditor.this.mySpotlightPainter.updateLater();
                    } else {
                        SettingsEditor.this.mySpotlightPainter.updateNow();
                    }
                }
            }
        };
        this.myFilter.myContext.addColleague(new OptionsEditorColleague(){

            @Override
            public ActionCallback onSelected(@Nullable Configurable configurable, Configurable oldConfigurable) {
                if (configurable != null) {
                    SettingsEditor.this.myProperties.setValue(SettingsEditor.SELECTED_CONFIGURABLE, ConfigurableVisitor.ByID.getID(configurable));
                    SettingsEditor.this.myLoadingDecorator.startLoading(false);
                }
                SettingsEditor.this.checkModified(oldConfigurable);
                ActionCallback result2 = SettingsEditor.this.myEditor.select(configurable);
                result2.doWhenDone(() -> {
                    SettingsEditor.this.updateController(configurable);
                    SettingsEditor.this.myLoadingDecorator.stopLoading();
                });
                return result2;
            }

            @Override
            public ActionCallback onModifiedAdded(Configurable configurable) {
                return this.updateIfCurrent(configurable);
            }

            @Override
            public ActionCallback onModifiedRemoved(Configurable configurable) {
                return this.updateIfCurrent(configurable);
            }

            @Override
            public ActionCallback onErrorsChanged() {
                return this.updateIfCurrent(((SettingsEditor)SettingsEditor.this).myFilter.myContext.getCurrentConfigurable());
            }

            private ActionCallback updateIfCurrent(Configurable configurable) {
                if (configurable != null && configurable == ((SettingsEditor)SettingsEditor.this).myFilter.myContext.getCurrentConfigurable()) {
                    SettingsEditor.this.updateStatus(configurable);
                    return ActionCallback.DONE;
                }
                return ActionCallback.REJECTED;
            }
        });
        this.myTreeView = factory.createTreeView(this.myFilter, groups);
        this.myTreeView.myTree.addKeyListener((KeyListener)this.mySearch);
        this.myEditor = new ConfigurableEditor(this, null){

            @Override
            boolean apply() {
                SettingsEditor.this.checkModified(((SettingsEditor)SettingsEditor.this).myFilter.myContext.getCurrentConfigurable());
                if (((SettingsEditor)SettingsEditor.this).myFilter.myContext.getModified().isEmpty()) {
                    return true;
                }
                LinkedHashMap<Configurable, ConfigurationException> map = new LinkedHashMap<Configurable, ConfigurationException>();
                for (Configurable configurable : ((SettingsEditor)SettingsEditor.this).myFilter.myContext.getModified()) {
                    ConfigurationException exception = ConfigurableEditor.apply(configurable);
                    if (exception != null) {
                        map.put(configurable, exception);
                        continue;
                    }
                    if (configurable.isModified()) continue;
                    ((SettingsEditor)SettingsEditor.this).myFilter.myContext.fireModifiedRemoved(configurable, null);
                }
                SettingsEditor.this.mySearch.updateToolTipText();
                ((SettingsEditor)SettingsEditor.this).myFilter.myContext.fireErrorsChanged(map, null);
                if (!map.isEmpty()) {
                    Configurable targetConfigurable = (Configurable)map.keySet().iterator().next();
                    ConfigurationException exception = (ConfigurationException)((Object)map.get(targetConfigurable));
                    Configurable originator = exception.getOriginator();
                    if (originator != null) {
                        targetConfigurable = originator;
                    }
                    SettingsEditor.this.myTreeView.select(targetConfigurable);
                    return false;
                }
                SettingsEditor.this.updateStatus(((SettingsEditor)SettingsEditor.this).myFilter.myContext.getCurrentConfigurable());
                return true;
            }

            @Override
            void updateCurrent(Configurable configurable, boolean reset) {
                if (reset && configurable != null) {
                    ((SettingsEditor)SettingsEditor.this).myFilter.myContext.fireReset(configurable);
                }
                SettingsEditor.this.checkModified(configurable);
            }

            @Override
            void openLink(Configurable configurable) {
                SettingsEditor.this.mySettings.select(configurable);
            }
        };
        this.myEditor.setPreferredSize((Dimension)JBUI.size((int)800, (int)600));
        this.myLoadingDecorator = new LoadingDecorator((JComponent)this.myEditor, (Disposable)this, 10, true);
        this.myBanner = new Banner(this.myEditor.getResetAction());
        this.mySearchPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.myBanner.setBorder(BorderFactory.createEmptyBorder(5, 0, 0, 10));
        this.mySearch.setBackground(UIUtil.SIDE_PANEL_BACKGROUND);
        this.mySearchPanel.setBackground(UIUtil.SIDE_PANEL_BACKGROUND);
        JPanel left = new JPanel(new BorderLayout());
        left.add("North", this.mySearchPanel);
        left.add("Center", this.myTreeView);
        JPanel right = new JPanel(new BorderLayout());
        right.add("North", this.myBanner);
        right.add("Center", this.myLoadingDecorator.getComponent());
        this.mySplitter = new OnePixelSplitter(false, this.myProperties.getFloat(SPLITTER_PROPORTION, 0.2f));
        this.mySplitter.setHonorComponentsMinimumSize(true);
        this.mySplitter.setFirstComponent((JComponent)left);
        this.mySplitter.setSecondComponent((JComponent)right);
        this.mySpotlightPainter = new SpotlightPainter(this.myEditor, this){

            @Override
            void updateNow() {
                Configurable configurable = ((SettingsEditor)SettingsEditor.this).myFilter.myContext.getCurrentConfigurable();
                if (((SettingsEditor)SettingsEditor.this).myTreeView.myTree.hasFocus() || SettingsEditor.this.mySearch.getTextEditor().hasFocus()) {
                    this.update(SettingsEditor.this.myFilter, configurable, SettingsEditor.this.myEditor.getContent(configurable));
                }
            }
        };
        this.add("Center", (Component)this.mySplitter);
        if (configurable == null && (configurable = new ConfigurableVisitor.ByID((id = this.myProperties.getValue(SELECTED_CONFIGURABLE)) != null ? id : "preferences.lookFeel").find(groups)) == null) {
            configurable = ConfigurableVisitor.ALL.find(groups);
        }
        this.myTreeView.select(configurable).doWhenDone(() -> this.myFilter.update(filter, false, true));
        Disposer.register((Disposable)this, (Disposable)this.myTreeView);
        this.installSpotlightRemover();
        this.mySearch.getTextEditor().addActionListener(event -> this.myTreeView.select(this.myFilter.myContext.getCurrentConfigurable()).doWhenDone(this::requestFocusToEditor));
    }

    private void requestFocusToEditor() {
        JComponent component = this.myEditor.getPreferredFocusedComponent();
        if (component != null) {
            IdeFocusManager.findInstanceByComponent((Component)component).requestFocus((Component)component, true);
        }
    }

    private void installSpotlightRemover() {
        FocusAdapter spotlightRemover = new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                Component comp = e.getOppositeComponent();
                if (comp == SettingsEditor.this.mySearch.getTextEditor() || comp == ((SettingsEditor)SettingsEditor.this).myTreeView.myTree) {
                    return;
                }
                SettingsEditor.this.mySpotlightPainter.update(null, null, null);
            }

            @Override
            public void focusGained(FocusEvent e) {
                if (!StringUtil.isEmpty((String)SettingsEditor.this.mySearch.getText())) {
                    SettingsEditor.this.mySpotlightPainter.updateNow();
                }
            }
        };
        this.myTreeView.myTree.addFocusListener((FocusListener)spotlightRemover);
        this.mySearch.getTextEditor().addFocusListener((FocusListener)spotlightRemover);
    }

    public Object getData(@NotNull @NonNls String dataId) {
        if (dataId == null) {
            SettingsEditor.$$$reportNull$$$0(0);
        }
        return Settings.KEY.is(dataId) ? this.mySettings : (SearchTextField.KEY.is(dataId) ? this.mySearch : null);
    }

    @Override
    void disposeOnce() {
        this.myProperties.setValue(SPLITTER_PROPORTION, this.mySplitter.getProportion(), 0.2f);
    }

    @Override
    Action getApplyAction() {
        return this.myEditor.getApplyAction();
    }

    @Override
    Action getResetAction() {
        return null;
    }

    @Override
    String getHelpTopic() {
        Configurable configurable = this.myFilter.myContext.getCurrentConfigurable();
        while (configurable != null) {
            String topic = configurable.getHelpTopic();
            if (topic != null) {
                return topic;
            }
            configurable = this.myFilter.myContext.getParentConfigurable(configurable);
        }
        return "preferences";
    }

    @Override
    boolean apply() {
        return this.myEditor.apply();
    }

    @Override
    boolean cancel() {
        if (this.myFilter.myContext.isHoldingFilter()) {
            this.mySearch.setText("");
            return false;
        }
        return super.cancel();
    }

    @Override
    JComponent getPreferredFocusedComponent() {
        return this.myTreeView != null ? this.myTreeView.myTree : this.myEditor;
    }

    @Nullable
    Collection<String> getPathNames() {
        return this.myTreeView == null ? null : this.myTreeView.getPathNames(this.myFilter.myContext.getCurrentConfigurable());
    }

    public void addOptionsListener(OptionsEditorColleague colleague) {
        this.myFilter.myContext.addColleague(colleague);
    }

    void updateStatus(Configurable configurable) {
        this.myFilter.updateSpotlight(configurable == null);
        if (this.myBanner != null) {
            this.myBanner.setProject(this.myTreeView.findConfigurableProject(configurable));
            this.myBanner.setText(this.myTreeView.getPathNames(configurable));
        }
        if (this.myEditor != null) {
            ConfigurationException exception = this.myFilter.myContext.getErrors().get(configurable);
            this.myEditor.getApplyAction().setEnabled(!this.myFilter.myContext.getModified().isEmpty());
            this.myEditor.getResetAction().setEnabled(this.myFilter.myContext.isModified(configurable) || exception != null);
            this.myEditor.setError(exception);
            this.myEditor.revalidate();
        }
        if (configurable != null) {
            new Alarm().addRequest(() -> {
                if (!this.myDisposed && this.mySpotlightPainter != null) {
                    this.mySpotlightPainter.updateNow();
                }
            }, 300);
        }
    }

    void updateController(Configurable configurable) {
        ConfigurableController controller;
        if (this.myLastController != null) {
            this.myLastController.setBanner(null);
            this.myLastController = null;
        }
        if ((controller = ConfigurableController.getOrCreate(configurable, this.myControllers)) != null) {
            this.myLastController = controller;
            controller.setBanner(this.myBanner);
        }
    }

    void checkModified(Configurable configurable) {
        Configurable parent = this.myFilter.myContext.getParentConfigurable(configurable);
        if (ConfigurableWrapper.hasOwnContent((UnnamedConfigurable)parent)) {
            this.checkModifiedForItem(parent);
            for (Configurable child2 : this.myFilter.myContext.getChildren(parent)) {
                this.checkModifiedForItem(child2);
            }
        } else if (configurable != null) {
            this.checkModifiedForItem(configurable);
        }
        this.updateStatus(configurable);
    }

    private void checkModifiedForItem(Configurable configurable) {
        if (configurable != null) {
            JComponent component = this.myEditor.getContent(configurable);
            if (component == null && ConfigurableWrapper.hasOwnContent((UnnamedConfigurable)configurable)) {
                component = this.myEditor.readContent(configurable);
            }
            if (component != null) {
                this.checkModifiedInternal(configurable);
            }
        }
    }

    private void checkModifiedInternal(Configurable configurable) {
        if (configurable.isModified()) {
            this.myFilter.myContext.fireModifiedAdded(configurable, null);
        } else if (!this.myFilter.myContext.getErrors().containsKey(configurable)) {
            this.myFilter.myContext.fireModifiedRemoved(configurable, null);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataId", "com/intellij/openapi/options/newEditor/SettingsEditor", "getData"));
    }
}

