/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.actions;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.impl.XDebuggerUtilImpl;
import com.intellij.xdebugger.impl.settings.XDebuggerSettingManagerImpl;
import org.jetbrains.annotations.NotNull;

final class ShowLibraryFramesAction
extends ToggleAction {
    private static final String IS_LIBRARY_FRAME_FILTER_SUPPORTED = "isLibraryFrameFilterSupported";
    private volatile boolean myShouldShow = XDebuggerSettingManagerImpl.getInstanceImpl().getDataViewSettings().isShowLibraryStackFrames();
    private static final String ourTextWhenShowIsOn = "Hide Frames from Libraries";
    private static final String ourTextWhenShowIsOff = "Show All Frames";

    ShowLibraryFramesAction() {
        super("", "", AllIcons.General.Filter);
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            ShowLibraryFramesAction.$$$reportNull$$$0(0);
        }
        super.update(e);
        Presentation presentation = e.getPresentation();
        Object isSupported = presentation.getClientProperty(IS_LIBRARY_FRAME_FILTER_SUPPORTED);
        XDebugSession session2 = (XDebugSession)e.getData(XDebugSession.DATA_KEY);
        if (isSupported == null) {
            if (session2 == null) {
                presentation.setVisible(false);
                return;
            }
            isSupported = session2.getDebugProcess().isLibraryFrameFilterSupported();
            presentation.putClientProperty(IS_LIBRARY_FRAME_FILTER_SUPPORTED, isSupported);
        }
        if (Boolean.TRUE.equals(isSupported)) {
            presentation.setVisible(true);
            boolean shouldShow = !Boolean.TRUE.equals(presentation.getClientProperty("selected"));
            presentation.setText(shouldShow ? ourTextWhenShowIsOn : ourTextWhenShowIsOff);
        } else {
            presentation.setVisible(false);
        }
    }

    public boolean isSelected(@NotNull AnActionEvent e) {
        if (e == null) {
            ShowLibraryFramesAction.$$$reportNull$$$0(1);
        }
        return !this.myShouldShow;
    }

    public void setSelected(@NotNull AnActionEvent e, boolean enabled) {
        if (e == null) {
            ShowLibraryFramesAction.$$$reportNull$$$0(2);
        }
        this.myShouldShow = !enabled;
        XDebuggerSettingManagerImpl.getInstanceImpl().getDataViewSettings().setShowLibraryStackFrames(this.myShouldShow);
        XDebuggerUtilImpl.rebuildAllSessionsViews(e.getProject());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "e";
        objectArray2[1] = "com/intellij/xdebugger/impl/actions/ShowLibraryFramesAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isSelected";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "setSelected";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

