/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.gem;

import b.h.la;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.remote.RemoteSdkAdditionalData;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.text.VersionComparatorUtil;
import java.lang.invoke.MethodHandles;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;
import org.jdom.Element;
import org.jdom.filter.ElementFilter;
import org.jdom.filter.Filter;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.gem.GemBoxState;
import org.jetbrains.plugins.ruby.gem.GemDataContext;
import org.jetbrains.plugins.ruby.gem.GemInfo;
import org.jetbrains.plugins.ruby.gem.GemUtil;
import org.jetbrains.plugins.ruby.gem.GemsDataKeys;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.RubyLanguageLevelPusher;
import org.jetbrains.plugins.ruby.ruby.sdk.LanguageLevel;
import org.jetbrains.plugins.ruby.ruby.sdk.RubySdkAdditionalData;
import org.jetbrains.plugins.ruby.ruby.sdk.jruby.JRubySdkUtil;

public class GemBox {
    private static final Logger d;
    @NonNls
    private static final String f = "url";
    @NonNls
    private static final String b = "box";
    private static final String g = "@global";
    private final GemBoxState c;
    @NotNull
    private final Sdk e;
    @NotNull
    private final String a;
    private static final long h;

    public GemBox(@NotNull Sdk sdk, @NotNull String gemUrl) {
        if (sdk == null) {
            GemBox.a(0);
        }
        if (gemUrl == null) {
            GemBox.a(1);
        }
        this(sdk, gemUrl, true);
    }

    private GemBox(@NotNull Sdk sdk, @NotNull String gemUrl, boolean update) {
        if (sdk == null) {
            GemBox.a(2);
        }
        if (gemUrl == null) {
            GemBox.a(3);
        }
        this.c = new GemBoxState();
        this.e = sdk;
        this.a = gemUrl;
        if (update) {
            this.updateGems();
        }
    }

    @NotNull
    public static String getDefaultGemName(@NotNull VirtualFile gemFile) {
        String string;
        int n2;
        if (gemFile == null) {
            GemBox.a(4);
        }
        String string2 = GemBox.a(n2 = (string = gemFile.getNameWithoutExtension()).lastIndexOf("-"), string) ? string.substring(0, n2) : string;
        if (string2 == null) {
            GemBox.a(5);
        }
        return string2;
    }

    @Nullable
    public static String getDefaultGemVersion(@NotNull VirtualFile gemFile) {
        String string;
        int n2;
        if (gemFile == null) {
            GemBox.a(6);
        }
        return GemBox.a(n2 = (string = gemFile.getNameWithoutExtension()).lastIndexOf("-"), string) ? string.substring(n2 + 1) : null;
    }

    private static boolean a(int n2, String string) {
        long l2 = h ^ 0x6B91ADB34F3CL;
        return n2 >= 0 && StringUtil.containsAnyChar((String)string.substring(n2 + 1), (String)"0123456789");
    }

    public String getUrl() {
        return this.a;
    }

    public void updateGems() {
        this.c.doWrite((map, set) -> {
            set.addAll(map.values());
            ContainerUtil.filter(map.values(), gemInfo -> !gemInfo.isValid()).forEach(gemInfo -> {
                GemInfo cfr_ignored_0 = (GemInfo)map.remove(gemInfo.getUrl());
            });
            VirtualFile virtualFile2 = this.getRoot(!ApplicationManager.getApplication().isUnitTestMode());
            if (virtualFile2 == null) {
                return;
            }
            ContainerUtil.filter((Object[])virtualFile2.getChildren(), virtualFile -> !map.containsKey(virtualFile.getUrl())).forEach(this::addGem);
            this.a(virtualFile2, (Map<String, GemInfo>)map);
        });
    }

    private void a(@NotNull VirtualFile virtualFile, @NotNull Map<String, GemInfo> map) {
        LanguageLevel languageLevel;
        long l2 = h ^ 0x42523181249CL;
        if (virtualFile == null) {
            GemBox.a(7);
        }
        if (map == null) {
            GemBox.a(8);
        }
        if ((languageLevel = RubyLanguageLevelPusher.getEffectiveLanguageLevel(this.e)).isLessThan(LanguageLevel.RUBY20)) {
            return;
        }
        VirtualFile virtualFile2 = GemUtil.getSpecFolder(virtualFile);
        if (virtualFile2 == null) {
            return;
        }
        VirtualFile virtualFile3 = virtualFile2.findChild("default");
        if (virtualFile3 == null || !virtualFile3.isDirectory()) {
            return;
        }
        String string = languageLevel.equals((Object)LanguageLevel.RUBY20) ? "2.0.0" : (JRubySdkUtil.isJRubySDK(this.e) ? (VersionComparatorUtil.compare((String)JRubySdkUtil.getJRubyShortVersion(this.e.getVersionString()), (String)"9.0.4.0") > 0 ? "stdlib" : "2.1") : (languageLevel.equals((Object)LanguageLevel.RUBY21) ? "2.1.0" : (languageLevel.equals((Object)LanguageLevel.RUBY22) ? "2.2.0" : (languageLevel.equals((Object)LanguageLevel.RUBY23) ? "2.3.0" : (languageLevel.equals((Object)LanguageLevel.RUBY24) ? "2.4.0" : (languageLevel.equals((Object)LanguageLevel.RUBY25) ? "2.5.0" : (languageLevel.equals((Object)LanguageLevel.RUBY26) ? "2.6.0" : "2.6.0")))))));
        RubySdkAdditionalData rubySdkAdditionalData = RubySdkAdditionalData.notNullFrom(this.e);
        if (rubySdkAdditionalData instanceof RemoteSdkAdditionalData) {
            return;
        }
        VirtualFile virtualFile4 = Stream.of(Paths.get(rubySdkAdditionalData.getGemsBinDirectory(), "/../lib/ruby/"), Paths.get(RubySdkAdditionalData.getInterpreterDir(this.e), "/../lib/ruby/")).map(path -> path.resolve(string)).filter(path -> Files.exists(path, new LinkOption[0])).map(path -> VfsUtil.findFile((Path)path, (boolean)false)).findFirst().orElse(null);
        if (virtualFile4 == null) {
            d.warn("Unable to find lib directory relative to " + rubySdkAdditionalData.getGemsBinDirectory() + " or " + RubySdkAdditionalData.getInterpreterDir(this.e) + "for " + this.e);
            return;
        }
        for (VirtualFile virtualFile5 : virtualFile3.getChildren()) {
            String string2 = GemBox.getDefaultGemName(virtualFile5);
            String string3 = GemBox.getDefaultGemVersion(virtualFile5);
            if (string3 == null) continue;
            GemDataContext gemDataContext = new GemDataContext();
            gemDataContext.putData(GemsDataKeys.NAME, string2);
            gemDataContext.putData(GemsDataKeys.VERSION, string3);
            gemDataContext.putData(GemsDataKeys.SUMMARY, "This " + string2 + " is bundled with Ruby");
            gemDataContext.putData(GemsDataKeys.SDK, this.e);
            gemDataContext.putData(GemsDataKeys.FROM_PATH, false);
            GemInfo gemInfo = GemInfo.create(gemDataContext, virtualFile4.getUrl() + "/" + string2, null);
            if (gemInfo == null) continue;
            map.put(gemInfo.getUrl(), gemInfo);
        }
    }

    @Nullable
    public VirtualFile getRoot(boolean forceRefresh) {
        VirtualFile virtualFile;
        VirtualFile virtualFile2 = virtualFile = forceRefresh ? VirtualFileManager.getInstance().refreshAndFindFileByUrl(this.a) : VirtualFileManager.getInstance().findFileByUrl(this.a);
        if (forceRefresh && virtualFile != null && virtualFile.isValid()) {
            virtualFile.refresh(false, true);
        }
        return virtualFile;
    }

    public void unregisterLibraries(LibraryTable.ModifiableModel model) {
        this.getAllGems().forEach(gemInfo -> gemInfo.removeLibrary(model));
    }

    public Collection<GemInfo> getAllGems() {
        return this.c.compute((map, set) -> ContainerUtil.newArrayList(map.values()));
    }

    public static void updateLibraries(@NotNull LibraryTable.ModifiableModel model, @NotNull Map<String, String> name2SourceRoots, @NotNull Collection<? extends GemBox> gemBoxes) {
        if (model == null) {
            GemBox.a(9);
        }
        if (name2SourceRoots == null) {
            GemBox.a(10);
        }
        if (gemBoxes == null) {
            GemBox.a(11);
        }
        MultiMap multiMap = new MultiMap();
        MultiMap multiMap2 = new MultiMap();
        for (GemBox gemBox : gemBoxes) {
            gemBox.c.doWrite((map, set) -> {
                map.values().forEach(gemInfo -> multiMap2.putValue((Object)gemInfo.getLibraryName(), gemInfo));
                set.forEach(gemInfo -> multiMap.putValue((Object)gemInfo.getLibraryName(), gemInfo));
                set.clear();
            });
        }
        multiMap.keySet().stream().filter(string -> !multiMap2.containsKey(string)).map(string -> {
            if (model == null) {
                GemBox.a(25);
            }
            return model.getLibraryByName(string);
        }).filter(Objects::nonNull).forEach(library -> {
            if (model == null) {
                GemBox.a(24);
            }
            model.removeLibrary(library);
        });
        multiMap2.entrySet().stream().map(entry -> GemBox.a((Collection)entry.getValue())).forEach(gemInfo -> {
            if (model == null) {
                GemBox.a(22);
            }
            if (name2SourceRoots == null) {
                GemBox.a(23);
            }
            GemBox.b(model, name2SourceRoots, gemInfo);
        });
    }

    public Element getState() {
        long l2 = h ^ 0x612D28184954L;
        Element element = new Element(b);
        element.setAttribute(f, this.a);
        this.getAllGems().stream().map(GemInfo::getState).forEach(arg_0 -> ((Element)element).addContent(arg_0));
        return element;
    }

    @Nullable
    public static GemBox create(@NotNull Sdk sdk, @NotNull Element element) {
        long l2 = h ^ 0x1F74567A8EA6L;
        if (sdk == null) {
            GemBox.a(12);
        }
        if (element == null) {
            GemBox.a(13);
        }
        String string = element.getAttributeValue(f);
        if (!Comparing.strEqual((String)element.getName(), (String)b) || string == null) {
            return null;
        }
        GemBox gemBox = new GemBox(sdk, string, false);
        gemBox.c.doWrite((map, set) -> {
            if (element == null) {
                GemBox.a(20);
            }
            if (sdk == null) {
                GemBox.a(21);
            }
            for (Object e10 : element.getContent((Filter)new ElementFilter())) {
                GemInfo gemInfo = GemInfo.create(sdk, (Element)e10);
                if (gemInfo == null) continue;
                map.put(gemInfo.getUrl(), gemInfo);
            }
        });
        return gemBox;
    }

    public Collection<GemInfo> findGem(@NotNull String gemName, @Nullable String gemVersion) {
        if (gemName == null) {
            GemBox.a(14);
        }
        HashSet<GemInfo> hashSet = new HashSet<GemInfo>();
        for (GemInfo gemInfo : this.getAllGems()) {
            if (!Comparing.strEqual((String)gemInfo.getName(), (String)gemName)) continue;
            if (gemVersion != null) {
                if (!Comparing.strEqual((String)gemInfo.getVersion(), (String)gemVersion)) continue;
                return Collections.singletonList(gemInfo);
            }
            hashSet.add(gemInfo);
        }
        return hashSet;
    }

    public void addGem(VirtualFile file) {
        this.c.doWrite((map, set) -> GemInfo.create(this.e, file).forEach(gemInfo -> map.put(gemInfo.getUrl(), gemInfo)));
    }

    public void removeGem(VirtualFile file) {
        this.c.doWrite((map, set) -> {
            String string = file.getUrl();
            GemInfo gemInfo = (GemInfo)map.get(string);
            if (gemInfo != null) {
                this.b(gemInfo);
            } else {
                String[] stringArray;
                for (String string2 : stringArray = ArrayUtil.toStringArray(map.keySet())) {
                    if (!string2.startsWith(string)) continue;
                    this.b((GemInfo)map.get(string2));
                }
            }
        });
    }

    private void b(GemInfo gemInfo) {
        this.c.doWrite((map, set) -> {
            map.remove(gemInfo.getUrl());
            set.add(gemInfo);
        });
    }

    @NotNull
    private static GemInfo a(@NotNull Collection<? extends GemInfo> collection) {
        if (collection == null) {
            GemBox.a(15);
        }
        GemInfo gemInfo3 = Collections.min(collection, (gemInfo, gemInfo2) -> {
            long l2 = h ^ 0xAD8867A33ACL;
            int n2 = Boolean.compare(gemInfo.getRequirePaths().isEmpty(), gemInfo2.getRequirePaths().isEmpty());
            if (n2 != 0) {
                return n2;
            }
            n2 = Boolean.compare(gemInfo.getUrl().contains(g), gemInfo2.getUrl().contains(g));
            if (n2 != 0) {
                return n2;
            }
            return gemInfo.getUrl().compareTo(gemInfo2.getUrl());
        });
        if (gemInfo3 == null) {
            GemBox.a(16);
        }
        return gemInfo3;
    }

    private static void b(@NotNull LibraryTable.ModifiableModel modifiableModel, @NotNull Map<String, String> map, @NotNull GemInfo gemInfo) {
        String string;
        if (modifiableModel == null) {
            GemBox.a(17);
        }
        if (map == null) {
            GemBox.a(18);
        }
        if (gemInfo == null) {
            GemBox.a(19);
        }
        if (map.getOrDefault(string = gemInfo.getLibraryName(), "0") != "3") {
            gemInfo.createLibrary(modifiableModel);
            map.put(string, "3");
        }
    }

    static {
        h = la.a(8128493201595139661L, 396694579780999781L, MethodHandles.lookup().lookupClass()).a(249674908296946L);
        d = Logger.getInstance(GemBox.class);
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = h ^ 0x7C3E41C8E8B3L;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 16: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 5: 
            case 16: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gemUrl";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gemFile";
                break;
            }
            case 5: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/gem/GemBox";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gemBoxRoot";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gemsMap";
                break;
            }
            case 9: 
            case 17: 
            case 22: 
            case 24: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 10: 
            case 18: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name2SourceRoots";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gemBoxes";
                break;
            }
            case 13: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gemName";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gems";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gem";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/gem/GemBox";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultGemName";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "chooseBestGem";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultGemName";
                break;
            }
            case 5: 
            case 16: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultGemVersion";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "addDefaultGems";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "updateLibraries";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "findGem";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "chooseBestGem";
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "updateLibraryByGemInfo";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "lambda$create$17";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "lambda$updateLibraries$16";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "lambda$updateLibraries$14";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "lambda$updateLibraries$13";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 16: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

