/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.gem;

import b.h.la;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.Sets;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkAdditionalData;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.MultiValuesMap;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.PathUtil;
import com.intellij.util.SystemProperties;
import com.intellij.util.text.VersionComparatorUtil;
import java.io.File;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.gem.GemDependency;
import org.jetbrains.plugins.ruby.gem.GemInfo;
import org.jetbrains.plugins.ruby.gem.GemManager;
import org.jetbrains.plugins.ruby.gem.RubyGemExecutionContext;
import org.jetbrains.plugins.ruby.gem.RubyGemsEnvironment;
import org.jetbrains.plugins.ruby.gem.util.BundlerUtil;
import org.jetbrains.plugins.ruby.gem.util.GemComparator;
import org.jetbrains.plugins.ruby.gem.util.GemNameComparator;
import org.jetbrains.plugins.ruby.gem.util.GemSearchUtil;
import org.jetbrains.plugins.ruby.rails.RailsUtil;
import org.jetbrains.plugins.ruby.rails.facet.RailsFacetUtil;
import org.jetbrains.plugins.ruby.rails.facet.configuration.StandardRailsPaths;
import org.jetbrains.plugins.ruby.ruby.lang.RubyFileType;
import org.jetbrains.plugins.ruby.ruby.lang.TextUtil;
import org.jetbrains.plugins.ruby.ruby.sdk.RubySdkAdditionalData;
import org.jetbrains.plugins.ruby.ruby.sdk.RubySdkUtil;
import org.jetbrains.plugins.ruby.tasks.rake.RakeUtilBase;
import org.jetbrains.plugins.ruby.utils.VirtualFileUtil;
import org.jetbrains.plugins.ruby.version.management.rbenv.gemsets.RbenvGemsetManager;
import org.jetbrains.plugins.ruby.version.management.rvm.RVMSupportUtil;

public class GemUtil {
    public static final Pattern NAME_PATTERN;
    public static final String GEMSPEC = ".gemspec";
    public static final String GEM = "gem";
    private static final Logger b;
    @NonNls
    private static final Pattern a;
    @NonNls
    private static final String d = "readme";
    private static final Predicate<String> c;
    private static final long e;

    private GemUtil() {
    }

    @Nullable
    public static String findScriptInBinDir(@NotNull String rubyScriptName, @Nullable VirtualFile gemRootBinDir) {
        String string;
        if (rubyScriptName == null) {
            GemUtil.a(0);
        }
        if (gemRootBinDir != null && (string = GemUtil.findExecutableRubyScriptPath(rubyScriptName, gemRootBinDir.getPath())) != null) {
            return string;
        }
        return null;
    }

    @Nullable
    static String findExecutableRubyScriptPath(@NotNull String rubyScriptName, @NotNull String sdkBinFolder) {
        String string;
        if (rubyScriptName == null) {
            GemUtil.a(1);
        }
        if (sdkBinFolder == null) {
            GemUtil.a(2);
        }
        if (new File(string = sdkBinFolder + '/' + rubyScriptName).isFile()) {
            return FileUtil.toSystemDependentName((String)string);
        }
        if (new File(string = string + "." + RubyFileType.RUBY.getDefaultExtension()).isFile()) {
            return FileUtil.toSystemDependentName((String)string);
        }
        return null;
    }

    public static boolean isGemExecutableRubyScriptExists(@Nullable Module module, @Nullable Sdk sdk, @NotNull String gemName) {
        if (gemName == null) {
            GemUtil.a(3);
        }
        return GemUtil.isGemExecutableRubyScriptExists(module, sdk, gemName, gemName);
    }

    public static boolean isGemExecutableRubyScriptExists(@Nullable Module module, @Nullable Sdk sdk, @NotNull String gemName, @NotNull String rubyScriptName) {
        if (gemName == null) {
            GemUtil.a(4);
        }
        if (rubyScriptName == null) {
            GemUtil.a(5);
        }
        return StringUtil.isNotEmpty((String)RubyGemExecutionContext.getScriptPath(sdk, module, gemName, rubyScriptName));
    }

    @NotNull
    public static String getGemUrlFromPath(@Nullable String path, @Nullable VirtualFile relativeRoot) {
        VirtualFile virtualFile;
        path = StringUtil.startsWithChar((CharSequence)(path = TextUtil.trimTrailingSlashes(path)), (char)'~') ? SystemProperties.getUserHome() + path.substring(1) : path;
        VirtualFile virtualFile2 = virtualFile = relativeRoot != null ? relativeRoot.findFileByRelativePath(path) : null;
        if (virtualFile != null) {
            String string = virtualFile.getUrl();
            if (string == null) {
                GemUtil.a(6);
            }
            return string;
        }
        String string = PathUtil.getCanonicalPath((String)path);
        String string2 = string != null ? VfsUtilCore.pathToUrl((String)string) : path;
        if (string2 == null) {
            GemUtil.a(7);
        }
        return string2;
    }

    @NotNull
    public static List<VirtualFile> getAllGemsLibUrls(@NotNull VirtualFile gemRoot) {
        long l2 = e ^ 0x6161D5810B52L;
        if (gemRoot == null) {
            GemUtil.a(8);
        }
        HashMap<String, Pair> hashMap = new HashMap<String, Pair>();
        ArrayList<VirtualFile> arrayList = new ArrayList<VirtualFile>();
        for (VirtualFile virtualFile : gemRoot.getChildren()) {
            VirtualFile virtualFile2 = virtualFile.findChild("lib");
            if (virtualFile2 != null) {
                Matcher matcher = a.matcher(virtualFile.getName());
                if (matcher.find()) {
                    String string = matcher.group(1);
                    String string2 = matcher.group(2);
                    Pair pair = (Pair)hashMap.get(string);
                    if (pair != null && VersionComparatorUtil.compare((String)((String)pair.first), (String)string2) >= 0) continue;
                    hashMap.put(string, Pair.create((Object)string2, (Object)virtualFile2));
                    continue;
                }
                arrayList.add(virtualFile2);
                continue;
            }
            b.debug("No 'lib' dir found for gem " + virtualFile.getPath());
        }
        for (Pair pair : hashMap.values()) {
            arrayList.add((VirtualFile)pair.second);
        }
        ArrayList<VirtualFile> arrayList2 = arrayList;
        if (arrayList2 == null) {
            GemUtil.a(9);
        }
        return arrayList2;
    }

    public static boolean isGemsRootUrl(@NotNull String url) {
        long l2 = e ^ 0xB741A27FFB2L;
        if (url == null) {
            GemUtil.a(10);
        }
        return url.endsWith("/gems");
    }

    public static List<List<GemInfo>> packGemsFromMultiValuesMap(MultiValuesMap<String, GemInfo> map) {
        ArrayList<List<GemInfo>> arrayList = new ArrayList<List<GemInfo>>();
        for (Map.Entry entry : map.entrySet()) {
            ArrayList arrayList2 = new ArrayList((Collection)entry.getValue());
            Collections.sort(arrayList2, Collections.reverseOrder(new GemComparator()));
            arrayList.add(arrayList2);
        }
        Collections.sort(arrayList, new GemNameComparator());
        return arrayList;
    }

    @NotNull
    public static Set<String> determineGemUrlsForSDK(@Nullable Sdk sdk) {
        long l2 = e ^ 0x7B02E618B0E8L;
        if (sdk == null) {
            LinkedHashSet linkedHashSet = Sets.newLinkedHashSet();
            if (linkedHashSet == null) {
                GemUtil.a(11);
            }
            return linkedHashSet;
        }
        SdkAdditionalData sdkAdditionalData = sdk.getSdkAdditionalData();
        if (!(sdkAdditionalData instanceof RubySdkAdditionalData)) {
            LinkedHashSet linkedHashSet = Sets.newLinkedHashSet();
            if (linkedHashSet == null) {
                GemUtil.a(12);
            }
            return linkedHashSet;
        }
        LinkedHashSet linkedHashSet = Sets.newLinkedHashSet();
        linkedHashSet.addAll(GemUtil.a((RubySdkAdditionalData)sdkAdditionalData));
        if (!linkedHashSet.isEmpty()) {
            LinkedHashSet linkedHashSet2 = linkedHashSet;
            if (linkedHashSet2 == null) {
                GemUtil.a(13);
            }
            return linkedHashSet2;
        }
        linkedHashSet.addAll(GemUtil.a(sdk));
        if (!linkedHashSet.isEmpty()) {
            LinkedHashSet linkedHashSet3 = linkedHashSet;
            if (linkedHashSet3 == null) {
                GemUtil.a(14);
            }
            return linkedHashSet3;
        }
        linkedHashSet.addAll(RbenvGemsetManager.getGemsetGemsURLs(sdk));
        if (!linkedHashSet.isEmpty()) {
            LinkedHashSet linkedHashSet4 = linkedHashSet;
            if (linkedHashSet4 == null) {
                GemUtil.a(15);
            }
            return linkedHashSet4;
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            LinkedHashSet linkedHashSet5 = linkedHashSet;
            if (linkedHashSet5 == null) {
                GemUtil.a(16);
            }
            return linkedHashSet5;
        }
        try {
            for (String string : RubyGemsEnvironment.getGemPaths(sdk)) {
                linkedHashSet.add(VirtualFileUtil.constructLocalUrl(string + "/gems"));
            }
            BundlerUtil.addBundlerPaths(sdk, linkedHashSet);
        }
        catch (Exception exception) {
            b.info("Problem with gem urls", (Throwable)exception);
        }
        LinkedHashSet linkedHashSet6 = linkedHashSet;
        if (linkedHashSet6 == null) {
            GemUtil.a(17);
        }
        return linkedHashSet6;
    }

    private static Collection<String> a(@NotNull String string, @NotNull Sdk sdk) {
        String[] stringArray;
        String string2;
        if (string == null) {
            GemUtil.a(18);
        }
        if (sdk == null) {
            GemUtil.a(19);
        }
        if (string.contains("\n")) {
            string2 = "\n";
            string = string.replace("\r", "");
        } else {
            stringArray = RubySdkUtil.getRubySdkAdditionalData(sdk).getSdkSystemAccessor();
            string2 = stringArray.isWindows() && string.startsWith("/") ? ":" : stringArray.getPathSeparator();
        }
        stringArray = string.split(string2);
        return Collections2.filter((Collection)Collections2.transform(Arrays.asList(stringArray), (Function)new UnCygwinizePath(sdk)), c);
    }

    @NotNull
    private static Collection<? extends String> a(@NotNull RubySdkAdditionalData rubySdkAdditionalData) {
        List<? extends String> list2;
        if (rubySdkAdditionalData == null) {
            GemUtil.a(20);
        }
        if ((list2 = rubySdkAdditionalData.getGemsRootUrls()) == null) {
            Set set = Collections.emptySet();
            if (set == null) {
                GemUtil.a(21);
            }
            return set;
        }
        List<? extends String> list3 = list2;
        if (list3 == null) {
            GemUtil.a(22);
        }
        return list3;
    }

    @NotNull
    private static Set<String> a(@NotNull Sdk sdk) {
        if (sdk == null) {
            GemUtil.a(23);
        }
        if (!RVMSupportUtil.isRVMInterpreter(sdk)) {
            Set<String> set = Collections.emptySet();
            if (set == null) {
                GemUtil.a(24);
            }
            return set;
        }
        Set<String> set = RVMSupportUtil.determineGemRootsPaths(sdk);
        String string = BundlerUtil.addRVMBundleUrl(sdk);
        LinkedHashSet linkedHashSet = Sets.newLinkedHashSet();
        if (string != null) {
            linkedHashSet.add(string);
        }
        for (String string2 : set) {
            linkedHashSet.add(VirtualFileUtil.constructLocalUrl(string2));
        }
        LinkedHashSet linkedHashSet2 = linkedHashSet;
        if (linkedHashSet2 == null) {
            GemUtil.a(25);
        }
        return linkedHashSet2;
    }

    public static List<List<GemInfo>> getPackedGems(@NotNull Sdk sdk) {
        if (sdk == null) {
            GemUtil.a(26);
        }
        GemManager gemManager = GemManager.getInstance();
        Collection<GemInfo> collection = gemManager.getAllGems(sdk);
        return GemUtil.getPackedGems(collection);
    }

    public static List<List<GemInfo>> getPackedGems(Collection<GemInfo> gems) {
        if (gems == null || gems.isEmpty()) {
            return Collections.emptyList();
        }
        List<Object> list2 = Arrays.asList(gems.toArray());
        MultiValuesMap multiValuesMap = new MultiValuesMap();
        for (Object object : list2) {
            GemInfo gemInfo = (GemInfo)object;
            Collection collection = multiValuesMap.get((Object)gemInfo.getName());
            if (collection != null && GemUtil.a(gemInfo, collection)) continue;
            multiValuesMap.put((Object)gemInfo.getName(), (Object)gemInfo);
        }
        return GemUtil.packGemsFromMultiValuesMap((MultiValuesMap<String, GemInfo>)multiValuesMap);
    }

    private static boolean a(GemInfo gemInfo, Collection<? extends GemInfo> collection) {
        if (gemInfo.isRemote()) {
            return collection.contains(gemInfo);
        }
        for (GemInfo gemInfo2 : collection) {
            if (!GemSearchUtil.hasSameNameAndVersion(gemInfo.getName(), gemInfo.getVersion(), gemInfo2)) continue;
            if (gemInfo.isGit() && gemInfo2.isGit()) {
                return Comparing.strEqual((String)gemInfo.getRef(), (String)gemInfo2.getRef());
            }
            return true;
        }
        return false;
    }

    @Nullable
    public static String getGemReadme(@NotNull VirtualFile gemFile) {
        long l2 = e ^ 0x3C6E84632424L;
        if (gemFile == null) {
            GemUtil.a(27);
        }
        VirtualFile virtualFile = null;
        for (VirtualFile virtualFile2 : gemFile.getChildren()) {
            if (!d.equals(virtualFile2.getNameWithoutExtension().toLowerCase())) continue;
            virtualFile = virtualFile2;
            break;
        }
        if (virtualFile != null) {
            try {
                return VfsUtilCore.loadText(virtualFile);
            }
            catch (IOException iOException) {
                b.warn("Failed to read description", (Throwable)iOException);
            }
        }
        return null;
    }

    @Nullable
    static VirtualFile getSpecFolder(VirtualFile parent) {
        long l2 = e ^ 0x647C2B9B2603L;
        VirtualFile virtualFile = parent != null ? parent.getParent() : null;
        return virtualFile != null ? virtualFile.findChild("specifications") : null;
    }

    public static boolean isGemOrRailsPluginSupportProbablyEnabled(@NotNull Module module, @NotNull Sdk sdk, @NotNull String[] gemNames, @NotNull String[] pluginsNames) {
        if (module == null) {
            GemUtil.a(28);
        }
        if (sdk == null) {
            GemUtil.a(29);
        }
        if (gemNames == null) {
            GemUtil.a(30);
        }
        if (pluginsNames == null) {
            GemUtil.a(31);
        }
        for (String string : gemNames) {
            if (GemSearchUtil.findGem(module, string) == null && GemSearchUtil.findGem(module, sdk, string) == null) continue;
            return true;
        }
        return GemUtil.a(module, pluginsNames);
    }

    public static boolean isGemOrRailsPluginSupportEnabled(@NotNull Module module, @NotNull String[] gemNames, @NotNull String[] pluginsNames) {
        if (module == null) {
            GemUtil.a(32);
        }
        if (gemNames == null) {
            GemUtil.a(33);
        }
        if (pluginsNames == null) {
            GemUtil.a(34);
        }
        for (String string : gemNames) {
            GemInfo gemInfo = GemSearchUtil.findGem(module, string);
            if (gemInfo == null) continue;
            return true;
        }
        return GemUtil.a(module, pluginsNames);
    }

    private static boolean a(@NotNull Module module, @NotNull String[] stringArray) {
        if (module == null) {
            GemUtil.a(35);
        }
        if (stringArray == null) {
            GemUtil.a(36);
        }
        if (stringArray.length == 0) {
            return false;
        }
        if (!RailsFacetUtil.hasRailsSupport(module)) {
            return false;
        }
        StandardRailsPaths standardRailsPaths = RailsFacetUtil.getRailsAppPaths(module);
        assert (standardRailsPaths != null);
        VirtualFile virtualFile = RailsUtil.getPluginsRoot(module);
        if (virtualFile != null && virtualFile.isValid()) {
            for (String string : stringArray) {
                if (virtualFile.findChild(string) == null) continue;
                return true;
            }
        }
        return false;
    }

    @Nullable
    public static VirtualFile getGemOrRailsPluginLibDir(@NotNull Module module, @NotNull String gemName, @NotNull String[] pluginsNames) {
        GemInfo gemInfo;
        long l2 = e ^ 0xB1B65B2F2F5L;
        if (module == null) {
            GemUtil.a(37);
        }
        if (gemName == null) {
            GemUtil.a(38);
        }
        if (pluginsNames == null) {
            GemUtil.a(39);
        }
        if ((gemInfo = GemSearchUtil.findGem(module, gemName)) != null) {
            return gemInfo.getLibFolder();
        }
        if (!RailsFacetUtil.hasRailsSupport(module)) {
            return null;
        }
        StandardRailsPaths standardRailsPaths = RailsFacetUtil.getRailsAppPaths(module);
        assert (standardRailsPaths != null);
        VirtualFile virtualFile = RailsUtil.getPluginsRoot(module);
        if (virtualFile != null && virtualFile.isValid()) {
            for (String string : pluginsNames) {
                VirtualFile virtualFile2 = virtualFile.findChild(string);
                if (virtualFile2 == null) continue;
                return virtualFile2.findChild("lib");
            }
        }
        return null;
    }

    @Nullable
    public static VirtualFile getSpecFile(@Nullable VirtualFile gemDir) {
        long l2 = e ^ 0x6A76768053AAL;
        VirtualFile virtualFile = gemDir != null ? gemDir.getParent() : null;
        VirtualFile virtualFile2 = virtualFile != null ? GemUtil.getSpecFolder(virtualFile) : null;
        VirtualFile virtualFile3 = virtualFile2 != null ? virtualFile2.findChild(gemDir.getName() + GEMSPEC) : null;
        return virtualFile3 != null ? virtualFile3 : BundlerUtil.getGitGemSpec(gemDir);
    }

    public static Set<GemDependency> getMissingDependencies(Sdk sdk, Module module, Set<? extends GemDependency> requirements) {
        HashSet<GemInfo> hashSet = new HashSet<GemInfo>(GemManager.getInstance().getAllGems(sdk, module));
        GemManager.addModuleGems(module, hashSet);
        HashSet<GemDependency> hashSet2 = new HashSet<GemDependency>();
        for (GemDependency gemDependency : requirements) {
            if (GemSearchUtil.findGem(hashSet, gemDependency) != null) continue;
            hashSet2.add(gemDependency);
        }
        return hashSet2;
    }

    public static boolean isGemModule(Module module) {
        long l2 = e ^ 0x454CBF28B2D5L;
        for (VirtualFile virtualFile : ModuleRootManager.getInstance((Module)module).getContentRoots()) {
            for (VirtualFile virtualFile2 : virtualFile.getChildren()) {
                String string = virtualFile2.getExtension();
                if (string != null && GEMSPEC.endsWith(string)) {
                    return true;
                }
                if (!RakeUtilBase.isRakeFileByNamingConventions(virtualFile2)) continue;
                try {
                    String string2 = VfsUtilCore.loadText((VirtualFile)virtualFile2);
                    if (!string2.contains("Gem::Specification")) continue;
                    return true;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        return false;
    }

    public static boolean isGemspecFile(@Nullable VirtualFile file) {
        long l2 = e ^ 0xACE2FC12E79L;
        if (file == null) {
            return false;
        }
        String string = file.getExtension();
        return string != null && GEMSPEC.endsWith(string);
    }

    @Deprecated
    @Nullable
    public static String getGemExecutableRubyScriptPath(@Nullable Module module, @Nullable Sdk sdk, @NotNull String gemName, @NotNull String rubyScriptName) {
        RubyGemExecutionContext rubyGemExecutionContext;
        if (gemName == null) {
            GemUtil.a(40);
        }
        if (rubyScriptName == null) {
            GemUtil.a(41);
        }
        if (sdk != null) {
            rubyGemExecutionContext = (RubyGemExecutionContext)new RubyGemExecutionContext(sdk, gemName).withModule(module);
        } else if (module != null) {
            rubyGemExecutionContext = new RubyGemExecutionContext(module, gemName);
        } else {
            return null;
        }
        return rubyGemExecutionContext.withGemScriptName(rubyScriptName).getScriptPath();
    }

    @Nullable
    @Contract(value="null -> null")
    public static VirtualFile findGemLibDirectory(@Nullable VirtualFile gemRoot) {
        long l2 = e ^ 0x323B5F0643FCL;
        if (gemRoot == null) {
            return null;
        }
        VirtualFile virtualFile = gemRoot.findChild("lib");
        if (virtualFile != null && virtualFile.isDirectory()) {
            return virtualFile;
        }
        virtualFile = gemRoot.findChild("ext");
        return virtualFile != null && virtualFile.isDirectory() ? virtualFile : null;
    }

    static {
        e = la.a(-8861439362858632501L, -3014234541225896905L, MethodHandles.lookup().lookupClass()).a(153229730011669L);
        long l2 = e ^ 0x290621192141L;
        NAME_PATTERN = Pattern.compile("[A-Za-z0-9\\-_.]*");
        b = Logger.getInstance(GemUtil.class);
        a = Pattern.compile("(.+)\\-([\\d\\.]+)");
        c = string -> !StringUtil.isEmpty((String)string) && !".".equals(string);
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = e ^ 0x43485E6CBE35L;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 21: 
            case 22: 
            case 24: 
            case 25: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 6: 
            case 7: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 21: 
            case 22: 
            case 24: 
            case 25: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rubyScriptName";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdkBinFolder";
                break;
            }
            case 3: 
            case 4: 
            case 38: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gemName";
                break;
            }
            case 6: 
            case 7: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 21: 
            case 22: 
            case 24: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/gem/GemUtil";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gemRoot";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gempath";
                break;
            }
            case 19: 
            case 23: 
            case 26: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gemFile";
                break;
            }
            case 28: 
            case 32: 
            case 35: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 30: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gemNames";
                break;
            }
            case 31: 
            case 34: 
            case 36: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginsNames";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/gem/GemUtil";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getGemUrlFromPath";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllGemsLibUrls";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "determineGemUrlsForSDK";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getSavedGemRootUrls";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "determineRvmSdkGemUrls";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findScriptInBinDir";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "findExecutableRubyScriptPath";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isGemExecutableRubyScriptExists";
                break;
            }
            case 6: 
            case 7: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 21: 
            case 22: 
            case 24: 
            case 25: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getAllGemsLibUrls";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isGemsRootUrl";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "splitGempaths";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getSavedGemRootUrls";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "determineRvmSdkGemUrls";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getPackedGems";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getGemReadme";
                break;
            }
            case 28: 
            case 29: 
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "isGemOrRailsPluginSupportProbablyEnabled";
                break;
            }
            case 32: 
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "isGemOrRailsPluginSupportEnabled";
                break;
            }
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "isPluginSupportEnabled";
                break;
            }
            case 37: 
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "getGemOrRailsPluginLibDir";
                break;
            }
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "getGemExecutableRubyScriptPath";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 21: 
            case 22: 
            case 24: 
            case 25: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class UnCygwinizePath
    implements Function<String, String> {
        @NotNull
        private final Sdk a;
        private static final long b = la.a(-2250158964702963382L, 9132284376257913435L, MethodHandles.lookup().lookupClass()).a(113703734878393L);

        UnCygwinizePath(@NotNull Sdk sdk) {
            if (sdk == null) {
                UnCygwinizePath.a(0);
            }
            this.a = sdk;
        }

        public String apply(@Nullable String path) {
            if (path == null) {
                return null;
            }
            return RubySdkUtil.unCygwinizePath(this.a, path.trim());
        }

        private static /* synthetic */ void a(int n2) {
            long l2 = b ^ 0x132562DB66FFL;
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sdk", "org/jetbrains/plugins/ruby/gem/GemUtil$UnCygwinizePath", "<init>"));
        }
    }
}

