/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.rails.nameConventions;

import b.h.la;
import com.intellij.ide.highlighter.HtmlFileType;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.erb.ERbFileType;
import org.jetbrains.plugins.ruby.rails.facet.RailsFacetUtil;
import org.jetbrains.plugins.ruby.rails.facet.configuration.StandardRailsPaths;
import org.jetbrains.plugins.ruby.rails.langs.RJSFileType;
import org.jetbrains.plugins.ruby.rails.langs.RXMLFileType;
import org.jetbrains.plugins.ruby.templates.TemplateIntegrationUtils;
import org.jetbrains.plugins.ruby.utils.VirtualFileUtil;

public class ViewsConventions {
    private static final long a = la.a(5609462888073971177L, 4444754105708125475L, MethodHandles.lookup().lookupClass()).a(196982403398431L);

    private ViewsConventions() {
    }

    public static boolean isRHTMLFile(String fileName) {
        FileType fileType = FileTypeManager.getInstance().getFileTypeByFileName(fileName);
        return fileType instanceof ERbFileType;
    }

    public static boolean isHTMLFile(String fileName) {
        FileType fileType = FileTypeManager.getInstance().getFileTypeByFileName(fileName);
        return fileType instanceof HtmlFileType;
    }

    public static boolean isRJSFile(String fileName) {
        FileType fileType = FileTypeManager.getInstance().getFileTypeByFileName(fileName);
        return fileType instanceof RJSFileType;
    }

    public static boolean isTemplateFile(String fileName) {
        FileType fileType = FileTypeManager.getInstance().getFileTypeByFileName(fileName);
        return ViewsConventions.isTemplateFileType(fileType);
    }

    public static boolean isTemplateFileType(FileType fileType) {
        return TemplateIntegrationUtils.getInstance().isTemplateFile(fileType);
    }

    public static boolean isValidViewFileName(String fileName) {
        long l2 = a ^ 0x8BD9ACBFF79L;
        return ViewsConventions.isRHTMLFile(fileName) || ViewsConventions.isTemplateFile(fileName) || ViewsConventions.isRXMLFile(fileName) || ViewsConventions.isRJSFile(fileName) || ViewsConventions.isHTMLFile(fileName) || fileName.endsWith(".jbuilder") || fileName.endsWith(".rabl") || fileName.endsWith(".coffee");
    }

    public static boolean isValidRubyBasedViewTemplate(@NotNull VirtualFile file) {
        FileType fileType;
        long l2 = a ^ 0x4412777D0A27L;
        if (file == null) {
            ViewsConventions.a(0);
        }
        return (fileType = file.getFileType()) instanceof ERbFileType || ViewsConventions.isTemplateFileType(fileType) || fileType instanceof RJSFileType || fileType instanceof RXMLFileType || "rabl".equals(file.getExtension()) || "jbuilder".equals(file.getExtension());
    }

    public static boolean isRXMLFile(String fileName) {
        FileType fileType = FileTypeManager.getInstance().getFileTypeByFileName(fileName);
        return fileType instanceof RXMLFileType;
    }

    @Nullable
    public static String getRelativePathOfLayoutsFolder(@Nullable String fileUrl, @NotNull Module module) {
        if (module == null) {
            ViewsConventions.a(1);
        }
        StandardRailsPaths standardRailsPaths = RailsFacetUtil.getRailsAppPaths(module);
        assert (standardRailsPaths != null);
        String string = standardRailsPaths.getLayoutsRootURL();
        if (fileUrl == null) {
            return null;
        }
        return VirtualFileUtil.getRelativePath(fileUrl, string);
    }

    @Nullable
    public static String getRelativePathOfViewsFolder(@Nullable String fileUrl, @NotNull Module module) {
        if (module == null) {
            ViewsConventions.a(2);
        }
        StandardRailsPaths standardRailsPaths = RailsFacetUtil.getRailsAppPaths(module);
        assert (standardRailsPaths != null);
        String string = standardRailsPaths.getViewsRootURL();
        if (fileUrl == null) {
            return null;
        }
        return VirtualFileUtil.getRelativePath(fileUrl, string);
    }

    public static List<VirtualFile> findPartialViews(@Nullable VirtualFile folder) {
        ArrayList<VirtualFile> arrayList = new ArrayList<VirtualFile>();
        if (folder != null) {
            for (VirtualFile virtualFile : folder.getChildren()) {
                if (!ViewsConventions.isValidPartialViewFile(virtualFile)) continue;
                arrayList.add(virtualFile);
            }
        }
        return arrayList;
    }

    public static boolean isValidPartialViewFile(@NotNull VirtualFile file) {
        if (file == null) {
            ViewsConventions.a(3);
        }
        String string = file.getExtension();
        String string2 = file.getName();
        return !file.isDirectory() && !StringUtil.isEmpty((String)string) && ViewsConventions.isPartialViewName(string2);
    }

    public static boolean isPartialViewName(@NotNull String fileName) {
        if (fileName == null) {
            ViewsConventions.a(4);
        }
        return fileName.startsWith("_") && ViewsConventions.isValidViewFileName(fileName);
    }

    public static boolean hasValidTemplatePath(@NotNull String viewOrLayotFileUrl, @NotNull StandardRailsPaths settings) {
        if (viewOrLayotFileUrl == null) {
            ViewsConventions.a(5);
        }
        if (settings == null) {
            ViewsConventions.a(6);
        }
        String string = settings.getViewsRootURL();
        return viewOrLayotFileUrl.startsWith(string);
    }

    public static boolean isValidLayoutFileName(String fileName) {
        return ViewsConventions.isRHTMLFile(fileName) || ViewsConventions.isRXMLFile(fileName) || ViewsConventions.isTemplateFile(fileName);
    }

    public static boolean isApplicationLayoutFile(VirtualFile layout) {
        long l2 = a ^ 0x7115175B27D8L;
        return "application".equals(ViewsConventions.getViewOrLayoutNameByFileName(layout.getNameWithoutExtension())) && ViewsConventions.isLayoutFile(layout);
    }

    public static boolean isViewFile(@Nullable VirtualFile fileOrDir) {
        return fileOrDir != null && !fileOrDir.isDirectory() && ViewsConventions.isValidViewFileName(fileOrDir.getName());
    }

    public static boolean isLayoutFile(@Nullable VirtualFile fileOrDir) {
        return fileOrDir != null && !fileOrDir.isDirectory() && ViewsConventions.isValidLayoutFileName(fileOrDir.getName());
    }

    @NotNull
    public static String getActionMethodNameByView(@NotNull VirtualFile viewFile) {
        if (viewFile == null) {
            ViewsConventions.a(7);
        }
        String string = ViewsConventions.getViewOrLayoutNameByFileName(viewFile.getName());
        if (string == null) {
            ViewsConventions.a(8);
        }
        return string;
    }

    @NotNull
    public static String getViewOrLayoutNameByFileName(@NotNull String viewFileName) {
        int n2;
        if (viewFileName == null) {
            ViewsConventions.a(9);
        }
        if ((n2 = viewFileName.indexOf(46)) > 0) {
            String string = viewFileName.substring(0, n2);
            if (string == null) {
                ViewsConventions.a(10);
            }
            return string;
        }
        String string = viewFileName;
        if (string == null) {
            ViewsConventions.a(11);
        }
        return string;
    }

    @NotNull
    public static List<String> getViewExtensions(@NotNull String viewFileName) {
        int n2;
        if (viewFileName == null) {
            ViewsConventions.a(12);
        }
        int n3 = n2 = viewFileName.length() == 0 ? -1 : viewFileName.indexOf(46, 1);
        if (n2 <= 0) {
            List<String> list2 = Collections.emptyList();
            if (list2 == null) {
                ViewsConventions.a(13);
            }
            return list2;
        }
        String string = viewFileName.substring(n2 + 1);
        if (string.indexOf(46) == -1) {
            List<String> list3 = Collections.singletonList(string);
            if (list3 == null) {
                ViewsConventions.a(14);
            }
            return list3;
        }
        List list4 = StringUtil.split((String)string, (String)".");
        if (list4 == null) {
            ViewsConventions.a(15);
        }
        return list4;
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = a ^ 0x6D4734261729L;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 15: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 8: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 15: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "viewOrLayotFileUrl";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "viewFile";
                break;
            }
            case 8: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/rails/nameConventions/ViewsConventions";
                break;
            }
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "viewFileName";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/rails/nameConventions/ViewsConventions";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionMethodNameByView";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getViewOrLayoutNameByFileName";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getViewExtensions";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isValidRubyBasedViewTemplate";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getRelativePathOfLayoutsFolder";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getRelativePathOfViewsFolder";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isValidPartialViewFile";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isPartialViewName";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "hasValidTemplatePath";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getActionMethodNameByView";
                break;
            }
            case 8: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 15: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getViewOrLayoutNameByFileName";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getViewExtensions";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 15: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

