/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.version.management;

import b.h.la;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import java.lang.invoke.MethodHandles;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.version.management.RubyVersionManagerHandlerBase;
import org.jetbrains.plugins.ruby.version.management.RubyVersionManagerSdkData;

public interface SdkRefresher {
    public static final ExtensionPointName<SdkRefresher> EP_NAME;
    public static final long t;

    @Contract(value="null -> false")
    public boolean isManagedSdk(@Nullable Sdk var1);

    public void refreshSDKs();

    public void refreshAsynchronously();

    @Nullable
    public String suggestSdkName(@NotNull String var1, @NotNull String var2, @NotNull RubyVersionManagerSdkData var3);

    default public void onApplicationInit() {
    }

    default public void onProjectOpened(@NotNull Project project) {
        if (project == null) {
            SdkRefresher.a(0);
        }
    }

    default public void onProjectClosed(@NotNull Project project) {
        if (project == null) {
            SdkRefresher.a(1);
        }
    }

    @Contract(pure=true)
    @Nullable
    public RubyVersionManagerHandlerBase getVersionManagerHandler();

    public static void refreshAllAsynchronously() {
        SdkRefresher.forEach(SdkRefresher::refreshAsynchronously);
    }

    public static void refreshAll() {
        long l2 = t ^ 0x7C4A9DDCFEF2L;
        ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> SdkRefresher.forEach(SdkRefresher::refreshSDKs), RBundle.message((String)"ruby.sdk.scanning"), true, null);
    }

    public static void forEach(Consumer<? super SdkRefresher> action) {
        SdkRefresher.getRefreshers().forEach(action);
    }

    public static boolean isAutoRefreshable(@Nullable Sdk sdk) {
        return SdkRefresher.getRefreshers().stream().anyMatch(sdkRefresher -> sdkRefresher.isManagedSdk(sdk));
    }

    public static List<? extends SdkRefresher> getRefreshers() {
        return Arrays.asList(EP_NAME.getExtensions());
    }

    static {
        t = la.a(4524275539244438193L, -388740583965138325L, MethodHandles.lookup().lookupClass()).a(124365857588611L);
        long l2 = t ^ 0x3C001C5A47F6L;
        EP_NAME = new ExtensionPointName("org.jetbrains.plugins.ruby.rubySdkRefresher");
    }

    private static /* synthetic */ void a(int n2) {
        Object[] objectArray;
        long l2 = t ^ 0x77267F21D385L;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "project";
        objectArray2[1] = "org/jetbrains/plugins/ruby/version/management/SdkRefresher";
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "onProjectOpened";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "onProjectClosed";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

