/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cvsSupport2.cvsBrowser;

import com.intellij.CvsBundle;
import com.intellij.cvsSupport2.connections.CvsEnvironment;
import com.intellij.cvsSupport2.cvsBrowser.GetContentCallback;
import com.intellij.cvsSupport2.cvsBrowser.RemoteResourceDataProvider;
import com.intellij.cvsSupport2.cvsExecution.CvsOperationExecutor;
import com.intellij.cvsSupport2.cvsExecution.DefaultCvsOperationExecutorCallback;
import com.intellij.cvsSupport2.cvshandlers.CommandCvsHandler;
import com.intellij.cvsSupport2.cvsoperations.common.CvsOperation;
import com.intellij.cvsSupport2.cvsoperations.cvsContent.DirectoryContent;
import com.intellij.cvsSupport2.cvsoperations.cvsContent.DirectoryContentProvider;
import com.intellij.cvsSupport2.cvsoperations.cvsContent.GetDirectoriesListViaUpdateOperation;
import com.intellij.cvsSupport2.cvsoperations.cvsMessages.CvsListenerWithProgress;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.util.Consumer;
import java.util.List;

public abstract class AbstractVcsDataProvider
implements RemoteResourceDataProvider {
    protected final CvsEnvironment myEnvironment;
    private Consumer<VcsException> myErrorCallback;

    protected AbstractVcsDataProvider(CvsEnvironment environment) {
        this.myEnvironment = environment;
    }

    @Override
    public void fillContentFor(GetContentCallback callback, Consumer<VcsException> errorCallback) {
        this.myErrorCallback = errorCallback;
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            this.executeCommand(this.createDirectoryContentProvider(callback.getElementPath()), callback);
        } else {
            DirectoryContentProvider provider = this.createDirectoryContentProvider(callback.getElementPath());
            provider.setStreamingListener((Consumer<DirectoryContent>)((Consumer)directoryContent -> callback.appendDirectoryContent((DirectoryContent)directoryContent)));
            this.executeCommand(provider, callback);
        }
    }

    public DirectoryContentProvider createDirectoryContentProvider(String path) {
        return new GetDirectoriesListViaUpdateOperation(this.myEnvironment, path);
    }

    private void executeCommand(DirectoryContentProvider command, final GetContentCallback callback) {
        CvsOperationExecutor executor = new CvsOperationExecutor(false, callback.getProject(), callback.getModalityState());
        executor.setIsQuietOperation(true);
        final CancellableCvsHandler cvsHandler = new CancellableCvsHandler(CvsBundle.message((String)"browse.repository.operation.name", (Object[])new Object[0]), (CvsOperation)((Object)command));
        callback.useForCancel(cvsHandler.getProgressListener());
        executor.performActionSync(cvsHandler, new DefaultCvsOperationExecutorCallback(){

            @Override
            public void executionFinished(boolean successfully) {
                List<VcsException> errors;
                if (!successfully && !(errors = cvsHandler.getErrorsExceptAborted()).isEmpty()) {
                    AbstractVcsDataProvider.this.myErrorCallback.consume((Object)errors.get(0));
                }
                callback.finished();
            }
        });
    }

    private static class CancellableCvsHandler
    extends CommandCvsHandler {
        private CancellableCvsHandler(String title, CvsOperation cvsOperation) {
            super(title, cvsOperation, true);
        }

        @Override
        protected boolean runInReadThread() {
            return false;
        }

        @Override
        public CvsListenerWithProgress getProgressListener() {
            return super.getProgressListener();
        }
    }
}

