/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cvsSupport2.cvsBrowser;

import com.intellij.CvsBundle;
import com.intellij.cvsSupport2.config.CvsRootConfiguration;
import com.intellij.cvsSupport2.cvsBrowser.CvsElement;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.awt.Component;
import java.io.File;
import javax.swing.Icon;
import org.jetbrains.annotations.Nullable;

public class CheckoutHelper {
    private File myCheckoutLocation;
    private final CvsRootConfiguration myConfiguration;
    private final Component myPanel;
    private CvsElement myElement;

    public CheckoutHelper(CvsRootConfiguration configuration, Component panel) {
        this.myConfiguration = configuration;
        this.myPanel = panel;
    }

    public boolean prepareCheckoutData(CvsElement element, boolean useAltCheckoutPath) {
        this.myElement = element;
        if (!useAltCheckoutPath) {
            if (!this.requestLocation()) {
                return false;
            }
            if (this.shouldCreateDirectoryOfTheSameName() && !this.creatingConfirmation()) {
                return false;
            }
        }
        return true;
    }

    private boolean creatingConfirmation() {
        File checkoutDirectory = new File(this.myCheckoutLocation, this.myElement.getCheckoutPath());
        if (checkoutDirectory.isDirectory()) {
            return true;
        }
        return Messages.showYesNoDialog((String)CvsBundle.message((String)"confirmation.text.directory.will.be.created", (Object[])new Object[]{checkoutDirectory}), (String)CvsBundle.message((String)"operation.name.check.out.project", (Object[])new Object[0]), (Icon)Messages.getQuestionIcon()) == 0;
    }

    private boolean shouldCreateDirectoryOfTheSameName() {
        int compareResult = new File(this.myCheckoutLocation.getName()).compareTo(new File(this.myElement.getCheckoutDirectoryName()));
        return compareResult == 0;
    }

    @Nullable
    public VirtualFile chooseCheckoutLocation(String pathToSuggestedFolder) {
        FileChooserDescriptor descriptor = FileChooserDescriptorFactory.createSingleFolderDescriptor();
        descriptor.setTitle(CvsBundle.message((String)"dialog.description.select.a.directory.to.check.out.the.files.to", (Object[])new Object[0]));
        VirtualFile suggestedCheckoutFolder = LocalFileSystem.getInstance().findFileByPath(pathToSuggestedFolder.replace(File.separatorChar, '/'));
        return FileChooser.chooseFile((FileChooserDescriptor)descriptor, (Component)this.myPanel, null, (VirtualFile)suggestedCheckoutFolder);
    }

    private boolean requestLocation() {
        VirtualFile virtualFile = this.chooseCheckoutLocation(this.myConfiguration.PATH_TO_WORKING_FOLDER);
        if (virtualFile == null) {
            return false;
        }
        this.myCheckoutLocation = VfsUtil.virtualToIoFile((VirtualFile)virtualFile);
        this.myConfiguration.PATH_TO_WORKING_FOLDER = this.myCheckoutLocation.getAbsolutePath();
        return true;
    }

    public File getCheckoutLocation() {
        return this.myCheckoutLocation;
    }
}

