/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.rails.codeInsight.actionCable;

import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.navigation.GotoRelatedItem;
import com.intellij.navigation.GotoRelatedProvider;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.util.ArrayUtil;
import icons.RubyJavascriptDebuggerIcons;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.rails.RailsUtil;
import org.jetbrains.plugins.ruby.rails.actions.navigation.RailsRelatedFilesProvider;
import org.jetbrains.plugins.ruby.rails.facet.RailsFacetUtil;
import org.jetbrains.plugins.ruby.rails.facet.configuration.StandardRailsPaths;
import org.jetbrains.plugins.ruby.rails.model.RailsChannel;

public class ActionCableGotoRelatedProvider
extends GotoRelatedProvider {
    private static final String[] CHANNEL_CLIENT_FILE_EXTENSION = new String[]{"coffee", "js"};

    @NotNull
    public List<? extends GotoRelatedItem> getItems(@NotNull DataContext context) {
        PsiFile file;
        if (context == null) {
            ActionCableGotoRelatedProvider.$$$reportNull$$$0(0);
        }
        if ((file = (PsiFile)CommonDataKeys.PSI_FILE.getData(context)) != null) {
            List<? extends GotoRelatedItem> list = this.getItems((PsiElement)file);
            if (list == null) {
                ActionCableGotoRelatedProvider.$$$reportNull$$$0(1);
            }
            return list;
        }
        List list = Collections.emptyList();
        if (list == null) {
            ActionCableGotoRelatedProvider.$$$reportNull$$$0(2);
        }
        return list;
    }

    @NotNull
    public List<? extends GotoRelatedItem> getItems(@NotNull PsiElement element) {
        RailsChannel possibleChannel;
        Module module;
        if (element == null) {
            ActionCableGotoRelatedProvider.$$$reportNull$$$0(3);
        }
        if ((module = ModuleUtilCore.findModuleForPsiElement((PsiElement)element)) == null) {
            List list = Collections.emptyList();
            if (list == null) {
                ActionCableGotoRelatedProvider.$$$reportNull$$$0(4);
            }
            return list;
        }
        StandardRailsPaths paths = RailsFacetUtil.getRailsAppPaths((Module)module);
        if (paths == null) {
            List list = Collections.emptyList();
            if (list == null) {
                ActionCableGotoRelatedProvider.$$$reportNull$$$0(5);
            }
            return list;
        }
        PsiFile psiFile = element.getContainingFile();
        RailsChannel railsChannel = possibleChannel = psiFile != null ? RailsChannel.fromFile((PsiFile)psiFile) : null;
        if (possibleChannel != null) {
            List<? extends GotoRelatedItem> list = ActionCableGotoRelatedProvider.getRelatedItemsForChannel(possibleChannel, paths);
            if (list == null) {
                ActionCableGotoRelatedProvider.$$$reportNull$$$0(6);
            }
            return list;
        }
        if (psiFile instanceof JSFile && RailsUtil.isUnderChannelClientDirectory((PsiFile)psiFile)) {
            List<? extends GotoRelatedItem> list = ActionCableGotoRelatedProvider.getRelatedItemsForChannelClient(psiFile, paths);
            if (list == null) {
                ActionCableGotoRelatedProvider.$$$reportNull$$$0(7);
            }
            return list;
        }
        List list = Collections.emptyList();
        if (list == null) {
            ActionCableGotoRelatedProvider.$$$reportNull$$$0(8);
        }
        return list;
    }

    private static List<? extends GotoRelatedItem> getRelatedItemsForChannelClient(@NotNull PsiFile jsFile, StandardRailsPaths paths) {
        VirtualFile channelsDir;
        if (jsFile == null) {
            ActionCableGotoRelatedProvider.$$$reportNull$$$0(9);
        }
        if ((channelsDir = VirtualFileManager.getInstance().findFileByUrl(paths.getChannelsRootURL())) == null || !channelsDir.exists() || !channelsDir.isDirectory()) {
            return Collections.emptyList();
        }
        Project project = jsFile.getProject();
        boolean mnemonicUsed = false;
        ArrayList<RailsRelatedFilesProvider.RailsGotoRelatedItem> result = new ArrayList<RailsRelatedFilesProvider.RailsGotoRelatedItem>();
        for (VirtualFile file : channelsDir.getChildren()) {
            RailsChannel channel;
            PsiFile channelFile;
            if (file.isDirectory() || !file.getNameWithoutExtension().endsWith("channel") || (channelFile = PsiManager.getInstance((Project)project).findFile(file)) == null || (channel = RailsChannel.fromFile((PsiFile)channelFile)) == null) continue;
            result.add(new RailsRelatedFilesProvider.RailsGotoRelatedItem((PsiElement)channel.getRClass(), RBundle.message((String)"rails.action.cable.channel"), RubyJavascriptDebuggerIcons.Channel, mnemonicUsed ? -1 : 7));
            mnemonicUsed = true;
        }
        return result;
    }

    private static List<? extends GotoRelatedItem> getRelatedItemsForChannel(@NotNull RailsChannel channel, StandardRailsPaths paths) {
        if (channel == null) {
            ActionCableGotoRelatedProvider.$$$reportNull$$$0(10);
        }
        String assetChannelPath = paths.getChannelClientsRootURL();
        VirtualFile channelJavascriptDir = VirtualFileManager.getInstance().findFileByUrl(assetChannelPath);
        if (channelJavascriptDir == null || !channelJavascriptDir.isDirectory()) {
            return Collections.emptyList();
        }
        boolean mnemonicUsed = false;
        ArrayList<RailsRelatedFilesProvider.RailsGotoRelatedItem> result = new ArrayList<RailsRelatedFilesProvider.RailsGotoRelatedItem>();
        for (VirtualFile file : channelJavascriptDir.getChildren()) {
            PsiFile channelClientPsiFile;
            String extension = file.getExtension();
            if (file.isDirectory() || extension == null || !ArrayUtil.contains((String)extension.toLowerCase(), (String[])CHANNEL_CLIENT_FILE_EXTENSION) || (channelClientPsiFile = PsiManager.getInstance((Project)channel.getApp().getProject()).findFile(file)) == null) continue;
            result.add(new RailsRelatedFilesProvider.RailsGotoRelatedItem((PsiElement)channelClientPsiFile, RBundle.message((String)"rails.action.cable.channel.client"), channelClientPsiFile.getIcon(0), mnemonicUsed ? -1 : 7));
            mnemonicUsed = true;
        }
        return result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/rails/codeInsight/actionCable/ActionCableGotoRelatedProvider";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jsFile";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "channel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/rails/codeInsight/actionCable/ActionCableGotoRelatedProvider";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getItems";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getItems";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getRelatedItemsForChannelClient";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getRelatedItemsForChannel";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

