/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.config;

import java.util.ArrayList;
import java.util.List;
import org.jetbrains.idea.svn.config.SvnConfigureProxiesComponent;
import org.jetbrains.idea.svn.config.ValidationListener;

public class GroupsValidator
implements Runnable {
    private final List<SvnConfigureProxiesComponent> myComponents = new ArrayList<SvnConfigureProxiesComponent>();
    private final ValidationListener myListener;
    private boolean myStopped;

    public GroupsValidator(ValidationListener listener) {
        this.myListener = listener;
    }

    public void add(SvnConfigureProxiesComponent component) {
        this.myComponents.add(component);
    }

    @Override
    public void run() {
        if (this.myStopped) {
            return;
        }
        this.myListener.onSuccess();
        boolean valid = true;
        for (SvnConfigureProxiesComponent component : this.myComponents) {
            if (component.validate(this.myListener)) continue;
            valid = false;
            break;
        }
        for (SvnConfigureProxiesComponent component : this.myComponents) {
            component.setIsValid(valid);
        }
    }

    public void stop() {
        this.myStopped = true;
    }
}

