/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.framework.detection;

import com.intellij.facet.Facet;
import com.intellij.facet.FacetConfiguration;
import com.intellij.facet.FacetType;
import com.intellij.facet.FacetTypeId;
import com.intellij.facet.FacetTypeRegistry;
import com.intellij.framework.FrameworkType;
import com.intellij.framework.detection.DetectedFrameworkDescription;
import com.intellij.framework.detection.FrameworkDetectionContext;
import com.intellij.framework.detection.FrameworkDetector;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ui.EmptyIcon;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class FacetBasedFrameworkDetector<F extends Facet, C extends FacetConfiguration>
extends FrameworkDetector {
    private static final Logger LOG = Logger.getInstance(FacetBasedFrameworkDetector.class);

    protected FacetBasedFrameworkDetector(String detectorId) {
        super(detectorId);
    }

    protected FacetBasedFrameworkDetector(@NotNull String detectorId, int detectorVersion) {
        if (detectorId == null) {
            FacetBasedFrameworkDetector.$$$reportNull$$$0(0);
        }
        super(detectorId, detectorVersion);
    }

    @NotNull
    public abstract FacetType<F, C> getFacetType();

    @NotNull
    public List<Pair<C, Collection<VirtualFile>>> createConfigurations(@NotNull Collection<VirtualFile> files, @NotNull Collection<C> existentFacetConfigurations) {
        C configuration;
        if (files == null) {
            FacetBasedFrameworkDetector.$$$reportNull$$$0(1);
        }
        if (existentFacetConfigurations == null) {
            FacetBasedFrameworkDetector.$$$reportNull$$$0(2);
        }
        if ((configuration = this.createConfiguration(files)) != null) {
            List<Pair<C, Collection<VirtualFile>>> list = Collections.singletonList(Pair.create(configuration, files));
            if (list == null) {
                FacetBasedFrameworkDetector.$$$reportNull$$$0(3);
            }
            return list;
        }
        List<Pair<C, Collection<VirtualFile>>> list = Collections.emptyList();
        if (list == null) {
            FacetBasedFrameworkDetector.$$$reportNull$$$0(4);
        }
        return list;
    }

    @Nullable
    protected C createConfiguration(Collection<VirtualFile> files) {
        return this.getFacetType().createDefaultConfiguration();
    }

    public void setupFacet(@NotNull F facet, ModifiableRootModel model) {
        if (facet == null) {
            FacetBasedFrameworkDetector.$$$reportNull$$$0(5);
        }
    }

    @Override
    public List<? extends DetectedFrameworkDescription> detect(@NotNull Collection<VirtualFile> newFiles, @NotNull FrameworkDetectionContext context) {
        if (newFiles == null) {
            FacetBasedFrameworkDetector.$$$reportNull$$$0(6);
        }
        if (context == null) {
            FacetBasedFrameworkDetector.$$$reportNull$$$0(7);
        }
        return context.createDetectedFacetDescriptions(this, newFiles);
    }

    @Override
    public FrameworkType getFrameworkType() {
        FacetType<F, C> type = this.getFacetType();
        LOG.assertTrue(type != null, (Object)("'getFacetType' returns 'null' in " + this.getClass()));
        return FacetBasedFrameworkDetector.createFrameworkType(type);
    }

    static FrameworkType createFrameworkType(FacetType<?, ?> facetType) {
        return new FacetBasedFrameworkType(facetType);
    }

    @Override
    public FrameworkType getUnderlyingFrameworkType() {
        FacetTypeId<?> underlyingTypeId = this.getFacetType().getUnderlyingFacetType();
        return underlyingTypeId != null ? FacetBasedFrameworkDetector.createFrameworkType(FacetTypeRegistry.getInstance().findFacetType(underlyingTypeId)) : null;
    }

    public boolean isSuitableUnderlyingFacetConfiguration(FacetConfiguration underlying, C configuration, Set<VirtualFile> files) {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "detectorId";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "existentFacetConfigurations";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/framework/detection/FacetBasedFrameworkDetector";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facet";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newFiles";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/framework/detection/FacetBasedFrameworkDetector";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createConfigurations";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createConfigurations";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setupFacet";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "detect";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class FacetBasedFrameworkType
    extends FrameworkType {
        private final FacetType<?, ?> myFacetType;
        private final Icon myIcon;

        FacetBasedFrameworkType(@NotNull FacetType<?, ?> facetType) {
            if (facetType == null) {
                FacetBasedFrameworkType.$$$reportNull$$$0(0);
            }
            super(facetType.getStringId());
            this.myFacetType = facetType;
            Icon icon = this.myFacetType.getIcon();
            this.myIcon = icon != null ? icon : EmptyIcon.ICON_16;
        }

        @Override
        @NotNull
        public String getPresentableName() {
            String string = this.myFacetType.getPresentableName();
            if (string == null) {
                FacetBasedFrameworkType.$$$reportNull$$$0(1);
            }
            return string;
        }

        @Override
        @NotNull
        public Icon getIcon() {
            Icon icon = this.myIcon;
            if (icon == null) {
                FacetBasedFrameworkType.$$$reportNull$$$0(2);
            }
            return icon;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "facetType";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/framework/detection/FacetBasedFrameworkDetector$FacetBasedFrameworkType";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/framework/detection/FacetBasedFrameworkDetector$FacetBasedFrameworkType";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPresentableName";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getIcon";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

