/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagram.rails;

import com.intellij.diagram.DiagramDataModel;
import com.intellij.diagram.DiagramEdge;
import com.intellij.diagram.DiagramNode;
import com.intellij.diagram.rails.RailsUmlDiagramProvider;
import com.intellij.diagram.rails.RailsUmlEdge;
import com.intellij.diagram.rails.RailsUmlNode;
import com.intellij.diagram.rails.associations.AssociationManager;
import com.intellij.diagram.rails.associations.AssociationProperty;
import com.intellij.diagram.rails.associations.AssociationRelationship;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.psi.PsiManager;
import com.intellij.psi.util.PsiModificationTracker;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.associations.Association;
import org.jetbrains.plugins.ruby.rails.model.RailsApp;
import org.jetbrains.plugins.ruby.ruby.codeInsight.resolve.scope.RElementWithFQN;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.fqn.FQN;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.Symbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.SymbolUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.classes.RClass;
import org.jetbrains.plugins.ruby.ruby.lang.psi.holders.RContainer;

public class RailsUmlDataModel
extends DiagramDataModel<RClass> {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.plugins.ruby.rails.db.associationsEditor.model.AssociationDataModel");
    private final Module myModule;
    private List<RClass> myClasses;
    private final Set<DiagramNode<RClass>> myNodes;
    private final Set<DiagramNode<RClass>> myRemovedNodes;
    private final Collection<DiagramEdge<RClass>> myEdges;

    public RailsUmlDataModel(@NotNull Module module) {
        if (module == null) {
            RailsUmlDataModel.$$$reportNull$$$0(0);
        }
        super(module.getProject(), RailsUmlDiagramProvider.getInstance());
        this.myClasses = new ArrayList<RClass>();
        this.myNodes = new com.intellij.util.containers.hash.HashSet();
        this.myRemovedNodes = new com.intellij.util.containers.hash.HashSet();
        this.myEdges = new HashSet<DiagramEdge<RClass>>();
        this.myModule = module;
        RailsApp app = RailsApp.fromModule((Module)module);
        LOG.assertTrue(app != null);
    }

    @NotNull
    public Set<DiagramNode<RClass>> getNodes() {
        Set<DiagramNode<RClass>> set = this.myNodes;
        if (set == null) {
            RailsUmlDataModel.$$$reportNull$$$0(1);
        }
        return set;
    }

    @NotNull
    public Collection<DiagramEdge<RClass>> getEdges() {
        Collection<DiagramEdge<RClass>> collection = this.myEdges;
        if (collection == null) {
            RailsUmlDataModel.$$$reportNull$$$0(2);
        }
        return collection;
    }

    @NotNull
    public ModificationTracker getModificationTracker() {
        PsiModificationTracker psiModificationTracker = PsiManager.getInstance((Project)this.getProject()).getModificationTracker();
        if (psiModificationTracker == null) {
            RailsUmlDataModel.$$$reportNull$$$0(3);
        }
        return psiModificationTracker;
    }

    private void init() {
        AssociationManager associationManager = AssociationManager.getInstance(this.myModule);
        this.myClasses = new ArrayList<RClass>(associationManager.getModelClasses());
    }

    public void refreshDataModel() {
        AssociationManager.getInstance(this.myModule).refresh();
        this.init();
        this.myNodes.clear();
        this.myEdges.clear();
        Iterator<RClass> iterator = this.myClasses.iterator();
        while (iterator.hasNext()) {
            RClass next = iterator.next();
            if (next.isValid()) {
                RailsUmlNode node = new RailsUmlNode(next);
                if (this.myRemovedNodes.contains((Object)node)) continue;
                this.myNodes.add((DiagramNode<RClass>)node);
                continue;
            }
            iterator.remove();
        }
        AssociationManager associationManager = AssociationManager.getInstance(this.myModule);
        for (DiagramNode<RClass> fromNode : this.myNodes) {
            for (DiagramNode<RClass> toNode : this.myNodes) {
                List<AssociationRelationship> relationships = associationManager.getRelationships((RClass)fromNode.getIdentifyingElement(), (RClass)toNode.getIdentifyingElement());
                if (relationships.isEmpty()) continue;
                for (AssociationRelationship relationship : relationships) {
                    Object[] toProperties;
                    String propertyName;
                    Association association = relationship.getAssociation();
                    Association reverseAssociation = relationship.getReverseAssociation();
                    RailsUmlEdge edge = new RailsUmlEdge(fromNode, toNode, association, reverseAssociation);
                    this.myEdges.add((DiagramEdge<RClass>)edge);
                    if (association != null) {
                        Object[] fromProperties;
                        for (Object property : fromProperties = this.getProvider().getElementManager().getNodeItems(fromNode.getIdentifyingElement())) {
                            if (!(property instanceof AssociationProperty)) continue;
                            propertyName = ((AssociationProperty)property).getName();
                            String associationName = association.getName();
                            if (!associationName.equals(propertyName)) continue;
                            edge.setSourceAnchor(property);
                        }
                    }
                    if (reverseAssociation == null) continue;
                    for (Object property : toProperties = this.getProvider().getElementManager().getNodeItems(toNode.getIdentifyingElement())) {
                        if (!(property instanceof AssociationProperty)) continue;
                        propertyName = ((AssociationProperty)property).getName();
                        String reverseAssociationName = reverseAssociation.getName();
                        if (!reverseAssociationName.equals(propertyName)) continue;
                        edge.setTargetAnchor(property);
                    }
                }
            }
        }
    }

    public DiagramNode<RClass> addElement(RClass rClass) {
        if (this.isAlreadyDrawn(rClass)) {
            return null;
        }
        RailsUmlNode node = new RailsUmlNode(rClass);
        if (this.myRemovedNodes.contains((Object)node)) {
            this.myRemovedNodes.remove((Object)node);
        }
        return node;
    }

    public void removeNode(DiagramNode<RClass> node) {
        this.myRemovedNodes.add(node);
        this.removeElement((RClass)node.getIdentifyingElement());
    }

    private boolean isAlreadyDrawn(RClass element) {
        if (element != null) {
            FQN elementFQN = null;
            Symbol elementSymbol = SymbolUtil.getSymbolByContainer((RElementWithFQN)element);
            if (elementSymbol != null) {
                elementFQN = elementSymbol.getFQNWithNesting();
            }
            for (DiagramNode<RClass> node : this.myNodes) {
                RClass rClass = (RClass)node.getIdentifyingElement();
                Symbol nodeSymbol = SymbolUtil.getSymbolByContainer((RElementWithFQN)rClass);
                FQN nodeFQN = null;
                if (nodeSymbol != null) {
                    nodeFQN = nodeSymbol.getFQNWithNesting();
                }
                if (elementFQN == null || nodeFQN == null) continue;
                this.myClasses.add(element);
                if (!elementFQN.equals(nodeFQN)) continue;
                return true;
            }
        }
        return false;
    }

    private void removeElement(RClass rClass) {
        DiagramNode node = this.findNodeByRClass(rClass);
        if (node != null) {
            ArrayList<DiagramEdge<RClass>> edges = new ArrayList<DiagramEdge<RClass>>();
            for (DiagramEdge<RClass> edge : this.myEdges) {
                if (!edge.getTarget().equals(node) && !edge.getSource().equals(node)) continue;
                edges.add(edge);
            }
            this.myEdges.removeAll(edges);
        }
        this.myNodes.remove(node);
    }

    @Nullable
    private DiagramNode findNodeByRClass(RClass rClass) {
        Symbol symbol = SymbolUtil.getSymbolByContainer((RElementWithFQN)rClass);
        if (symbol != null) {
            FQN elementFQN = symbol.getFQNWithNesting();
            for (DiagramNode<RClass> node : this.myNodes) {
                FQN fqn = RailsUmlDataModel.getNodeFQN(node);
                if (elementFQN == FQN.INVALID || !elementFQN.equals(fqn)) continue;
                return node;
            }
        }
        return null;
    }

    @NotNull
    public static FQN getNodeFQN(DiagramNode<RClass> node) {
        RContainer container = (RContainer)node.getIdentifyingElement();
        Symbol symbol = SymbolUtil.getSymbolByContainer((RElementWithFQN)container);
        if (symbol != null) {
            FQN fQN = symbol.getFQNWithNesting();
            if (fQN == null) {
                RailsUmlDataModel.$$$reportNull$$$0(4);
            }
            return fQN;
        }
        FQN fQN = FQN.INVALID;
        if (fQN == null) {
            RailsUmlDataModel.$$$reportNull$$$0(5);
        }
        return fQN;
    }

    @NotNull
    public String getNodeName(DiagramNode<RClass> node) {
        String name = node.getTooltip();
        if (name != null) {
            String string = name;
            if (string == null) {
                RailsUmlDataModel.$$$reportNull$$$0(6);
            }
            return string;
        }
        String string = new String();
        if (string == null) {
            RailsUmlDataModel.$$$reportNull$$$0(7);
        }
        return string;
    }

    public DiagramEdge<RClass> createEdge(@NotNull DiagramNode<RClass> from, @NotNull DiagramNode<RClass> to) {
        if (from == null) {
            RailsUmlDataModel.$$$reportNull$$$0(8);
        }
        if (to == null) {
            RailsUmlDataModel.$$$reportNull$$$0(9);
        }
        return null;
    }

    public void dispose() {
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/diagram/rails/RailsUmlDataModel";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "from";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "to";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/diagram/rails/RailsUmlDataModel";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getNodes";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getEdges";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getModificationTracker";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getNodeFQN";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getNodeName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createEdge";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

