/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagram.rails;

import com.intellij.diagram.DiagramEdgeBase;
import com.intellij.diagram.DiagramNode;
import com.intellij.diagram.DiagramRelationshipInfo;
import com.intellij.diagram.rails.RailsUmlNode;
import com.intellij.diagram.rails.RailsUmlRelationship;
import com.intellij.xml.util.XmlStringUtil;
import org.jetbrains.plugins.ruby.associations.Association;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.classes.RClass;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RCall;

public class RailsUmlEdge
extends DiagramEdgeBase<RClass> {
    private final Association myAssociation;
    private final Association myReverseAssociation;
    private final DiagramNode<RClass> mySource;
    private final DiagramNode<RClass> myTarget;

    public RailsUmlEdge(DiagramNode<RClass> source, DiagramNode<RClass> target, Association association, Association reverseAssociation) {
        super(source, target, (DiagramRelationshipInfo)new RailsUmlRelationship(association, reverseAssociation));
        this.mySource = source;
        this.myTarget = target;
        this.myAssociation = association;
        this.myReverseAssociation = reverseAssociation;
    }

    public RailsUmlNode getSource() {
        return (RailsUmlNode)super.getSource();
    }

    public String getName() {
        StringBuilder builder = new StringBuilder();
        if (this.myAssociation != null) {
            RClass model = this.myAssociation.getItem().getRClass();
            builder.append("<b>").append(model.getName()).append(":&nbsp</b>");
            RCall call = this.myAssociation.getRCall();
            if (call != null) {
                builder.append(call.getText()).append("<br>");
            }
        }
        if (this.myReverseAssociation != null) {
            RClass reverseModel = this.myReverseAssociation.getItem().getRClass();
            builder.append("<b>").append(reverseModel.getName()).append(":&nbsp</b>");
            RCall reverseCall = this.myReverseAssociation.getRCall();
            if (reverseCall != null) {
                builder.append(reverseCall.getText());
            }
        }
        if (this.myAssociation == null && this.myReverseAssociation == null && this.mySource != null && this.myTarget != null) {
            builder.append(((RClass)this.mySource.getIdentifyingElement()).getName()).append("&nbsp &#60 &nbsp ").append(((RClass)this.myTarget.getIdentifyingElement()).getName());
        }
        return XmlStringUtil.wrapInHtml((CharSequence)builder);
    }

    public RailsUmlNode getTarget() {
        return (RailsUmlNode)super.getTarget();
    }
}

