/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.rails;

import com.intellij.database.Dbms;
import com.intellij.database.autoconfig.DataSourceConfigUtil;
import com.intellij.database.autoconfig.DataSourceConfiguration;
import com.intellij.database.autoconfig.DataSourceDetector;
import com.intellij.database.rails.YAMLDataSourceConfiguration;
import com.intellij.diagnostic.AttachmentFactory;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.rails.model.RailsApp;
import org.jetbrains.plugins.ruby.ruby.RubyUtil;
import org.yaml.snakeyaml.error.YAMLException;

public class RailsDataSourceDetector
extends DataSourceDetector {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.database.rails.RailsDataSourceInfoProvider");

    public void collectDataSources(@NotNull Module module, @NotNull DataSourceDetector.Builder builder, boolean onTheFly) {
        VirtualFile databaseYml;
        RailsApp app;
        if (module == null) {
            RailsDataSourceDetector.$$$reportNull$$$0(0);
        }
        if (builder == null) {
            RailsDataSourceDetector.$$$reportNull$$$0(1);
        }
        VirtualFile config = (app = RailsApp.fromModule((Module)module)) != null ? app.getConfigRoot() : null;
        VirtualFile virtualFile = databaseYml = config != null ? config.findChild("database.yml") : null;
        if (databaseYml != null) {
            RailsDataSourceDetector.createDataSources(module, builder, databaseYml);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void createDataSources(@NotNull Module module, @NotNull DataSourceDetector.Builder builder, VirtualFile databaseYml) {
        Map map;
        String text;
        if (module == null) {
            RailsDataSourceDetector.$$$reportNull$$$0(2);
        }
        if (builder == null) {
            RailsDataSourceDetector.$$$reportNull$$$0(3);
        }
        PsiFile file = PsiManager.getInstance((Project)module.getProject()).findFile(databaseYml);
        Document document = FileDocumentManager.getInstance().getDocument(databaseYml);
        String string = text = document == null ? null : document.getText();
        if (StringUtil.isEmpty((String)text)) {
            return;
        }
        try (ByteArrayInputStream in = new ByteArrayInputStream(text.getBytes(CharsetToolkit.UTF8_CHARSET));){
            map = RubyUtil.loadYaml((InputStream)in);
        }
        catch (YAMLException e) {
            return;
        }
        catch (Exception e) {
            LOG.error("Error loading data sources from: " + databaseYml.getName(), (Throwable)e, new Attachment[]{AttachmentFactory.createAttachment((Document)document)});
            return;
        }
        if (map != null) {
            for (Object o : map.keySet()) {
                if (!(map.get(o) instanceof Map)) continue;
                RailsDataSourceDetector.createDataSource(module, o.toString(), (Map)map.get(o), builder, file);
            }
        }
    }

    private static void createDataSource(@NotNull Module module, String key, Map value, @NotNull DataSourceDetector.Builder builder, PsiFile db) {
        Object adapterName;
        if (module == null) {
            RailsDataSourceDetector.$$$reportNull$$$0(4);
        }
        if (builder == null) {
            RailsDataSourceDetector.$$$reportNull$$$0(5);
        }
        if ((adapterName = value.get("adapter")) == null) {
            return;
        }
        Dbms dbms = RailsDataSourceDetector.guessDbms(adapterName.toString());
        if (dbms == Dbms.UNKNOWN) {
            return;
        }
        if (dbms == Dbms.MYSQL && value.get("socket") != null && value.get("host") == null) {
            return;
        }
        YAMLDataSourceConfiguration config = new YAMLDataSourceConfiguration(module, value);
        String dbName = "Rails " + module.getName() + ": " + key;
        DataSourceConfigUtil.buildDataSource((Dbms)dbms, (String)dbName, (String)"database.yml", (PsiElement)db, (DataSourceConfiguration)config, (DataSourceDetector.Builder)builder);
    }

    @NotNull
    private static Dbms guessDbms(String adapter) {
        adapter = StringUtil.trimStart((String)adapter, (String)"jdbc");
        Dbms dbms = Dbms.fromString((String)adapter);
        if (dbms == null) {
            RailsDataSourceDetector.$$$reportNull$$$0(6);
        }
        return dbms;
    }

    public boolean isRelevantFile(@NotNull PsiFile file) {
        if (file == null) {
            RailsDataSourceDetector.$$$reportNull$$$0(7);
        }
        return "database.yml".equals(file.getName());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/rails/RailsDataSourceDetector";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/rails/RailsDataSourceDetector";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "guessDbms";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "collectDataSources";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createDataSources";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createDataSource";
                break;
            }
            case 6: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isRelevantFile";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

