/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.resolve.accessibility;

import com.intellij.lang.ecmascript6.psi.ES6ImportSpecifier;
import com.intellij.lang.ecmascript6.resolve.ES6PsiUtil;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSField;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.resolve.AccessibilityProcessingHandler;
import com.intellij.lang.javascript.psi.resolve.ResultSink;
import com.intellij.lang.javascript.psi.resolve.SinkResolveProcessor;
import com.intellij.lang.javascript.psi.resolve.accessibility.JSAccessibilityChecker;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfigService;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptConfigAccessibilityChecker
extends JSAccessibilityChecker {
    public static final TypeScriptConfigAccessibilityChecker INSTANCE = new TypeScriptConfigAccessibilityChecker();
    private static final Collection<Class<? extends JSElement>> myClasses = ContainerUtil.newArrayList((Object[])new Class[]{JSVariable.class, JSFunction.class, JSField.class, ES6ImportSpecifier.class, JSClass.class});

    @Override
    @NotNull
    protected Collection<Class<? extends JSElement>> getSuitableClasses() {
        Collection<Class<? extends JSElement>> collection = myClasses;
        if (collection == null) {
            TypeScriptConfigAccessibilityChecker.$$$reportNull$$$0(0);
        }
        return collection;
    }

    @Override
    protected String checkImpl(@Nullable PsiElement place, @NotNull PsiElement element) {
        if (element == null) {
            TypeScriptConfigAccessibilityChecker.$$$reportNull$$$0(1);
        }
        if (place == null) {
            return null;
        }
        if (place instanceof ES6ImportSpecifier) {
            return null;
        }
        PsiFile placeContainingFile = place.getContainingFile();
        PsiFile elementContainingFile = element.getContainingFile();
        if (placeContainingFile == null || elementContainingFile == null) {
            return null;
        }
        if (place instanceof JSReferenceExpression && ((JSReferenceExpression)place).getQualifier() != null) {
            if (ES6PsiUtil.isExternalModule((PsiElement)elementContainingFile)) {
                return null;
            }
            PsiElement module = ES6PsiUtil.findExternalModule(element);
            if (module != null) {
                return null;
            }
        }
        VirtualFile scope = placeContainingFile.getOriginalFile().getVirtualFile();
        VirtualFile referencedFile = elementContainingFile.getOriginalFile().getVirtualFile();
        if (scope == null || referencedFile == null) {
            return null;
        }
        if (!TypeScriptConfigService.Provider.isAccessible(place.getProject(), scope, referencedFile)) {
            return "javascript.element.need.to.be.included.to.config";
        }
        return null;
    }

    @Override
    public boolean isAvailable(AccessibilityProcessingHandler handler, SinkResolveProcessor resolveProcessor) {
        return ((ResultSink)resolveProcessor.getResultSink()).isTypeScript() && !resolveProcessor.isLocalResolve();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/resolve/accessibility/TypeScriptConfigAccessibilityChecker";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getSuitableClasses";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/resolve/accessibility/TypeScriptConfigAccessibilityChecker";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "checkImpl";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

