/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.types;

import com.intellij.codeInsight.completion.CompletionUtilCoreImpl;
import com.intellij.lang.ecmascript6.resolve.ES6PsiUtil;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSNumberParser;
import com.intellij.lang.javascript.ecmascript6.TypeScriptSignatureChooser;
import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.psi.JSBlockStatement;
import com.intellij.lang.javascript.psi.JSCommonTypeNames;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSDestructuringContainer;
import com.intellij.lang.javascript.psi.JSDestructuringParameter;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSElementBase;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionItem;
import com.intellij.lang.javascript.psi.JSFunctionType;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSParameterItem;
import com.intellij.lang.javascript.psi.JSParameterListElement;
import com.intellij.lang.javascript.psi.JSParameterTypeDecorator;
import com.intellij.lang.javascript.psi.JSPsiElementBase;
import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSSourceElement;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeDeclarationOwner;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecma6.ES6ReferenceList;
import com.intellij.lang.javascript.psi.ecma6.FlowJSFunctionType;
import com.intellij.lang.javascript.psi.ecma6.FlowJSMaybeType;
import com.intellij.lang.javascript.psi.ecma6.JSTypeDeclaration;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptArrayType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptBooleanLiteralType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptClass;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptCompileTimeType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptConditionalType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptFunction;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptFunctionType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptGenericOrMappedTypeParameter;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptIndexedAccessType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptInferType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptInterface;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptMappedType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptMappedTypeParameter;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptModule;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptNamedGenericArgumentType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptNumberLiteralType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptObjectType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptParenthesizedType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptSingleType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptSpreadType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptStringLiteralType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptThisType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTupleType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeAlias;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeOperator;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeParameter;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeParameterList;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeParameterListOwner;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypePredicate;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeofType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptUnionOrIntersectionType;
import com.intellij.lang.javascript.psi.ecma6.impl.ES6ReferenceListImpl;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.ecmal4.JSReferenceList;
import com.intellij.lang.javascript.psi.ecmal4.JSReferenceListMember;
import com.intellij.lang.javascript.psi.resolve.JSClassResolver;
import com.intellij.lang.javascript.psi.resolve.JSImportHandlingUtil;
import com.intellij.lang.javascript.psi.resolve.JSRecursionGuard;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.stubs.JSImplicitPrototypeElement;
import com.intellij.lang.javascript.psi.types.JSAnyType;
import com.intellij.lang.javascript.psi.types.JSApplyNewType;
import com.intellij.lang.javascript.psi.types.JSArrayTypeImpl;
import com.intellij.lang.javascript.psi.types.JSBigIntLiteralTypeImpl;
import com.intellij.lang.javascript.psi.types.JSBooleanLiteralTypeImpl;
import com.intellij.lang.javascript.psi.types.JSCompositeTypeImpl;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.lang.javascript.psi.types.JSDecoratedType;
import com.intellij.lang.javascript.psi.types.JSDecoratedTypeImpl;
import com.intellij.lang.javascript.psi.types.JSFunctionTypeImpl;
import com.intellij.lang.javascript.psi.types.JSGenericParameterImpl;
import com.intellij.lang.javascript.psi.types.JSGenericTypeImpl;
import com.intellij.lang.javascript.psi.types.JSIntersectionTypeImpl;
import com.intellij.lang.javascript.psi.types.JSLiteralKeyType;
import com.intellij.lang.javascript.psi.types.JSNamedType;
import com.intellij.lang.javascript.psi.types.JSNamedTypeFactory;
import com.intellij.lang.javascript.psi.types.JSNamedTypeSubstitutorType;
import com.intellij.lang.javascript.psi.types.JSNumberLiteralTypeImpl;
import com.intellij.lang.javascript.psi.types.JSRecordTypeImpl;
import com.intellij.lang.javascript.psi.types.JSSimpleRecordTypeImpl;
import com.intellij.lang.javascript.psi.types.JSSimpleTypeBaseImpl;
import com.intellij.lang.javascript.psi.types.JSSpreadTypeImpl;
import com.intellij.lang.javascript.psi.types.JSStringLiteralTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTaggedLiteralKeyTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTupleTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeBaseImpl;
import com.intellij.lang.javascript.psi.types.JSTypeCastUtil;
import com.intellij.lang.javascript.psi.types.JSTypeContext;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.JSTypeSourceFactory;
import com.intellij.lang.javascript.psi.types.JSTypeSubstitutor;
import com.intellij.lang.javascript.psi.types.JSTypeWithOuterGenerics;
import com.intellij.lang.javascript.psi.types.JSTypeofTypeImpl;
import com.intellij.lang.javascript.psi.types.TypeScriptConditionalTypeGenericParameterImpl;
import com.intellij.lang.javascript.psi.types.TypeScriptConditionalTypeJSTypeImpl;
import com.intellij.lang.javascript.psi.types.TypeScriptGenericThisTypeImpl;
import com.intellij.lang.javascript.psi.types.TypeScriptIndexedAccessJSTypeImpl;
import com.intellij.lang.javascript.psi.types.TypeScriptJSFunctionTypeImpl;
import com.intellij.lang.javascript.psi.types.TypeScriptMappedJSTypeImpl;
import com.intellij.lang.javascript.psi.types.TypeScriptMappedTypeGenericParameterImpl;
import com.intellij.lang.javascript.psi.types.TypeScriptTypeMemberParser;
import com.intellij.lang.javascript.psi.types.TypeScriptTypeOfJSTypeImpl;
import com.intellij.lang.javascript.psi.types.TypeScriptTypeOperatorJSTypeImpl;
import com.intellij.lang.javascript.psi.types.TypeScriptTypePredicateTypeImpl;
import com.intellij.lang.javascript.psi.types.primitives.JSNullType;
import com.intellij.lang.javascript.psi.types.primitives.JSUndefinedType;
import com.intellij.lang.javascript.psi.types.typescript.TypeScriptGenericDeclarationTypeImpl;
import com.intellij.lang.javascript.psi.types.typescript.TypeScriptGenericParameterImpl;
import com.intellij.lang.javascript.psi.util.JSClassUtils;
import com.intellij.lang.typescript.library.TypeScriptLibraryProvider;
import com.intellij.lang.typescript.psi.TypeScriptPsiUtil;
import com.intellij.lang.typescript.resolve.TypeScriptGenericTypesEvaluator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.ParameterizedCachedValue;
import com.intellij.psi.util.ParameterizedCachedValueProvider;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.ArrayUtil;
import com.intellij.util.AstLoadingFilter;
import com.intellij.util.Function;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.TIntHashSet;
import gnu.trove.TIntIterator;
import java.lang.invoke.LambdaMetafactory;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptTypeParser {
    private static final ParameterizedCachedValueProvider<JSRecordType, JSClass> BUILD_CLASS_PROVIDER = currentClass -> {
        JSRecordType result2 = (JSRecordType)RecursionManager.doPreventingRecursion((Object)currentClass, (boolean)false, () -> TypeScriptTypeParser.buildTypeFromClass(currentClass, false, true));
        if (result2 == null) {
            result2 = new JSRecordTypeImpl(JSTypeSourceFactory.createTypeSource((PsiElement)currentClass, false), ContainerUtil.emptyList());
        }
        return CachedValueProvider.Result.create((Object)result2, (Object[])new Object[]{JSTypeUtils.getTypeInvalidationDependency()});
    };
    private static final Key<ParameterizedCachedValue<JSRecordType, JSClass>> BUILD_CLASS_CACHE_KEY = Key.create((String)"ts.create.record.cl");
    private static final Key<CachedValue<JSFunctionType>> TS_FULL_FUNCTION_CACHE_KEY = Key.create((String)"ts.fn.full.type.cache");
    public static final Function<JSTypeDeclaration, JSType> MAP_DECLARATION_TO_TYPE = TypeScriptTypeParser::buildTypeFromTypeScript;

    @NotNull
    public static JSType buildTypeFromTypeScript(@NotNull JSTypeDeclaration type) {
        if (type == null) {
            TypeScriptTypeParser.$$$reportNull$$$0(0);
        }
        JSType jSType = TypeScriptTypeParser.buildTypeFromTypeScriptImpl(type);
        if (jSType == null) {
            TypeScriptTypeParser.$$$reportNull$$$0(1);
        }
        return jSType;
    }

    @NotNull
    private static JSType buildTypeFromTypeScriptImpl(@NotNull JSTypeDeclaration type) {
        if (type == null) {
            TypeScriptTypeParser.$$$reportNull$$$0(2);
        }
        if (type instanceof TypeScriptParenthesizedType) {
            type = TypeScriptPsiUtil.unparenthesizeType(type);
        }
        JSTypeSource source = JSTypeSourceFactory.createTypeSource((PsiElement)type, true);
        if (type instanceof TypeScriptSpreadType) {
            TypeScriptType innerType = ((TypeScriptSpreadType)type).getInnerType();
            JSType inner = innerType == null ? null : TypeScriptTypeParser.buildTypeFromTypeScript((JSTypeDeclaration)innerType);
            JSSimpleTypeBaseImpl jSSimpleTypeBaseImpl = inner == null ? JSAnyType.get(source) : new JSSpreadTypeImpl(source, inner);
            if (jSSimpleTypeBaseImpl == null) {
                TypeScriptTypeParser.$$$reportNull$$$0(3);
            }
            return jSSimpleTypeBaseImpl;
        }
        if (type instanceof TypeScriptNamedGenericArgumentType) {
            TypeScriptType value = ((TypeScriptNamedGenericArgumentType)type).getTypeValue();
            if (value == null) {
                JSAnyType jSAnyType = JSAnyType.get(source);
                if (jSAnyType == null) {
                    TypeScriptTypeParser.$$$reportNull$$$0(4);
                }
                return jSAnyType;
            }
            JSNamedTypeSubstitutorType jSNamedTypeSubstitutorType = new JSNamedTypeSubstitutorType(source, TypeScriptTypeParser.buildTypeFromTypeScript((JSTypeDeclaration)value), ((TypeScriptNamedGenericArgumentType)type).getGenericName());
            if (jSNamedTypeSubstitutorType == null) {
                TypeScriptTypeParser.$$$reportNull$$$0(5);
            }
            return jSNamedTypeSubstitutorType;
        }
        if (type instanceof TypeScriptObjectType) {
            ArrayList<JSRecordType.TypeMember> typeMembers = new ArrayList<JSRecordType.TypeMember>();
            TypeScriptTypeParser.addObjectTypeProperties(typeMembers, (TypeScriptObjectType)type, JSTypeSubstitutor.EMPTY, false);
            JSSimpleRecordTypeImpl jSSimpleRecordTypeImpl = new JSSimpleRecordTypeImpl(source, typeMembers);
            if (jSSimpleRecordTypeImpl == null) {
                TypeScriptTypeParser.$$$reportNull$$$0(6);
            }
            return jSSimpleRecordTypeImpl;
        }
        if (type instanceof TypeScriptInferType) {
            TypeScriptInferType inferType = (TypeScriptInferType)type;
            String variableName = inferType.getVariableName();
            JSTypeBaseImpl jSTypeBaseImpl = variableName == null ? JSAnyType.get(source) : new TypeScriptConditionalTypeGenericParameterImpl(TypeScriptTypeParser.getTypeParameterId((TypeScriptGenericOrMappedTypeParameter)inferType), source);
            if (jSTypeBaseImpl == null) {
                TypeScriptTypeParser.$$$reportNull$$$0(7);
            }
            return jSTypeBaseImpl;
        }
        if (type instanceof TypeScriptFunctionType || type instanceof FlowJSFunctionType) {
            JSFunctionType jsType = TypeScriptTypeParser.buildFunctionType((JSFunctionItem)type);
            if (((JSFunction)type).isConstructor() && jsType instanceof JSFunctionTypeImpl) {
                SmartList typeMembers = new SmartList((Object)new JSRecordTypeImpl.CallSignatureImpl(true, jsType));
                JSRecordTypeImpl jSRecordTypeImpl = new JSRecordTypeImpl(source, (List<? extends JSRecordType.TypeMember>)typeMembers);
                if (jSRecordTypeImpl == null) {
                    TypeScriptTypeParser.$$$reportNull$$$0(8);
                }
                return jSRecordTypeImpl;
            }
            JSFunctionType jSFunctionType = jsType;
            if (jSFunctionType == null) {
                TypeScriptTypeParser.$$$reportNull$$$0(9);
            }
            return jSFunctionType;
        }
        if (type instanceof TypeScriptArrayType) {
            TypeScriptType arrayBaseType = ((TypeScriptArrayType)type).getType();
            JSType baseType = arrayBaseType != null ? TypeScriptTypeParser.buildTypeFromTypeScript((JSTypeDeclaration)arrayBaseType) : JSAnyType.get((PsiElement)type, false);
            JSArrayTypeImpl jSArrayTypeImpl = new JSArrayTypeImpl(baseType, source);
            if (jSArrayTypeImpl == null) {
                TypeScriptTypeParser.$$$reportNull$$$0(10);
            }
            return jSArrayTypeImpl;
        }
        if (type instanceof TypeScriptSingleType) {
            JSType result2 = TypeScriptTypeParser.buildSingleType((TypeScriptSingleType)type, source);
            if (result2 != null) {
                JSType jSType = result2;
                if (jSType == null) {
                    TypeScriptTypeParser.$$$reportNull$$$0(11);
                }
                return jSType;
            }
        } else if (type instanceof TypeScriptStringLiteralType) {
            String literal = ((TypeScriptStringLiteralType)type).getInnerText();
            if (literal != null) {
                JSLiteralKeyType literalKeyType = JSTaggedLiteralKeyTypeImpl.tryCreate((PsiElement)type, (TypeScriptType)((TypeScriptStringLiteralType)type), literal);
                if (literalKeyType != null) {
                    JSLiteralKeyType jSLiteralKeyType = literalKeyType;
                    if (jSLiteralKeyType == null) {
                        TypeScriptTypeParser.$$$reportNull$$$0(12);
                    }
                    return jSLiteralKeyType;
                }
                JSStringLiteralTypeImpl jSStringLiteralTypeImpl = new JSStringLiteralTypeImpl(literal, false, source);
                if (jSStringLiteralTypeImpl == null) {
                    TypeScriptTypeParser.$$$reportNull$$$0(13);
                }
                return jSStringLiteralTypeImpl;
            }
        } else if (type instanceof TypeScriptNumberLiteralType) {
            String literal = ((TypeScriptNumberLiteralType)type).getInnerText();
            if (literal != null) {
                BigInteger bigInt = JSNumberParser.tryParseBigInt(literal);
                if (bigInt != null) {
                    JSBigIntLiteralTypeImpl jSBigIntLiteralTypeImpl = new JSBigIntLiteralTypeImpl(bigInt, false, source, literal);
                    if (jSBigIntLiteralTypeImpl == null) {
                        TypeScriptTypeParser.$$$reportNull$$$0(14);
                    }
                    return jSBigIntLiteralTypeImpl;
                }
                Double parsedLiteral = JSNumberParser.tryParseNumericValue(literal, true);
                if (parsedLiteral != null) {
                    JSNumberLiteralTypeImpl jSNumberLiteralTypeImpl = new JSNumberLiteralTypeImpl(parsedLiteral, false, source, literal);
                    if (jSNumberLiteralTypeImpl == null) {
                        TypeScriptTypeParser.$$$reportNull$$$0(15);
                    }
                    return jSNumberLiteralTypeImpl;
                }
            }
        } else {
            if (type instanceof TypeScriptBooleanLiteralType) {
                JSBooleanLiteralTypeImpl jSBooleanLiteralTypeImpl = new JSBooleanLiteralTypeImpl(((TypeScriptBooleanLiteralType)type).getValue(), false, source);
                if (jSBooleanLiteralTypeImpl == null) {
                    TypeScriptTypeParser.$$$reportNull$$$0(16);
                }
                return jSBooleanLiteralTypeImpl;
            }
            if (type instanceof TypeScriptTypeofType) {
                JSExpression expression;
                PsiElement owner;
                TypeScriptTypeofType typeofType = (TypeScriptTypeofType)type;
                String text = typeofType.getReferenceText();
                if (text != null && TypeScriptTypeParser.canUseTypeOf(owner = typeofType.getOwner())) {
                    TypeScriptTypeOfJSTypeImpl typeScriptTypeOfJSTypeImpl = new TypeScriptTypeOfJSTypeImpl(text, source);
                    if (typeScriptTypeOfJSTypeImpl == null) {
                        TypeScriptTypeParser.$$$reportNull$$$0(17);
                    }
                    return typeScriptTypeOfJSTypeImpl;
                }
                PsiFile containingFile = typeofType.getContainingFile();
                if (containingFile != null && (expression = (JSExpression)AstLoadingFilter.forceAllowTreeLoading((PsiFile)containingFile, () -> typeofType.getExpression())) != null) {
                    JSTypeofTypeImpl jSTypeofTypeImpl = new JSTypeofTypeImpl(expression, source);
                    if (jSTypeofTypeImpl == null) {
                        TypeScriptTypeParser.$$$reportNull$$$0(18);
                    }
                    return jSTypeofTypeImpl;
                }
            } else if (type instanceof TypeScriptUnionOrIntersectionType) {
                ArrayList types = ContainerUtil.newArrayList();
                TypeScriptUnionOrIntersectionType unionOrIntersectionType = (TypeScriptUnionOrIntersectionType)type;
                for (TypeScriptType scriptType : unionOrIntersectionType.getTypes()) {
                    types.add(TypeScriptTypeParser.buildTypeFromTypeScript((JSTypeDeclaration)scriptType));
                }
                if (unionOrIntersectionType.isUnionType()) {
                    TypeScriptTypeParser.fixUnionOrder(types);
                    JSCompositeTypeImpl jSCompositeTypeImpl = new JSCompositeTypeImpl(source, types);
                    if (jSCompositeTypeImpl == null) {
                        TypeScriptTypeParser.$$$reportNull$$$0(19);
                    }
                    return jSCompositeTypeImpl;
                }
                if (unionOrIntersectionType.isIntersectionType()) {
                    JSType jSType = JSIntersectionTypeImpl.getIntersectionType(types, source);
                    if (jSType == null) {
                        TypeScriptTypeParser.$$$reportNull$$$0(20);
                    }
                    return jSType;
                }
            } else if (type instanceof TypeScriptTypeOperator) {
                JSType nestedType;
                TypeScriptType operatorType = ((TypeScriptTypeOperator)type).getOperatorType();
                JSType jSType = nestedType = operatorType == null ? null : TypeScriptTypeParser.buildTypeFromTypeScript((JSTypeDeclaration)operatorType);
                if (nestedType != null) {
                    TypeScriptTypeOperatorJSTypeImpl typeScriptTypeOperatorJSTypeImpl = new TypeScriptTypeOperatorJSTypeImpl(nestedType, source);
                    if (typeScriptTypeOperatorJSTypeImpl == null) {
                        TypeScriptTypeParser.$$$reportNull$$$0(21);
                    }
                    return typeScriptTypeOperatorJSTypeImpl;
                }
            } else if (type instanceof TypeScriptIndexedAccessType) {
                JSType parameterType;
                TypeScriptIndexedAccessType indexedAccessType = (TypeScriptIndexedAccessType)type;
                TypeScriptType ownerTypeElement = indexedAccessType.getOwnerTypeElement();
                JSType ownerType = ownerTypeElement == null ? null : TypeScriptTypeParser.buildTypeFromTypeScript((JSTypeDeclaration)ownerTypeElement);
                TypeScriptType parameterTypeElement = indexedAccessType.getParameterTypeElement();
                JSType jSType = parameterType = parameterTypeElement == null ? null : TypeScriptTypeParser.buildTypeFromTypeScript((JSTypeDeclaration)parameterTypeElement);
                if (ownerType != null && parameterType != null) {
                    TypeScriptIndexedAccessJSTypeImpl typeScriptIndexedAccessJSTypeImpl = new TypeScriptIndexedAccessJSTypeImpl(ownerType, parameterType, source);
                    if (typeScriptIndexedAccessJSTypeImpl == null) {
                        TypeScriptTypeParser.$$$reportNull$$$0(22);
                    }
                    return typeScriptIndexedAccessJSTypeImpl;
                }
            } else if (type instanceof TypeScriptMappedType) {
                TypeScriptMappedType mappedType = (TypeScriptMappedType)type;
                TypeScriptType resultTypeElement = mappedType.getResultTypeElement();
                TypeScriptMappedTypeParameter parameter = mappedType.getTypeParameter();
                if (resultTypeElement != null && parameter != null) {
                    TypeScriptType parameterTypeElement = parameter.getTypeElement();
                    String name = parameter.getName();
                    if (name != null && parameterTypeElement != null) {
                        boolean optional = mappedType.isOptional();
                        boolean readonly = mappedType.isReadonly();
                        boolean minusReadonly = mappedType.isMinusReadonly();
                        boolean minusOptional = mappedType.isMinusOptional();
                        TypeScriptMappedJSTypeImpl typeScriptMappedJSTypeImpl = new TypeScriptMappedJSTypeImpl(source, readonly, optional, minusReadonly, minusOptional, name, TypeScriptTypeParser.buildTypeFromTypeScriptImpl((JSTypeDeclaration)parameterTypeElement), TypeScriptTypeParser.buildTypeFromTypeScriptImpl((JSTypeDeclaration)resultTypeElement));
                        if (typeScriptMappedJSTypeImpl == null) {
                            TypeScriptTypeParser.$$$reportNull$$$0(23);
                        }
                        return typeScriptMappedJSTypeImpl;
                    }
                }
            } else {
                if (type instanceof TypeScriptTypePredicate) {
                    TypeScriptTypePredicate typePredicate = (TypeScriptTypePredicate)type;
                    JSType guardType = typePredicate.getGuardType();
                    TypeScriptTypePredicateTypeImpl typeScriptTypePredicateTypeImpl = new TypeScriptTypePredicateTypeImpl(guardType, source, typePredicate.getParameterName(), typePredicate.getParameterIndex());
                    if (typeScriptTypePredicateTypeImpl == null) {
                        TypeScriptTypeParser.$$$reportNull$$$0(24);
                    }
                    return typeScriptTypePredicateTypeImpl;
                }
                if (type instanceof TypeScriptThisType) {
                    JSClass parentClass = (JSClass)PsiTreeUtil.getStubOrPsiParentOfType((PsiElement)type, JSClass.class);
                    if (parentClass != null) {
                        String name = parentClass.getQualifiedName();
                        JSType parentType = name == null ? null : JSNamedTypeFactory.createType(name, source, JSContext.INSTANCE);
                        TypeScriptGenericThisTypeImpl typeScriptGenericThisTypeImpl = new TypeScriptGenericThisTypeImpl(JSTypeSourceFactory.createTypeSource((PsiElement)parentClass, true), parentType);
                        if (typeScriptGenericThisTypeImpl == null) {
                            TypeScriptTypeParser.$$$reportNull$$$0(25);
                        }
                        return typeScriptGenericThisTypeImpl;
                    }
                } else {
                    JSTypeDeclaration innerType;
                    if (type instanceof TypeScriptTupleType) {
                        ArrayList types = ContainerUtil.newArrayList();
                        for (TypeScriptType scriptType : ((TypeScriptTupleType)type).getElements()) {
                            types.add(TypeScriptTypeParser.buildTypeFromTypeScript((JSTypeDeclaration)scriptType));
                        }
                        JSTupleTypeImpl jSTupleTypeImpl = new JSTupleTypeImpl(source, types, true, ((TypeScriptTupleType)type).getOptionalStart());
                        if (jSTupleTypeImpl == null) {
                            TypeScriptTypeParser.$$$reportNull$$$0(26);
                        }
                        return jSTupleTypeImpl;
                    }
                    if (type instanceof TypeScriptConditionalType) {
                        TypeScriptType checkedType = ((TypeScriptConditionalType)type).getCheckedType();
                        TypeScriptType testType = ((TypeScriptConditionalType)type).getTestType();
                        TypeScriptType typeIfTrue = ((TypeScriptConditionalType)type).getTypeIfTrue();
                        TypeScriptType typeIfFalse = ((TypeScriptConditionalType)type).getTypeIfFalse();
                        if (checkedType != null && testType != null && typeIfTrue != null && typeIfFalse != null) {
                            TypeScriptConditionalTypeJSTypeImpl typeScriptConditionalTypeJSTypeImpl = new TypeScriptConditionalTypeJSTypeImpl(source, TypeScriptTypeParser.buildTypeFromTypeScriptImpl((JSTypeDeclaration)checkedType), TypeScriptTypeParser.buildTypeFromTypeScriptImpl((JSTypeDeclaration)testType), TypeScriptTypeParser.buildTypeFromTypeScriptImpl((JSTypeDeclaration)typeIfTrue), TypeScriptTypeParser.buildTypeFromTypeScriptImpl((JSTypeDeclaration)typeIfFalse));
                            if (typeScriptConditionalTypeJSTypeImpl == null) {
                                TypeScriptTypeParser.$$$reportNull$$$0(27);
                            }
                            return typeScriptConditionalTypeJSTypeImpl;
                        }
                    } else if (type instanceof FlowJSMaybeType && (innerType = ((FlowJSMaybeType)type).getInnerType()) != null) {
                        JSType innerJSType = TypeScriptTypeParser.buildTypeFromTypeScriptImpl(innerType);
                        JSDecoratedTypeImpl jSDecoratedTypeImpl = new JSDecoratedTypeImpl(source, innerJSType, Collections.singleton(JSDecoratedType.TypeDecoration.JSDOC_NULLABLE));
                        if (jSDecoratedTypeImpl == null) {
                            TypeScriptTypeParser.$$$reportNull$$$0(28);
                        }
                        return jSDecoratedTypeImpl;
                    }
                }
            }
        }
        JSAnyType jSAnyType = JSAnyType.get((PsiElement)type, false);
        if (jSAnyType == null) {
            TypeScriptTypeParser.$$$reportNull$$$0(29);
        }
        return jSAnyType;
    }

    private static void fixUnionOrder(@NotNull List<JSType> types) {
        if (types == null) {
            TypeScriptTypeParser.$$$reportNull$$$0(30);
        }
        int initialSize = types.size();
        TIntHashSet toDrop = new TIntHashSet(initialSize);
        for (int i = 0; i < initialSize; ++i) {
            JSType type = types.get(i);
            if (!(type instanceof JSUndefinedType) && !(type instanceof JSNullType) && !(type instanceof JSGenericParameterImpl)) continue;
            types.add(type);
            toDrop.add(i);
        }
        TIntIterator iterator = toDrop.iterator();
        while (iterator.hasNext()) {
            types.remove(iterator.next());
        }
    }

    private static boolean canUseTypeOf(@Nullable PsiElement owner) {
        if (owner instanceof JSParameter) {
            return TypeScriptTypeParser.canUseTypeOf((PsiElement)((JSParameter)owner).getDeclaringFunction());
        }
        return PsiTreeUtil.getContextOfType((PsiElement)owner, (Class[])new Class[]{JSFunction.class, JSBlockStatement.class}) == null;
    }

    @NotNull
    public static JSFunctionType buildFunctionType(@NotNull JSFunctionItem function) {
        if (function == null) {
            TypeScriptTypeParser.$$$reportNull$$$0(31);
        }
        JSFunctionType jSFunctionType = (JSFunctionType)CachedValuesManager.getCachedValue((PsiElement)function, TS_FULL_FUNCTION_CACHE_KEY, () -> {
            if (function == null) {
                TypeScriptTypeParser.$$$reportNull$$$0(94);
            }
            return CachedValueProvider.Result.create((Object)TypeScriptTypeParser.buildFunctionTypeImpl(function), (Object[])new Object[]{function});
        });
        if (jSFunctionType == null) {
            TypeScriptTypeParser.$$$reportNull$$$0(32);
        }
        return jSFunctionType;
    }

    @NotNull
    private static JSFunctionType buildFunctionTypeImpl(@NotNull JSFunctionItem function) {
        if (function == null) {
            TypeScriptTypeParser.$$$reportNull$$$0(33);
        }
        TypeScriptJSFunctionTypeImpl typeScriptJSFunctionTypeImpl = TypeScriptTypeParser.buildFunctionTypeImpl(function, function.getReturnType());
        if (typeScriptJSFunctionTypeImpl == null) {
            TypeScriptTypeParser.$$$reportNull$$$0(34);
        }
        return typeScriptJSFunctionTypeImpl;
    }

    static TypeScriptJSFunctionTypeImpl buildFunctionTypeImpl(@NotNull JSFunctionItem type, @Nullable JSType returnType) {
        if (type == null) {
            TypeScriptTypeParser.$$$reportNull$$$0(35);
        }
        SmartList decorators = new SmartList();
        JSParameterItem[] parameters = type.getParameters();
        String[] parameterNames = ArrayUtil.EMPTY_STRING_ARRAY;
        if (parameters.length > 0) {
            parameterNames = new String[parameters.length];
        }
        int index = 0;
        for (JSParameterItem p : parameters) {
            decorators.add(p.getTypeDecorator());
            parameterNames[index++] = TypeScriptTypeParser.getParameterNameText(p);
        }
        JSTypeSource source = JSTypeSourceFactory.createTypeSource((PsiElement)type, true);
        JSType thisType = type instanceof TypeScriptFunction ? ((TypeScriptFunction)type).getExplicitThisType() : null;
        List<TypeScriptGenericDeclarationTypeImpl> generics = TypeScriptGenericTypesEvaluator.buildGenericParameterDeclarations(TypeScriptPsiUtil.getTypeParametersForOwner((PsiElement)type));
        return new TypeScriptJSFunctionTypeImpl(source, generics, (List<JSParameterTypeDecorator>)decorators, parameterNames, thisType, returnType);
    }

    @Nullable
    private static String getParameterNameText(@NotNull JSParameterItem p) {
        if (p == null) {
            TypeScriptTypeParser.$$$reportNull$$$0(36);
        }
        if (!(p instanceof JSDestructuringParameter)) {
            return p.getName();
        }
        JSDestructuringContainer target = ((JSDestructuringParameter)p).getTarget();
        if (target == null) {
            return p.getName();
        }
        StringBuilder builder = new StringBuilder();
        ES6PsiUtil.buildSignatureForDestructuringContainer(target, builder, false);
        return builder.toString();
    }

    private static void addObjectTypeProperties(@NotNull List<JSRecordType.TypeMember> typeMembers, @Nullable TypeScriptObjectType type, @Nullable JSTypeSubstitutor typeSubstitutor, boolean skipNewSignatures) {
        if (typeMembers == null) {
            TypeScriptTypeParser.$$$reportNull$$$0(37);
        }
        if (type == null) {
            return;
        }
        Object[] candidates = type.getTypeMembers();
        List members = StreamEx.of((Object[])candidates).map(el -> TypeScriptTypeMemberParser.buildTypeMember(el, typeSubstitutor)).nonNull().toList();
        TypeScriptTypeParser.filterAndfillTypeMembers(members, typeMembers, skipNewSignatures);
    }

    private static void filterAndfillTypeMembers(@NotNull List<JSRecordType.TypeMember> candidates, @NotNull List<JSRecordType.TypeMember> result2, boolean skipNewSignatures) {
        if (candidates == null) {
            TypeScriptTypeParser.$$$reportNull$$$0(38);
        }
        if (result2 == null) {
            TypeScriptTypeParser.$$$reportNull$$$0(39);
        }
        for (JSRecordType.TypeMember typeMember : candidates) {
            if (skipNewSignatures && typeMember instanceof JSRecordType.CallSignature && ((JSRecordType.CallSignature)typeMember).hasNew()) continue;
            result2.add(typeMember);
        }
    }

    @Nullable
    private static JSType buildSingleType(@NotNull TypeScriptSingleType type, @NotNull JSTypeSource source) {
        String typeName;
        if (type == null) {
            TypeScriptTypeParser.$$$reportNull$$$0(40);
        }
        if (source == null) {
            TypeScriptTypeParser.$$$reportNull$$$0(41);
        }
        if ((typeName = type.getQualifiedTypeName()) == null) {
            return null;
        }
        if (!typeName.contains(".")) {
            JSElement ownerCandidate = (JSElement)PsiTreeUtil.getContextOfType((PsiElement)type, (Class[])new Class[]{TypeScriptTypeParameterListOwner.class, TypeScriptMappedType.class, TypeScriptConditionalType.class});
            while (ownerCandidate != null) {
                JSType genericParameter = TypeScriptTypeParser.getAsGenericParameterIfOwner(type, source, typeName, ownerCandidate);
                if (genericParameter != null) {
                    return genericParameter;
                }
                ownerCandidate = (JSElement)PsiTreeUtil.getContextOfType((PsiElement)ownerCandidate, (Class[])new Class[]{TypeScriptTypeParameterListOwner.class, TypeScriptMappedType.class, TypeScriptConditionalType.class});
            }
        }
        return TypeScriptTypeParser.getSingleOrGenericType(type, TypeScriptTypeParser.getSimpleType(source, typeName), source);
    }

    @NotNull
    private static JSType getSimpleType(@NotNull JSTypeSource source, @NotNull String typeName) {
        if (source == null) {
            TypeScriptTypeParser.$$$reportNull$$$0(42);
        }
        if (typeName == null) {
            TypeScriptTypeParser.$$$reportNull$$$0(43);
        }
        JSType jSType = JSNamedTypeFactory.createType(typeName, source, JSTypeContext.INSTANCE, false, false);
        if (jSType == null) {
            TypeScriptTypeParser.$$$reportNull$$$0(44);
        }
        return jSType;
    }

    @Nullable
    private static JSType getAsGenericParameterIfOwner(@NotNull TypeScriptSingleType type, @NotNull JSTypeSource source, @NotNull String typeName, @NotNull JSElement ownerCandidate) {
        if (type == null) {
            TypeScriptTypeParser.$$$reportNull$$$0(45);
        }
        if (source == null) {
            TypeScriptTypeParser.$$$reportNull$$$0(46);
        }
        if (typeName == null) {
            TypeScriptTypeParser.$$$reportNull$$$0(47);
        }
        if (ownerCandidate == null) {
            TypeScriptTypeParser.$$$reportNull$$$0(48);
        }
        if (ownerCandidate instanceof TypeScriptTypeParameterListOwner) {
            TypeScriptTypeParameter[] parameters;
            TypeScriptTypeParameterList typeParameterList = ((TypeScriptTypeParameterListOwner)ownerCandidate).getTypeParameterList();
            if (typeParameterList == null) {
                return null;
            }
            for (TypeScriptTypeParameter parameter : parameters = typeParameterList.getTypeParameters()) {
                if (!StringUtil.equals((CharSequence)typeName, (CharSequence)parameter.getName())) continue;
                boolean fromDeclaration = PsiTreeUtil.isContextAncestor((PsiElement)typeParameterList, (PsiElement)type, (boolean)true);
                TypeScriptType constraint = parameter.getTypeConstraint();
                JSType jsConstraint = fromDeclaration || constraint == null ? null : TypeScriptTypeParser.buildTypeFromTypeScript((JSTypeDeclaration)constraint);
                TypeScriptGenericParameterImpl genericParameter = new TypeScriptGenericParameterImpl(TypeScriptTypeParser.getTypeParameterId((TypeScriptGenericOrMappedTypeParameter)parameter), source, jsConstraint);
                return TypeScriptTypeParser.getSingleOrGenericType(type, genericParameter, source);
            }
            return null;
        }
        if (ownerCandidate instanceof TypeScriptMappedType) {
            TypeScriptMappedTypeParameter parameter = ((TypeScriptMappedType)ownerCandidate).getTypeParameter();
            return parameter != null && typeName.equals(parameter.getName()) ? new TypeScriptMappedTypeGenericParameterImpl(TypeScriptTypeParser.getTypeParameterId((TypeScriptGenericOrMappedTypeParameter)parameter), source) : null;
        }
        if (ownerCandidate instanceof TypeScriptConditionalType) {
            Collection inferTypes = ((TypeScriptConditionalType)ownerCandidate).getInferTypes();
            for (TypeScriptInferType inferType : inferTypes) {
                String name = inferType.getVariableName();
                if (!typeName.equals(name)) continue;
                return new TypeScriptConditionalTypeGenericParameterImpl(TypeScriptTypeParser.getTypeParameterId((TypeScriptGenericOrMappedTypeParameter)inferType), source);
            }
        }
        return null;
    }

    @NotNull
    private static JSType getSingleOrGenericType(@NotNull TypeScriptSingleType type, @NotNull JSType baseType, @NotNull JSTypeSource source) {
        Object[] declarations;
        if (type == null) {
            TypeScriptTypeParser.$$$reportNull$$$0(49);
        }
        if (baseType == null) {
            TypeScriptTypeParser.$$$reportNull$$$0(50);
        }
        if (source == null) {
            TypeScriptTypeParser.$$$reportNull$$$0(51);
        }
        if ((declarations = type.getTypeArguments()).length > 0) {
            JSGenericTypeImpl jSGenericTypeImpl = new JSGenericTypeImpl(source, baseType, ContainerUtil.map((Object[])declarations, MAP_DECLARATION_TO_TYPE));
            if (jSGenericTypeImpl == null) {
                TypeScriptTypeParser.$$$reportNull$$$0(52);
            }
            return jSGenericTypeImpl;
        }
        JSType jSType = baseType;
        if (jSType == null) {
            TypeScriptTypeParser.$$$reportNull$$$0(53);
        }
        return jSType;
    }

    @NotNull
    public static JSRecordType buildTypeFromClass(@NotNull JSClass clazz, boolean isStatic) {
        if (clazz == null) {
            TypeScriptTypeParser.$$$reportNull$$$0(54);
        }
        if (!isStatic) {
            JSRecordType jSRecordType = (JSRecordType)CachedValuesManager.getManager((Project)clazz.getProject()).getParameterizedCachedValue((UserDataHolder)clazz, BUILD_CLASS_CACHE_KEY, BUILD_CLASS_PROVIDER, false, (Object)clazz);
            if (jSRecordType == null) {
                TypeScriptTypeParser.$$$reportNull$$$0(55);
            }
            return jSRecordType;
        }
        JSRecordType jSRecordType = TypeScriptTypeParser.buildTypeFromClass(clazz, true, true);
        if (jSRecordType == null) {
            TypeScriptTypeParser.$$$reportNull$$$0(56);
        }
        return jSRecordType;
    }

    @NotNull
    public static JSRecordType buildTypeFromClass(@NotNull JSClass clazz, boolean isStatic, boolean includeSupers) {
        if (clazz == null) {
            TypeScriptTypeParser.$$$reportNull$$$0(57);
        }
        JSRecordType type = TypeScriptTypeParser.buildTypeFromClass(clazz, isStatic, includeSupers, true, true);
        JSRecordType jSRecordType = TypeScriptTypeParser.overrideSourceForLibrarySymbols((PsiElement)clazz, type);
        if (jSRecordType == null) {
            TypeScriptTypeParser.$$$reportNull$$$0(58);
        }
        return jSRecordType;
    }

    @NotNull
    public static JSRecordType buildTypeFromClass(final @NotNull JSClass clazz, final boolean isStatic, boolean includeSupers, final boolean includeAbstractMembers, boolean includeInterfaceMembers) {
        JSType declaration;
        if (clazz == null) {
            TypeScriptTypeParser.$$$reportNull$$$0(59);
        }
        if (clazz instanceof TypeScriptTypeAlias && (declaration = ((TypeScriptTypeAlias)clazz).getParsedTypeDeclaration()) != null) {
            JSRecordType jSRecordType = declaration.asRecordType();
            if (jSRecordType == null) {
                TypeScriptTypeParser.$$$reportNull$$$0(60);
            }
            return jSRecordType;
        }
        final JSTypeSource source = JSTypeSourceFactory.createTypeSource((PsiElement)clazz, true);
        final ArrayList<Object> typeMembers = new ArrayList<Object>();
        JSClassUtils.JSClassHierarchyProcessor processor = new JSClassUtils.JSClassHierarchyProcessor(){
            private boolean isFunctionProcessed = false;

            @Override
            public boolean process(@NotNull JSClass<?> currentClass, @NotNull JSTypeSubstitutor typeSubstitutor, boolean fromImplements, boolean fromStaticContext, int depth) {
                if (currentClass == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (typeSubstitutor == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (fromStaticContext && !isStatic) {
                    return true;
                }
                if (currentClass != clazz && TypeScriptTypeParser.isFunctionClass(currentClass)) {
                    if (this.isFunctionProcessed) {
                        return true;
                    }
                    JSRecordType recordFunction = TypeScriptUtil.getFunctionTypeMembers((PsiElement)clazz);
                    if (recordFunction != null) {
                        typeMembers.addAll(recordFunction.getTypeMembers());
                    }
                    this.isFunctionProcessed = true;
                    return true;
                }
                if (currentClass instanceof TypeScriptTypeAlias) {
                    JSRecordType recordType;
                    if ((!isStatic || fromStaticContext) && (recordType = TypeScriptUtil.getTypeAliasRecordTypeForSubstitutor((TypeScriptTypeAlias)currentClass, typeSubstitutor)) != null) {
                        TypeScriptTypeParser.filterAndfillTypeMembers(recordType.getTypeMembers(), typeMembers, fromStaticContext);
                    }
                } else if (currentClass instanceof TypeScriptInterface) {
                    if (!isStatic || fromStaticContext) {
                        TypeScriptObjectType body = ((TypeScriptInterface)currentClass).getBody();
                        TypeScriptTypeParser.addObjectTypeProperties(typeMembers, body, typeSubstitutor, fromStaticContext);
                    }
                } else {
                    String classQName;
                    for (JSElement element : currentClass.getMembers()) {
                        JSRecordType.TypeMember typeMember;
                        JSAttributeListOwner function;
                        JSAttributeList list;
                        if (element instanceof JSAttributeListOwner && !includeAbstractMembers && (list = (function = (JSAttributeListOwner)element).getAttributeList()) != null && list.hasModifier(JSAttributeList.ModifierType.ABSTRACT) || (typeMember = TypeScriptTypeMemberParser.buildTypeMemberFromClassMember(clazz, element, isStatic, source, typeSubstitutor)) == null) continue;
                        typeMembers.add(typeMember);
                    }
                    if (DialectDetector.isJavaScript(currentClass) && (classQName = currentClass.getQualifiedName()) != null) {
                        JSClassResolver.getInstance().processNamespaceMembers(classQName, clazz.getContainingFile(), true, (Processor<JSPsiElementBase>)((Processor)e -> {
                            if (e instanceof JSDefinitionExpression && e.getName() != null) {
                                typeMembers.add(new JSRecordTypeImpl.PropertySignatureImpl(e.getName(), ((JSDefinitionExpression)e).getType(), false, (PsiElement)e));
                            }
                            return true;
                        }));
                    }
                }
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "currentClass";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "typeSubstitutor";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/lang/javascript/psi/types/TypeScriptTypeParser$1";
                objectArray[2] = "process";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        if (includeSupers) {
            JSClassUtils.processClassesInHierarchy(clazz, includeInterfaceMembers, processor);
        } else {
            processor.process(clazz, JSTypeSubstitutor.EMPTY, false, false, 0);
        }
        if (!(clazz instanceof TypeScriptCompileTimeType) && isStatic) {
            boolean hasConstructor = false;
            boolean hasPrototype = false;
            for (JSRecordType.TypeMember typeMember : typeMembers) {
                if (typeMember instanceof JSRecordType.CallSignature && ((JSRecordType.CallSignature)typeMember).hasNew()) {
                    hasConstructor = true;
                }
                if (!(typeMember instanceof JSRecordType.PropertySignature) || !"prototype".equals(((JSRecordType.PropertySignature)typeMember).getMemberName())) continue;
                hasPrototype = true;
            }
            if (!hasConstructor) {
                JSType returnType = TypeScriptTypeParser.createConstructorReturnType(clazz, source);
                JSFunctionTypeImpl jSFunctionTypeImpl = new JSFunctionTypeImpl(source, ContainerUtil.emptyList(), returnType);
                typeMembers.add(new JSRecordTypeImpl.CallSignatureImpl(true, jSFunctionTypeImpl));
            }
            if (!hasPrototype) {
                JSImplicitPrototypeElement property = JSClassUtils.getImplicitPrototypeProperty(clazz);
                typeMembers.add(new JSRecordTypeImpl.PropertySignatureImpl(property.getName(), property.getJSType(), false, (PsiElement)property));
            }
        }
        JSRecordTypeImpl jSRecordTypeImpl = clazz.getName() == null && !isStatic ? new JSSimpleRecordTypeImpl(source, typeMembers) : new JSRecordTypeImpl(source, typeMembers);
        if (jSRecordTypeImpl == null) {
            TypeScriptTypeParser.$$$reportNull$$$0(61);
        }
        return jSRecordTypeImpl;
    }

    @NotNull
    static JSType createConstructorReturnType(@NotNull JSClass clazz, @NotNull JSTypeSource source) {
        String name;
        if (clazz == null) {
            TypeScriptTypeParser.$$$reportNull$$$0(62);
        }
        if (source == null) {
            TypeScriptTypeParser.$$$reportNull$$$0(63);
        }
        JSRecordType rawConstructorType = StringUtil.isEmpty((String)(name = clazz.getQualifiedName())) ? TypeScriptTypeParser.buildTypeFromClass(clazz, false, true) : JSNamedTypeFactory.createType(name, source, JSContext.INSTANCE);
        JSType mixinType = TypeScriptTypeParser.getMixinInstanceType(clazz, source);
        if (mixinType == null) {
            JSRecordType jSRecordType = rawConstructorType;
            if (jSRecordType == null) {
                TypeScriptTypeParser.$$$reportNull$$$0(64);
            }
            return jSRecordType;
        }
        JSType jSType = JSIntersectionTypeImpl.getIntersectionType(StreamEx.of((Object[])new JSType[]{rawConstructorType, mixinType}).nonNull().toList(), source);
        if (jSType == null) {
            TypeScriptTypeParser.$$$reportNull$$$0(65);
        }
        return jSType;
    }

    @Nullable
    private static JSType getMixinInstanceType(@NotNull JSClass clazz, @NotNull JSTypeSource source) {
        if (clazz == null) {
            TypeScriptTypeParser.$$$reportNull$$$0(66);
        }
        if (source == null) {
            TypeScriptTypeParser.$$$reportNull$$$0(67);
        }
        if (!(clazz instanceof TypeScriptClass) || !ES6PsiUtil.isLocalClass(clazz)) {
            return null;
        }
        JSReferenceList list = clazz.getExtendsList();
        if (!(list instanceof ES6ReferenceList)) {
            return null;
        }
        Object[] members = list.getMembers();
        JSReferenceListMember member = (JSReferenceListMember)ArrayUtil.getFirstElement((Object[])members);
        if (member == null) {
            return null;
        }
        ES6ReferenceListImpl.ClassExpressionResolve resolve = ES6ReferenceListImpl.resolveReferenceListMember(member);
        JSType type = resolve.constructorType;
        if (type == null || !JSTypeUtils.hasForeignGenericParameter(type)) {
            return null;
        }
        return type instanceof JSFunctionType ? JSTypeUtils.getNewOrReturnType(type, true) : new JSApplyNewType(type, source);
    }

    private static boolean isFunctionClass(JSClass<?> currentClass) {
        String fileName = currentClass.getContainingFile().getName();
        return JSCommonTypeNames.FUNCTION_CLASS_NAMES.contains(currentClass.getName()) && TypeScriptLibraryProvider.getService(currentClass.getProject()).isLibraryFileName(fileName);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public static JSType buildTypeFromClassMember(PsiElement element) {
        if (element instanceof JSFunction) {
            if (((JSFunction)element).isGetProperty()) {
                return ((JSFunction)element).getReturnType();
            }
            if (!((JSFunction)element).isSetProperty()) return TypeScriptTypeParser.buildFunctionType((JSFunctionItem)((JSFunction)element));
            JSParameterListElement[] parameters = ((JSFunction)element).getParameters();
            if (parameters.length != 1) return null;
            return parameters[0].getType();
        }
        if (!(element instanceof JSTypeDeclarationOwner)) return null;
        return ((JSTypeDeclarationOwner)element).getType();
    }

    private static JSRecordType buildResolvedType(@NotNull Collection<? extends PsiElement> elements, @NotNull JSType type, @Nullable JSRecursionGuard recursionGuard) {
        if (elements == null) {
            TypeScriptTypeParser.$$$reportNull$$$0(68);
        }
        if (type == null) {
            TypeScriptTypeParser.$$$reportNull$$$0(69);
        }
        boolean isStatic = type instanceof JSNamedType && ((JSNamedType)type).isStaticOrInstance() == JSContext.STATIC;
        ArrayList<JSRecordType.TypeMember> members = new ArrayList<JSRecordType.TypeMember>();
        for (PsiElement psiElement : TypeScriptTypeParser.sortElements(elements)) {
            TypeScriptTypeParser.addTypeMembersFromClass(type, isStatic, members, psiElement, recursionGuard);
        }
        return new JSRecordTypeImpl(type.getSource(), members);
    }

    @NotNull
    private static Collection<? extends PsiElement> sortElements(@NotNull Collection<? extends PsiElement> elements) {
        if (elements == null) {
            TypeScriptTypeParser.$$$reportNull$$$0(70);
        }
        if (elements.size() <= 1) {
            Collection<? extends PsiElement> collection = elements;
            if (collection == null) {
                TypeScriptTypeParser.$$$reportNull$$$0(71);
            }
            return collection;
        }
        ArrayList result2 = ContainerUtil.newArrayListWithCapacity((int)elements.size());
        List restElements = ContainerUtil.newSmartList();
        for (PsiElement psiElement : elements) {
            List toAdd = psiElement instanceof JSClass && ((JSClass)psiElement).getSupers().length == 0 ? result2 : restElements;
            toAdd.add(psiElement);
        }
        result2.addAll(restElements);
        ArrayList arrayList = result2;
        if (arrayList == null) {
            TypeScriptTypeParser.$$$reportNull$$$0(72);
        }
        return arrayList;
    }

    @NotNull
    private static JSRecordType overrideSourceForLibrarySymbols(@NotNull PsiElement context, @NotNull JSRecordType resultType) {
        if (context == null) {
            TypeScriptTypeParser.$$$reportNull$$$0(73);
        }
        if (resultType == null) {
            TypeScriptTypeParser.$$$reportNull$$$0(74);
        }
        Set<VirtualFile> libraries = TypeScriptLibraryProvider.getAllLibraries(context.getProject());
        boolean hasSourceFromLibrary = false;
        block0: for (JSRecordType.TypeMember member : resultType.getTypeMembers()) {
            List sourceElements = member.getMemberSource().getAllSourceElements();
            for (PsiElement element : sourceElements) {
                VirtualFile virtualFile = PsiUtilCore.getVirtualFile((PsiElement)element);
                if (virtualFile == null || !libraries.contains(virtualFile)) continue;
                hasSourceFromLibrary = true;
                continue block0;
            }
        }
        if (!hasSourceFromLibrary) {
            JSRecordType jSRecordType = resultType;
            if (jSRecordType == null) {
                TypeScriptTypeParser.$$$reportNull$$$0(75);
            }
            return jSRecordType;
        }
        JSTypeSource resultTypeSource = resultType.getSource();
        JSType candidate = JSTypeBaseImpl.replaceSourceRecursive((JSType)resultType, (Function<? super JSTypeBaseImpl, ? extends JSType>)((Function)el -> {
            if (!(el instanceof JSNamedType) && !(el instanceof JSGenericTypeImpl)) {
                return el;
            }
            if (el.getSource() == resultTypeSource) {
                return el;
            }
            VirtualFile virtualFile = PsiUtilCore.getVirtualFile((PsiElement)el.getSource().getSourceElement());
            if (virtualFile != null && libraries.contains(virtualFile)) {
                return el.copyWithNewSource(resultTypeSource);
            }
            return el;
        }));
        JSRecordType jSRecordType = candidate instanceof JSRecordType ? (JSRecordType)candidate : resultType;
        if (jSRecordType == null) {
            TypeScriptTypeParser.$$$reportNull$$$0(76);
        }
        return jSRecordType;
    }

    public static JSRecordType buildResolvedType(Collection<? extends PsiElement> elements, JSType type) {
        return TypeScriptTypeParser.buildResolvedType(elements, type, null);
    }

    @NotNull
    public static JSRecordType buildResolvedType(@Nullable JSType type) {
        Collection<? extends PsiElement> elements = TypeScriptTypeParser.resolveElementsByType(type);
        JSRecordType jSRecordType = TypeScriptTypeParser.buildResolvedType(elements, type);
        if (jSRecordType == null) {
            TypeScriptTypeParser.$$$reportNull$$$0(77);
        }
        return jSRecordType;
    }

    @NotNull
    public static Collection<? extends PsiElement> resolveElementsByType(@Nullable JSType type) {
        PsiElement originSourceElement;
        if (type == null) {
            List list = Collections.emptyList();
            if (list == null) {
                TypeScriptTypeParser.$$$reportNull$$$0(78);
            }
            return list;
        }
        PsiElement sourceElement = type.getSource().getSourceElement();
        if (sourceElement == null || !DialectDetector.isTypeScript(sourceElement)) {
            List list = Collections.emptyList();
            if (list == null) {
                TypeScriptTypeParser.$$$reportNull$$$0(79);
            }
            return list;
        }
        if (type instanceof JSFunctionTypeImpl && sourceElement instanceof JSFunction) {
            List list = ContainerUtil.createMaybeSingletonList((Object)sourceElement);
            if (list == null) {
                TypeScriptTypeParser.$$$reportNull$$$0(80);
            }
            return list;
        }
        if (type instanceof JSGenericTypeImpl && ((JSGenericTypeImpl)type).getType() instanceof JSFunctionTypeImpl && (originSourceElement = ((JSGenericTypeImpl)type).getType().getSource().getSourceElement()) instanceof JSFunction) {
            List list = ContainerUtil.createMaybeSingletonList((Object)originSourceElement);
            if (list == null) {
                TypeScriptTypeParser.$$$reportNull$$$0(81);
            }
            return list;
        }
        Collection<? extends PsiElement> collection = JSImportHandlingUtil.resolveElementsByType(type, sourceElement);
        if (collection == null) {
            TypeScriptTypeParser.$$$reportNull$$$0(82);
        }
        return collection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    private static void addTypeMembersFromClass(@NotNull JSType type, boolean isStatic, @NotNull List<JSRecordType.TypeMember> members, @NotNull PsiElement resolvedElement, @Nullable JSRecursionGuard recursionGuard) {
        if (type == null) {
            TypeScriptTypeParser.$$$reportNull$$$0(83);
        }
        if (members == null) {
            TypeScriptTypeParser.$$$reportNull$$$0(84);
        }
        if (resolvedElement == null) {
            TypeScriptTypeParser.$$$reportNull$$$0(85);
        }
        if (resolvedElement instanceof JSClass) {
            if (type instanceof JSArrayTypeImpl) {
                type = ((JSArrayTypeImpl)type).asGenericType();
            }
            classType = null;
            hasOuters = false;
            if (type instanceof JSTypeWithOuterGenerics) {
                type = ((JSTypeWithOuterGenerics)type).getType();
                hasOuters = true;
            }
            if (type instanceof JSGenericTypeImpl) {
                classType = JSTypeCastUtil.buildWithAppliedGenericArguments((JSClass)resolvedElement, (JSGenericTypeImpl)type, hasOuters);
            } else if (resolvedElement instanceof TypeScriptTypeAlias) {
                if (recursionGuard == null) {
                    recursionGuard = new JSRecursionGuard();
                }
                if (recursionGuard.isAlreadyProcessingItem(resolvedElement)) {
                    return;
                }
                recursionGuard.addProcessingItem(resolvedElement);
                try {
                    declaration = ((TypeScriptTypeAlias)resolvedElement).getParsedTypeDeclaration();
                    if (declaration instanceof JSRecordType) {
                        classType = (JSRecordType)declaration;
                    }
                    if (declaration instanceof JSFunctionTypeImpl) {
                        classType = declaration.asRecordType();
                    }
                    if (declaration == null) ** GOTO lbl39
                    classType = TypeScriptTypeParser.buildResolvedType(TypeScriptTypeParser.resolveElementsByType(declaration), declaration, recursionGuard);
                }
                finally {
                    recursionGuard.removeProcessingItem(resolvedElement);
                }
            } else {
                classType = TypeScriptTypeParser.buildTypeFromClass((JSClass)resolvedElement, isStatic);
            }
lbl39:
            // 6 sources

            if (classType != null) {
                classType.getTypeMembers().stream().filter((Predicate<JSRecordType.TypeMember>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, isAccessible(com.intellij.lang.javascript.psi.JSRecordType$TypeMember ), (Lcom/intellij/lang/javascript/psi/JSRecordType$TypeMember;)Z)()).forEach((Consumer<JSRecordType.TypeMember>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$addTypeMembersFromClass$6(java.util.List com.intellij.lang.javascript.psi.JSRecordType$TypeMember ), (Lcom/intellij/lang/javascript/psi/JSRecordType$TypeMember;)V)(members));
            }
        } else if (resolvedElement instanceof TypeScriptModule && isStatic) {
            moduleType = TypeScriptTypeParser.buildTypeForModule((TypeScriptModule)resolvedElement);
            if (moduleType != null) {
                members.addAll(moduleType.getTypeMembers());
            }
        } else if (resolvedElement instanceof JSFunction) {
            if (resolvedElement instanceof TypeScriptFunction) {
                for (JSFunctionItem item : TypeScriptPsiUtil.getAllOverloadSignatures((TypeScriptFunction)resolvedElement)) {
                    members.add((JSRecordType.TypeMember)TypeScriptTypeParser.createCallSignatureForFunction(item));
                }
            }
            members.add((JSRecordType.TypeMember)TypeScriptTypeParser.createCallSignatureForFunction((JSFunctionItem)((JSFunction)resolvedElement)));
        }
    }

    private static boolean isAccessible(@NotNull JSRecordType.TypeMember m) {
        if (m == null) {
            TypeScriptTypeParser.$$$reportNull$$$0(86);
        }
        return !(m instanceof JSRecordType.PropertySignature) || ((JSRecordType.PropertySignature)m).getAccessType() == JSAttributeList.AccessType.PUBLIC;
    }

    @NotNull
    private static JSRecordTypeImpl.CallSignatureImpl createCallSignatureForFunction(@NotNull JSFunctionItem resolvedElement) {
        if (resolvedElement == null) {
            TypeScriptTypeParser.$$$reportNull$$$0(87);
        }
        JSRecordTypeImpl.CallSignatureImpl callSignatureImpl = new JSRecordTypeImpl.CallSignatureImpl(false, new JSFunctionTypeImpl(JSTypeSourceFactory.createTypeSource((PsiElement)resolvedElement, true), TypeScriptSignatureChooser.getTypeDecoratorsWithAppliedGenerics(resolvedElement.getParameterVariables(), null), resolvedElement.getReturnType()));
        if (callSignatureImpl == null) {
            TypeScriptTypeParser.$$$reportNull$$$0(88);
        }
        return callSignatureImpl;
    }

    @Nullable
    public static JSRecordType buildTypeForModule(@NotNull TypeScriptModule element) {
        if (element == null) {
            TypeScriptTypeParser.$$$reportNull$$$0(89);
        }
        if (!element.isInstantiated()) {
            return null;
        }
        JSSourceElement[] elements = JSResolveUtil.getSourceElements((PsiElement)element);
        ArrayList<JSRecordTypeImpl.PropertySignatureImpl> typeMembers = new ArrayList<JSRecordTypeImpl.PropertySignatureImpl>();
        for (JSSourceElement sourceElement : elements) {
            if (!(sourceElement instanceof JSVarStatement) && (!(sourceElement instanceof JSElementBase) || ((JSElementBase)sourceElement).getAccessType() != JSAttributeList.AccessType.PUBLIC)) continue;
            if (sourceElement instanceof JSVarStatement) {
                for (JSVariable variable : ((JSVarStatement)sourceElement).getStubSafeVariables()) {
                    String name;
                    if (variable.getAccessType() != JSAttributeList.AccessType.PUBLIC || (name = variable.getName()) == null) continue;
                    typeMembers.add(new JSRecordTypeImpl.PropertySignatureImpl(name, variable.getType(), false, (PsiElement)variable));
                }
                continue;
            }
            if (sourceElement instanceof JSFunction) {
                JSFunction function = (JSFunction)sourceElement;
                String name = function.getName();
                if (name == null) continue;
                typeMembers.add(new JSRecordTypeImpl.PropertySignatureImpl(name, (JSType)TypeScriptTypeParser.buildFunctionType((JSFunctionItem)function), false, (PsiElement)function));
                continue;
            }
            if (!(sourceElement instanceof JSClass)) continue;
            JSTypeSource source = JSTypeSourceFactory.createTypeSource((PsiElement)sourceElement, true);
            String name = sourceElement.getName();
            if (name == null) continue;
            JSType type = JSNamedTypeFactory.createType(name, source, JSContext.STATIC);
            typeMembers.add(new JSRecordTypeImpl.PropertySignatureImpl(name, type, false, (PsiElement)sourceElement));
        }
        JSTypeSource source = JSTypeSourceFactory.createTypeSource((PsiElement)element, true);
        return new JSRecordTypeImpl(source, typeMembers);
    }

    @NotNull
    public static JSTypeSubstitutor.JSTypeGenericId getTypeParameterId(@NotNull TypeScriptGenericOrMappedTypeParameter parameter) {
        if (parameter == null) {
            TypeScriptTypeParser.$$$reportNull$$$0(90);
        }
        if (parameter instanceof TypeScriptInferType) {
            TypeParameterGenericId typeParameterGenericId = new TypeParameterGenericId(parameter, ((TypeScriptInferType)parameter).getVariableName());
            if (typeParameterGenericId == null) {
                TypeScriptTypeParser.$$$reportNull$$$0(91);
            }
            return typeParameterGenericId;
        }
        TypeParameterGenericId typeParameterGenericId = new TypeParameterGenericId(parameter, parameter.getName());
        if (typeParameterGenericId == null) {
            TypeScriptTypeParser.$$$reportNull$$$0(92);
        }
        return typeParameterGenericId;
    }

    private static /* synthetic */ void lambda$addTypeMembersFromClass$6(@NotNull List members, JSRecordType.TypeMember m) {
        if (members == null) {
            TypeScriptTypeParser.$$$reportNull$$$0(93);
        }
        members.add(m);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 32: 
            case 34: 
            case 44: 
            case 52: 
            case 53: 
            case 55: 
            case 56: 
            case 58: 
            case 60: 
            case 61: 
            case 64: 
            case 65: 
            case 71: 
            case 72: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 88: 
            case 91: 
            case 92: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 32: 
            case 34: 
            case 44: 
            case 52: 
            case 53: 
            case 55: 
            case 56: 
            case 58: 
            case 60: 
            case 61: 
            case 64: 
            case 65: 
            case 71: 
            case 72: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 88: 
            case 91: 
            case 92: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 32: 
            case 34: 
            case 44: 
            case 52: 
            case 53: 
            case 55: 
            case 56: 
            case 58: 
            case 60: 
            case 61: 
            case 64: 
            case 65: 
            case 71: 
            case 72: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 88: 
            case 91: 
            case 92: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/types/TypeScriptTypeParser";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "types";
                break;
            }
            case 31: 
            case 33: 
            case 94: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "p";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeMembers";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "candidates";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 41: 
            case 42: 
            case 46: 
            case 51: 
            case 63: 
            case 67: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 43: 
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeName";
                break;
            }
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ownerCandidate";
                break;
            }
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseType";
                break;
            }
            case 54: 
            case 57: 
            case 59: 
            case 62: 
            case 66: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 68: 
            case 70: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 73: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 74: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resultType";
                break;
            }
            case 84: 
            case 93: {
                objectArray2 = objectArray3;
                objectArray3[0] = "members";
                break;
            }
            case 85: 
            case 87: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolvedElement";
                break;
            }
            case 86: {
                objectArray2 = objectArray3;
                objectArray3[0] = "m";
                break;
            }
            case 89: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 90: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/types/TypeScriptTypeParser";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildTypeFromTypeScript";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "buildTypeFromTypeScriptImpl";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "buildFunctionType";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "buildFunctionTypeImpl";
                break;
            }
            case 44: {
                objectArray = objectArray2;
                objectArray2[1] = "getSimpleType";
                break;
            }
            case 52: 
            case 53: {
                objectArray = objectArray2;
                objectArray2[1] = "getSingleOrGenericType";
                break;
            }
            case 55: 
            case 56: 
            case 58: 
            case 60: 
            case 61: {
                objectArray = objectArray2;
                objectArray2[1] = "buildTypeFromClass";
                break;
            }
            case 64: 
            case 65: {
                objectArray = objectArray2;
                objectArray2[1] = "createConstructorReturnType";
                break;
            }
            case 71: 
            case 72: {
                objectArray = objectArray2;
                objectArray2[1] = "sortElements";
                break;
            }
            case 75: 
            case 76: {
                objectArray = objectArray2;
                objectArray2[1] = "overrideSourceForLibrarySymbols";
                break;
            }
            case 77: {
                objectArray = objectArray2;
                objectArray2[1] = "buildResolvedType";
                break;
            }
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveElementsByType";
                break;
            }
            case 88: {
                objectArray = objectArray2;
                objectArray2[1] = "createCallSignatureForFunction";
                break;
            }
            case 91: 
            case 92: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeParameterId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildTypeFromTypeScript";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 32: 
            case 34: 
            case 44: 
            case 52: 
            case 53: 
            case 55: 
            case 56: 
            case 58: 
            case 60: 
            case 61: 
            case 64: 
            case 65: 
            case 71: 
            case 72: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 88: 
            case 91: 
            case 92: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "buildTypeFromTypeScriptImpl";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "fixUnionOrder";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "buildFunctionType";
                break;
            }
            case 33: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "buildFunctionTypeImpl";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "getParameterNameText";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "addObjectTypeProperties";
                break;
            }
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "filterAndfillTypeMembers";
                break;
            }
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "buildSingleType";
                break;
            }
            case 42: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "getSimpleType";
                break;
            }
            case 45: 
            case 46: 
            case 47: 
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "getAsGenericParameterIfOwner";
                break;
            }
            case 49: 
            case 50: 
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "getSingleOrGenericType";
                break;
            }
            case 54: 
            case 57: 
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "buildTypeFromClass";
                break;
            }
            case 62: 
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "createConstructorReturnType";
                break;
            }
            case 66: 
            case 67: {
                objectArray = objectArray;
                objectArray[2] = "getMixinInstanceType";
                break;
            }
            case 68: 
            case 69: {
                objectArray = objectArray;
                objectArray[2] = "buildResolvedType";
                break;
            }
            case 70: {
                objectArray = objectArray;
                objectArray[2] = "sortElements";
                break;
            }
            case 73: 
            case 74: {
                objectArray = objectArray;
                objectArray[2] = "overrideSourceForLibrarySymbols";
                break;
            }
            case 83: 
            case 84: 
            case 85: {
                objectArray = objectArray;
                objectArray[2] = "addTypeMembersFromClass";
                break;
            }
            case 86: {
                objectArray = objectArray;
                objectArray[2] = "isAccessible";
                break;
            }
            case 87: {
                objectArray = objectArray;
                objectArray[2] = "createCallSignatureForFunction";
                break;
            }
            case 89: {
                objectArray = objectArray;
                objectArray[2] = "buildTypeForModule";
                break;
            }
            case 90: {
                objectArray = objectArray;
                objectArray[2] = "getTypeParameterId";
                break;
            }
            case 93: {
                objectArray = objectArray;
                objectArray[2] = "lambda$addTypeMembersFromClass$6";
                break;
            }
            case 94: {
                objectArray = objectArray;
                objectArray[2] = "lambda$buildFunctionType$3";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 32: 
            case 34: 
            case 44: 
            case 52: 
            case 53: 
            case 55: 
            case 56: 
            case 58: 
            case 60: 
            case 61: 
            case 64: 
            case 65: 
            case 71: 
            case 72: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 88: 
            case 91: 
            case 92: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static final class TypeParameterGenericId
    implements JSTypeSubstitutor.JSTypeGenericId {
        @NotNull
        private final PsiElement myOwner;
        @NotNull
        private final String myName;
        @Nullable
        private final String myOwnerQName;

        TypeParameterGenericId(@NotNull TypeScriptGenericOrMappedTypeParameter parameter, @Nullable String name) {
            if (parameter == null) {
                TypeParameterGenericId.$$$reportNull$$$0(0);
            }
            this.myName = StringUtil.notNullize((String)name);
            TypeScriptGenericOrMappedTypeParameter originalCandidate = (TypeScriptGenericOrMappedTypeParameter)CompletionUtilCoreImpl.getOriginalElement((PsiElement)parameter);
            TypeScriptGenericOrMappedTypeParameter original = originalCandidate == null ? parameter : originalCandidate;
            JSElement owner = original.getOwner();
            this.myOwner = owner == null ? original : owner;
            this.myOwnerQName = this.myOwner instanceof JSQualifiedNamedElement ? ((JSQualifiedNamedElement)this.myOwner).getQualifiedName() : null;
        }

        public int hashCode() {
            return this.myName.hashCode();
        }

        @NotNull
        public String getName() {
            String string = this.myName;
            if (string == null) {
                TypeParameterGenericId.$$$reportNull$$$0(1);
            }
            return string;
        }

        public boolean equals(Object candidate) {
            if (!(candidate instanceof TypeParameterGenericId)) {
                return false;
            }
            TypeParameterGenericId obj = (TypeParameterGenericId)candidate;
            if (!this.getName().equals(obj.getName())) {
                return false;
            }
            if (this.myOwner.equals(((TypeParameterGenericId)candidate).myOwner)) {
                return true;
            }
            return this.myOwnerQName != null && Objects.equals(this.myOwnerQName, ((TypeParameterGenericId)candidate).myOwnerQName);
        }

        public String toString() {
            PsiElement owner = this.myOwner;
            String name = owner instanceof PsiNamedElement ? ((PsiNamedElement)owner).getName() : owner.getClass().getSimpleName();
            return name + "@<" + this.getName() + ">";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parameter";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/psi/types/TypeScriptTypeParser$TypeParameterGenericId";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/psi/types/TypeScriptTypeParser$TypeParameterGenericId";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

