/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.refactoring;

import com.intellij.lang.Language;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.JSElementTypes;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.flex.XmlBackedJSClassImpl;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.XmlBackedJSClassFactory;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.lang.javascript.refactoring.util.JSRefactoringUtil;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlFile;
import com.intellij.refactoring.RefactoringActionHandler;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.lang.ElementsHandler;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BaseJSRefactoringHandler
implements RefactoringActionHandler,
ElementsHandler {
    private final String myRefactoringName;
    private final String myCannotRefactorReason;

    public BaseJSRefactoringHandler(String refactoringName, String cannotRefactorReason) {
        this.myRefactoringName = refactoringName;
        this.myCannotRefactorReason = cannotRefactorReason;
    }

    public boolean isEnabledOnElements(PsiElement[] elements) {
        return elements.length == 1;
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file2, DataContext dataContext) {
        if (project == null) {
            BaseJSRefactoringHandler.$$$reportNull$$$0(0);
        }
        int offset = editor.getCaretModel().getOffset();
        editor.getScrollingModel().scrollToCaret(ScrollType.MAKE_VISIBLE);
        PsiElement element = file2.findElementAt(offset);
        while (true) {
            if (element instanceof JSFile) {
                element = JSResolveUtil.getXmlBackedClass((JSFile)element);
            }
            if (element == null || element instanceof PsiFile) {
                if (element != null && JavaScriptSupportLoader.isFlexMxmFile((PsiFile)element)) {
                    this.invoke(project, new PsiElement[]{XmlBackedJSClassFactory.getXmlBackedClass((XmlFile)element)}, dataContext);
                } else {
                    CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)RefactoringBundle.getCannotRefactorMessage((String)this.myCannotRefactorReason), (String)this.myRefactoringName, null);
                }
                return;
            }
            if (element.getNode().getElementType() == JSElementTypes.IMPLEMENTS_LIST && XmlBackedJSClassImpl.isImplementsAttribute((JSFile)element.getContainingFile())) {
                element = JSResolveUtil.getXmlBackedClass((JSFile)element.getContainingFile());
            }
            if (!JSRefactoringUtil.checkReadOnlyStatus(element, editor, this.myRefactoringName)) {
                return;
            }
            if (JSUtils.isMember(element) || element instanceof JSClass) {
                this.invoke(project, new PsiElement[]{element}, dataContext);
                return;
            }
            element = element.getParent();
        }
    }

    @Nullable
    protected static JSClass getClass(PsiElement element) {
        if (element instanceof JSClass) {
            return (JSClass)element;
        }
        if (element instanceof JSFile) {
            return JSPsiImplUtils.findClass((JSFile)element);
        }
        if (element instanceof PsiFile && JavaScriptSupportLoader.isFlexMxmFile((PsiFile)element)) {
            return XmlBackedJSClassFactory.getXmlBackedClass((XmlFile)element);
        }
        return JSUtils.getMemberContainingClass(element);
    }

    protected boolean checkEcma(PsiElement element, Editor editor) {
        return BaseJSRefactoringHandler.checkEcma(element, editor, this.myRefactoringName);
    }

    public static boolean checkEcma(PsiElement element, Editor editor, String refactoringName) {
        if (!BaseJSRefactoringHandler.doCheckEcma(element)) {
            CommonRefactoringUtil.showErrorHint((Project)element.getProject(), (Editor)editor, (String)JSBundle.message((String)"error.not.available.in.javascript.code", (Object[])new Object[]{refactoringName}), (String)refactoringName, null);
            return false;
        }
        return true;
    }

    public static boolean doCheckEcma(PsiElement element) {
        if (element instanceof XmlBackedJSClassImpl) {
            return JavaScriptSupportLoader.isFlexMxmFile(element.getContainingFile());
        }
        if (element instanceof XmlFile) {
            return JavaScriptSupportLoader.isFlexMxmFile((PsiFile)element);
        }
        return element.getContainingFile().getLanguage().isKindOf((Language)JavaScriptSupportLoader.ECMA_SCRIPT_L4);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/refactoring/BaseJSRefactoringHandler", "invoke"));
    }
}

