/*
 * Decompiled with CFR 0.152.
 */
package com.sixrr.inspectjs.control;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.lang.javascript.psi.JSIfStatement;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.sixrr.inspectjs.InspectionJSBundle;
import com.sixrr.inspectjs.InspectionJSFix;
import com.sixrr.inspectjs.control.ConstantIfStatementJSInspection;
import org.jetbrains.annotations.NotNull;

public class JSSimplifyIfStatementFix
extends InspectionJSFix {
    private final boolean myConditionAlwaysFalse;

    public JSSimplifyIfStatementFix(boolean conditionAlwaysFalse) {
        this.myConditionAlwaysFalse = conditionAlwaysFalse;
    }

    @NotNull
    public String getFamilyName() {
        String string = InspectionJSBundle.message("constant.conditional.expression.simplify.quickfix", new Object[0]);
        if (string == null) {
            JSSimplifyIfStatementFix.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    public void doFix(Project project, ProblemDescriptor descriptor2) throws IncorrectOperationException {
        PsiElement element = descriptor2.getPsiElement();
        JSIfStatement statement = (JSIfStatement)PsiTreeUtil.getParentOfType((PsiElement)element, JSIfStatement.class);
        if (statement == null) {
            return;
        }
        JSSimplifyIfStatementFix.simplifyConstantIf(statement, this.myConditionAlwaysFalse);
    }

    public static void simplifyConstantIf(@NotNull JSIfStatement statement, boolean isFalse) {
        if (statement == null) {
            JSSimplifyIfStatementFix.$$$reportNull$$$0(1);
        }
        JSStatement thenBranch = statement.getThen();
        JSStatement elseBranch = statement.getElse();
        if (isFalse) {
            if (elseBranch != null) {
                JSSimplifyIfStatementFix.replaceStatementWithUnwrapping(elseBranch, statement);
            } else {
                JSSimplifyIfStatementFix.deleteElement((PsiElement)statement);
            }
        } else {
            JSSimplifyIfStatementFix.replaceStatementWithUnwrapping(thenBranch, statement);
        }
    }

    private static void replaceStatementWithUnwrapping(JSStatement branch, JSIfStatement statement) throws IncorrectOperationException {
        String branchText = branch.getText();
        if (branchText.startsWith("{") && branchText.endsWith("}")) {
            branchText = branchText.substring(1, branchText.length() - 1).trim();
        }
        ConstantIfStatementJSInspection.replaceStatementOrRemove((JSStatement)statement, branchText);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/sixrr/inspectjs/control/JSSimplifyIfStatementFix";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/sixrr/inspectjs/control/JSSimplifyIfStatementFix";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "simplifyConstantIf";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

